/*
 * 쐬: 2005/03/10
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.invoker.AbstractSQLInvoker;
import zigen.plugin.db.ui.editors.internal.invoker.AddColumnInvoker;
import zigen.plugin.db.ui.editors.internal.invoker.ModifyColumnInvoker;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

/**
 * TableDefineInputDialogNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/10 ZIGEN create.
 */
public class TableDefineInputDialog extends Dialog {

	private ISQLCreatorFactory factory;

	private ITable table;

	private Column column;

	private Column newColumn;

	private Text txtColumnName;

	private Text txtColumnComment;

	private Text txtDefualtt;

	private Combo cmbColumnType;

	private Text txtColumnSize;

	private Button chkNotNull;

	// private Button chkIsPK;

	private boolean isAddColumn = false;;

	public TableDefineInputDialog(Shell parentShell, ISQLCreatorFactory factory, ITable table, Column column, boolean isAddColumn) {
		super(parentShell);
		super.setDefaultImage(ImageCacher.getInstance().getImage(DbPlugin.IMG_CODE_DB));
		setShellStyle(getShellStyle() | SWT.RESIZE); // TCY\
		this.table = table;
		this.column = column;
		this.factory = factory;
		this.isAddColumn = isAddColumn;
	}

	public TableDefineInputDialog(Shell parentShell, ISQLCreatorFactory factory, ITable table, Column column) {
		this(parentShell, factory, table, column, false);
	}

	protected void constrainShellSize() {
		Shell shell = getShell();
		shell.pack();
		shell.setSize(shell.getSize().x + 10, shell.getSize().y);
	}

	protected void okPressed() {
		if (save()) {
			super.okPressed();
		} else {
			;
		}
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		if (isAddColumn) {
			newShell.setText(Messages.getString("TableDefineInputDialog.0")); //$NON-NLS-1$
		} else {
			newShell.setText(Messages.getString("TableDefineInputDialog.1")); //$NON-NLS-1$
		}
	}

	protected Control createDialogArea(Composite parent) {

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Group group = new Group(composite, SWT.NULL);
		group.setText(Messages.getString("TableDefineInputDialog.2")); //$NON-NLS-1$

		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 1;
		// gd.widthHint = 400;
		group.setLayoutData(gd);
		group.setLayout(new GridLayout(6, false));

		Label label = new Label(group, SWT.NULL);
		label.setText(Messages.getString("TableDefineInputDialog.3")); //$NON-NLS-1$
		txtColumnName = new Text(group, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 5;
		txtColumnName.setLayoutData(gd);
		txtColumnName.setText(column.getName());
		txtColumnName.addFocusListener(new TextSelectionListener());

		// Derbył́AJ̕ύX܂Ȃ
		if (!isAddColumn & DBType.DB_TYPE_DERBY == DBType.getType(table.getDbConfig())) {
			txtColumnName.setEnabled(false);
		}

		label = new Label(group, SWT.NULL);
		label.setText(Messages.getString("TableDefineInputDialog.4")); //$NON-NLS-1$
		txtColumnComment = new Text(group, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 5;
		txtColumnComment.setLayoutData(gd);

		if (factory.supportsRemarks()) {
			txtColumnComment.setText(column.getRemarks());
			txtColumnComment.addFocusListener(new TextSelectionListener());
		} else {
			txtColumnComment.setEnabled(false);
		}

		label = new Label(group, SWT.NULL);
		label.setText(Messages.getString("TableDefineInputDialog.5")); //$NON-NLS-1$

		// cmbColumnType = new Combo(group, SWT.READ_ONLY);
		cmbColumnType = new Combo(group, SWT.NONE);
		cmbColumnType.setVisibleItemCount(20);
		for (int i = 0; i < factory.getSupportColumnType().length; i++) {
			cmbColumnType.add((factory.getSupportColumnType()[i]));
		}
		cmbColumnType.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (txtColumnSize != null) {
					txtColumnSize.setEnabled(factory.isVisibleColumnSize(cmbColumnType.getText()));
				}
			}
		});

		cmbColumnType.setText(column.getTypeName());

		// IԂłȂ΁Aǉ
		if (cmbColumnType.getSelectionIndex() > 0) {
			cmbColumnType.add(column.getTypeName());
		}

		if (!isAddColumn && !factory.supportsModifyColumnType()) {
			cmbColumnType.setEnabled(false);
		}

		label = new Label(group, SWT.NULL);
		label.setText(Messages.getString("TableDefineInputDialog.6")); //$NON-NLS-1$
		txtColumnSize = new Text(group, SWT.BORDER);
		txtColumnSize.addFocusListener(new TextSelectionListener());

		gd = new GridData();
		gd.widthHint = 50;
		txtColumnSize.setLayoutData(gd);
		txtColumnSize.setText(column.getSize());

		if (!isAddColumn && !factory.supportsModifyColumnSize(cmbColumnType.getText())) {
			txtColumnSize.setEnabled(false);
		}

		chkNotNull = new Button(group, SWT.CHECK);
		chkNotNull.setText(Messages.getString("TableDefineInputDialog.7")); //$NON-NLS-1$
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		chkNotNull.setLayoutData(gd);
		chkNotNull.setSelection(column.isNotNull());

		label = new Label(group, SWT.NULL);
		label.setText(Messages.getString("TableDefineInputDialog.8")); //$NON-NLS-1$
		txtDefualtt = new Text(group, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 5;
		txtDefualtt.setLayoutData(gd);
		txtDefualtt.addFocusListener(new FocusAdapter() {
			public void focusLost(FocusEvent e) {
				// updateColumn();
			}
		});
		txtDefualtt.setText(column.getDefaultValue());
		txtDefualtt.addFocusListener(new TextSelectionListener());

		Label dummy = new Label(group, SWT.NULL);
		Label label2 = new Label(group, SWT.NULL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 5;
		txtDefualtt.setLayoutData(gd);
		label2.setLayoutData(gd);
		label2.setText(Messages.getString("TableDefineInputDialog.9")); //$NON-NLS-1$

		// Composite checks = new Composite(group, SWT.NULL);
		// checks.setLayout(new RowLayout());
		// gd = new GridData();
		// gd.horizontalSpan = 4;
		// checks.setLayoutData(gd);
		//
		// chkNotNull = new Button(checks, SWT.CHECK);
		// chkNotNull.setText("K{");
		// chkNotNull.addSelectionListener(new SelectionAdapter() {
		// public void widgetSelected(SelectionEvent e) {
		// // updateColumn();
		// }
		// });
		// chkNotNull.setSelection(column.isNotNull());

		// JIʒm
		cmbColumnType.notifyListeners(SWT.Selection, null);

		return composite;
	}

	private String validate(String fieldName, Text text) {
		String value = text.getText();
		if (value == null || value.length() == 0) {
			text.setFocus();
			return fieldName + Messages.getString("TableDefineInputDialog.10"); //$NON-NLS-1$
		}
		if (value.indexOf(",") > 0 || value.indexOf("|") > 0) { //$NON-NLS-1$ //$NON-NLS-2$
			text.setFocus();
			// return fieldName + "[,]܂[|]܂߂邱Ƃ͂ł܂"; //$NON-NLS-1$
			return fieldName + Messages.getString("TableDefineInputDialog.11"); //$NON-NLS-1$
		}
		return null;
	}

	private boolean save() {
		try {
			newColumn = new Column(new TableColumn());
			newColumn.setParent(column.getParent());
			newColumn.setName(txtColumnName.getText());
			newColumn.setTypeName(cmbColumnType.getText());

			if (factory.isVisibleColumnSize(cmbColumnType.getText())) {
				newColumn.setSize(txtColumnSize.getText());
			}
			newColumn.setDefaultValue(txtDefualtt.getText());
			newColumn.setRemark(txtColumnComment.getText());
			newColumn.setNotNull(chkNotNull.getSelection());

			AbstractSQLInvoker invoker;
			if (isAddColumn) {
				invoker = new AddColumnInvoker(table, newColumn);
			} else {
				invoker = new ModifyColumnInvoker(table, column, newColumn);
			}
			return invoker.execute();

		} catch (Exception e) {
			DbPlugin.log(e);
			return false;
		}

	}

	public void verifyHandler(VerifyEvent event) {
		if (event.character == ',' || event.character == '|') {
			event.doit = false;
		}
	}

	public void validateHandler(TypedEvent event) {
		Text text = (Text) event.widget;
		String value = text.getText();
		if (value.indexOf(",") > 0 || value.indexOf("|") > 0) { //$NON-NLS-1$ //$NON-NLS-2$
			text.setFocus();

		}
	}

	public Column getNewColumn() {
		return newColumn;
	}

}
