/*
 * 쐬: 2005/03/26
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

import zigen.plugin.db.core.TimeWatcher;

/**
 * TableContentProviderNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/26 ZIGEN create.
 * 
 */
public class TableViewContentProvider implements IStructuredContentProvider {
	Object[] contents;

//	TableViewer viewer;

	public TableViewContentProvider() {
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
//		this.viewer = (TableViewer) viewer;
		if (newInput instanceof Object[]) {
			contents = (Object[]) newInput;
		} else {
			contents = null;
		}
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		// if (contents != null && contents == inputElement) {
		Object[] out = new Object[contents.length - 1]; // Jpf[^
		System.arraycopy(contents, 1, out, 0, out.length);
		return out;

		// }
		// return new Object[0];
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// TODO ꂽ\bhEX^u
		contents = null;
	}

	public Object[] getContents() {
		return contents;
	}

}
