package zigen.plugin.db.ui.contentassist.processor;

import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ContentInfo;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.contentassist.SQLProposalCreator2;
import zigen.plugin.db.ui.views.internal.SQLKeywordScanner;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTFromList;

public class DeleteProcessor extends DefaultProcessor {

	public DeleteProcessor(List proposals, ProcessorInfo info) {
		super(proposals, info);
	}

	public void createProposals(ASTDeleteStatement st) {

		String[] modifiers = SQLKeywordScanner.SQLKeywords;
		try {
			ContentInfo ci = new ContentInfo(ContentAssistUtil.getIDBConfig());
			TableInfo[] tinfos = ci.getTableInfo(); // 	e[u񃊃Xg擾

			ASTFromList fromList = super.findASTFromList(st);
			int fromItemCount = fromList != null ? super.getSizeRemoveComma(fromList) : 0;

			switch (currentScope) {
			case SqlParser.SCOPE_DELETE:
				// DeletêƂ́AFrom̂ݕ\
				modifiers = new String[]{
					"from" //$NON-NLS-1$
				};
				break;

			case SqlParser.SCOPE_FROM:
				// e[uXg\
				SQLProposalCreator2.addProposal(proposals, tinfos, pinfo);

				//				// e[uXg\
				//				if (st.isFromItemEditing() || !"".equals(word)) {
				//					SQLProposalCreator.addProposal(proposals, infos, word, offset, isAfterPeriod);
				//					modifiers = null;
				//				} else {
				//					// From΁AWherêݕ\
				//					modifiers = new String[]{
				//						"where"
				//					};
				//				}
				break;

			case SqlParser.SCOPE_WHERE:
				if (fromItemCount == 0) {
					;
				} else if (fromItemCount == 1) {
					createColumnProposal(fromList.getChild(0));
					break;
				}

				//				// Whereł́A_ł͏ɃJ\
				//				if (fromItemCount == 1 || !"".equals(word)) {
				//					// e[uJҏW
				//					Column[] cols = ci.getColumns(st.getTableName());
				//					// 2006/11/24 ZIGEN modify
				//					//Column[] cols = ci.getColumns(ContentAssistUtil.createContentAssistTable(st.getTableName()));
				//					SQLProposalCreator.addProposal(proposals, cols, word, offset, isAfterPeriod);
				//				}
				break;
			}
		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);

		} finally {
			// SQLL[[h̓o^
			SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);
		}

	}

}
