/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;

/**
 * ExecuteCurrentSQLActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/12 ZIGEN create.
 */
public class ExecuteSelectedSQLAction extends AbstractExecuteSQLAction {


	private TextSelection selection;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public ExecuteSelectedSQLAction(IDBConfig config, IDocument doc, int offset, String secondaryId) {
		super(config, doc, offset, secondaryId);
		this.setText(Messages.getString("ExecuteSelectedSQLAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("ExecuteSelectedSQLAction.1")); //$NON-NLS-1$
		this.setActionDefinitionId("zigen.plugin.SQLSelectedExecuteActionCommand"); //$NON-NLS-1$
	}

	public void run() {

		try {
			if (selection != null && !"".equals(selection.getText())) { //$NON-NLS-1$
				executeSql(selection.getText());
			} else {
				DbPlugin.getDefault().showWaringMessage(Messages.getString("ExecuteSelectedSQLAction.4")); //$NON-NLS-1$

			}
		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);

		}
	}

	public void setSelection(TextSelection selection) {
		this.selection = selection;
	}
}
