package zigen.plugin.db.diff;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressConstants;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.ColumnSearcher;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.ConstraintSearcher;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleConstraintSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleIndexSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleColumn;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;
import zigen.plugin.db.ui.views.TableSearchThread;

public class DDLDiffJob extends AbstractJob {

    private TreeViewer viewer;

    private List allTables = new ArrayList();

    private List ddlList = new ArrayList();

    private Map map1 = new HashMap();

    private Map map2 = new HashMap();

    private Schema s1;

    private Schema s2;

    public DDLDiffJob(TreeViewer viewer, Schema s1, Schema s2) {
        super(Messages.getString("DDLDiffJob.0")); //$NON-NLS-1$
        this.s1 = s1;
        this.s2 = s2;
        this.viewer = viewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;

        try {
            setProperty(IProgressConstants.ICON_PROPERTY, null);

            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }

            Schema schema1 = (Schema) s1.clone();
            schema1.setParent(s1.getParent());

            Schema schema2 = (Schema) s2.clone();
            schema2.setParent(s2.getParent());

            // 1ڂ̃XL[}z[h
            if (loadAll(monitor, schema1, map1) == Status.OK_STATUS) {
                // 2ڂ̃XL[}z[h
                result = loadAll(monitor, schema2, map2);
            } else {
                return Status.CANCEL_STATUS;
            }

            // ׂẴe[uׂ
            Collections.sort(allTables);

            for (Iterator iter = allTables.iterator(); iter.hasNext();) {

                String tableName = (String) iter.next();

                Object obj1 = map1.get(tableName);
                Object obj2 = map2.get(tableName);

                if (obj1 != null && obj2 != null) {
                    DDL target1 = (DDL) obj1;
                    DDL target2 = (DDL) obj2;

                    /*
                     * قȂ̂o^ꍇ if (!target1.ddl.equals(target2.ddl)) { DDLDiff diff = new DDLDiff(target1, target2); ddlList.add(diff); }
                     */
                    
                    DDLDiff diff = new DDLDiff(target1, target2);
                    ddlList.add(diff);
                
                } else if (obj1 == null) {
                    DDL target2 = (DDL) obj2;
                    DDLDiff diff = new DDLDiff(null, target2);
                    ddlList.add(diff);

                } else if (obj2 == null) {
                    DDL target1 = (DDL) obj1;
                    DDLDiff diff = new DDLDiff(target1, null);
                    ddlList.add(diff);

                }

            }
            monitor.done();

            showResults(new ShowDiffView());

        } catch (Exception e) {
            DbPlugin.log(e);

        }

        return result;
    }

    private IStatus loadAll(IProgressMonitor monitor, Schema schema, Map map) {

        Connection con = null;
        try {

            IDBConfig config = schema.getDbConfig();
            // Connection con = Transaction.getInstance(config).getConnection();
            con = ConnectionManager.getConnection(config);

            schema.removeChildAll();
            schema.setExpanded(true);

            String[] tableTypes = schema.getDataBase().getTableType();
            for (int i = 0; i < tableTypes.length; i++) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                // TableInfo[] tables = TableSearcher.execute(con, schema.getName(), types);
                // TableSearchThread.addFolderAndTables(con, schema, tableTypes[i], tables);

                int totalWork = 0;
                String[] types = new String[] {tableTypes[i]};
                if (tableTypes[i].toUpperCase().matches(TableTypeSearchJob.VisibleFolderPattern)) {
                    TableInfo[] tables = TableSearcher.execute(con, schema.getName(), types);
                    TableSearchThread.addFolderAndTables(con, schema, tableTypes[i], tables);
                    totalWork = tables.length;

                } else {
                    break;
                }

                // else if ("SEQUENCE".equals(tableTypes[i])) { //$NON-NLS-1$
                // // SEQUENCE ́AOraclêݑΉ
                // switch (DBType.getType(schema.getDbConfig())) {
                // case DBType.DB_TYPE_ORACLE:
                // Folder folder = new Folder();
                // folder.setName(tableTypes[i]);
                // OracleSequence seq = new OracleSequence();
                // seq.setName(DbPluginConstant.TREE_LEAF_LOADING);
                // folder.addChild(seq);
                // schema.addChild(folder);
                // }
                // }

                monitor.beginTask(config.getDbName()
                        + "/" + schema.getName() + Messages.getString("DDLDiffJob.1") + tableTypes[i] + Messages.getString("DDLDiffJob.2"), totalWork); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                TreeLeaf leaf = schema.getChild(tableTypes[i]);
                if (leaf instanceof Folder) {
                    Folder folder = (Folder) leaf;
                    folder.setExpanded(true);

                    List list = folder.getChildren();
                    for (Iterator iter = list.iterator(); iter.hasNext();) {

                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }

                        ITable table;
                        try {
                            table = (ITable) iter.next();
                            monitor.subTask("Target:" + table.getName());
                            if (!table.isExpanded()) {
                                table.removeChild(table.getChild(DbPluginConstant.TREE_LEAF_LOADING));
                                table.setExpanded(true);
                                try {
                                    loadColumn(monitor, con, table, config.isConvertUnicode());
                                } catch (NotFoundSynonymInfoException e) {
                                    DbPlugin.log(e);
                                }

                                // DLL̍쐬
                                DDL ddl = new DDL(table);
                                if (!allTables.contains(table.getName())) {
                                    allTables.add(table.getName());
                                }
                                map.put(table.getName(), ddl);

                            }

                        } catch (RuntimeException e1) {
                            // TODO ꂽ catch ubN
                            e1.printStackTrace();
                        }

                        monitor.worked(1);
                    }

                }

            }

            schema.removeChildAll();
            schema = null;

        } catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        } finally {
            ConnectionManager.closeConnection(con);
        }

        return Status.OK_STATUS;

    }

    private void loadColumn(IProgressMonitor monitor, Connection con, ITable table, boolean convertUnicode) throws Exception {
        TablePKColumn[] pks = null;
        TableFKColumn[] fks = null;
        TableConstraintColumn[] cons = null;
        TableIDXColumn[] uidxs = null;
        TableIDXColumn[] nonuidxs = null;

        String schemaName = table.getSchemaName();
        String tableName = table.getName();
        switch (DBType.getType(con.getMetaData())) {
            case DBType.DB_TYPE_ORACLE:
                if (table instanceof Synonym) {
                    Synonym synonym = (Synonym) table;
                    schemaName = synonym.getTable_owner();
                    tableName = synonym.getTable_name();
                } else if (table instanceof Bookmark) {
                    Bookmark bm = (Bookmark) table;
                    if (bm.isSynonym()) {
                        // SynonymInfo info = OracleSynonymInfoSearcher.execute(con,
                        // bm.getName());
                        SynonymInfo info = OracleSynonymInfoSearcher.execute(con, bm.getSchemaName(), bm.getName());
                        schemaName = info.getTable_owner();
                        tableName = info.getTable_name();

                    }
                }
                break;
        }

        TableColumn[] columns = ColumnSearcher.execute(con, schemaName, tableName, convertUnicode);
        pks = ConstraintSearcher.getPKColumns(con, schemaName, tableName);
        fks = ConstraintSearcher.getFKColumns(con, schemaName, tableName);

        if (!table.getFolderName().equals("VIEW")) { //$NON-NLS-1$

            switch (DBType.getType(con.getMetaData())) {
                case DBType.DB_TYPE_ORACLE:
                    cons = OracleConstraintSearcher.getConstraintColumns(con, schemaName, tableName);
                    uidxs = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName, true);
                    nonuidxs = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName, false);
                    break;
                default:
                    uidxs = ConstraintSearcher.getUniqueIDXColumns(con, schemaName, tableName, true);
                    nonuidxs = ConstraintSearcher.getUniqueIDXColumns(con, schemaName, tableName, false);
                    break;
            }

        }

        table.setTablePKColumns(pks);
        table.setTableFKColumns(fks);
        table.setTableConstraintColumns(cons);
        table.setTableUIDXColumns(uidxs);
        table.setTableNonUIDXColumns(nonuidxs);

        for (int i = 0; i < columns.length; i++) {
            TableColumn w_column = columns[i];
            TablePKColumn w_pk = getPKColumn(pks, w_column);
            TableFKColumn[] w_fks = getFKColumns(fks, w_column);

            addChild(con, table, w_column, w_pk, w_fks);

        }
    }

    private void addChild(Connection con, ITable table, TableColumn w_column, TablePKColumn w_pk, TableFKColumn[] w_fks) throws Exception {

        switch (DBType.getType(con.getMetaData())) {
            case DBType.DB_TYPE_ORACLE:
                table.addChild(new OracleColumn(w_column, w_pk, w_fks));
                break;
            default:
                table.addChild(new Column(w_column, w_pk, w_fks));
                break;
        }
    }

    private TablePKColumn getPKColumn(TablePKColumn[] pks, TableColumn column) throws Exception {
        TablePKColumn pk = null;
        for (int i = 0; i < pks.length; i++) {
            if (pks[i].getColumnName().equals(column.getColumnName())) {
                pk = pks[i];
                break;
            }
        }
        return pk;

    }

    private TableFKColumn[] getFKColumns(TableFKColumn[] fks, TableColumn column) throws Exception {

        List list = new ArrayList();
        for (int i = 0; i < fks.length; i++) {
            if (fks[i].getColumnName().equals(column.getColumnName())) {
                list.add(fks[i]);
            }
        }
        return (TableFKColumn[]) list.toArray(new TableFKColumn[0]);

    }

    public class ShowDiffView implements Runnable {

        public ShowDiffView() {
        }

        public void run() {
            try {

                DDLDiff[] diffs = (DDLDiff[]) ddlList.toArray(new DDLDiff[0]);

                DDLDiffEditorInput input = new DDLDiffEditorInput(diffs, false);
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                IEditorPart editor = IDE.openEditor(page, input, DDLDiffEditor.ID, true);

                if (editor instanceof DDLDiffEditor) {
                    DDLDiffEditor dEditor = (DDLDiffEditor) editor;
                }

            } catch (Exception e) {
                DbPlugin.log(e);
            }

        }
    }
}
