/*
 * 쐬: 2005/03/28
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core.rule;

import java.sql.SQLException;

/**
 * 
 * OracleInsertFactory.javaNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/05/07 ZIGEN create.
 * 
 */
public class OracleStatementFactory extends DefaultStatementFactory {

	OracleStatementFactory(boolean convertUnicode) {
		super(convertUnicode);
	}

	protected String getDate(Object value) throws SQLException {
		if (value == null)
			return NULL;
		return "to_date('" + value + "','YYYY-MM-DD HH24:MI:SS')";
	}

	protected String getTimestamp(Object value) throws SQLException {
		if (value == null)
			return NULL;

		return "to_timestamp('" + value + "','YYYY-MM-DD HH24:MI:SS.FF')";
	}
}
