/*
 * 쐬: 2005/03/24
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

/**
 * 
 * TableManager.javaNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/11/19 ZIGEN create.
 * 
 */
public class TableManager {

	public static TableElement[] invoke(Connection con, ITable table) throws Exception, MaxRecordException {
		return invoke(con, table, null);
	}

	public static TableElement[] invoke(IDBConfig config, ITable table) throws Exception, MaxRecordException {
		return invoke(config, table, null);
	}

	public static TableElement[] invoke(IDBConfig config, ITable table, String condition) throws Exception, MaxRecordException {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return invoke(con, table, condition);

		} catch (Exception e) {
			throw e;
		}
	}

	public static TableElement[] invoke(Connection con, ITable table, String condition) throws Exception, MaxRecordException {
		ResultSet rs = null;
		Statement stmt = null;
		TablePKColumn[] pks = null;
		TableFKColumn[] fks = null;
		TableIDXColumn[] uidxs = null;
		try {
			int limit = DbPlugin.getDefault().getPreferenceStore().getInt(PreferencePage.P_MAX_VIEW_RECORD);

			pks = table.getTablePKColumns();
			fks = table.getTableFKColumns();

			// uidxs = table.getTableUIDXColumns();
			uidxs = ConstraintSearcher.getFirstUniqueIndex(table.getTableUIDXColumns());

			stmt = con.createStatement();

			String sql = getSQL(table, condition, limit);
			rs = stmt.executeQuery(sql);
			ResultSetMetaData meta = rs.getMetaData();

			List list = new ArrayList();
			TableColumn[] columns = getTableColumns(meta, table); // 1sڂResultSetMetaDatai[

			TableElement header;
			if (pks != null && pks.length > 0) {
				header = createHeaderElement(rs, table, columns, pks, fks);

			} else {
				header = createHeaderElement(rs, table, columns, uidxs, fks);

			}

			if (pks == null || pks.length == 0) {
				header.setCanModify(checkModify(table.getDbConfig(), columns));
			} else {
				header.setCanModify(true);
			}
			list.add(header); // 0̏ꍇłwb_\ł悤ɂ

			int recordNo = 1;
			while (rs.next()) {
				if (limit > 0 && recordNo > limit) {
					String msg = Messages.getString("TableManager.0") ; //$NON-NLS-1$
					throw new MaxRecordException(msg, (TableElement[]) list.toArray(new TableElement[0]));
                    //String msg = "ő\(" + limit + ")𒴂܂\n" + "ő\ύX邩AύXĂ";
                    //throw new MaxRecordException(msg, (TableElement[]) list.toArray(new TableElement[0]));
                    
				}
				TableElement elements;
				if (pks != null && pks.length > 0) {
					elements = createElement(rs, table, columns, pks, recordNo);
				} else {
					elements = createElement(rs, table, columns, uidxs, recordNo);
				}
				recordNo++;
				list.add(elements);
			}
			return (TableElement[]) list.toArray(new TableElement[0]);

		} catch (Exception e) {
			throw e;
		} finally {
			ResultSetUtil.close(rs);
			StatementUtil.close(stmt);
		}

	}

	public static String getSQL(ITable table, String condition, int limit) {
		IDBConfig config = table.getDbConfig();
		ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(config, table);
		return factory.createSelect(condition, limit);

	}

	public static String getSQLForCSV(ITable table) {
		return getSQL(table, null, 0);
	}

	// PKꍇ AND ҏWs̃f[^^ꍇ͕ҏWsƂ
	static boolean checkModify(IDBConfig config, TableColumn[] columns) {

		IMappingFactory factory = AbstractMappingFactory.getFactory(config);

		for (int i = 0; i < columns.length; i++) {
			TableColumn col = columns[i];
			if (!factory.canModifyDataType(col.getDataType())) {
				// if(!JDBCMapping2.canModifyDataType(col.getDataType())){
				// 1łҏWs\ȃJ^ΕҏWłȂ
				return false;
			}
		}

		return true;
	}

	/**
	 * f[^XVpTableColumn[]쐬
	 * 
	 * @param meta
	 * @param table
	 * @return
	 * @throws SQLException
	 */
	static TableColumn[] getTableColumns(ResultSetMetaData meta, ITable table) throws SQLException {

		try {

			// e[uWJ̏ꍇ͓WJĂ
			if (table.isExpanded()) {

				int count = meta.getColumnCount();
				Column[] cols = table.getColumns();

				TableColumn[] columns = new TableColumn[cols.length];

				// 0.3.0 ̏ꍇ
				for (int i = 0; i < count; i++) {
					TableColumn column = new TableColumn();
					column.setColumnName(meta.getColumnName(i + 1));
					column.setTypeName(meta.getColumnTypeName(i + 1));
					column.setDataType(meta.getColumnType(i + 1));
					column.setColumnSize(meta.getColumnDisplaySize(i + 1));
					column.setDecimalDigits(meta.getScale(i + 1));
					// column.setNotNull(cols[i].isNotNull());
					if (ResultSetMetaData.columnNoNulls == meta.isNullable(i + 1)) {
						column.setNotNull(true);
					} else {
						column.setNotNull(false);
					}
					columns[i] = column;
				}

				// // since 0.3.1 or 1.0.0 Meta擾̂ł͂ȂATablevf擾
				// for (int i = 0; i < columns.length; i++) {
				// columns[i] = cols[i].getColumn();
				// }

				return columns;

			} else {
				throw new IllegalStateException("[ERROR]:OɃe[uWJԂłKv܂B"); //$NON-NLS-1$
			}

		} catch (SQLException e) {
			DbPlugin.log(e);
			throw e;
		}

	}

	static TableElement createHeaderElement(ResultSet rs, ITable table, TableColumn[] columns, TablePKColumn[] pks, TableFKColumn[] fks) throws Exception {
		TableElement elements = null;
		int size = rs.getMetaData().getColumnCount();
		List pkColumnList = new ArrayList();
		for (int i = 0; i < size; i++) {
			if (ConstraintSearcher.isPKColumn(pks, columns[i].getColumnName())) {
				pkColumnList.add(columns[i]);
			}
		}
		if (pks.length == 0) {
			TableColumn[] uniqueColumns = new TableColumn[columns.length];
			System.arraycopy(columns, 0, uniqueColumns, 0, columns.length);
			elements = new TableHeaderElement(table, columns, uniqueColumns);
			elements.setCanModify(checkModify(table.getDbConfig(), columns));
		} else {
			elements = new TableHeaderElement(table, columns, (TableColumn[]) pkColumnList.toArray(new TableColumn[0]));
			elements.setCanModify(true);
			elements.setTablePKColumn(pks);
		}

		if (fks.length != 0) {
			elements.setTableFKColumn(fks);
		}

		return elements;
	}

	static TableElement createElement(ResultSet rs, ITable table, TableColumn[] columns, TablePKColumn[] pks, int recordNo) throws Exception {
		TableElement elements = null;
		int size = rs.getMetaData().getColumnCount();
		Object[] items = new Object[size]; // SJf[^
		List pkColumnList = new ArrayList();
		List pkItemList = new ArrayList();
		IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
		for (int i = 0; i < size; i++) {
			items[i] = factory.getObject(rs, i + 1);
			// ŌCLOB/BLOB^getObjectȂ(΍)
			if (ConstraintSearcher.isPKColumn(pks, columns[i].getColumnName())) {
				pkColumnList.add(columns[i]);
				pkItemList.add(items[i]);
			}
		}

		TableColumn[] uniqueColumns;
		Object[] uniqueItems;
		if (pks.length == 0) {
			uniqueColumns = columns;
			uniqueItems = new Object[size];
			System.arraycopy(items, 0, uniqueItems, 0, size);
			elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
			elements.setCanModify(checkModify(table.getDbConfig(), columns));
		} else {
			uniqueColumns = (TableColumn[]) pkColumnList.toArray(new TableColumn[0]);
			uniqueItems = new Object[pks.length];
			System.arraycopy(pkItemList.toArray(), 0, uniqueItems, 0, pks.length);
			elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
			elements.setCanModify(true);
		}

		return elements;
	}

	static TableElement createHeaderElement(ResultSet rs, ITable table, TableColumn[] columns, TableIDXColumn[] idxs, TableFKColumn[] fks) throws Exception {
		TableElement elements = null;
		int size = rs.getMetaData().getColumnCount();

		List uniqueColumnList = new ArrayList();
		// for (int i = 0; i < size; i++) {
		for (int i = 0; i < columns.length; i++) {
			if (ConstraintSearcher.isUniqueIDXColumn(idxs, columns[i].getColumnName())) {
				uniqueColumnList.add(columns[i]);
			}
		}

		if (idxs == null || idxs.length == 0) {
			TableColumn[] uniqueColumns = new TableColumn[columns.length];
			System.arraycopy(columns, 0, uniqueColumns, 0, columns.length);
			elements = new TableHeaderElement(table, columns, uniqueColumns);
			elements.setCanModify(checkModify(table.getDbConfig(), columns));
		} else {
			elements = new TableHeaderElement(table, columns, (TableColumn[]) uniqueColumnList.toArray(new TableColumn[0]));
			elements.setCanModify(true);
		}

		if (fks != null && fks.length > 0) {
			elements.setTableFKColumn(fks);
		}
		return elements;
	}

	static TableElement createElement(ResultSet rs, ITable table, TableColumn[] columns, TableIDXColumn[] idxs, int recordNo) throws Exception {
		TableElement elements = null;
		int size = rs.getMetaData().getColumnCount();
		Object[] items = new Object[size];
		List uniqueColumnList = new ArrayList();
		List uniqueItemList = new ArrayList();
		IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
		for (int i = 0; i < size; i++) {
			// lItemɐݒ肷
			items[i] = factory.getObject(rs, i + 1);

			// ŏɌUniqueIndexXVL[ƂĈ
			if (ConstraintSearcher.isUniqueIDXColumn(idxs, columns[i].getColumnName())) {
				uniqueColumnList.add(columns[i]);
				uniqueItemList.add(items[i]);
			}
		}
		TableColumn[] uniqueColumns;
		Object[] uniqueItems;
		if (idxs == null || idxs.length == 0) {
			uniqueColumns = columns;
			uniqueItems = new Object[size];
			System.arraycopy(items, 0, uniqueItems, 0, size);
			elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
			elements.setCanModify(checkModify(table.getDbConfig(), columns));
		} else {
			uniqueColumns = (TableColumn[]) uniqueColumnList.toArray(new TableColumn[0]);
			uniqueItems = new Object[idxs.length];
			System.arraycopy(uniqueItemList.toArray(), 0, uniqueItems, 0, idxs.length);
			elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
			elements.setCanModify(true);
		}
		return elements;
	}
}
