package zigen.plugin.db.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import zigen.plugin.db.DbPluginConstant;

/**
 * 
 * SelectIntoChecker.javaNX. MySQLSELECT FROM INTO ǂ肷邽߂̃`FbJ[
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/07/29 ZIGEN create.
 * 
 */
public class SelectIntoChecker {

	public static boolean check(String text) {
		SelectIntoTokenizer t = new SelectIntoTokenizer(text);
		String token = null;
		List wk = new ArrayList();
		if ((token = t.nextToken().toUpperCase()).equals("SELECT")) { //$NON-NLS-1$
			wk.add(token);

			// 2߈ȍ~
			while ((token = t.nextToken()) != null) {
				if ("FROM".equals(token) || "INTO".equals(token)) { //$NON-NLS-1$ //$NON-NLS-2$
					wk.add(token);
				}

				// [vɃXg4ȏɂȂAfalse
				if (wk.size() == 4) {
					return false;
				}
			}

			if (wk.size() == 3) {
				String[] s = (String[]) wk.toArray(new String[3]);
				if (s[0].equals("SELECT") && s[1].equals("FROM") && s[2].equals("INTO")) { //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					return true;
				}
			}
		}

		return false;
	}

}

class SelectIntoTokenizer implements Enumeration {

	private String demiliter = " "; //$NON-NLS-1$

	private String text;

	private int currentPosition;

	private int maxPosition;

	public SelectIntoTokenizer(String str) {
		// sR[h𔼊p󔒂̈ɕύX
		str = str.replaceAll(DbPluginConstant.LINE_SEP, " "); //$NON-NLS-1$
		str = str.replaceAll("\r", " "); //$NON-NLS-1$ //$NON-NLS-2$
		str = str.replaceAll("\n", " "); //$NON-NLS-1$ //$NON-NLS-2$
		str = str.replaceAll("\t", " "); //$NON-NLS-1$ //$NON-NLS-2$

		this.text = str;
		currentPosition = 0;
		maxPosition = this.text.length();

	}

	private int nextDemiliter(int i) {
		boolean flg = false;

		while (i < maxPosition) {
			char ch = text.charAt(i);

			int pos = text.indexOf(demiliter, i);

			if (!flg && pos == i) {
				break;
			} else if ('\'' == ch) {
				flg = !flg;
			} else if ('"' == ch) {
				flg = !flg;
			}

			i++;
		}
		return i;
	}

	public int getTokenCount() {
		int i = 0;
		int ret = 1;
		while ((i = nextDemiliter(i)) < maxPosition) {
			i++;
			ret++;
		}
		return ret;
	}

	public String nextToken() {
		if (currentPosition > maxPosition) {
			return null;
		}

		int start = currentPosition;
		currentPosition = nextDemiliter(currentPosition);

		StringBuffer sb = new StringBuffer();
		while (start < currentPosition) {
			char ch = text.charAt(start++);
			sb.append(ch);
		}
		currentPosition++;

		return sb.toString();
	}

	public Object nextElement() {
		return nextToken();
	}

	public boolean hasMoreElements() {
		return (nextDemiliter(currentPosition) <= maxPosition);
	}

}