/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.actions.ActionFactory;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.diff.DDLDiffForSchemaAction;
import zigen.plugin.db.diff.DDLDiffForTableAction;
import zigen.plugin.db.ext.csv.CreateCSVAction;
import zigen.plugin.db.ext.oracle.internal.OpenSourceEdirotAction;
import zigen.plugin.db.ext.oracle.tablespace.CalcTableSpaceWizardAction;
import zigen.plugin.db.ui.actions.CloseDBAction;
import zigen.plugin.db.ui.actions.ConnectDBAction;
import zigen.plugin.db.ui.actions.CopyColumnNameAction;
import zigen.plugin.db.ui.actions.CopyDBAction;
import zigen.plugin.db.ui.actions.CopySchemaNameAction;
import zigen.plugin.db.ui.actions.CopyTableNameAction;
import zigen.plugin.db.ui.actions.DeleteFromTableAction;
import zigen.plugin.db.ui.actions.DropTreeNodeAction;
import zigen.plugin.db.ui.actions.EditDBAction;
import zigen.plugin.db.ui.actions.ExportDBConfigAction;
import zigen.plugin.db.ui.actions.ImportDBConfigAction;
import zigen.plugin.db.ui.actions.OpenEditorAction;
import zigen.plugin.db.ui.actions.PurgeRecyclebinAction;
import zigen.plugin.db.ui.actions.RefreshAction;
import zigen.plugin.db.ui.actions.RegistBookmarkAction;
import zigen.plugin.db.ui.actions.RegistBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RegistDBAction;
import zigen.plugin.db.ui.actions.RemoveBookmarkAction;
import zigen.plugin.db.ui.actions.RemoveBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RemoveDBAction;
import zigen.plugin.db.ui.actions.RenameBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RenameTableAction;
import zigen.plugin.db.ui.actions.ShowDriverVersionAction;
import zigen.plugin.db.ui.actions.ShowPluginVersionAction;
import zigen.plugin.db.ui.actions.ToggleLinkingAction;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.jobs.RefreshTableJob;

/**
 * TreeViewNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/09 ZIGEN create.
 *        [002] 2005/07/15 ZIGEN VOACSV쐬@\Be[ul[@\ǉ [003] 2005/10/01 ZIGEN
 *        Oraclep\̈挩ς@\̒ǉ
 * 
 */
public class TreeView extends AbstractTreeView {

	private RegistDBAction registDBAction;

	private RemoveDBAction removeDBAction;

	private EditDBAction editDBAction;

	private ConnectDBAction connectDBAction;

	private CloseDBAction closeDBAction;

	private RefreshAction refreshAction;

	private OpenEditorAction openEditorAction;

	private RenameTableAction renameTableAction;

	private CreateCSVAction createCSVAction;

	//private GenerateVOAction generateVOAction;

	private CalcTableSpaceWizardAction calcTableSpaceWizardAction;;

	private CopyDBAction copyDBAction;

	private ShowDriverVersionAction showDriverVersionAction;

	private ShowPluginVersionAction showPluginVersionAction;

	private RegistBookmarkFolderAction registBookmarkFolderAction;

	private RenameBookmarkFolderAction renameBookmarkFolderAction;

	private RemoveBookmarkFolderAction removeBookmarkFolderAction;

	private RegistBookmarkAction registBookmarkAction;

	private RemoveBookmarkAction removeBookmarkAction;

	private CopyTableNameAction copyTableNameAction;

	private CopySchemaNameAction copySchemaNameAction;

	private CopyColumnNameAction copyColumnNameAction;

	private ExportDBConfigAction exportDBConfigAction;

	private ImportDBConfigAction importDBConfigAction;

	private PurgeRecyclebinAction purgeRecyclebinAction;

	private DeleteFromTableAction deleteFromTableAction;

	private DDLDiffForTableAction ddlDiffAction;

	private DDLDiffForSchemaAction diffForSchemaAction;

	private OpenSourceEdirotAction openEdirotForSourceAction;

	private DropTreeNodeAction dropTreeNodeAction;
	
	private ToggleLinkingAction toggleLinkingAction;

	// private TableDefineEditAction tableDefineEditAction;

	// private EditorLinkContiribution editorLinkContiribution;

	public void setFocus() {
	}

	void makeActions() {
		registDBAction = new RegistDBAction(viewer);
		removeDBAction = new RemoveDBAction(viewer);
		removeDBAction.setEnabled(false); // False
		editDBAction = new EditDBAction(viewer);
		connectDBAction = new ConnectDBAction(viewer);
		closeDBAction = new CloseDBAction(viewer);
		openEditorAction = new OpenEditorAction(viewer);
		refreshAction = new RefreshAction(viewer);
		//generateVOAction = new GenerateVOAction(viewer);
		renameTableAction = new RenameTableAction(viewer);
		createCSVAction = new CreateCSVAction(viewer);
		calcTableSpaceWizardAction = new CalcTableSpaceWizardAction(viewer);
		showDriverVersionAction = new ShowDriverVersionAction(viewer);
		showPluginVersionAction = new ShowPluginVersionAction();
		copyDBAction = new CopyDBAction(viewer);
		exportDBConfigAction = new ExportDBConfigAction(contentProvider.getRoot());
		importDBConfigAction = new ImportDBConfigAction(viewer);
		purgeRecyclebinAction = new PurgeRecyclebinAction(viewer);
		deleteFromTableAction = new DeleteFromTableAction(viewer);
		ddlDiffAction = new DDLDiffForTableAction(viewer);
		diffForSchemaAction = new DDLDiffForSchemaAction(viewer);
		openEdirotForSourceAction = new OpenSourceEdirotAction(viewer);
		dropTreeNodeAction = new DropTreeNodeAction(viewer);
		// tableDefineEditAction = new TableDefineEditAction(viewer);
		toggleLinkingAction = new ToggleLinkingAction(this);
		
		bookMarkActions();

		clipboardActions();

	}

	/**
	 * CɓpAction쐬
	 */
	void bookMarkActions() {
		registBookmarkFolderAction = new RegistBookmarkFolderAction(viewer);
		renameBookmarkFolderAction = new RenameBookmarkFolderAction(viewer);
		removeBookmarkFolderAction = new RemoveBookmarkFolderAction(viewer);
		registBookmarkAction = new RegistBookmarkAction(viewer);
		removeBookmarkAction = new RemoveBookmarkAction(viewer);
	}

	/**
	 * Nbv{[hpAction쐬
	 */
	void clipboardActions() {

		copySchemaNameAction = new CopySchemaNameAction(viewer);
		copyTableNameAction = new CopyTableNameAction(viewer);
		copyColumnNameAction = new CopyColumnNameAction(viewer);

	}

	void fillContextMenu(IMenuManager manager) {
		// Îɂĕ\郁j[ύX
		Object obj = (Object) ((StructuredSelection) viewer.getSelection()).getFirstElement();

		if (obj instanceof Root) {
			removeDBAction.setEnabled(false); // 폜s\
			manager.add(registDBAction);
			manager.add(removeDBAction);
			manager.add(new Separator());
			manager.add(importDBConfigAction);
			manager.add(exportDBConfigAction);
			manager.add(new Separator());
			manager.add(showPluginVersionAction);

		} else if (obj instanceof BookmarkRoot) {
			manager.add(registBookmarkFolderAction);

		} else if (obj instanceof BookmarkFolder) {
			manager.add(registBookmarkFolderAction);
			manager.add(renameBookmarkFolderAction);
			manager.add(removeBookmarkFolderAction);

		} else if (obj instanceof DataBase) {
			DataBase db = (DataBase) obj;
			removeDBAction.setEnabled(true); // 폜\
			manager.add(connectDBAction); // ڑ
			manager.add(closeDBAction); // ؒf
			// manager.add(refreshAction); // XViĐڑj
			manager.add(new Separator());

			manager.add(registDBAction); // DB`o^
			manager.add(editDBAction); // DB`ҏW
			manager.add(removeDBAction); // DB`폜
			manager.add(copyDBAction); // DB`
			// manager.add(new Separator());
			// manager.add(importDBConfigAction);
			// manager.add(exportDBConfigAction);
			manager.add(new Separator());
			manager.add(showDriverVersionAction); // Driver Version\

			// IDataBasevfɉāAڑ/ؒfsetEnableds
			if (db.isConnected()) {
				// refreshAction.setEnabled(true);
				connectDBAction.setEnabled(false);
				closeDBAction.setEnabled(true);
				showDriverVersionAction.setEnabled(true);
			} else {
				// refreshAction.setEnabled(false);
				connectDBAction.setEnabled(true);
				closeDBAction.setEnabled(false);
				showDriverVersionAction.setEnabled(false);
			}

		} else if (obj instanceof Schema) {
			// refreshAction.setEnabled(true);
			manager.add(refreshAction); // XViĐڑj
			manager.add(copySchemaNameAction); // Nbv{[hɃe[u\t

			// <!-- [003] ǉ ZIGEN 2005/10/01
			// Oracle Only
			Schema schema = (Schema) obj;
			switch (DBType.getType(schema.getDbConfig())) {
			case DBType.DB_TYPE_ORACLE:
				manager.add(new Separator());
				manager.add(calcTableSpaceWizardAction); // \̈̌

				if (schema.getName().compareToIgnoreCase(schema.getDbConfig().getUserId()) == 0) {
					manager.add(new Separator());
					manager.add(purgeRecyclebinAction);
				}

				break;

			default:
				break;
			}
			// [003] ǉ ZIGEN 2005/10/01 -->

			manager.add(diffForSchemaAction);

			// <!-- [003] ǉ ZIGEN 2005/06/25
		} else if (obj instanceof Folder) {
			// refreshAction.setEnabled(true);
			manager.add(refreshAction); // XViĐڑj

		} else if (obj instanceof OracleSource || obj instanceof OracleSequence) {
			// Source source = (Source)obj;
			manager.add(openEdirotForSourceAction);
			manager.add(dropTreeNodeAction);

		}

		// [003] ǉ ZIGEN 2005/06/25 -->

		else if (obj instanceof ITable) {

			try {
				ITable table = (ITable) obj;

				manager.add(openEditorAction);
				// manager.add(tableDefineEditAction);

				manager.add(refreshAction); // XViĐڑj
				manager.add(copyTableNameAction); // Nbv{[hɃe[u\t

				// <!-- [002] ǉ ZIGEN 2005/07/15
				manager.add(new Separator());
				manager.add(renameTableAction);
				manager.add(deleteFromTableAction);
				
                // Other plug-ins can contribute there actions here
                manager.add(new Separator("Generate"));
                //manager.add(generateVOAction);
				manager.add(createCSVAction);

				manager.add(ddlDiffAction);

				// Cɓɒǉ
				manager.add(new Separator());

				// CɓɒǉTablê
				if (obj instanceof Table) {
					manager.add(registBookmarkAction);
				} else if (obj instanceof Bookmark) {
					manager.add(removeBookmarkAction);
				}

			} catch (Exception e) {
				DbPlugin.log(e);
			}

		} else if (obj instanceof Column) {
			manager.add(new Separator());
			manager.add(copyColumnNameAction);
		}

		// uCɓvpContextMenu쐬
		bookMarkFillContextMenu(manager, obj);

		// Other plug-ins can contribute there actions here
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	void bookMarkFillContextMenu(IMenuManager manager, Object obj) {
		// if (obj instanceof BookmarkRoot) {
		// manager.add(refreshAction); // XV
		// } else if (obj instanceof BookmarkFolder) {
		// manager.add(refreshAction); // XV
		// } else if (obj instanceof Bookmark) {
		// manager.add(refreshAction); // XV
		// }
	}

	protected void fillLocalPullDown(IMenuManager manager) {
		manager.add(registDBAction); // DB`o^
		//manager.add(removeDBAction); // DB`o^
		manager.add(new Separator());
		manager.add(importDBConfigAction);
		manager.add(exportDBConfigAction);
		manager.add(new Separator());
		manager.add(toggleLinkingAction);
	}

	void fillLocalToolBar(IToolBarManager manager) {
		manager.add(registDBAction); // DB`o^
		//manager.add(removeDBAction); // DB`o^
		manager.add(new Separator());
		manager.add(importDBConfigAction);
		manager.add(exportDBConfigAction);
		manager.add(new Separator());
		manager.add(toggleLinkingAction);
	}

	private Column selectedColumn;

	public Column getSelectedColumn() {
		return selectedColumn;
	}

	/**
	 * Ivfɂăj[̊E񊈐𐧌
	 */
	void selectionChangeHandler(SelectionChangedEvent event) {
		selectedColumn = null;// IJ

		removeDBAction.setEnabled(false);
		renameTableAction.setEnabled(false);
		ddlDiffAction.setEnabled(false);
		diffForSchemaAction.setEnabled(false);
		createCSVAction.setEnabled(false);
		deleteFromTableAction.setEnabled(false);
		refreshAction.setEnabled(false);
		// tableDefineEditAction.setEnabled(false);

		IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		if (selection.size() == 1) {
			Object element = (Object) (selection).getFirstElement();
			if (element instanceof DataBase) {
				removeDBAction.setEnabled(true);

			} else if (element instanceof ITable) {
				renameTableAction.setEnabled(true);
				createCSVAction.setEnabled(true);
				deleteFromTableAction.setEnabled(true);
				// tableDefineEditAction.setEnabled(true);
			} else if (element instanceof Column) {
				selectedColumn = (Column) element;
			}

			refreshAction.setEnabled(true);

		} else if (selection.size() == 2) {
			Object ele1 = selection.iterator().next();
			Object ele2 = selection.iterator().next();

			if (ele1 instanceof ITable && ele2 instanceof ITable) {
				// _łOraclêDiff@\
				// ITable table1 = (ITable) ele1;
				// ITable table2 = (ITable) ele2;
				/*
				 * if (DBType.DB_TYPE_ORACLE == table1.getDbConfig().getDbType() &&
				 * DBType.DB_TYPE_ORACLE == table2.getDbConfig().getDbType()) { //
				 * OraclȅꍇDDLDiffj[\ ddlDiffAction.setEnabled(true); }
				 * else { ddlDiffAction.setEnabled(false); }
				 */
				ddlDiffAction.setEnabled(true);

			} else if (ele1 instanceof Schema && ele2 instanceof Schema) {
				diffForSchemaAction.setEnabled(true);
			}
		}

		setGlobalAction(selection);

	}

	void setGlobalAction(IStructuredSelection selection) {
		IActionBars bars = getViewSite().getActionBars();
		bars.clearGlobalActionHandlers();
		if (selection.size() == 1) {
			Object element = (Object) (selection).getFirstElement();
			if (element instanceof Schema) {
				bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), refreshAction);
			} else if (element instanceof Folder) {
				bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), refreshAction);

			} else if (element instanceof Table) {
				bars.setGlobalActionHandler(ActionFactory.RENAME.getId(), renameTableAction);
				bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), refreshAction);

			} else if (element instanceof Column) {
			}
		}

		// IvfɊ֌WȂ
		Object element = (Object) (selection).getFirstElement();
		if (element instanceof Schema) {
			bars.setGlobalActionHandler(ActionFactory.COPY.getId(), copySchemaNameAction);

		} else if (element instanceof ITable) {
			bars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyTableNameAction);

		} else if (element instanceof Column) {
			bars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyColumnNameAction);
		}
		bars.updateActionBars();
	}

	public void statusChanged(Object obj, int status) {
		if (status == StatusChangeListener.EVT_ModifyTableDefine) {
			if (obj instanceof ITable) {
				ITable table = (ITable) obj;
				RefreshTableJob job = new RefreshTableJob(viewer, table);
				job.setPriority(RefreshTableJob.SHORT);
				job.setUser(true);
				job.schedule();
			}
		} else if (status == StatusChangeListener.EVT_LinkTable) {
			if (isLinkingEnabled()) {
				if (obj instanceof ISelection) {
					ISelection selection = (ISelection) obj;
					viewer.setSelection(selection, true);
					//viewer.reveal(table);
					
				}
			}
		}
	}
}
