package zigen.plugin.db.ui.views;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.ResourceUtil;

public class SQLExecuteViewSelectionAdapter implements ISelectionListener {

    AbstractSQLExecuteView view;
    
    public SQLExecuteViewSelectionAdapter(AbstractSQLExecuteView view){
        this.view = view;
    }
    
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection != null && selection instanceof StructuredSelection) {
            Object obj = ((StructuredSelection) selection).getFirstElement();
            if (obj != null) {
                /*
                if (obj instanceof IJavaProject) {
                    IJavaProject iprj = (IJavaProject) obj;
                    IProject prj = iprj.getProject();

                    IDBConfig config = ResourceUtil.getDBConfig(prj);
                    if (config != null)
                        view.updateCombo(config);

                } else 
                */
                if (obj instanceof IResource) {
                    IDBConfig config = ResourceUtil.getDBConfig((IResource) obj);
                    if (config != null)
                        view.updateCombo(config);

                } else if (obj instanceof TreeNode) {
                    IDBConfig config = ((TreeNode) obj).getDbConfig();
                    if (config != null)
                        view.updateCombo(config);
                }

            }

        }
    }

}
