package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import zigen.plugin.db.ui.internal.History;

public class HistoryViewTableFilter extends ViewerFilter {

	protected String text;

	public HistoryViewTableFilter(String text) {
		this.text = text.toLowerCase();
	}

	public boolean select(Viewer viewer, Object parent, Object node) {
		if (text != null && !"".equals(text)) { //$NON-NLS-1$
			if (node instanceof History) {
				History his = (History) node;
				String sql = his.getSqlHistory().getSql();
				if (sql.toLowerCase().indexOf(text) >= 0) {
					return true;
				} else {
					return false;
				}
			}
		}
		return true;

	}
}
