package zigen.plugin.db.ui.util;

import org.eclipse.core.resources.IResource;

import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;

public class ResourceUtil {

	public static String getDBConfigName(IResource resource) {
		return ProjectUtil.getDBConfigName(resource.getProject());
	}

	public static IDBConfig getDBConfig(IResource resource) {
		String dbName = getDBConfigName(resource);
		if (dbName != null) {
			return DBConfigManager.getDBConfig(dbName);
		} else {
			return null;
		}
	}

}
