package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;

public class DropIndexInvoker extends AbstractSQLInvoker {


	private static String TITLE = Messages.getString("DropIndexInvoker.0"); //$NON-NLS-1$

	private String indexName;

	public DropIndexInvoker(ITable table, String indexName) {
		super(TITLE, table);
		this.indexName = indexName;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String sql = factory.createDropIndexDDL(indexName);
		return new String[] {
			sql
		};
	}

}