package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class AddIndexInvoker extends AbstractSQLInvoker {

	private static String TITLE = Messages.getString("AddIndexInvoker.0"); //$NON-NLS-1$

	String indexName;

	Column[] columns;

	int indexType;

	public AddIndexInvoker(ITable table, String indexName, Column[] columns, int indexType) {
		super(TITLE, table);
		this.indexName = indexName;
		this.columns = columns;
		this.indexType = indexType;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String sql = factory.createCreateIndexDDL(indexName, columns, indexType);
		return new String[] {
			sql
		};
	}

}