/*
 * 쐬: 2005/03/18
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.views.internal.ColorManager;

/**
 * ForegroundColorUpdateThread.java.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/12/13 ZIGEN create.
 * 
 */
public class ForegroundColorUpdateAction implements Runnable {


	protected Table table;

	protected Color blue;

	protected Color black;

	protected Color glay;

	protected Color white;

	protected Color lightblue;

	// protected int selectedIndex = -1;

	IPreferenceStore store;

	public ForegroundColorUpdateAction(Table table) {
		ColorManager colorManager = new ColorManager();
		this.table = table;
		this.store = DbPlugin.getDefault().getPreferenceStore();

		Display display = Display.getDefault();
		blue = new Color(display, 0, 0, 255); // 
		black = new Color(display, 0, 0, 0);
		glay = table.getDisplay().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND);
		white = table.getDisplay().getSystemColor(SWT.COLOR_WHITE);
		lightblue = colorManager.getColor(PreferencePage.P_COLOR_BACKGROUND);

	}

	public void run() {

		try {

			if (store.getBoolean(PreferencePage.P_CHANGE_NULL_COLOR)) {

				String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString(PreferencePage.P_NULL_SYMBOL);

				int columnSize = table.getColumnCount(); // J擾
				int rowSize = table.getItemCount(); // R[h擾

				for (int i = 0; i < rowSize; i++) {
					updateRecord(i, columnSize, nullSymbol);
				}

			}

		} catch (org.eclipse.swt.SWTException e) {
			// ANG𔭍sƃG[邱Ƃ
			// DbPlugin.log(e);

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

	protected void updateRecord(int rowIndex, int columnSize, String nullSymbol) {

		TableItem item = table.getItem(rowIndex);
		for (int k = 0; k < columnSize; k++) {

			if (nullSymbol.equals(item.getText(k))) {
				item.setForeground(k, blue); // FontJ[̕ύX
			} else {
				item.setForeground(k, black); // FontJ[̕ύX
				// Color nowColor = item.getForeground(); // \̐F擾
				// item.setForeground(k, nowColor); // FontJ[̕ύX
			}
		}

		// ĕ`
		// table.redraw();
	}
}