package zigen.plugin.db.ui.contentassist;

import java.sql.Connection;

import org.eclipse.swt.widgets.Display;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.TableTypeSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ContentAssistTable;

public class ContentInfo {

	IDBConfig config;

	String[] tableTypes;

	// String[] schemas;

	TableInfo[] tableInfo;

	boolean isConnected = false;

	public ContentInfo(IDBConfig config) {
		this.config = config;
		configure();
	}

	private void configure() {
		try {

			Transaction trans = Transaction.getInstance(config);
			if (trans.isConneting()) {
				isConnected = true;
				Connection con = trans.getConnection();

				// interbaseł́A "SYSTEM TABLE", "TABLE", "VIEW"邪
				// "SYSTEM TABLE"āAe[uƃnOAbv邽߁A
				// interbase ŗL̏
				switch (config.getDbType()) {
				case DBType.DB_TYPE_INTERBASE:
					tableTypes = new String[] {
							"TABLE", "VIEW"}; //$NON-NLS-1$ //$NON-NLS-2$
					break;
				default:
					tableTypes = getTableTypes(con);
					break;
				}
				tableInfo = getTableInfo(con, config.getSchema(), tableTypes);
			} else {
				Display.getDefault().syncExec(new ConfirmConnectDBAction(trans));
				if (trans.isConneting()) {
					configure();
				}
			}
		} catch (Exception e) {
			DbPlugin.log(e);
		}
	}

	private String[] getTableTypes(Connection con) {
		String[] result = null;
		ObjectCacher holder = ObjectCacher.getInstance(config.getDbName() + "@TableType"); //$NON-NLS-1$
		synchronized (holder) {
			result = (String[]) holder.get();
			if (result == null) {
				try {
					result = TableTypeSearcher.execute(con);
				} catch (Exception e) {
					DbPlugin.log(e);
				}
				holder.put(result);
			} else {
			}
		}
		return result;

	}

	private String[] getSchemas(Connection con, IDBConfig config) {
		String[] result = null;
		ObjectCacher holder = ObjectCacher.getInstance(config.getDbName() + "@Schema"); //$NON-NLS-1$
		synchronized (holder) {
			result = (String[]) holder.get();
			if (result == null) {
				try {
					result = SchemaSearcher.execute(con);
				} catch (Exception e) {
					DbPlugin.log(e);
				}
				holder.put(result);
			} else {
			}
		}
		return result;

	}

	private TableInfo[] getTableInfo(Connection con, String schemaName, String[] tableTypes) {
		TableInfo[] result = null;
		ObjectCacher holder = ObjectCacher.getInstance(schemaName);
		synchronized (holder) {
			result = (TableInfo[]) holder.get();
			if (result == null) {
				try {
					if (schemaName != null) {
						result = TableSearcher.execute(con, schemaName.toUpperCase(), tableTypes);
					} else {
						result = TableSearcher.execute(con, null, tableTypes);
					}

					// \[g

				} catch (Exception e) {
					DbPlugin.log(e);
				}
				holder.put(result);
			} else {
			}
		}
		return result;

	}

	public Column[] getColumns(String tableName) {
		Column[] result = null;
		ObjectCacher holder = ObjectCacher.getInstance(tableName);
		synchronized (holder) {
			result = (Column[]) holder.get();
			if (result == null) {
				ContentAssistTable table = ContentAssistUtil.createContentAssistTable(tableName);
				result = table.getColumns();
				holder.put(result);
			} else {
			}
		}
		return result;
	}

	public TableInfo[] getTableInfo() {
		return tableInfo;
	}

}
