/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewer;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.views.SQLExecuteView;

/**
 * SQLFormatActionNX. ublancoCommonsvCu(GNU LGPLCZX) SQLtH[}bg@\gpĂ܂B
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/08/06 ZIGEN create.
 * 
 */
public class SQLFormatAction extends Action implements Runnable {
	private SQLExecuteView view;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public SQLFormatAction(SQLExecuteView view) {
		setText(Messages.getString("SQLFormatAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("SQLFormatAction.1")); //$NON-NLS-1$
		this.setActionDefinitionId("zigen.plugin.SQLFormatActionCommand"); //$NON-NLS-1$
		this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor(DbPlugin.IMG_CODE_FORMAT));
		// setAccelerator(SWT.CTRL | SWT.SHIFT | 'F');
		this.view = view;
	}

	/**
	 * Actions̏
	 */
	public void run() {
		try {
			// SQLsr[IDBConfig擾

			SourceViewer sv = view.getSqlViewer();

			String preSql = sv.getDocument().get();
			StringBuffer sb = new StringBuffer();

			IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
			String demiliter = store.getString(SQLEditorPreferencePage.P_SQL_DEMILITER);
			boolean onPatch = store.getBoolean(SQLEditorPreferencePage.P_FORMAT_PATCH);
			SQLTokenizer st = new SQLTokenizer(preSql, demiliter);

			while (st.hasMoreElements()) {
				String sql = (String) st.nextElement();
				if (sql != null && sql.length() > 0) {
					// -----------------------------------------------
					// BlancoSqlFormattergSQLtH[}bg
					// -----------------------------------------------
					// sb.append(SQLFormatter.format(sql,onPatch));
					sb.append(StringUtil.convertLineSep(SQLFormatter.format(sql, onPatch), DbPluginConstant.LINE_SEP));

					if ("/".equals(demiliter)) { //$NON-NLS-1$
						sb.append(DbPluginConstant.LINE_SEP);
					}
					sb.append(demiliter);
					sb.append(DbPluginConstant.LINE_SEP);

				}

			}
			sv.getDocument().set(sb.toString());

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

}
