/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.editors.internal.invoker.AbstractSQLInvoker;
import zigen.plugin.db.ui.editors.internal.invoker.ModifyTableInvoker;
import zigen.plugin.db.ui.internal.ITable;

/**
 * RenameTableActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/08 ZIGEN create.
 * 
 */
public class RenameTableAction extends Action implements Runnable {

	private StructuredViewer viewer = null;

	public RenameTableAction(StructuredViewer viewer) {
		this.viewer = viewer;
		this.setText(Messages.getString("RenameTableAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("RenameTableAction.1")); //$NON-NLS-1$

	}

	/**
	 * Actions̏
	 */
	public void run() {

		Object element = (Object) ((StructuredSelection) viewer.getSelection()).getFirstElement();
		try {
			if (element instanceof ITable) {
				ITable table = (ITable) element;

				Shell shell = DbPlugin.getDefault().getShell();
				InputDialog dialog = new InputDialog(shell, Messages.getString("RenameTableAction.2"), Messages.getString("RenameTableAction.3"), table.getName(), null); //$NON-NLS-1$ //$NON-NLS-2$
				int rc = dialog.open();
				if (rc == InputDialog.CANCEL) {
					return;
				}

				String newTableName = dialog.getValue().trim();
				if (!table.getName().equals(newTableName)) {
					String currentRemarks = table.getRemarks();
					AbstractSQLInvoker invoker = new ModifyTableInvoker(table, newTableName, currentRemarks);
					invoker.execute();
					viewer.refresh(table);
				}
			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

}
