/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IViewPart;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.jobs.SqlExecJob;
import zigen.plugin.db.ui.views.HistoryView;

/**
 * ExecuteCurrentSQLActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/12 ZIGEN create.
 */
abstract public class AbstractExecuteSQLAction extends Action implements Runnable {

	private static int MAX_BYTES_SIZE = 1024 * 1024;

	protected IDBConfig config;

	protected IDocument doc;

	protected int offset;

	protected String secondaryId; // SQLsr[̏ꍇ̂ݗL

	public AbstractExecuteSQLAction(IDBConfig config, IDocument doc, int offset, String secondaryId) {
		this.config = config;
		this.doc = doc;
		this.offset = offset;
		this.secondaryId = secondaryId;

		this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_EXECUTE));
	}

	protected String getDemiliter() {
		return DbPlugin.getDefault().getPreferenceStore().getString(SQLEditorPreferencePage.P_SQL_DEMILITER);
	}

	protected String getAllSql() {
		return doc.get();
	}

	protected String getCurrentSql() {
		String demiliter = getDemiliter();
		return new CurrentSql(doc, offset, demiliter).getSql();
	}

	protected void executeSql(String sql) {
		if (sql != null && sql.trim().length() > 0) {

			Transaction trans = Transaction.getInstance(config);
			SqlExecJob job = new SqlExecJob(trans, sql, secondaryId);
			// job.setPriority(Job.SHORT);
			job.setUser(false); // _CAOoȂ
			job.schedule();
			addHistory(sql);
			/*
			 * int size = sql.getBytes().length; if(size >= MAX_BYTES_SIZE){
			 * 
			 * StringBuffer sb = new StringBuffer(); sb.append("sSQL");
			 * //$NON-NLS-1$ sb.append(MAX_BYTES_SIZE / 1024);
			 * sb.append("KBȏ゠ׁASQLɊi[܂ł"); //$NON-NLS-1$
			 * 
			 * DbPlugin.getDefault().showWaringMessage(sb.toString());
			 * 
			 * }else{ addHistory(sql); }
			 */

		} else {
			DbPlugin.getDefault().showInformationMessage(Messages.getString("AbstractExecuteSQLAction.Message")); //$NON-NLS-1$
		}
	}

	protected void addHistory(String sql) {
		// SQLɕۑ
		SQLHistoryManager mgr = DbPlugin.getDefault().getHistoryManager();
		SQLHistory history = new SQLHistory(config, sql);

		if (mgr.addHistory(history)) {

			IViewPart part = DbPlugin.findView(DbPluginConstant.VIEW_ID_HistoryView);
			if (part instanceof HistoryView) {
				HistoryView hv = (HistoryView) part;
				hv.updateHistoryView(history);
				StatusChangeListener.fireStatusChangeListener(hv, StatusChangeListener.EVT_UpdateHistory);
			}

		}
	}

}
