/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.csv;

import java.io.File;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.preference.CSVPreferencePage;
import zigen.plugin.db.ui.internal.ITable;

/**
 * CreateCSVActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/08 ZIGEN create.
 * 
 */
public class CreateCSVAction extends Action {
	private StructuredViewer viewer = null;

	private IPreferenceStore store;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public CreateCSVAction(StructuredViewer viewer) {
		this.viewer = viewer;
		this.setText(Messages.getString("CreateCSVAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("CreateCSVAction.1")); //$NON-NLS-1$
		this.store = DbPlugin.getDefault().getPreferenceStore();
	}

	/**
	 * Actions̏
	 */
	public void run() {
		// 1Ȃꍇ
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		Object element = selection.getFirstElement();
		invoke(element);

		// if (fileName != null) {
		// IStructuredSelection selection = (IStructuredSelection)
		// viewer.getSelection();
		// for (Iterator iter = selection.iterator(); iter.hasNext();) {
		// Object obj = iter.next();
		// invoke(dialog.getPackageFragment(), obj);
		// }
		//            
		// }
	}

	private void invoke(Object element) {
		if (element instanceof ITable) {
			ITable table = (ITable) element;
			try {
				Shell shell = DbPlugin.getDefault().getShell();
				FileDialog dialog = new FileDialog(shell, SWT.SAVE);
				dialog.setFileName(table.getName());
				dialog.setFilterExtensions(new String[] {
						"*.csv", "*.*" //$NON-NLS-1$ //$NON-NLS-2$
				});
				dialog.setFilterNames(new String[] {
						Messages.getString("CreateCSVAction.4"), Messages.getString("CreateCSVAction.5") //$NON-NLS-1$ //$NON-NLS-2$
						});
				String fileName = dialog.open();

				// LZ̏
				if (fileName == null)
					return;

				File csvFile = new File(fileName);
				if (csvFile.exists()) {
					// Shell shell = DbPlugin.getDefault().getShell();
					MessageBox msg = new MessageBox(shell, SWT.YES | SWT.NO | SWT.ICON_QUESTION);
					msg.setMessage(fileName + Messages.getString("CreateCSVAction.6")); //$NON-NLS-1$
					msg.setText(Messages.getString("CreateCSVAction.7")); //$NON-NLS-1$
					int res2 = msg.open();
					if (res2 == SWT.NO)
						return;
				}
				String encoding = store.getString(CSVPreferencePage.P_ENCODING);

				CSVConfig config = new CSVConfig();
				config.setQuery(TableManager.getSQLForCSV(table));
				// config.setCsvEncoding("Shift_JIS"); // ݌Œ
				config.setCsvEncoding(encoding); // ݌Œ
													// TODO:OŐݒł悤ɏC邱

				config.setCsvFile(fileName);
				CSVWriter writer = new CSVWriter(table.getDbConfig(), config);
				writer.execute();

			} catch (Exception e) {
				DbPlugin.getDefault().showErrorDialog(e);
			}
		}
	}

}
