package zigen.plugin.db.diff;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;

public class DDL {

	boolean isSchemaSupport;

	String dbName;

	String schemaName;

	String tableName;

	String ddl;

	public DDL(ITable table) {
		this.dbName = table.getDbConfig().getDbName();
		this.schemaName = table.getSchemaName();
		this.tableName = table.getName();
		this.isSchemaSupport = table.getDataBase().isSchemaSupport();
		this.ddl = getDDLString(table);
	}

	private String getDDLString(ITable tableNode) {
		String result = ""; //$NON-NLS-1$
		try {
			if (tableNode != null) {
				IDBConfig config = tableNode.getDbConfig();
				ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(config, tableNode);
				result = factory.createDDL();
			}
		} catch (Exception e) {
			DbPlugin.log(e);
		}
		return result;
	}

	public String getSqlTableName() {
		StringBuffer sb = new StringBuffer();
		if (isSchemaSupport) {
			sb.append(schemaName + "." + tableName); //$NON-NLS-1$
		} else {
			sb.append(tableName);
		}
		return sb.toString();
	}

	public String getDbName() {
		return dbName;
	}

	public void setDbName(String dbName) {
		this.dbName = dbName;
	}

	public String getDdl() {
		return ddl;
	}

	public void setDdl(String ddl) {
		this.ddl = ddl;
	}

	public String getSchemaName() {
		return schemaName;
	}

	public void setSchemaName(String schemaName) {
		this.schemaName = schemaName;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public boolean isSchemaSupport() {
		return isSchemaSupport;
	}

	public void setSchemaSupport(boolean isSchemaSupport) {
		this.isSchemaSupport = isSchemaSupport;
	}

}
