/*
 * 쐬: 2005/04/17
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core;

import java.math.BigDecimal;
import java.util.Date;

/**
 * TimeWatcherNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/18 ZIGEN create.
 * 
 */
public class TimeWatcher {
	// private static TimeWatcher instance;

	private Date startTime = null;

	private Date stopTime = null;

	private boolean isStart = false; // vǂ̔

	// /**
	// * CX^X
	// * @param<code>_instance</code>
	// */
	// public synchronized static TimeWatcher getInstance() {
	// if (instance == null) {
	// instance = new TimeWatcher();
	// }
	// return instance;
	//
	// }

	/**
	 * RXgN^
	 */
	public TimeWatcher() {
	}

	/**
	 * Zbg finallyŌĂяoĂB
	 */
	public void reset() {
		isStart = false;
		startTime = null;
		stopTime = null;
	}

	/**
	 * Jn
	 */
	public void start() {
		if (isStart) {
			throw new IllegalStateException("Jnł"); //$NON-NLS-1$
		} else {
			isStart = true;
		}
		startTime = new Date();
	}

	/**
	 * I
	 */
	public void stop() {
		if (!isStart) {
			throw new IllegalStateException("JnĂ"); //$NON-NLS-1$
		} else {
			isStart = false;
		}
		stopTime = new Date();
	}

	/**
	 * g[^Ԃ擾
	 * 
	 * @return
	 * @throws Exception
	 */
	public String getTotalTime() {
		if (startTime == null) {
			throw new IllegalStateException("JnĂ"); //$NON-NLS-1$
		}
		if (stopTime == null) {
			throw new IllegalStateException("IĂ"); //$NON-NLS-1$
		}

		return getString((stopTime.getTime() - startTime.getTime()) / 1000.0);
	}

	private String getString(double second) {
		StringBuffer sb = new StringBuffer();
		if ((int) (second / 3600) > 0) { // intŊۂ߂
			sb.append((int) (second / 3600) + "h"); //$NON-NLS-1$
		}
		if ((int) ((second % 3600) / 60) > 0) { // intŊۂ߂
			sb.append((int) (second % 3600) / 60 + "min"); //$NON-NLS-1$
		}
		sb.append(formart(second % 60) + "sec"); //$NON-NLS-1$
		return sb.toString();
	}

	private static String formart(double time) {
		BigDecimal decimal = new BigDecimal(time);
		// decimal = decimal.movePointLeft(4);
		decimal = decimal.setScale(1, BigDecimal.ROUND_UP); // ؏グ
		// decimal = decimal.setScale(1, BigDecimal.ROUND_DOWN); // ؎̂
		// decimal = decimal.setScale(1, BigDecimal.ROUND_UP); // ľܓ
		return decimal.toString();
	}

	/**
	 * vǂ̔胁\bh
	 * 
	 * @return
	 */
	public boolean isStart() {
		return isStart;
	}

}
