/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import zigen.plugin.db.core.ConditionManager;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.ui.bookmark.BookmarkManager;
import zigen.plugin.db.ui.dialogs.DBDialogSettings;
import zigen.plugin.db.ui.dialogs.IDBDialogSettings;
import zigen.plugin.db.ui.editors.ITableViewEditor;

/**
 * DbPluginNX.
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/09 ZIGEN create. [002] 2005/06/02 ZIGEN SQLOt@C(XML)ɕۑ@\ǉ. [003] 2005/09/20 ZIGEN
 *        e[uGfB^piݏOt@C(XML)ɕۑ@\ǉ.
 */
public class DbPlugin extends AbstractUIPlugin {

    // private static Log log = LogFactory.getLog(DbPlugin.class);

    private static DbPlugin plugin;

    private ResourceBundle resourceBundle;

    private IDBDialogSettings dBDialogSettings;

    private XmlController xmlController;

    private String defaultProject = null;

    public DbPlugin() {
        super();
        plugin = this;

        try {
            resourceBundle = ResourceBundle.getBundle("ResourceBundleMessages"); //$NON-NLS-1$
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    private ImageCacher imageCacher;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        xmlController = new XmlController(getStateLocation());
        imageCacher = ImageCacher.getInstance();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            imageCacher.clear();
            saveDBDialogSettings();
            xmlController.save();

        } finally {
            super.stop(context);
        }
    }

    public static DbPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DbPlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public SQLHistoryManager getHistoryManager() {
        return xmlController.getHistoryManager();
    }

    public ConditionManager getConditionManager() {
        return xmlController.getConditionManager();
    }

    public BookmarkManager getBookmarkManager() {
        return xmlController.getBookmarkManager();
    }

    public PluginSettingsManager getPluginSettingsManager() {
        return xmlController.getPluginSettingsManager();
    }

    public synchronized IDBDialogSettings getDBDialogSettings() {
        if (dBDialogSettings == null)
            loadDBDialogSettings();
        return dBDialogSettings;
    }

    protected void loadDBDialogSettings() {
        dBDialogSettings = new DBDialogSettings("Workbench"); //$NON-NLS-1$
        String readWritePath = getStateLocation().append(DbPluginConstant.FN_DB_SETTINGS).toOSString();
        File settingsFile = new File(readWritePath);
        if (settingsFile.exists()) {
            try {
                dBDialogSettings.load(readWritePath);
            } catch (IOException e) {
                dBDialogSettings = new DBDialogSettings("Workbench"); //$NON-NLS-1$
            }
        } else {
            URL dsURL = BundleUtility.find(getBundle(), DbPluginConstant.FN_DB_SETTINGS);
            if (dsURL == null)
                return;
            InputStream is = null;
            try {
                is = dsURL.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8")); //$NON-NLS-1$
                dBDialogSettings.load(reader);
            } catch (IOException e) {
                dBDialogSettings = new DBDialogSettings("Workbench"); //$NON-NLS-1$
            } finally {
                try {
                    if (is != null)
                        is.close();
                } catch (IOException e) {
                    // do nothing
                }
            }
        }
    }

    protected void saveDBDialogSettings() {
        if (dBDialogSettings == null) {
            return;
        }
        try {
            String readWritePath = getStateLocation().append(DbPluginConstant.FN_DB_SETTINGS).toOSString();
            dBDialogSettings.save(readWritePath);
        } catch (IOException e) {
            DbPlugin.log(e);
        }
    }

    public static IViewPart findView(String viewId) {
        IWorkbenchPage page = getDefault().getPage();
        if (page != null) {
            return page.findView(viewId);
        } else {
            return null;
        }
    }

    public static IViewPart findView(String viewId, String secondaryId) throws PartInitException {
        IWorkbenchPage page = getDefault().getPage();
        if (page != null) {
            return page.showView(viewId, secondaryId, IWorkbenchPage.VIEW_VISIBLE);
        } else {
            return null;
        }
    }

    public static IViewPart showView(String viewId) throws PartInitException {
        IWorkbenchPage page = getDefault().getPage();
        if (page != null) {
            return page.showView(viewId);
        } else {
            return null;
        }
    }

    public static IViewPart showView(String viewId, String secondaryId) throws PartInitException {
        IWorkbenchPage page = getDefault().getPage();
        if (page != null) {
            return page.showView(viewId, secondaryId, IWorkbenchPage.VIEW_ACTIVATE);
        } else {
            return null;
        }
    }

    public static void hideView(IViewPart view) {
        IWorkbenchPage page = getDefault().getPage();
        if (page != null && view != null) {
            getDefault().getPage().hideView(view);
        }

    }

    public IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getShell();
    }

    public static ITableViewEditor getActiveTableViewEditor() {
        IEditorPart editor = DbPlugin.getDefault().getPage().getActiveEditor();
        if (editor instanceof ITableViewEditor) {
            return (ITableViewEditor) editor;
        } else {
            return null;
        }
    }

    public static void getCloseEditors(IEditorReference[] editorRefs) {
        DbPlugin.getDefault().getPage().closeEditors(editorRefs, true);
    }

    // public static SQLExecuteView getActiveSQLExecuteView() {
    // IWorkbenchPart wb = getDefault().getPage().getActivePart();
    // if (wb instanceof SQLExecuteView) {
    // return (SQLExecuteView) wb;
    // } else {
    // return null;
    // }
    // }

    /**
     * bZ[W\i_CAOj
     * @param message
     */
    public void showInformationMessage(String message) {
        MessageDialog.openInformation(getShell(), DbPluginConstant.TITLE, message);
    }

    /**
     * bZ[W\ix_CAOj
     * @param message
     */
    public void showWaringMessage(String message) {
        MessageDialog.openWarning(getShell(), DbPluginConstant.TITLE, message);
    }

    /**
     * mF_CAO
     * @param message
     */
    public boolean confirmDialog(String message) {
        return MessageDialog.openConfirm(getShell(), DbPluginConstant.TITLE, message);
    }

    /**
     * gOtmF_CAO
     * @param message
     */
    public MessageDialogWithToggle confirmDialogWithToggle(String message, String toggleMessage, boolean toggleStatus) {
        return MessageDialogWithToggle.openYesNoQuestion(getShell(), DbPluginConstant.TITLE, message, toggleMessage, toggleStatus, null, null);
    }

    public static final String IMG_CODE_BACK = "back.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_BOOKMARK = "bookmark.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_COLUMN = "column.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_CLOCK = "clock.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DB_ADD = "db_add.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DB_COPY = "db_copy.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DB_DELETE = "db_delete.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DB = "db.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_CONNECTED_DB = "connecteddb.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_FORWARD = "forward.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DB_NEW = "new_db.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_NOTNULL_COLUMN = "notNull.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_PK_COLUMN = "primarykey.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_REFRESH = "refresh.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_SCHEMA = "schema.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_SQL = "sql.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_TABLE = "table.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DISABLED_TABLE = "disabledtable.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DISABLED_SYNONYM = "disabledsynonym.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_UNIQUEKEY = "uniquekey.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_ASC = "asc.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DESC = "desc.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_BLANK = "blank.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_SAVE = "save.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_UNKNOWN = "unknown.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_CHECKED = "checked.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_UNCHECKED = "unchecked.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DISABLED_CHECKED = "disabledchecked.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_CHECKED_CENTER = "checkedcenter.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_UNCHECKED_CENTER = "uncheckedcenter.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_DISABLED_CHECKED_CENTER = "disabledcheckedcenter.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_TEMPLATE = "template.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_VIEW = "view.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_FUNCTION = "function.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_SYNONYM = "synonym.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_SEQUENCE = "sequence.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_EXECUTE = "execute.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_CLEAR = "clear.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_COMMIT = "commit.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_ROLLBACK = "rollback.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_IMPORT = "import.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_EXPORT = "export.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_FORMAT = "format.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_VERTICALLAYOUT = "verticallayout.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_HORIZONTALLAYOUT = "horizontallayout.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_REMOVE = "remove_exc.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_REMOVE_ALL = "removea_exc.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_PIN = "pin.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_OPEN = "open.gif"; //$NON-NLS-1$

    public static final String IMG_CODE_SYNCED = "synced.gif"; //$NON-NLS-1$

    protected void initializeImageRegistry(ImageRegistry registry) {

        registerImage(registry, IMG_CODE_SQL);
        registerImage(registry, IMG_CODE_SCHEMA);
        registerImage(registry, IMG_CODE_TABLE);
        registerImage(registry, IMG_CODE_DISABLED_TABLE);
        registerImage(registry, IMG_CODE_DISABLED_SYNONYM);

        registerImage(registry, IMG_CODE_PK_COLUMN);
        registerImage(registry, IMG_CODE_COLUMN);
        registerImage(registry, IMG_CODE_PK_COLUMN);
        registerImage(registry, IMG_CODE_NOTNULL_COLUMN);

        registerImage(registry, IMG_CODE_EXECUTE);
        registerImage(registry, IMG_CODE_CLEAR);

        registerImage(registry, IMG_CODE_FORWARD);
        registerImage(registry, IMG_CODE_BACK);

        registerImage(registry, IMG_CODE_REFRESH);
        registerImage(registry, IMG_CODE_COMMIT);
        registerImage(registry, IMG_CODE_ROLLBACK);

        registerImage(registry, IMG_CODE_DB_ADD);
        registerImage(registry, IMG_CODE_DB_DELETE);

        registerImage(registry, IMG_CODE_BOOKMARK);

        registerImage(registry, IMG_CODE_CLOCK);
        registerImage(registry, IMG_CODE_DB);
        registerImage(registry, IMG_CODE_CONNECTED_DB);

        registerImage(registry, IMG_CODE_DB_NEW);
        registerImage(registry, IMG_CODE_DB_COPY);

        registerImage(registry, IMG_CODE_ASC);
        registerImage(registry, IMG_CODE_DESC);
        registerImage(registry, IMG_CODE_BLANK);
        registerImage(registry, IMG_CODE_SAVE);
        registerImage(registry, IMG_CODE_UNKNOWN);

        registerImage(registry, IMG_CODE_CHECKED);
        registerImage(registry, IMG_CODE_UNCHECKED);
        registerImage(registry, IMG_CODE_DISABLED_CHECKED);

        registerImage(registry, IMG_CODE_CHECKED_CENTER);
        registerImage(registry, IMG_CODE_UNCHECKED_CENTER);
        registerImage(registry, IMG_CODE_DISABLED_CHECKED_CENTER);

        registerImage(registry, IMG_CODE_TEMPLATE);

        registerImage(registry, IMG_CODE_VIEW);
        registerImage(registry, IMG_CODE_FUNCTION);
        registerImage(registry, IMG_CODE_SYNONYM);
        registerImage(registry, IMG_CODE_SEQUENCE);
        registerImage(registry, IMG_CODE_IMPORT);
        registerImage(registry, IMG_CODE_EXPORT);

        registerImage(registry, IMG_CODE_FORMAT);
        registerImage(registry, IMG_CODE_VERTICALLAYOUT);
        registerImage(registry, IMG_CODE_HORIZONTALLAYOUT);

        registerImage(registry, IMG_CODE_REMOVE);
        registerImage(registry, IMG_CODE_REMOVE_ALL);

        registerImage(registry, IMG_CODE_PIN);
        registerImage(registry, IMG_CODE_OPEN);
        registerImage(registry, IMG_CODE_SYNCED);
    }

    private void registerImage(ImageRegistry registry, String fileName) {
        try {
            IPath path = new Path("icons/" + fileName); //$NON-NLS-1$
            URL url = find(path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL(url);
                registry.put(fileName, desc);
            }
        } catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    // pbP[WI_CAOOpen̏WJvWFNg擾
    public String getDefaultProject() {
        return defaultProject;
    }

    // pbP[WI_CAOOpen̏WJvWFNg̐ݒ
    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    private static String getPluginId() {
        return getDefault().getBundle().getSymbolicName();
    }

    public static void log(String message, Exception e) {
        IStatus status = new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, message, e);
        getDefault().getLog().log(status);
    }

    public static void log(String message) {
        log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        log(message, e);

        // for debug
        if (e != null)
            e.printStackTrace();
    }

    public static void log(IStatus status) {
        getDefault().getLog().log(status);
    }

    public static IStatus createErrorStatus(Throwable throwable) {
        return createErrorStatus(-1, throwable);
    }

    private static String getErrorMessage(Throwable throwable) {
        if (throwable != null) {
            String msg = throwable.getMessage();
            if (msg == null) {
                return getErrorMessage(throwable.getCause());
            } else {
                return msg;
            }
        } else {
            return Messages.getString("DbPlugin.ConfrimStatckTraceMessage"); //$NON-NLS-1$
        }
    }

    static IStatus createErrorStatus(int errorCode, Throwable throwable) {
        String msg = getErrorMessage(throwable);
        // bZ[W͍ŏ̉s܂łɕ\
        int endIndex = msg.indexOf(DbPluginConstant.LINE_SEP);
        if (endIndex > 0) {
            msg = msg.substring(0, endIndex);
        }
        return new Status(IStatus.ERROR, getPluginId(), errorCode, msg, throwable);
    }

    public static IStatus createWarningStatus(Throwable throwable) {
        return createWarningStatus(-1, throwable);
    }

    static IStatus createWarningStatus(int errorCode, Throwable throwable) {
        String msg = getErrorMessage(throwable);
        // bZ[W͍ŏ̉s܂łɕ\
        int endIndex = msg.indexOf(DbPluginConstant.LINE_SEP);
        if (endIndex > 0) {
            msg = msg.substring(0, endIndex);
        }
        return new Status(IStatus.WARNING, getPluginId(), errorCode, msg, null);
    }

    // public void showErrorDialog(String message, Throwable throwable) {
    public void showErrorDialog(Throwable throwable) {
        String message = Messages.getString("DbPlugin.ErrorMessage"); //$NON-NLS-1$
        // if (log.isDebugEnabled()) {
        if (throwable != null) {
            throwable.printStackTrace();
        }
        IStatus status = null;
        if (throwable instanceof SQLException) {
            status = createWarningStatus(throwable);
        } else {
            status = createErrorStatus(throwable);
        }

        ErrorDialog.openError(getShell(), DbPluginConstant.TITLE, message, status);
        // log(status);
        // log.error(status);

    }

    private String defaultSaveDir = null;

    public String getDefaultSaveDir() {
        return defaultSaveDir;
    }

    public void setDefaultSaveDir(String defaultSaveDir) {
        this.defaultSaveDir = defaultSaveDir;
    }

    public ImageDescriptor getImageDescriptor(String imageKey) {
        return getImageRegistry().getDescriptor(imageKey);
    }

    public Image getImage(String imageCode) {
        return imageCacher.getImage(imageCode);
    }

    public static Font getDefaultFont() {
        Font font = JFaceResources.getTextFont();
        return font;
    }

    public static Font getSmallFont() {
        Font newFont = null;
        Font font = getDefaultFont();
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            FontData data = datas[0];
            int currnetHeight = data.getHeight();
            data.setHeight(currnetHeight - 1); // TCYύX
            newFont = new Font(Display.getDefault(), data);
        }
        return newFont;
    }

    public static FontData getDefaultFontData() {
        Font font = getDefaultFont();
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            return datas[0];
        }
        return null;
    }

}
