/*
 * 쐬: 2007/10/11
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.jdt.ui;

import java.util.Iterator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

import zigen.plugin.db.ext.jdt.Activator;
import zigen.plugin.db.ext.jdt.ICodeGenerator;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.TreeView;

public abstract class GenerateAction implements IObjectActionDelegate {
	// IViewActionDelegate {

	protected String project;

	protected IAction action;

	protected IStructuredSelection selection;

	protected TreeView treeView;

	protected StructuredViewer structuredViewer;

//	// not run in eclpse3.3
//	public void init(IViewPart view) {
//		System.out.println("public void init(IViewPart view)");
//		this.project = Activator.getDefault().getDefaultProject();
//		this.viewPart = view;
//		if (view instanceof TreeView) {
//			this.structuredViewer = ((TreeView) view).getTreeViewer();
//		} else {
//			throw new RuntimeException("Required TreeView"); //$NON-NLS-1$
//		}
//	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		if (targetPart instanceof TreeView) {
			this.project = Activator.getDefault().getDefaultProject();
			this.treeView = (TreeView)targetPart;
			this.structuredViewer = treeView.getTreeViewer();
		}else{
			throw new RuntimeException("Required TreeView"); //$NON-NLS-1$
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.action = action;
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
			this.action.setEnabled(true);
		} else {
			this.action.setEnabled(false);
			throw new RuntimeException("Required IStructuredSelection."); //$NON-NLS-1$
		}
	}

	protected void createFileAndOpen(PackageFragment pkg, String fileName, String contents) throws JavaModelException, PartInitException {
		pkg.createCompilationUnit(fileName, contents, true, new NullProgressMonitor());

		// String javaProjectName = pkg.getJavaProject().getElementName();
		String pkgName = pkg.getElementName().replace('.', '/');
		String srcPath = pkg.getPackageFragmentRoot().getPath().toString(); // łSRCȂ

		// Cӂ̃\[XtH_ꏊɕۑł悤ɏC
		IContainer container = pkg.getJavaProject().getProject().getParent();
		IPath path = new Path(srcPath + "/" + pkgName + "/" + fileName); //$NON-NLS-1$ //$NON-NLS-2$
		IFile file = container.getFile(path);

		IWorkbenchPage page = Activator.getDefault().getPage();

		IDE.openEditor(page, file);
	}

	// t@C̑݃`FbN
	protected boolean existFile(PackageFragment pkg, String checkFile) throws JavaModelException {
		IJavaElement[] javaElems = pkg.getChildren();
		for (int i = 0; i < javaElems.length; i++) {
			IJavaElement element = javaElems[i];
			if (element.getElementName().equals(checkFile)) {
				return true;
			}
		}
		return false;
	}

	public void run(IAction action) {
		Shell shell = Activator.getDefault().getShell();
		PackageSelectDialog dialog = null;

		if (project != null) {
			dialog = new PackageSelectDialog(shell, getTitle(), project);
		} else {
			dialog = new PackageSelectDialog(shell, getTitle());
		}

		int res = dialog.open();

		if (res == PackageSelectDialog.OK) {
			PackageFragment pkg = dialog.getPackageFragment();
			project = pkg.getJavaProject().getElementName();
			Activator.getDefault().setDefaultProject(project);
			for (Iterator iter = selection.iterator(); iter.hasNext();) {
				Object obj = iter.next();
				invoke(pkg, obj);
			}

		}

	}

	public void invoke(PackageFragment pkg, Object element) {
		if (element instanceof ITable) {
			ITable table = (ITable) element;
			try {
				// Jvf̓ǂݍ
				loadColumnInfo(table);

				// VO̍쐬
				ICodeGenerator creator = createClassCreator(table);

				creator.execute();
				String fileName = creator.getClassName() + ".java"; //$NON-NLS-1$
				if (existFile(pkg, fileName)) {
					Shell shell = Activator.getDefault().getShell();
					MessageBox msg = new MessageBox(shell, SWT.YES | SWT.NO | SWT.ICON_QUESTION);
					msg.setMessage(fileName + Messages.getString("GenerateAction.0")); //$NON-NLS-1$
					msg.setText(Messages.getString("GenerateAction.1")); //$NON-NLS-1$
					int res2 = msg.open();
					if (res2 == SWT.NO)
						return;
				}

				// pbP[W̐ݒ
				creator.setPackageString(pkg.getElementName());
				// Javat@C̍쐬
				createFileAndOpen(pkg, fileName, creator.genaratedString());

			} catch (Exception e) {
				Activator.getDefault().showErrorDialog(e);
			}
		}

	}

	protected void loadColumnInfo(ITable table) {
		// e[uvfWJς(Jvf擾ς݁j`FbN
		if (!table.isExpanded()) {
			// WJtOTrueɂ(e[uvfLbVj
			table.setExpanded(true);
			// e[uꗗ
			new ColumnSearchAction(structuredViewer, table).run();
		}
	}

	abstract public String getTitle();

	abstract public ICodeGenerator createClassCreator(ITable table);

}
