package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

/** RgA񃊃eFp[e[VXLi */
public class PLSQLPartitionScanner extends RuleBasedPartitionScanner {

	public static final String SQL_COMMENT = "__sql_comment"; //$NON-NLS-1$

	public static final String SQL_STRING = "__sql_string"; //$NON-NLS-1$

	public PLSQLPartitionScanner() {
		IPredicateRule[] rules = new IPredicateRule[4];

		IToken comment = new Token(SQL_COMMENT);
		rules[0] = new MultiLineRule("/*", "*/", comment); //$NON-NLS-1$ //$NON-NLS-2$
		rules[1] = new EndOfLineRule("--", comment); //$NON-NLS-1$

		IToken string = new Token(SQL_STRING);
		// rules[2] = new SingleLineRule("\"", "\"", string, '\\');
		// rules[3] = new SingleLineRule("\'", "\'", string, '\\');
		// rules[1] = new MultiLineRule("\"", "\"", string, '\\');
		// rules[2] = new MultiLineRule("\'", "\'", string, '\\');

		// GXP[vɕύX
		rules[2] = new MultiLineRule("\"", "\"", string); //$NON-NLS-1$ //$NON-NLS-2$
		rules[3] = new MultiLineRule("\'", "\'", string); //$NON-NLS-1$ //$NON-NLS-2$

		setPredicateRules(rules);
	}

}
