/*
 * 쐬: 2005/04/03
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

import zigen.plugin.db.preference.SQLEditorPreferencePage;

/**
 * SQLCodeConfigurationNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/10 ZIGEN create.
 * 
 */
public class PLSQLCodeConfiguration extends SourceViewerConfiguration {

	private PLSQLKeywordScanner keyWorkScanner;

	private ColorManager colorManager;

	private PresentationReconciler reconciler;

	/**
	 * RXgN^
	 * 
	 * @param colorManager
	 */
	public PLSQLCodeConfiguration(ColorManager colorManager) {
		this.colorManager = colorManager;
	}

	protected PLSQLKeywordScanner getPLSQLKeywordScanner() {
		if (this.keyWorkScanner == null) {
			this.keyWorkScanner = new PLSQLKeywordScanner(colorManager);
		}
		return keyWorkScanner;
	}

	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] {
				IDocument.DEFAULT_CONTENT_TYPE,
				PLSQLPartitionScanner.SQL_COMMENT,
				PLSQLPartitionScanner.SQL_STRING
		};
	}

	static class SingleTokenScanner extends BufferedRuleBasedScanner {
		public SingleTokenScanner(TextAttribute attribute) {
			setDefaultReturnToken(new Token(attribute));
		}
	};

	/*
	 * // RecAVXgp̃I[oCh\bh public IContentAssistant
	 * getContentAssistant(ISourceViewer sourceViewer) { ContentAssistant
	 * assistant = new ContentAssistant();
	 * 
	 * SQLContentAssistantProcessor processor = new
	 * SQLContentAssistantProcessor();
	 * 
	 * assistant.setContentAssistProcessor(processor,
	 * IDocument.DEFAULT_CONTENT_TYPE);
	 *  // IInformationControlCreator̐ݒ
	 * assistant.setInformationControlCreator(getInformationControlCreator(sourceViewer));
	 *  // ANeBx[VLɂꍇtrue assistant.enableAutoActivation(true);
	 *  // ANeBx[V܂ł̎ assistant.setAutoActivationDelay(500); //
	 * assistant.setAutoActivationDelay(100);
	 *  // ₪PȂꍇ́AIɌ}ꍇtrue assistant.enableAutoInsert(true);
	 * 
	 * ////assistant.install(sourceViewer); return assistant; }
	 */

	// protected void TextWidgetConfig(StyledText text) {
	//
	// preferenceStore = DbPlugin.getDefault().getPreferenceStore();
	//
	// //Color color =
	// Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GREEN);
	// //sqlViewer.getTextWidget().setBackground(color);
	// }
	// \p\bh
	// I[o[Ch
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		// \RTC[̍쐬
		reconciler = new PresentationReconciler();
		InitializeDamagerRepairer();
		return reconciler;
	}

	/** F̐ݒύXꍇɂ̃\bhĂяo܂ */
	public void updatePreferences() {

		getPLSQLKeywordScanner().initialize();

		// Rg̃X^Cݒ
		NonRuleBasedDamagerRepairer commentDR = new NonRuleBasedDamagerRepairer(new TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_COMMENT)));
		reconciler.setDamager(commentDR, PLSQLPartitionScanner.SQL_COMMENT);
		reconciler.setRepairer(commentDR, PLSQLPartitionScanner.SQL_COMMENT);

		// 񃊃ẽX^Cݒ
		NonRuleBasedDamagerRepairer stringDR = new NonRuleBasedDamagerRepairer(new TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_STRING)));
		reconciler.setDamager(stringDR, PLSQLPartitionScanner.SQL_STRING);
		reconciler.setRepairer(stringDR, PLSQLPartitionScanner.SQL_STRING);

		// ftHg̈̃X^Cݒ
		/*
		 * DefaultDamagerRepairer keywordDR = new
		 * DefaultDamagerRepairer(getSQLKeywordScanner());
		 * reconciler.setDamager(keywordDR, IDocument.DEFAULT_CONTENT_TYPE);
		 * reconciler.setRepairer(keywordDR, IDocument.DEFAULT_CONTENT_TYPE);
		 */
	}

	private void InitializeDamagerRepairer() {

		// Rg̃X^Cݒ
		DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer(new SingleTokenScanner(new TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_COMMENT))));
		reconciler.setDamager(commentDR, PLSQLPartitionScanner.SQL_COMMENT);
		reconciler.setRepairer(commentDR, PLSQLPartitionScanner.SQL_COMMENT);

		// 񃊃ẽX^Cݒ
		DefaultDamagerRepairer stringDR = new DefaultDamagerRepairer(new SingleTokenScanner(new TextAttribute(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_STRING))));
		reconciler.setDamager(stringDR, PLSQLPartitionScanner.SQL_STRING);
		reconciler.setRepairer(stringDR, PLSQLPartitionScanner.SQL_STRING);

		// ftHg̈̃X^Cݒ
		DefaultDamagerRepairer keywordDR = new DefaultDamagerRepairer(getPLSQLKeywordScanner());
		reconciler.setDamager(keywordDR, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(keywordDR, IDocument.DEFAULT_CONTENT_TYPE);
	}

}