/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.History;

/**
 * TreeViewerSorterNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/09 ZIGEN create.
 * 
 */
public class HistoryViewSorter extends ViewerSorter {

	public int compare(Viewer viewer, Object e1, Object e2) {
		if (e1 instanceof Folder && e2 instanceof Folder) {
			String a = e1.toString();
			String b = e2.toString();
			return a.compareTo(b);

		} else if (e1 instanceof History && e2 instanceof History) {
			History c1 = (History) e1;
			History c2 = (History) e2;

			return c1.getSqlHistory().getDate().compareTo(c2.getSqlHistory().getDate());

		} else {
			// LȊO͖OŃ\[g
			String a = e1.toString();
			String b = e2.toString();
			return a.compareTo(b);
		}

	}
}
