package zigen.plugin.db.ui.jobs;

import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TimeWatcher;
import zigen.sql.parser.INode;
import zigen.sql.parser.Node;
import zigen.sql.parser.ast.ASTParentheses;

public class UpdateSQLFoldingJob extends AbstractJob {

	IDocument doc;

	ProjectionAnnotationModel model;

	public UpdateSQLFoldingJob(ProjectionAnnotationModel model, IDocument doc) {
		super(Messages.getString("UpdateSQLFoldingJob.0")); //$NON-NLS-1$
		this.model = model;
		this.doc = doc;
	}

	protected IStatus run(IProgressMonitor monitor) {
		INode node = null;
		TimeWatcher tw = new TimeWatcher();
		zigen.sql.parser.IVisitor visitor = null;
		zigen.sql.parser.ISqlParser parser = null;

		try {
			start();

			String sql = doc.get();
			parser = new zigen.sql.parser.SqlParser(sql);
			// visitor = new zigen.sql.parser.ASTVisitor();
			node = new Node("root"); //$NON-NLS-1$
			parser.parse(node);
			// node.accept(visitor, null);
			parser.dump(node);

			showResults(new UpdateFoldingAction(node));

			return Status.OK_STATUS;
		} catch (Exception e) {
			DbPlugin.log(e);

		} finally {
			if (parser != null)
				parser = null;
			if (visitor != null)
				visitor = null;

			stop();
		}
		return Status.OK_STATUS;

	}

	protected class UpdateFoldingAction implements Runnable {
		INode node;

		public UpdateFoldingAction(INode node) {
			this.node = node;
		}

		public void run() {
			try {
				if (model == null)
					return;

				model.removeAllAnnotations();
				applyFolding(doc, model, node);

			} catch (Exception e) {
				DbPlugin.log(e);
			}

		}

		private void applyFolding(IDocument doc, ProjectionAnnotationModel model, INode node) {
			try {
				if (node instanceof ASTParentheses) {
					ASTParentheses p = (ASTParentheses) node;
					int offset = doc.getLineOffset(p.getLineno() - 1);
					int length = doc.getLineOffset(p.getEndLineNo() - 1) - offset;
					Position position = new Position(offset, length);
					model.addAnnotation(new ProjectionAnnotation(), position);
				}
				List list = node.getChildren();
				if (list != null) {
					for (Iterator iter = list.iterator(); iter.hasNext();) {
						INode _node = (INode) iter.next();
						applyFolding(doc, model, _node);
					}
				}
			} catch (BadLocationException e) {
				DbPlugin.log(e);
			}
		}
	}
}
