/*
 * 쐬: 2005/03/10
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.internal;

import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;

/**
 * TableNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/10 ZIGEN create.
 * 
 */
public class Table extends TreeNode implements ITable {

	String remarks;

	TablePKColumn[] tablePKColumns = null;

	TableFKColumn[] tableFKColumns = null;

	TableConstraintColumn[] tableConstraintColumns = null;

	TableIDXColumn[] tableUIDXColumns = null;

	TableIDXColumn[] tableNonUIDXColumns = null;

	/**
	 * RXgN^
	 * 
	 * @param name
	 */
	public Table(String name, String remarks) {
		super(name);
		this.remarks = remarks;
	}

	/**
	 * RXgN^
	 * 
	 * @param name
	 */
	public Table(String name) {
		super(name);
	}

	/**
	 * RXgN^
	 * 
	 * @param name
	 */
	public Table() {
		super();
	}

	public void update(Table node) {
		this.remarks = node.remarks;
		this.tablePKColumns = node.tablePKColumns;
		this.tableFKColumns = node.tableFKColumns;
		this.tableUIDXColumns = node.tableUIDXColumns;
		this.tableNonUIDXColumns = node.tableNonUIDXColumns;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see zigen.plugin.db.ui.internal.ITable#getLabel()
	 */
	public String getLabel() {
		StringBuffer sb = new StringBuffer();

		sb.append(this.getName());
		if (remarks != null && remarks.length() > 0) {
			sb.append(" [");
			sb.append(remarks);
			sb.append("]");
		}
		return sb.toString();

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see zigen.plugin.db.ui.internal.ITable#getRemarks()
	 */
	public String getRemarks() {
		return (remarks == null) ? "" : remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	protected Column[] convertColumns(TreeLeaf[] leafs) {
		List list = new ArrayList(leafs.length);
		for (int i = 0; i < leafs.length; i++) {
			if (leafs[i] instanceof Column) {
				list.add((Column) leafs[i]);
			}
		}
		return (Column[]) list.toArray(new Column[0]);
	}

	/**
	 * e[uLĂJ擾
	 * 
	 * @return
	 */
	public Column[] getColumns() {
		return convertColumns(getChildrens());
	}

	public String getSqlTableName() {
		StringBuffer sb = new StringBuffer();
		if (getDataBase().isSchemaSupport()) {
			// sb.append(getSchema().getName() + "." + getName());
			sb.append("\"");
			sb.append(getSchema().getName());
			sb.append("\"");
			sb.append(".");
			sb.append(getName());

		} else {
			sb.append(getName());
		}
		return sb.toString();
	}

	public String getSchemaName() {
		if (getSchema() != null) {
			return getSchema().getName();
		} else {
			return null;
		}
	}

	public boolean isSchemaSupport() {
		return getDataBase().isSchemaSupport;
	}

	/**
	 * ȉequals\bh͕ύXȂ
	 */
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null) {
			return false;
		}
		if (o.getClass() != getClass()) {
			return false;
		}

		Table castedObj = (Table) o;
		IDBConfig config = castedObj.getDbConfig();
		Schema schema = castedObj.getSchema();

		// ǉ 2007/08/20
		if (config == null){
			System.err.println("Schema#equals() DBConfig擾ł܂łB");
			return false;
		}

		if (castedObj.getName().equals(getName()) && config.equals(getDbConfig()) && schema.equals(getSchema())) {
			return true;
		} else {
			return false;
		}

	}

	public Object clone() {
		Table inst = new Table();
		inst.name = this.name == null ? null : new String(this.name);
		inst.remarks = this.remarks == null ? null : new String(this.remarks);
		return inst;
	}

	public TableFKColumn[] getTableFKColumns() {
		return this.tableFKColumns;
	}

	public TablePKColumn[] getTablePKColumns() {
		return this.tablePKColumns;
	}

	public void setTableFKColumns(TableFKColumn[] tableFKColumns) {
		this.tableFKColumns = tableFKColumns;
	}

	public void setTablePKColumns(TablePKColumn[] tablePKColumns) {
		this.tablePKColumns = tablePKColumns;
	}

	public TableIDXColumn[] getTableUIDXColumns() {
		return tableUIDXColumns;
	}

	public void setTableUIDXColumns(TableIDXColumn[] tableUIDXColumns) {
		this.tableUIDXColumns = tableUIDXColumns;
	}

	public TableIDXColumn[] getTableNonUIDXColumns() {
		return tableNonUIDXColumns;
	}

	public void setTableNonUIDXColumns(TableIDXColumn[] tableNonUIDXColumns) {
		this.tableNonUIDXColumns = tableNonUIDXColumns;
	}

	public String getFolderName() {
		if (getFolder() != null) {
			return getFolder().getName();
		} else {
			return null;
		}
	}

	public TableConstraintColumn[] getTableConstraintColumns() {
		return tableConstraintColumns;
	}

	public void setTableConstraintColumns(TableConstraintColumn[] tableConstraintColumns) {
		this.tableConstraintColumns = tableConstraintColumns;
	}

}
