package zigen.plugin.db.ui.editors.internal.invoker;

import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;

public class ModifyTableInvoker extends AbstractSQLInvoker {


	private static String TITLE = Messages.getString("ModifyTableInvoker.0"); //$NON-NLS-1$

	private String newTableName;

	private String newRemarks;

	public ModifyTableInvoker(ITable table, String newTableName, String newRemarks) {
		super(TITLE, table);
		this.newTableName = newTableName;
		this.newRemarks = newRemarks;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		List list = new ArrayList();

		if (!table.getRemarks().equals(newRemarks)) {
			list.add(factory.createCommentOnTableDDL(newRemarks));
		}
		if (!table.getName().equals(newTableName)) {
			list.add(factory.createRenameTableDDL(newTableName));
		}
		return (String[]) list.toArray(new String[0]);

	}

	// RefreshTablê߂ɁAVe[uݒ肵Ă
	public void doUpdateAfter(ITable table) {
		table.setName(newTableName);
	}

}