package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class AddForeignKeyInvoker extends AbstractSQLInvoker {

	private static String TITLE = Messages.getString("AddForeignKeyInvoker.0"); //$NON-NLS-1$

	String constraintName;

	Column[] columns;

	ITable refTable;

	Column[] refColumns;

	boolean onDeleteCascade;

	public AddForeignKeyInvoker(ITable table, String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
		super(TITLE, table);
		this.constraintName = constraintName;
		this.columns = columns;
		this.refTable = refTable;
		this.refColumns = refColumns;
		this.onDeleteCascade = onDeleteCascade;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String sql = factory.createCreateConstraintFKDDL(constraintName, columns, refTable, refColumns, onDeleteCascade);
		return new String[] {
			sql
		};
	}

}