/*
 * 쐬: 2005/03/18
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.internal.Column;

/**
 * BackgroundColorUpdateThread.java
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/12/13 ZIGEN create.
 * 
 */
public class BackgroundColorUpdateAction implements Runnable {


	private Table table;

	private Column col;

	private Color red;

	private Color blue;

	private Color black;

	private Color glay;

	private Color white;

	public BackgroundColorUpdateAction(Table table, Column col) {

		this.table = table;
		this.col = col;
		Display display = Display.getDefault();
		red = new Color(display, 205, 0, 0); // 
		blue = new Color(display, 0, 0, 204); // 
		black = new Color(display, 0, 0, 0);
		glay = table.getDisplay().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND);
		white = table.getDisplay().getSystemColor(SWT.COLOR_WHITE);

	}

	public void run() {
		IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();

		try {

			String nullSymbol = ""; //$NON-NLS-1$
			if (store.getBoolean(PreferencePage.P_CHANGE_NULL_COLOR)) {
				nullSymbol = store.getString(PreferencePage.P_NULL_SYMBOL);
			}

			int columnSize = table.getColumnCount(); // J擾
			int rowSize = table.getItemCount(); // R[h擾

			for (int i = 0; i < rowSize; i++) {
				updateRecord(i, columnSize, nullSymbol);
			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

	private void updateRecord(int rowIndex, int columnSize, String nullSymbol) {

		String selectColumnName = ""; //$NON-NLS-1$

		TableItem item = table.getItem(rowIndex);
		TableElement elem = (TableElement) item.getData();
		TableColumn[] tableColmns = elem.getColumns();

		if (col != null) {
			selectColumnName = col.getName();
		}

		for (int k = 0; k < columnSize - 1; k++) {

			TableColumn tCol = tableColmns[k];

			if (tCol.getColumnName().equals(selectColumnName)) {
				// Jvꍇ

				item.setForeground(k + 1, white); // F
				item.setBackground(k + 1, blue); // wiF

				table.showColumn(table.getColumn(k + 1)); // J\(XN[)

			} else {
				// JvȂꍇ

				if (nullSymbol.equals(item.getText(k + 1))) {
					// NULL
					item.setForeground(k + 1, blue); // F
				} else {
					// NULLȊO
					item.setForeground(k + 1, black); // F
				}

				item.setBackground(k + 1, white); // wiF
			}
		}

		// ĕ`
		// table.redraw();
	}
}