/*
 * 쐬: 2007/02/10
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors;

import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.ui.editors.internal.ColumnFilterInfo;
import zigen.plugin.db.ui.jobs.TableFilterJob;

public class ColumnFilterDialog extends Dialog {

	private TableViewEditorFor31 editor;

	private TableViewer columnTableViewer;

	private static final int BUTTON_ID_SELECTALL = -100;

	private static final int BUTTON_ID_REMOVEALL = -101;

	public ColumnFilterDialog(Shell parent, TableViewEditorFor31 editor) {
		super(parent);
		super.setDefaultImage(ImageCacher.getInstance().getImage(DbPlugin.IMG_CODE_DB));

		setShellStyle(getShellStyle() | SWT.RESIZE); // TCY\
		this.editor = editor;
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("ColumnFilterDialog.0")); //$NON-NLS-1$
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, BUTTON_ID_SELECTALL, Messages.getString("ColumnFilterDialog.1"), false); //$NON-NLS-1$
		createButton(parent, BUTTON_ID_REMOVEALL, Messages.getString("ColumnFilterDialog.2"), false); //$NON-NLS-1$

		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);

	}

	public boolean close() {
		return super.close();
	}

	protected void buttonPressed(int buttonId) {
		// 邪ꂽꍇ̓^[ER[hݒ肵ă_CAO
		if (buttonId == IDialogConstants.CANCEL_ID) {
			setReturnCode(buttonId);
			close();
		} else if (buttonId == IDialogConstants.OK_ID) {

			// Filters
			TableFilterJob job = new TableFilterJob(editor.getViewer(), editor.filterInfos);
			job.setPriority(TableFilterJob.SHORT);
			job.setUser(false); // _CAOo
			job.schedule();

		} else if (buttonId == BUTTON_ID_SELECTALL) {
			selectAllHandler();
		} else if (buttonId == BUTTON_ID_REMOVEALL) {
			removeAllHandler();
		}

		super.buttonPressed(buttonId);
	}

	private static final String[] headers = {
			"", Messages.getString("ColumnFilterDialog.4"), Messages.getString("ColumnFilterDialog.5"), Messages.getString("ColumnFilterDialog.6"), Messages.getString("ColumnFilterDialog.7"), Messages.getString("ColumnFilterDialog.8"), Messages.getString("ColumnFilterDialog.9"), Messages.getString("ColumnFilterDialog.10"), Messages.getString("ColumnFilterDialog.11")}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);

		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label label = new Label(composite, SWT.NONE);
		label.setText(Messages.getString("ColumnFilterDialog.12")); //$NON-NLS-1$

		columnTableViewer = new TableViewer(composite, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		// TableViewerɃXN[\邽߂Ɉȉ̐ݒs(dv)
		columnTableViewer.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));

		Table table = columnTableViewer.getTable();
		// FONT
		table.setFont(DbPlugin.getDefaultFont());

		// table.setLayoutData(gridData);
		table.setHeaderVisible(true);// wb_ɂ
		table.setLinesVisible(true); // C\

		setHeaderColumn(table, headers);

		columnTableViewer.setColumnProperties(new String[] {
				"dummy", "check", "check", "check", "check", "check", "check", "check", "check"}); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$

		CheckboxCellEditor checkEditor = new CheckboxCellEditor(table);
		CellEditor[] editors = new CellEditor[] {
				null,
				checkEditor,
				null,
				null,
				null,
				null,
				null,
				null,
				null
		};

		columnTableViewer.setCellEditors(editors);
		columnTableViewer.setCellModifier(new ColumnSelectCellModifier());
		columnTableViewer.setLabelProvider(new ColumnSelectLabelProvider());
		columnTableViewer.setContentProvider(new ColumnSelectContentProvider());

		columnTableViewer.setInput(editor.filterInfos);
		columnsPack(table);

		return composite;
	}

	private void selectAllHandler() {
		ColumnFilterInfo[] infos = editor.filterInfos;
		for (int i = 0; i < infos.length; i++) {
			ColumnFilterInfo info = infos[i];
			if (!info.isPrimaryKey()) {
				info.setChecked(true);
			} else {
				info.setChecked(true);
			}
		}
		columnTableViewer.setInput(infos);
	}

	private void removeAllHandler() {
		ColumnFilterInfo[] infos = editor.filterInfos;
		for (int i = 0; i < infos.length; i++) {
			ColumnFilterInfo info = infos[i];
			if (!info.isPrimaryKey()) {
				info.setChecked(false);
			} else {
				info.setChecked(true);
			}
		}
		columnTableViewer.setInput(infos);
	}

	private void setHeaderColumn(Table table, String[] headers) {
		for (int i = 0; i < headers.length; i++) {
			TableColumn col;

			switch (i) {
			case 0:
				col = new TableColumn(table, SWT.NONE, i);
				col.setText(headers[i]);
				col.setResizable(false);
				col.setWidth(0);
				break;
			case 1:
				col = new TableColumn(table, SWT.CENTER, i);
				col.setText(headers[i]);
				col.setResizable(false);
				col.setWidth(50);
				break;
			case 5:
			case 6:
				col = new TableColumn(table, SWT.CENTER, i);
				col.setText(headers[i]);
				col.setResizable(true);
				col.pack();
				break;
			default:
				col = new TableColumn(table, SWT.LEFT, i);
				col.setText(headers[i]);
				col.setResizable(true);
				col.pack();
				break;
			}

		}
	}

	private void columnsPack(Table table) {
		table.setVisible(false);
		TableColumn[] cols = table.getColumns();
		for (int i = 2; i < cols.length; i++) {
			cols[i].pack();
		}
		table.setVisible(true);
	}

	private class ColumnSelectLabelProvider extends LabelProvider implements ITableLabelProvider {

		private ImageCacher imageCacher = ImageCacher.getInstance();

		private Image getImage(boolean isSelected) {
			String key = isSelected ? DbPlugin.IMG_CODE_CHECKED_CENTER : DbPlugin.IMG_CODE_UNCHECKED_CENTER;
			return imageCacher.getImage(key);
		}

		public String getColumnText(Object element, int columnIndex) {
			String result = ""; //$NON-NLS-1$
			ColumnFilterInfo col = (ColumnFilterInfo) element;
			switch (columnIndex) {
			case 0:
				;// ͕\Ȃ
				break;
			case 1:
				;// ͕\Ȃ
				break;
			case 2:
				result = col.getColumnName();
				break;
			case 3:
				result = col.getTypeName().toUpperCase();
				break;
			case 4:
				result = col.getSize();
				break;
			case 5:
				result = col.isPrimaryKey() ? "" : "@"; //$NON-NLS-1$ //$NON-NLS-2$
				break;

			case 6:
				result = col.isNotNull() ? "" : "@"; //$NON-NLS-1$ //$NON-NLS-2$
				break;
			case 7:
				result = col.getDefaultValue();
				break;
			case 8:
				result = col.getCommentName();
				break;
			default:
				break;
			}
			return result;
		}

		public Image getColumnImage(Object element, int columnIndex) {
			ColumnFilterInfo info = (ColumnFilterInfo) element;
			if (!info.isPrimaryKey()) {
				// PKȊO̓`FbN{bNXC[W̕\
				return (columnIndex == 1) ? getImage((info.isChecked())) : null;
			} else {
				// return null;
				return (columnIndex == 1) ? imageCacher.getImage(DbPlugin.IMG_CODE_DISABLED_CHECKED_CENTER) : null;
			}
		}

		public Image getImage(Object obj) {
			return null;
		}
	}

	private class ColumnSelectContentProvider implements IStructuredContentProvider {

		private List contents = null;

		public Object[] getElements(Object inputElement) {
			if (inputElement instanceof ColumnFilterInfo[]) {
				return (ColumnFilterInfo[]) inputElement;
			}
			return null;
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			contents = null;
		}

		public void dispose() {
			contents = null;
		}

	}

	private class ColumnSelectCellModifier implements ICellModifier {

		public ColumnSelectCellModifier() {
		}

		public boolean canModify(Object element, String property) {
			return true;
		}

		public Object getValue(Object element, String property) {
			ColumnFilterInfo item = (ColumnFilterInfo) element;
			if (property == "check") { //$NON-NLS-1$
				return new Boolean(item.isChecked());
			} else {
				return item.getColumnName();
			}
		}

		public void modify(Object element, String property, Object value) {
			if (element instanceof Item) {
				element = ((Item) element).getData();
			}
			ColumnFilterInfo info = (ColumnFilterInfo) element;

			if (property == "check" && !info.isPrimaryKey()) { //$NON-NLS-1$
				info.setChecked(((Boolean) value).booleanValue());

			}

			// e[uEr[XV
			columnTableViewer.update(element, new String[] {
				"check"}); //$NON-NLS-1$

			// // Filters
			// TableFilterJob job = new TableFilterJob(editor.viewer,
			// selectInfos);
			// job.setPriority(TableFilterJob.SHORT);
			// job.setUser(true); // _CAOo
			// job.schedule();

		}

	}

	/**
	 * _CAOTCY
	 */
	protected Point getInitialSize() {
		return new Point(600, 400);
	}

}
