package zigen.plugin.db.ui.contentassist.processor;

import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ContentInfo;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.contentassist.SQLProposalCreator2;
import zigen.plugin.db.ui.views.internal.SQLKeywordScanner;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTInsertStatement;
import zigen.sql.parser.ast.ASTTable;

public class InsertProcessor extends DefaultProcessor {

	public InsertProcessor(List proposals, ProcessorInfo info) {
		super(proposals, info);
	}

	public void createProposals(ASTInsertStatement st) {

		String[] modifiers = SQLKeywordScanner.SQLKeywords;
		try {
			ContentInfo ci = new ContentInfo(ContentAssistUtil.getIDBConfig());
			TableInfo[] tinfos = ci.getTableInfo(); // 	e[u񃊃Xg擾
			ASTTable table = super.findASTTable(st);

			switch (currentScope) {
			case SqlParser.SCOPE_INSERT:
				modifiers = new String[]{
					"into" //$NON-NLS-1$
				};
				break;

			case SqlParser.SCOPE_INTO:
				// e[uXg\
				SQLProposalCreator2.addProposal(proposals, tinfos, pinfo);

				//				if (fromItemCount == 0 || !"".equals(word)) {
				//					SQLProposalCreator.addProposal(proposals, finfo, word, offset, isAfterPeriod);
				//					modifiers = null;
				//				} else {
				//					modifiers = new String[]{
				//							"()", "values", "select * from"
				//					};
				//				}
				break;

			case SqlParser.SCOPE_INTO_COLUMNS:
				createColumnProposal(table);

				//				if (fromItemCount == 1) {
				//					if (st.isTableColumnEditing() || !"".equals(word)) {
				//						// e[uJҏW
				//						Column[] cols = ci.getColumns(st.getTableName());
				//						// 2006/11/24 ZIGEN modify
				//						//Column[] cols = ci.getColumns(ContentAssistUtil.createContentAssistTable(st.getTableName()));
				//						SQLProposalCreator.addProposal(proposals, cols, word, offset, isAfterPeriod);
				//
				//						modifiers = null;
				//					} else {
				//						// e[uJҏW
				//						modifiers = new String[]{
				//								"values", "select * from"
				//						};
				//					}
				//				}
				break;

			//			case SqlParser.SCOPE_INSERTVALUES:
			//				modifiers = null;
			//				break;
			//
			//			case SqlParser.SCOPE_WHERE:
			//				// Whereł́A_ł͏ɃJ\
			//				if (fromItemCount == 1) {
			//					Column[] cols = ci.getColumns(st.getTableName());
			//					// 2006/11/24 ZIGEN modify
			//					//Column[] cols = ci.getColumns(ContentAssistUtil.createContentAssistTable(st.getTableName()));
			//					SQLProposalCreator.addProposal(proposals, cols, word, offset, isAfterPeriod);
			//				}
			//				break;
			}
		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);

		} finally {
			// SQLL[[h̓o^
			SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);
		}
	}

}
