/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.PartInitException;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.TreeView;

public class ConfirmConnectDBAction extends Action implements Runnable {
	Transaction trans = null;

	public ConfirmConnectDBAction(Transaction trans) {
		this.trans = trans;
	}

	public void run() {
		try {
			IDBConfig config = trans.getConfig();
			StringBuffer sb = new StringBuffer();
			sb.append(config.getDbName());
			sb.append(Messages.getString("ConfirmConnectDBAction.1")); //$NON-NLS-1$

			if (DbPlugin.getDefault().confirmDialog(sb.toString())) {
				TreeView view = (TreeView) DbPlugin.findView(DbPluginConstant.VIEW_ID_TreeView);
				if (view == null) {
					view = (TreeView) DbPlugin.showView(DbPluginConstant.VIEW_ID_TreeView);
				}

				TreeContentProvider cp = view.getContentProvider();
				Root root = cp.getRoot();
				TreeLeaf node = root.getChild(config.getDbName());
				if (node != null && node instanceof DataBase) {
					DataBase db = (DataBase) node;
					db.setConnected(true); // 2xh
					ConnectDBJob job = new ConnectDBJob(view.getTreeViewer(), db);
					job.setPriority(ConnectDBJob.SHORT);
					job.setSystem(true);
					job.schedule(); // ڑɎs΁Adb.setConnected(false);

					// ConnectDBJobI܂őҋ@
					try {
						job.join();
					} catch (InterruptedException e) {
						DbPlugin.log(e);
					}

				}
			}

		} catch (PartInitException e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

}
