package zigen.plugin.db.diff;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class DiffContentProvider implements ITreeContentProvider {

	private Root invisibleRoot;

	private TreeViewer viewer;

	Table[] tables = null;

	public void inputChanged(Viewer v, Object oldInput, Object newInput) {

		if (newInput != null) {
			invisibleRoot = new Root("invisible", true); //$NON-NLS-1$

			this.viewer = (TreeViewer) v;

			if (newInput instanceof DDLDiff[]) {
				DDLDiff[] diffs = (DDLDiff[]) newInput;

				for (int i = 0; i < diffs.length; i++) {
					DDLDiff diff = diffs[i];
					invisibleRoot.addChild(diff);

				}

			}

		}

	}

	public void dispose() {
	}

	public Object[] getElements(Object inputElement) {
		return getChildren(invisibleRoot);
	}

	public Object getParent(Object element) {
		if (element instanceof TreeLeaf) {
			return ((TreeLeaf) element).getParent();
		}
		return null;
	}

	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof TreeNode) {
			return ((TreeNode) parentElement).getChildrens();
		}
		return new Object[0];
	}

	public boolean hasChildren(Object element) {
		if (element instanceof TreeNode)
			return ((TreeNode) element).hasChildren();
		return false;
	}

	public Root getInvisibleRoot() {
		return invisibleRoot;
	}
}