/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.diff;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.ui.internal.TreeNode;

/**
 * DDLLabelProviderNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/09 ZIGEN create.
 * 
 */
public class DDLLabelProvider extends LabelProvider {

	ImageCacher ic = ImageCacher.getInstance();

	/**
	 * \郉x̎擾
	 */
	public String getText(Object obj) {
		if (obj instanceof DDLDiff) {
			DDLDiff diff = (DDLDiff) obj;
			return diff.getName();

		} else {
			return obj.toString();
		}
	}

	/**
	 * \摜̎擾
	 */
	public Image getImage(Object obj) {

		String imageKey = ISharedImages.IMG_OBJ_ELEMENT;

		if (obj instanceof DDLDiff) {
			return ic.getImage(DbPlugin.IMG_CODE_TABLE);

		} else if (obj instanceof TreeNode) {
			imageKey = ISharedImages.IMG_OBJ_FOLDER; // FolderACR
		}

		return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
	}
}
