/*
 * 쐬: 2005/03/24
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.internal.OracleColumnCommentSearcher;

/**
 * ColumnSearcherNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/24 ZIGEN create.
 *        [002] 2005/07/30 ZIGEN Oraclep̃JRg擾̒ǉ [003] 2006/07/30 ZIGEN
 *        Vmj(Oraclê)ŃJ񂪎悤ɏC
 * 
 */
public class ColumnSearcher {


	static final int COLUMN_NAME = 4; // J

	static final int DATA_TYPE = 5; // java.sql.Types ł SQL f[^^

	static final int TYPE_NAME = 6; // DB iɈˑ̃f[^^

	static final int COLUMN_SIZE = 7; // TCYBchar/date ^CvɂĂ͍ő啶Anumeric
										//  decimal ^CvɂĂ͌

	static final int DECIMAL_DIGITS = 9; // _ȉ̌

	static final int NULLABLE = 11; // NULL gp̉

	static final int REMARKS = 12; // RgLq (null ̏ꍇ)

	static final int IS_NULLABLE = 18; // NULL lgp̉

	/**
	 * w肵e[uPK擾
	 * 
	 * @param con
	 * @param catalog
	 * @param schemaPattern
	 * @return
	 */
	public static TableColumn[] execute(IDBConfig config, String schemaPattern, String tableName) throws Exception {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return execute(con, schemaPattern, tableName, config.isConvertUnicode());
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * w肵e[ũJ擾
	 * 
	 * @param con
	 * @param catalog
	 * @param schemaPattern
	 * @return
	 */
	public static TableColumn[] execute(Connection con, String schemaPattern, String tableName, boolean convertUnicode) throws Exception {
		List list = new ArrayList();
		ResultSet rs = null;

		try {
			TablePKColumn[] pks = ConstraintSearcher.getPKColumns(con, schemaPattern, tableName); // PK擾;

			DatabaseMetaData objMet = con.getMetaData();

			if (schemaPattern != null) {
				rs = objMet.getColumns(null, schemaPattern, tableName, "%"); //$NON-NLS-1$
			} else {
				rs = objMet.getColumns(null, "%", tableName, "%"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			int seq = 1;
			while (rs.next()) {
				TableColumn column = new TableColumn();

				column.setSeq(seq); // J`i\[gɎgpj

				column.setColumnName(rs.getString(COLUMN_NAME));
				column.setDataType(rs.getShort(DATA_TYPE)); // Types.VARCHARȂ
				column.setTypeName(rs.getString(TYPE_NAME));
				column.setColumnSize(rs.getInt(COLUMN_SIZE));
				column.setDecimalDigits(rs.getInt(DECIMAL_DIGITS));

				// ftHgl̒ǉ
				// column.setDefaultValue(rs.getString("COLUMN_DEF"));
				// 2006/12/15 ZIGEN DefaultlT|[gĂȂꍇz
				// ftHgl̒ǉ
				// String defaultValue = rs.getString("COLUMN_DEF");
				String defaultValue = getDefaultValue(rs, convertUnicode);
				if (defaultValue != null) {
					column.setDefaultValue(defaultValue);
				}
				// 2006/12/15 ZIGEN end

				// Rgǉ
				// column.setRemarks(rs.getString(REMARKS));
				String remarks = rs.getString("REMARKS"); //$NON-NLS-1$
				if (convertUnicode) {
					remarks = JDBCUnicodeConvertor.convert(remarks);
				}
				column.setRemarks(remarks);

				overrideRemarks(con, schemaPattern, tableName, column, remarks, convertUnicode);

				if (rs.getInt(NULLABLE) == DatabaseMetaData.columnNoNulls) {
					column.setNotNull(true);
				} else {
					column.setNotNull(false);
				}

				// <!-- [002] C ZIGEN 2005/09/17
				if (ConstraintSearcher.isPKColumn(pks, column.getColumnName())) {
					column.setUniqueKey(true);
				}
				// log.debug(column);
				// [002] C ZIGEN 2005/09/17 -->

				list.add(column);

				seq++;
			}

			return (TableColumn[]) list.toArray(new TableColumn[0]);

		} catch (Exception e) {
			throw e;
		} finally {
			ResultSetUtil.close(rs);
		}
	}

	protected static void overrideRemarks(Connection con, String schemaPattern, String tableName, TableColumn column, String remarks, boolean convUnicode) throws Exception {
		switch (DBType.getType(con.getMetaData())) {

		case DBType.DB_TYPE_ORACLE:
			String columnComment = OracleColumnCommentSearcher.execute(con, schemaPattern, tableName, column.getColumnName(), convUnicode);
			column.setRemarks(columnComment);
			break;

		default:
			column.setRemarks(remarks);
			break;
		}

	}

	/**
	 * ÂSymfoWAREłCOLUMN_DEF̃J߁ASQLExceptionƂȂB ̂߁Aȉ̃\bhŌʂɏsB
	 * 
	 * @param rs
	 * @return
	 */
	protected static String getDefaultValue(ResultSet rs, boolean convertUnicode) {
		String defaultValue = null;
		try {
			defaultValue = rs.getString("COLUMN_DEF"); //$NON-NLS-1$

			// TRIM
			if (defaultValue != null)
				defaultValue = defaultValue.trim();

			if (convertUnicode) {
				return JDBCUnicodeConvertor.convert(defaultValue);
			}
		} catch (SQLException e) {
			DbPlugin.log(e);
		}
		return defaultValue;

	}

}
