#!/bin/sh
# chconf.sh   եʤɤѤ
#    K.Nakahira, Last updated: 12/29/2002

# ΥץȤǤϡ󥹥ȡΥǥ쥯ȥ˴ؤ
# ŪѹԤޤ

if [ "$1" = "" ]; then
	echo "Usage: $0 <conffile>"
	exit 1
fi

# եɤ߹
if [ -f "$1" ]; then
	. $1
else
	echo "Cannot open '$1'"
	exit 1
fi

MAKEFILE="$BASEDIR/Makefile"
BASEFILE="$BASEDIR/base.conf"
CONFFILE="$BASEDIR/data.conf"
DATE=`date '+%m%d%H%M%S'`

check() {
	echo -n "$1"
	read ans
	if [ "$ans" != "yes" -a "$ans" != "y" ]; then return 1; fi
	return 0
}

# Makefile Խ
setup_makefile() {
	MAKEFILE_ORIG="$MAKEFILE.org-$DATE"
	echo "$MAKEFILE => $MAKEFILE_ORIG"
	cp $MAKEFILE $MAKEFILE_ORIG

	CMD="s!/usr/local/DBIPgSystem/samples/bbs!$BASEDIR!; "
	perl -pe "$CMD" "$MAKEFILE_ORIG" > "$MAKEFILE"
}

# եԽ
setup_baseconf() {
	BASEFILE_ORIG="$BASEFILE.org-$DATE"
	echo "$BASEFILE => $BASEFILE_ORIG"
	cp $BASEFILE $BASEFILE_ORIG

	CMD="s!/usr/local/DBIPgSystem/samples/bbs!$BASEDIR!; "
	CMD=$CMD"s!/usr/local/DBIPgSystem/public_html/cgi-bin/bbs!$CGIDIR_STF!; "
	CMD=$CMD"s!(base->{nph} =) [01]!\$1 $NPH!; "
	CMD=$CMD"s!(base->{suexec} =) [01]!\$1 $SUEXEC!; "
	perl -pe "$CMD" "$BASEFILE_ORIG" > "$BASEFILE"
}

# ǡեԽ
setup_dataconf() {
	CONFFILE_ORIG="$CONFFILE.org-$DATE"
	echo "$CONFFILE => $CONFFILE_ORIG"
	cp $CONFFILE $CONFFILE_ORIG

	CMD="s!(maintenance =>) 0!\$1 1!; "
	CMD=$CMD"s!(basedir =>) '/usr/local/DBIPgSystem/samples/bbs'!" \
		CMD=$CMD"\$1 '$BASEDIR'!; "
	CMD=$CMD"s!(staff =>) '/cgi-bin/bbs'!\$1 '$BASEURI'!; "
	CMD=$CMD"s!(mailfrom =>) '.*?'!\$1 '$MAILFROM'!; "
	CMD=$CMD"s!(mailto =>) '.*?'!\$1 '$MAILTO'!; "
	[ -n "$DB_DATA_SOURCE" ] && \
		CMD=$CMD"s!(data_source =>) 'dbname=[^']*'!\$1 '$DB_DATA_SOURCE'!; "
	[ -n "$DB_USERNAME" ] && \
		CMD=$CMD"s!(username =>) 'dbipg'!\$1 '$DB_USERNAME'!; "
	[ -n "$DB_PASSWD" ] && \
		CMD=$CMD"s!(passwd =>) 'dbipg_passwd'!\$1 '$DB_PASSWD'!; "
	perl -pe "$CMD" "$CONFFILE_ORIG" > "$CONFFILE"

	return
}

echo "*** Makefile ***"
check "Would you like to fix $MAKEFILE (yes/no) ? " \
	&& setup_makefile || echo "Aborted."
echo "*** $BASEFILE ***"
check "Would you like to fix the config file '$BASEFILE' (yes/no) ? " \
	&& setup_baseconf || echo "Aborted."
echo "*** $CONFFILE ***"
check "Would you like to fix the config file '$CONFFILE' (yes/no) ? " \
	&& setup_dataconf || echo "Aborted."
exit

