#!/usr/bin/perl
# Template.pm   PerlΥɤƥץ졼Ȥ򰷤⥸塼
#    $Id: Template.pm,v 1.1.1.1 2002/12/26 04:37:53 nakahira Exp $
#    Last updated: 12/22/2002
#
# Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association
#   Written by K.Nakahira
#
#  This program is licensed under the GNU GPL.
#  See the following URL for more details:
#    http://www.gnu.org/licenses/gpl.txt
#

package Template;
require 5.005;

use strict;
use IO::File;
use POSIX qw(tmpnam);

use vars qw(@ISA @EXPORT $VERSION);
$VERSION = '1.010';

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw();

=for html
<div class="header">
<h1>Template.pm</h1></div>

=for html
<div class="pod">

=head1 NAME

Template - PerlΥɤƥץ졼Ȥ򰷤⥸塼

=head1 DESCRIPTION

Perl Υɤȥƥץ졼ȤʬΥΤʥ⥸塼롣
ƥץ졼ȤŬڤʲս Perl ΥɤळȤǡ
Perl ѿ򻲾ȤǤ롣

  use Template;

  # ŵŪʻȤ
  $tmpl = Template->new($templatefile);
  $out = $tmpl->out(\%var, \%nvar);

  # ǥɤΤ
  $out = Template->new($templatefile)->out(undef, undef, decodeonly => 1);

=head2 METHODS

=over 4

=item new ( FILE [,OPTION] )

  $tmpl = Template->new($file, %opt);

    OPTION :
      decoded => BOOLEAN       # true ʤХǥɤԤʤ
      tmpdir => STRING         # ⥸塼ǻȤƥݥǥ쥯ȥ
      escapecode => CODE       # nvar  var Ȥ˻Ȥ

Template֥Ȥ֤

$opt{escapecode} ά줿ϡ'&', '<', '>', '"' 
'&amp;', '&lt;', '&gt;', '&quot;' Ѵե륿ŬѤ롣

=cut

sub new {
  my ($class, $file, %opt) = @_;
  my $self = { file => $file };
  bless $self, $class;
  $self->{__decoded__} = $opt{decoded};
  $self->{__tmpdir__} = $opt{tmpdir} || '/tmp';
  $self->{__escapecode__} = $opt{escapecode} ||
	sub {
	  my $str = shift;
	  $str =~ s{([&<>"])}{ $1 eq '&' ? '&amp;' : $1 eq '<' ? '&lt' :
							 $1 eq '>' ? '&gt;' : '&quot;' }ge;
	};
  return $self;
}

=item out ( VAR, NVAR [,OPTION] )

  print $tmpl->out($var, $nvar, %opt);

  ARGS :
    var => HASHREF             # $nvar, $var ǻȤǤ
    nvar => HASHREF            # $nvar ΤߤǻȤǤ

  OPTION :
    decodeonly => BOOLEAN      # ǥɤΤ

ƥץ졼ȤϤ롣
var, nvar ǻꤵ줿ͤϡƥץ졼ѿ $nvar ǻȤǤ롣
ˡvar ǻꤵ줿ͤפ줿Τ
ƥץ졼ѿ $var ǻȤǤ롣

=cut

sub out {
  my ($self, $var, $nvar, %opt) = @_;

  $self->{__string__} = $self->decode() unless(exists $self->{__string__});
  return $self->{__string__} if($opt{decodeonly});
  my $fh_tmp = $self->_create_tmpfile();
  my %var = %{ $self->_replica_var($var, $self->{__escapecode__}) };
  my %nvar = ( %$var, %$nvar );

  my $oldfh = select($fh_tmp);
  eval $self->{__string__};
  select($oldfh);
  die "'$self->{file}' is invalid: $@" if($@);

  my $out;
  seek($fh_tmp, 0, 0) or die "Cannot seek: $!";
  $out .= $_ while(<$fh_tmp>);

  return $out;
}

=item decode ( [OPTION] )

  $tmpl->decode();

    OPTION :
      file => STRING           # ե̾
      forbid => HASHREF        # ̵¥롼פˤʤƥץ졼
                               # ѡ
      import => BOOLEAN        # true ʤ ݡȤ줿ե

ƥץ졼ȥե뤫 Perl Υɤ롣
ƥץ졼ȥեȤˤϡƵŪ˸ƤӽФ롣

=cut

sub decode {
  my ($self, %opt) = @_;

  my $file = $opt{file} || $self->{file};

  # ƥץ졼ȥեɤ߹
  my $old_input_sep = $/;
  open(IN, $file) or die "Cannot open '$file'";
  undef $/;
  flock(IN, 1);
  my $code = <IN>;
  close(IN);
  $/ = $old_input_sep;

  return $code if($self->{__decoded__});

  # ƥץ졼ȥե Perl ΥɤѴ
  $opt{forbid} ||= { };
  my $forbid = { $file => 1, %{ $opt{forbid} } };
  my $dir = $file;
  $dir =~ s!/[^/]*$!!;
  my ($str, $err_forbid, $ifile);
  my $import = { };
  $code =~ s/([\\'])/\\$1/g;
  $code =~ s{<%([^%]*%+(?:[^>%][^%]*%+)*)>}{
	$str = $1;
	chop($str);
	$str =~ s/\\([\\'])/$1/g;
	if($str =~ m/^\s*#import\(([^)]+)\);?\s*$/) {
	  # եΥݡ
	  $ifile = "$dir/$1";
	  if($forbid->{$ifile}) {
		$err_forbid = $ifile;
		'';
	  } else {
		$import->{$ifile} = 1;
		"';\n{\n<% $ifile %>}\nprint '";
	  }
	} else {
	  "';\n$str\n;\nprint '";
	}
  }eg;

  die "$file: Infinity loop ($err_forbid)" if($err_forbid);

  foreach my $key (keys %$import) {
	$str = $self->decode(file => $key, forbid => $forbid, import => 1);
	$code =~ s/<% $key %>/$str/g;
  }

  $self->{__decoded__} = 1 unless($opt{import});
  return join('', "print '", $code, "';\n");
}

=item _replica_var ( VAR [,FILTER] )

  $out = $self->_replica_var($in, $filter);

    ARGS :
      $in => REF               # ѿ
      filter => CODEREF        # ե륿

    RET : REF                  # $out ʣ

ѿʣ롣
ѿϥåؤΥե󥹤ξϡ
éäʣ롣
ARRAY, HASH, GLOB, SCALAR, REF ؤΥե󥹰ʳ
ե󥹤ξϡ
ʴʣǤϤʤ˥ե󥹤ΤΤñ˥ԡ롣

=cut

sub _replica_var {
  my ($self, $in, $filter) = @_;
  my $out;
  if(ref($in) eq '') {
	return (defined($filter) ? &$filter($in) : $in)
  } elsif(ref($in) eq 'ARRAY') {
	$out = [ ];
	foreach my $i (@$in) {
	  push(@$out, $self->_replica_var($i, $filter)); }
  } elsif(ref($in) eq 'HASH') {
	$out = { };
	foreach my $k (keys %$in) {
	  $out->{$k} = $self->_replica_var($in->{$k}, $filter); }
  } elsif(ref($in) eq 'GLOB') {
	$$out = $$in;
  } elsif(ref($in) eq 'SCALAR') {
	$$out = (defined($filter) ? &$filter($$in) : $$in);
  } elsif(ref($in) eq 'REF') {
	$out = $self->_replica_var($$in, $filter);   return \$out;
  } else {
	return $in;
  }
  return $out;
}

sub _create_tmpfile {
  my $self = shift;

  my ($fh, $n, $name);
  while(1) {
	($name = tmpnam() . $$ . int(rand(10000))) =~ s!^.*/!!;
	$name = "$self->{__tmpdir__}/template-$name";
	last if($fh = IO::File->new($name, O_RDWR|O_CREAT|O_EXCL));
	die "Unable to create new temporary file: $!" if($n++ > 30);
  }

  flock($fh, 2);
  unlink($name);
  return $fh;
}

1;
__END__

=back

=head1 SEE ALSO

F<IO::File>

=head1 AUTHOR

Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the following URL for more details:
  http://www.gnu.org/licenses/gpl.txt

Written by Kenji Nakahira <nakahira@coop.nagoya-u.ac.jp>

=for html
</div>

=cut
