#!/usr/bin/perl
# DBIPgSystem::Passwd.pm   DBIPgSystemˤƥѥɴԤ⥸塼
#    $Id: Passwd.pm,v 1.2 2002/12/29 08:11:42 nakahira Exp $
#    Last updated: 12/29/2002
#
# Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association
#   Written by K.Nakahira
#
#  This program is licensed under the GNU GPL.
#  See the following URL for more details:
#    http://www.gnu.org/licenses/gpl.txt
#

package DBIPgSystem::Passwd;
require 5.005;

use strict;
use AutoLoader;
use CGI qw/-no_xhtml/;
use DBI;
use Digest::MD5;

use lib "..";
use DBIPgSystem::DB;

use vars qw(@ISA @EXPORT $VERSION $DEBUG $TEST);
$VERSION = '2.001';

@ISA = qw(AutoLoader);

=for html
<div class="header">
<div class="bar">
<a href="../index.html">Top</a>
<a href="index.html">ޥ˥奢</a>
</div>
<h1>DBIPgSystem::Passwd.pm</h1></div>

=for html
<div class="pod">

=head1 NAME

DBIPgSystem::Passwd - DBIPgSystemˤƥѥɴԤ⥸塼

=head1 DESCRIPTION

ѥɴԤ

=head2 METHODS --- API

=over 4

=item new ( CONFIG_FILE [,OPTION] )

  $dbpass = DBIPgSystem::DB->new($config_file, %opt);

󥹥ȥ饯$config_file ϥ桼ե롣

=cut

sub new {
  my ($class, $dbi, $conffile, %opt) = @_;
  $DEBUG = $opt{debug} || 0;
  $TEST = $opt{test} || 0;

  # ɤ߹
  $dbi->fatal_error("Cannot open '$conffile'")
	unless(-f $conffile and -r $conffile);
  my $self;
  eval {
	require $conffile;
	$self = &configure($dbi->{userinfo}{group}) };
  $dbi->fatal_error($@) if($@);

  $self->{userinfo} =
	{ group => $dbi->{userinfo}{group} };
  $self->{dbi} = $dbi;
  bless $self, $class;
  $self->_init();

  return $self;
}

1;

__END__

=item column_check ( COLUMN )

  $error = $dbpass->column_check($col);

    ARGS :
      $col => HASHREF          # 桼

    RET : ARRAYREF             # 顼ξ

桼Υ顼åԤ

=cut

sub column_check {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $col) = @_;
  my $dbi = $self->{dbi};

  my $error = &{ $self->{column_check} }($col);
  if($error and @$error) {
	foreach my $e (@$error) {
	  $e = { name => $e->[0], print => $self->{column_name}{ $e->[0] },
			 msg => $dbi->get_errmsg($e->[1]) };
	}
  }

  # 桼̾Υå
  my $coluser = $dbi->{global}{userinfo}{col_user};
  push(@$error, { name => $coluser,
				  print => $self->{column_name}{ $coluser },
				  msg => $dbi->get_errmsg('registry_username') })
	if($col->{$coluser} eq 'root');

  $self->_hook($col, $error);
  return $error;
}

=item readcol ( TYPE, VALUE )

  $col = $dbpass->readcol('uid', $uid);
  $col = $dbpass->readcol('email', $email);

    ARGS :
      $type => STRING          # 
      $value => STRING         # 

    RET : HASHREF              # 桼

桼֤

=cut

sub readcol {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $type, $value) = @_;
  my $dbi = $self->{dbi};

  my $colhash =
	{ uid => 'system_uid', email => $dbi->{global}{userinfo}{col_email} };
  my $colname = $colhash->{$type}
	or $dbi->fatal_error("\$type is invalid: $type");

  my $qval = $dbi->{dbh}->quote($value);
  my $array = [ ];
  @$array = $dbi->selectrow_array
	("SELECT * FROM \"$self->{global}{table}\" WHERE "
	 . "$colname = $qval") or return undef;

  my $col = { };
  my $i = 0;
  foreach my $c (@{ $self->{column} }, @{ $self->{syscol} }) {
	next if($c->{nodb});
	$col->{ $c->{name} } = $array->[$i];
	$i++;
  }

  $self->_hook($col);
  return $col;
}

=item register ( COLUMN, UIDREF )

  $error = $dbpass->register($col, $uidref);

    ARGS :
      $col => HASHREF          # 桼
      $uidref => NUMREF        # UID ؤΥե

    OPTION :
      rollback => BOOLEAN      # true ʤ commit ʤ
      update => BOOLEAN        # true ʤХ桼ι

    RET : HASHREF              # 顼ξ

桼ǡ١롣
ºݤ˴ϿƤǡȽʣ뤫ɤĴ١
ʣʤä uid դ롣
$opt{rollback}  true ʤСcommit 򤻤 uid ʤ

=cut

sub register {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $col, $uidref, %opt) = @_;
  my $dbi = $self->{dbi};
  my $dbh = $self->{dbi}{dbh};

  my $table = $self->{global}{table};

  # 桼̾Υå
  my $coluser = $dbi->{global}{userinfo}{col_user};
  return { name => $coluser,
		   print => $self->{column_name}{ $coluser },
		   msg => $dbi->get_errmsg('registry_username') }
	if($col->{$coluser} eq 'root');

  # 桼
  my ($colname, $colval);
  foreach my $c (@{ $self->{column} }) {
	next if($c->{nodb});
	push(@$colname, "\"$c->{name}\"");
	push(@$colval, $col->{ $c->{name} });
  }

  # ƥ
  my $syscol = [ 'system_uid', 'system_group', 'system_time' ];
  my $bnum;
  my $n = @$colval;
  foreach my $c (@$syscol) { $bnum->{$c} = $n++; }
  my $sys = { system_uid => undef, system_group => $self->{userinfo}{group},
			  system_time => 'NOW' };

  # UPDATE/INSERTʸ
  foreach my $c (@$syscol) { $colval->[ $bnum->{$c} ] = $sys->{$c}; }
  my $quid = $dbh->quote($$uidref);
  my $sql = $opt{update} ?
	"UPDATE \"$table\" SET " . join(', ', map { "$_ = ?" } @$colname, @$syscol)
	  . " WHERE system_uid = $quid" :
		"INSERT INTO \"$table\" ( " . join(', ', @$colname, @$syscol)
		  . " ) VALUES ( " . join(', ', map { '?' } @$colval) . " )";

  # å
  my $sth;
  eval {
	$sth = $dbh->prepare($sql);
	$sth->execute(@$colval);
	$dbh->rollback;
  };
  if($@) {
	# 顼
	my $errstr = "$@ ; " . $dbh->errstr;
	eval { $dbh->rollback };
	if($errstr =~ m/unique index/i) {
	  eval { "" =~ m/$table/ };
	  $errstr =~ s/^.*${table}_(.*)_key$/$1/s;
	  return { name => $errstr, print => $self->{column_name}{$errstr},
			   msg => $dbi->get_errmsg('registry_uniq') };
	}
	$dbi->fatal_error($errstr, sql => $sql);
  }

  # system_uid 
  unless($opt{update} or $opt{rollback}) {
	eval { $$uidref = $dbh->selectrow_array
			 ("SELECT nextval('seq_auth_uid')") };
	$self->fatal_error("$@ ; " . $dbh->errstr)
	  if($@ or $$uidref eq '');
  }
  $colval->[ $bnum->{system_uid} ] = $$uidref;

  # UPDATE/INSERTʸ¹Ԥ commit 򤹤
  eval {
	$sth->execute(@$colval);
	unless($opt{rollback}) { $dbh->commit; }
	else { $dbh->rollback; }
  };
  $dbi->fatal_error("$@ ; " . $dbh->errstr) if($@);

  return undef;
}

=item create_table ( [OPTION] )

  $str = $dbpass->create_table() or die;

    OPTION :
      drop => BOOLEAN          # DROP ޥɤ֤

    RET : STRING               # CREATE TABLE ޥ

ǡե˽äƥơ֥褦
CREATE TABLE ޥɤ֤

=cut

sub create_table {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 1);

  my $list = [ ];
  my $uniq;
  foreach my $c (@{ $self->{column} }) {
	next if($c->{nodb});
	$uniq = $c->{uniq} ? 'UNIQUE' : '';
	push(@$list, "  \"$c->{name}\" text $uniq");
  }
  foreach my $c (@{ $self->{syscol} }) {
	push(@$list, "  \"$c->{name}\" $c->{type}");
  }

  my $ret = [ ];
  push(@$ret, 'DROP SEQUENCE seq_auth_uid;',
	   "DROP TABLE \"$self->{global}{table}\";")
	if($opt{drop});
  push(@$ret, 'CREATE SEQUENCE seq_auth_uid;');
  push(@$ret, "CREATE TABLE \"$self->{global}{table}\" (\n"
	   . join(",\n", @$list) . ' );');
  return join("\n", @$ret) . "\n";
}

=back

=head2 METHODS

=over 4

=item send_mail ( COLUMN [,OPTION] )

  $dbpass->send_mail($col, $type);

    ARGS :
      $col => HASHREF          # 桼
      $type => STRING          # 

桼Ͽ/桼ιδλʤɤΤ餻뤿Υ᡼롣

=cut

sub send_mail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $col, $type) = @_;
  my $dbi = $self->{dbi};

  my ($mailto, $title, $body) =
	&{ $self->{global}{mail} }($self, $col, $type);
  $dbi->send_mail($mailto, $title, $body);
}

=back

=head2 TEST METHODS

=over 4

=item test_conf ( )

  $dbi->test_conf();

ɤ߹桼ե뤬ɤǧ롣

=cut

sub test_conf {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;
  my $tmp;

  $tmp = $self->{global}{table};
  die "dbtable '$tmp' is invalid"
	unless($tmp =~ m/^[a-z](?:|[a-z_]*[a-z])$/
		   and $tmp !~ m/^(seq_|dbsession|sys_)/
		   and length($tmp) < $self->{dbi}{sys}{sqlnamelen});

  foreach my $col (@{ $self->{column} }) {
	die "'\$self->{column}[*]{name}' is invalid: $col->{name}"
	  unless($col->{name} =~ m/^[a-z](?:|[a-z_]*[a-z])$/
			 and $col->{name} !~ m/^(system_|draft_)/
			 and length($col->{name}) < $self->{dbi}{sys}{sqlnamelen});
  }

  if(defined $self->{hook}) {
	foreach my $key (keys %{ $self->{hook} }) {
	  die "\$self->{hook}{$key} is invalid"
		if(ref($self->{hook}{$key}) ne 'CODE');
	}
  }
}

=item test_errcode ( )

  $dbi->test_errcode();

$errcode ˻ꤵ줿顼ɤ
顼åեƤ뤳Ȥǧ롣

=cut

sub test_errcode {
  &dbdebug('sub', @_) if($DEBUG);
  my $self = shift;
  my $dbi = $self->{dbi};
  my $errcode = [ 'registry_uniq', 'registry_username' ];
  foreach my $c (@$errcode) { $dbi->get_errmsg($c); }
}

=back

=head2 INTERNAL METHODS

=over 4

=item _init ( )

  $self->_init();

Ԥ

=cut

sub _init {
  my $self = shift;
  $self->{syscol} =
	[ { name => 'system_uid', type => 'int4' },
	  { name => 'system_group', type => 'text' },
	  { name => 'system_time', type => 'timestamp' },
	];
}

=item _hook ( [ARGS] )

  $self->_hook(@args);

$self->{hook}{ (᥽å̾) } ƤиƤӽФ

=cut

sub _hook {
  my $self = $_[0];
  my $method = (caller(1))[3];
  $method =~ s/.*:://g;

  &{ $self->{hook}{$method} }(@_) if($self->{hook}{$method});
}

# 1;
# __END__

=back

=head1 SEE ALSO

F<DBIPgSystem>, F<Jcode>

=head1 COPYRIGHT

Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the following URL for more details:
  http://www.gnu.org/licenses/gpl.txt

Written by Kenji Nakahira <nakahira@coop.nagoya-u.ac.jp>

=for html
</div>

=cut
