#!/usr/bin/perl
# DBIPgSystem::DB.pm
#    $Id: DB.pm,v 1.2 2002/12/29 08:11:42 nakahira Exp $
#    Last updated: 12/29/2002
#
# Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association
#   Written by K.Nakahira
#
#  This program is licensed under the GNU GPL.
#  See the following URL for more details:
#    http://www.gnu.org/licenses/gpl.txt
#

package DBIPgSystem::DB;
require 5.005;

use strict;
use AutoLoader;
use IO::File;
use CGI qw/-no_xhtml/;
use Text::CSV_XS;
use DBI;
use Jcode;
use Digest::MD5;
use POSIX qw(tmpnam);
$CGI::POST_MAX = 30_000_000;				# 30MB

use lib "..";
use DBIPgSystem::Code;
use Template;

use vars qw(@ISA @EXPORT $VERSION $DEBUG $TEST);
$VERSION = '2.001';

require Exporter;
@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(dbdebug);

=for html
<div class="header">
<div class="bar">
<a href="../index.html">Top</a>
<a href="index.html">ޥ˥奢</a>
</div>
<h1>DBIPgSystem::DB.pm</h1></div>

=for html
<div class="pod">

=head1 NAME

DBIPgSystem::DB - DBIPgSystem Τꥳʬ

=head1 DESCRIPTION

ǡե뤫ɤ߹
ǡ١إꡢ
CSV/ֶڤϤԤ

=head2 METHODS --- API

=over 4

=item new ( CONFIG_FILE, GROUP, USER [,OPTION] )

  $dbi = DBIPgSystem::DB->new($config_file, $group, $user, %opt);

    ARGS :
      group => STRING          # 롼̾
      user => STRING           # 桼̾

    OPTION :
      debug => BOOLEAN         # true ʤХǥХå⡼
      test => BOOLEAN          # true ʤưƥȥ⡼
      nph => BOOLEAN           # true ʤ NPH
      no_db => BOOLEAN         # true ʤХǡ١˥ʤ
      test_db_commit => BOOLEAN  # true ʤ commit  (test ʻ)

󥹥ȥ饯$config_file ϥǡե롣

=cut

sub new {
  my ($class, $conffile, $group, $user, %opt) = @_;
  $DEBUG = $opt{debug} || 0;
  $TEST = $opt{test} || 0;

  # ɤ߹
  die "new: Cannot open '$conffile'" unless(-f $conffile and -r $conffile);
  my $self;
  eval {
	require $conffile;
	$self = &configure($group) };
  my $conferror = $@;

  # ǥե
  $self->{global}{mail_charset} ||= 'ISO-2022-JP';
  $self->{global}{searchnum} ||= 50;

  # $self->{sys} : ƥѤѥ᡼
  $self->{sys} =
	{ nph => $opt{nph} ? 1 : 0, search_ext => '_s', sqlnamelen => 32,
	  printheader => 0, fatalerror => 0, export_mode => 0, incode => '',
	};

  # $self->{userinfo} : 桼
  $self->{userinfo} =
	{ group => $group,
	  staff => $self->{global}{staff}{$group} ? 1 : 0,
	};
  $self->{db}{dbtnum} = scalar(keys %{ $self->{db}{col} });

  # $self->{query} : CGI ֥
  $self->{query} = CGI->new();
  $self->{query}->autoEscape(undef);			# ưפ
  bless $self, $class;

  $self->DBIPgSystem::DB::_init();

  $self->{template_src} = { };			# ƥץ졼ȤΥ

  if($DEBUG) {
	print "HTTP/1.1 200 OK\r\n" if($self->{sys}{nph});
	print "Status: 200 OK\r\n";
	print "Content-type: text/plain\r\n\r\n";
	&dbdebug('sub', @_);
	$self->{sys}{printheader} = 1;
	$self->{global}{html_charset} = "EUC-JP";
	$self->{debug}{maintenance} = 0;
  }

  if($TEST) {
	$self->{debug}{no_db_commit} = 1 unless($opt{test_db_commit});
	$self->{debug}{maintenance} = 0;
  }
  $self->fatal_error("conffile: $conferror") if($conferror);
  $self->fatal_error("Group '$group' doesn't exist\n")
	unless($self->{global}{groups}{$group});

  # $self->{global} Խ
  $self->{global}{code_dist} = { $group => $self->{global}{code_dist} }
	if(ref($self->{global}{code_dist}) eq '');

  # dbcol, dbseq, dbcnum 
  my $search_num;
  my $n = 0;
  my $primary = $self->{global}{primary};
  foreach my $dbt (keys %{ $self->{db}{col} }, ":$primary") {
	next if($dbt eq $primary);	# $primary νϺǸ˹Ԥ
	$dbt = $primary if($dbt eq ":$primary");
	$self->{dbcol}{$dbt} = [ ];
	$self->{dbseq}{$dbt} = { };
	# $search_num ˡơ֥ $dbt ΥοƤ
	$search_num = @{ $self->{db}{col}{$dbt} } -
	  ($dbt eq $primary ? (scalar(keys %{ $self->{db}{col} }) - 1) : 0);

	foreach my $dbc (@{ $self->{db}{col}{$dbt} }) {
	  if($dbt eq $self->{global}{primary}) {
		if(ref($dbc) ne 'HASH') {
		  $self->{dbcnum}{$dbc} = [ ];
		  foreach (@{ $self->{dbcol}{$dbc} }) {
			push(@{ $self->{dbcnum}{$dbc} }, $n++);
		  }
		  next;
		}
		push(@{ $self->{dbcnum}{$dbt} }, $n++);
	  }
	  # $dbc->{num}, $dbc->{search_num} ɲä
	  $dbc->{num} = @{ $self->{dbcol}{$dbt} };
	  $dbc->{search_num} = $search_num++ if($dbc->{search});
	  # $self->{dbcol}, $self->{dbseq}  $dbc ɲä
	  push(@{ $self->{dbcol}{$dbt} }, $dbc);
	  $self->{dbseq}{$dbt}{ $dbc->{name} } = $dbc;
	}

	# $self->{dbnum} 
	$self->{dbnum}{$dbt} =
	  { user => scalar @{ $self->{dbcol}{$dbt} },
		search => $search_num - @{ $self->{dbcol}{$dbt} },
		user_search => $search_num,
	  };
  }
  undef $self->{db}{col};

  # ƥεհ
  $self->{db}{sysseq} = { };
  $self->{db}{sysseq} = $self->{db}{sysseq};
  foreach my $i (0 .. $#{ $self->{db}{syscol} }) {
	$self->{db}{sysseq}{ $self->{db}{syscol}[$i]{name} } =
	  $self->{db}{syscol}[$i];
	$self->{db}{syscol}[$i]{num} = $i;
  }
  $self->{db}{subsysseq} = { };
  $self->{db}{subsysseq} = $self->{db}{subsysseq};
  foreach my $i (0 .. $#{ $self->{db}{subsyscol} }) {
	$self->{db}{subsysseq}{ $self->{db}{subsyscol}[$i]{name} } =
	  $self->{db}{subsyscol}[$i];
	$self->{db}{subsyscol}[$i]{num} = $i;
  }

  # ƥʥν
  if($self->{debug}{maintenance}
	 and $ENV{REMOTE_ADDR} !~ m/$self->{debug}{maintenance_except_addr}/) {
	$self->print_template
	  ("$self->{template}{maintenance}",
	   { maintenance_msg => $self->{debug}{maintenance_msg} },
	   status => '503 Service Unavailable');
  }

  $self->{debug}{no_db} = 1 if($opt{no_db});
  return $self if($self->{debug}{no_db});

  # $self->{dbh} : DBI ֥
  eval {
	$self->{dbh} = DBI->connect
	  ("dbi:Pg:$self->{global}{db}{data_source}",
	   "$self->{global}{db}{username}",
	   "$self->{global}{db}{passwd}",
	   { AutoCommit => 0, PrintError => 0, RaiseError => 1 }); };
  $self->fatal_error("$@ ; $DBH::errstr") if($@);

  # 桼μ
  my $g_ui = $self->{global}{userinfo};
  my $ui = $self->{userinfo};
  if($opt{admin}) {
	($ui->{uid}, $ui->{email}, $ui->{read}, $ui->{add}, $ui->{delete},
	 $ui->{detail}, $ui->{tofile}, $ui->{state_active}, $ui->{state_wait},
	 $ui->{state_invalid}) =
	   (0, undef, undef, undef, undef, undef, undef, 'RAD', 'RAD', 'RAD');
  } elsif($g_ui and $user ne '') {
	my $qu = $self->{dbh}->quote($user);
	($ui->{uid}, $ui->{email}, $ui->{read}, $ui->{add}, $ui->{delete},
	 $ui->{detail}, $ui->{tofile}, $ui->{state_active}, $ui->{state_wait},
	 $ui->{state_invalid}) =
	   $self->selectrow_array
		 (join
		  ('', "SELECT system_uid, $g_ui->{col_email}, system_read, ",
		   "system_add, system_delete, system_detail, system_tofile, ",
		   "system_state_active, system_state_wait, system_state_invalid ",
		   "FROM sys_userinfo $g_ui->{join} ",
		   "WHERE \"$g_ui->{col_user}\" = $qu"));
  } else {
	$self->{global}{userinfo_default} ||= { };
	$self->{userinfo} =
	  { %{ $self->{global}{userinfo_default} }, %{ $self->{userinfo} } };
  }

  return $self;
}

sub DESTROY {
  my $self = shift;
  $self->{dbh}->disconnect unless($self->{debug}{no_db});
}

sub query {
  my $self = shift;
  $self->{query};
}

=item print_template ( TEMPLATE [,HASHREF [,OPTION] ] )

  $dbi->print_template($template, { %hash });
  $dbi->print_template($template, { %hash }, %option);

    ARGS :
      $template => STRING      # ƥץ졼ȥե̾
      $hashref => HASHREF      # ƥץ졼Ϥѿ

    OPTION :
      noexit => BOOLEAN        # λʤ
      status => STRING         # HTTP ơ
      fh => FILEHANDLE         # 
      group => STRING          # 롼̾
      dir => STRING            # ǥ쥯ȥ
      decode => BOOLEAN        # ǥɤŪ˹Ԥ

$template бƥץ졼ȥեȤä HTMLϤƽλ롣
ƥץ졼ȥեǤϡ
URLפԤäѿ %var 䡢ԤäƤʤѿ %nvar ѤǤ롣
%var ̾ɽhidden 桢textarea ǰϤޤ줿ΰǤλѤ
ŬƤ롣
ѿΥ򤽤ΤޤɽȤ %nvar ȤȤ褤
ʤʬȼˡ
$nvar{sys} ˤϡˤ˻ȤѿǼƤ롣
ޤ󥹥ѿ DB ⥸塼Υ᥽åɡ
CGI.pm Υ֥ $query ʤɤѤǤ롣

noexit  true Ǥʤ¤ꡢä齪λ롣
noexit  true ˤʤǤϡƥץ졼ȥե
%nvar ͤѹ٤ǤϤʤ

=cut

sub print_template {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $template, $var, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  $var ||= { };
  $self->fatal_error("The parameter 'var' ($var) is invalid")
	if(ref($var) ne 'HASH');
  $self->fatal_error("The parameter 'var' ($var) is invalid")
	if(defined $var->{db} or defined $var->{code_dist}
	   or defined $var->{html_charset});
  $self->fatal_error("The option 'fh' is invalid")
	if(exists($opt{fh}) and ref($opt{fh}) !~ m/^(GLOB|FH)$/i);

  $self->{query}->delete_all();
  $self->fatal_error("The parameter 'template' is invalid",
					 template => $template)
	if($template =~ m![^\w.#~=:%-]!);

  my $decoded = ($self->{template}{decoded} and not $opt{decode}) ? 1 : 0;
  my $group = $opt{group} ne '' ? $opt{group} : $self->{userinfo}{group};
  my $dir = $opt{dir} ne '' ? $opt{dir} : $self->{template}{dir}{$group};
  my $file = join('/', $self->{global}{basedir}, $dir,
				  $template . ($decoded ? '.pl' : '.html'));

  my $tmpdir = "$self->{global}{basedir}/$self->{global}{tmpdir}";
  $self->{__template__}{$file} =
	Template->new($file, decoded => $decoded, tmpdir => $tmpdir,
				  escapecode => sub { CGI->escapeHTML($_[0]) })
	  unless(exists $self->{__template__}{$file});

  my $html_charset = ref($self->{global}{html_charset}) eq 'HASH' ?
	$self->{global}{html_charset}{$group} : $self->{global}{html_charset};

  # nvar Ѱ
  my $nvar = { };
  $nvar->{sys} =
	{ html_charset => $html_charset,
	  base => $self->{global}{baseuri}{$group},
	  version => $VERSION,
	  code_dist => $self->{global}{code_dist}{$group} };
  $nvar->{sys}{maintenance} =
	$self->{debug}{maintenance} ?
	  join('', "<h1 style=\"text-align:center;\"><span style=\"color:red;\">",
		   "Maintenance Mode</span><br>",
		   "<span style=\"font-size:medium;\">",
		   "- DBIPgSystem (ver. $VERSION) -</span></h1>") : '';
  $nvar->{column} = $opt{column} || [ ];
  $nvar->{dbi} = $self;
  $nvar->{query} = $self->{query};

  my $out;
  my $group_ = $self->{userinfo}{group};
  $nvar->{dbi}{userinfo}{group} = $group;
  eval { $out = $self->{__template__}{$file}->out($var, $nvar); };
  $self->fatal_error($@) if($@);
  $nvar->{dbi}{userinfo}{group} = $group_;

  my $fh = $opt{fh} || \*STDOUT;
  $self->DBIPgSystem::DB::_print_header
	(status => $opt{status}, fh => $fh, group => $group)
	unless($opt{noheader});
  if($html_charset =~ m/^(?:Shift_JIS|x-sjis)$/) {
	print $fh jcode($out, 'euc')->sjis
	  or $self->fatal_error("Cannot print: $!");
  } elsif($html_charset =~ m/^ISO-2022-JP$/) {
	print $fh jcode($out, 'euc')->jis
	  or $self->fatal_error("Cannot print: $!");
  } else {
	print $fh $out or $self->fatal_error("Cannot print: $!");
  }

  $self->{dbh}->disconnect() if($self->{dbh} and not $opt{noexit});
  exit unless($opt{noexit});
}

1;

__END__

=item add_log ( TYPE, MSG [,HASH] )

  $dbi->add_log($type, $msg, %hash);

    ARGS :
      $type => STRING          # μ
      $msg => STRING           # Υå
      %hash => HASH            # ˻Ĥͤ

    OPTION :
      file => STRING           # ե̾

Ȥ롣ե1Ԥˡ
ܥƥΥС󡢥ΥסƤӽФΰ֡
å롼̾REMOTE_ADDRHTTP_USER_AGENT%hash Ƥɲä롣
ޤUID Фɲä롣

$self->{log} 򻲾Ȥбեɲä롣
ǡե꼡ǡ
դ䥿̤ˡۤʤե̾б뤳ȤǤ롣

$type  'Fatal', 'Error', 'Warning'ʸʸζ̤ʤ
ΤȤϡcallerؿȤäƥץξ֤˽񤭽Ф

=cut

sub add_log {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $type, $msg, %vars) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);
  $self->fatal_error("type 'type' must be defined") if($type eq '');

  my $log;

  # 
  my ($sec, $min, $hour, $mday, $mon, $year, $wday)	= localtime;
  $year += 1900;   $mon++;
  my $year2 = $year % 100;
  $mon = sprintf("%.2d", $mon);   $mday = sprintf("%.2d", $mday);
  $hour = sprintf("%.2d", $hour);   $min = sprintf("%.2d", $min);
  $sec = sprintf("%.2d", $sec);
  $wday = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
  my $date = "$year/$mon/$mday($wday) $hour:$min:$sec";

  # ե̾
  return undef
	if(exists($self->{log}{$type}) and not defined($self->{log}{$type}));
  my $logfile = ($self->{log}{$type} ne '') ?
	"$self->{global}{basedir}/$self->{log}{$type}"
	  : "$self->{global}{basedir}/$self->{log}{basefile}";
  $logfile =~ s/\^Y/$year/g;  $logfile =~ s/\^y/$year2/g;
  $logfile =~ s/\^m/$mon/g;   $logfile =~ s/\^d/$mday/g;
  $logfile =~ s/\^h/$hour/g;

  my $file = (caller)[1] . ' (' . (caller)[2] . ')';
  push(@$log, $date, $VERSION, $type, $file, $msg, $self->{userinfo}{group},
	   $ENV{REMOTE_ADDR}, $ENV{HTTP_USER_AGENT});

  # type  fatal or error or warning ʤ caller դ
  if($type =~ m/^(fatal|error|warning)\s*$/i) {
	my $i = 0;
	my $call = [ ];
	my $caller;
	$caller .= join(', ', @$call) . "\n" while(@$call = caller($i++));
	push(@$log, "caller == $caller");
  }

  $vars{__UID__} = $self->{userinfo}{uid}
	if(not exists($vars{__UID__}) and defined $self->{userinfo}{uid});
  foreach (keys %vars) { push(@$log, "$_ == $vars{$_}"); }

  # ʸǰդǤ褦ˡִ
  foreach (@$log) { s/\*/* /g;   s/;/; /g;   s/\n/;; /g; }

  # ե˽񤭹
  open(OUT, ">> $logfile") or return undef;
  flock(OUT, 2);
  seek(OUT, 0, 2);
  print OUT join(' ** ', @$log), "\n";
  close(OUT);
  return 1;
}

=item print_error ( TITLE, ERROR_CODE [,LOGTITLE [,LOGS] ] )

  $dbi->print_error($title, $err);
  $dbi->print_error($title, $err, $logtitle, %logs);

HTMLǥ顼Ϥƽλ롣

=cut

sub print_error {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $title, $err, $logtitle, %logs) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);

  die $err if($TEST);
  $title = $self->get_errmsg($title);
  my $errmsg;
  if(ref($err) eq 'HASH') {
	my $msg = delete $err->{msg};
	$errmsg = $self->get_errmsg($msg, %$err);
  } else {
	$errmsg = $self->get_errmsg($err);
  }
  $logtitle = $title . (defined $logtitle ? " ($logtitle)" : '');
  $self->add_log('Error', $logtitle, %logs, errmsg => $errmsg);
  $self->print_template
	($self->{template}{error}, { title => $title, errmsg => $errmsg },
	 status => "400 Bad Request");
}

=item fatal_error ( MSG [,HASH] )

  $dbif->fatal_error($msg, %vars);

̿Ūʥ顼ʥ桼¦˸ʤϤΥ顼ˤν򤹤롣
˽񤭽ФåϤ
̳ɤ˥顼Ƥ᡼Τ롣
ä齪λ롣

=cut

sub fatal_error {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $msg, %vars) = @_;
  $msg .= "\nToo few arguments" if(@_ < 2);

  $self->{dbh}->disconnect() if($self->{dbh});
  $msg = (caller(1))[3] . ' ( line ' . (caller(0))[2] . " ) : $msg";

  die $msg if($TEST);

  if($self->{sys}{fatalerror}) {
	unless($self->{sys}{printheader}) {
	  if($self->{sys}{nph}) {
		print "HTTP/1.1 500 Internal Server Error\r\n",
	  }
	  print "Status: 500 Internal Server Error\r\n";
	  print "Content-type: text/plain\r\n";
	  print "\r\n";
	}
	print "$self->{sys}{fatalerror}\n";
	exit;
  }

  $self->{sys}{fatalerror} = 'Fatal Error !!';
  $self->{sys}{fatalerror} = $self->get_errmsg('fatal');

  # ե˽񤭽Ф
  $self->add_log('Fatal', $msg, %vars);

  # ᡼ʸ
  my $bodylist = [ ];
  push(@$bodylist, '[message]', $msg, '');
  my ($i, $call) = (0, [ ]);
  push(@$bodylist, '[caller]');
  push(@$bodylist, join(', ', @$call)) while(@$call = caller($i++));
  push(@$bodylist, '');
  my ($k, $v);
  push(@$bodylist, "[VAR:$k]", $v, '') while(($k, $v) = each %vars);
  push(@$bodylist, "[ENV:$k]", $v, '') while(($k, $v) = each %ENV);

  # Ԥ˥᡼
  my $ret = $self->send_mail
	($self->{global}{mailto}, "DBIPgSystem (ver. $VERSION), Fatal Error",
	 $bodylist);
  unless($ret) {
	$self->{sys}{fatalerror} = $self->get_errmsg
	  ('fatal_nomail', mailto => $self->{global}{mailto}, reason => $msg);
  }

  # åϤ
  my $err = $self->print_template
	($self->{template}{fatalerror},
	 { apology => $self->{sys}{fatalerror} },
	 status => '500 Internal Server Error', fatal => 1);
}

=item send_mail ( TO, SUBJECT, BODY [,OPTION] )

  $dbi->send_mail($to, $subject, $body, %opt);

    ARGS :
      $to => STRING            # To إå
      $subject => STRING       # Subject إå
      $body => STRING or ARRAYREF  # ʸ

    OPTION :
      $header => HASHREF       # ץΥإå

᡼롣$to  $subject ɬƤʤФʤʤ
$body ؤΥե󥹤ξϡԤ³ΤʸȤ롣

=cut

sub send_mail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $to, $subject, $body, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 4);

  return undef if($self->{debug}{no_mail});
  return undef unless(defined($to) and defined($subject));
  return undef unless(-e $self->{global}{sendmail});

  $opt{header}{'Content-Transfer-Encoding'} = '7bit';
  $opt{header}{'Content-Type'} = 'text/plain; charset='
	. $self->{global}{mail_charset};

  my $mail = [ ];
  my ($k, $v);

  my $fromaddr = $self->{global}{mailfrom};
  $fromaddr =~ s/'/\\'/g;
  $fromaddr = $1 if($fromaddr =~ m/<([^>]+)>/);
  my $from = jcode($self->{global}{mailfrom}, 'euc')->mime_encode;
  push(@$mail, "From: $from", "To: $to", "Subject: $subject");
  push(@$mail, "$k: $v") while(($k, $v) = each %{ $opt{header} });
  push(@$mail, '');
  push(@$mail, ref($body) eq 'ARRAY' ? @$body : $body);

  open(MAIL,"| $self->{global}{sendmail} -i -t -f'$fromaddr'") or return undef;
  foreach (@$mail) { print MAIL jcode($_, 'euc')->iso_2022_jp, "\n"; }
  close(MAIL);
  return 1;
}

=item col_split ( DATA [,CODE] )

  @data = $dbi->col_split($data);
  @data = $dbi->col_split($data, $code);

    ARGS :
      $data => STRING          # ʸ̾ϥ͡
      $code => STRING          # $self->{code} Υ

    RET : @array

ʣͤĥͤʸ󤫤ηѴ롣
$code ꤷϡ$self->{code}{$code} 򻲾Ȥ
б֤ͤ

=cut

sub col_split {
  my ($self, $data, $code) = @_;
  $data =~ s/^\x1D//;   $data =~ s/\x1D$//;
  return map { $self->{code}{$code}{$_} } split(/\x1D/, $data, -1) if($code);
  return split(/\x1D/, $data, -1);
}

=item fileinfo ( VALUE )

  ($path, $uri) = $dbi->fileinfo($value);

    ARGS :
      $value => STRING         # 

    RET : @array
      0 => STRING              # URI
      1 => STRING              # ѥ

ե뷿Υ˳ǼƤեURIȥѥ֤
ƤӽФΥƥȤ顼ͤƤȤURI֤
ͤϡ$self->{sys}{export_mode} ˤäưۤʤ롣

=cut

sub fileinfo {
  my ($self, $value) = @_;
  my ($uri, $path);

  if(-f "$self->{global}{filetype}{dir}/$value") {
	$uri = "$self->{global}{filetype}{fileuri}/$value";
	$path = "$self->{global}{filetype}{dir}/$value";
  } else {
	$uri = "$self->{global}{filetype}{tmpfileuri}/$value";
	$path = "$self->{global}{filetype}{tmpdir}/$value";
  }
  return (wantarray ? ($uri, $path) : $uri);
}

=item export_uri ( DID, PAGE )

  $uri = $dbi->export_uri($did, $page);

    RET : STRING                 # URI

$did, $page б륨ݡȤ줿եURI֤

=cut

sub export_uri {
  my ($self, $did, $page) = @_;
  my $group = $self->{userinfo}{group};
  die "page (= $page) is too large"
	if($page > $self->{template}{numpage_detail}{$group});

  $page = sprintf("%.2d", $page);
  my $html = $self->{global}{export_file}{$group};
  $html =~ s!^.*/!/!;
  $html =~ s/\^d/sprintf("%.7d", $did)/ge;
  $html =~ s/\^p/sprintf("%.2d", $page)/ge;
  $html =~ s/\^a/chr(96 + $page)/ge;
  my $uri = $self->{global}{export_uri}{$group} . $html;
  return $uri;
}

=item getcookie ( )

  $value = $dbi->getcookie($name);

åбͤ롣

=cut

sub getcookie {
  my ($self, $name) = @_;
  $name = quotemeta($name);
  my $value = ( map { s/^$name=//; $_ } grep {/^$name=/}
				split(';', $ENV{'HTTP_COOKIE'}) )[0];
  return $value;
}

=item cmp_order ( ORDER, LIST )

  $num = $dbi->cmp_order($order, @list);

    RET : NUM                  # ޥå

ORDERȤơ@list 椫 $order Ọ̇̄ŪΡ
ޤ ORDERȿФΤΤõ index ֤
⤷ʤ undef ֤

=cut

sub cmp_order {
  my ($self, $order, @list) = @_;

  $order =~ s{([a-z_]+)(?:| +asc| +(desc)) *(?:(,) *|$)}{
	$1 . ($2 ? '!' : '#') . $3 }egi;
  my $revord = $order;
  $revord =~ s/([!#])/ $1 eq '!' ? '#' : '!'/eg;
  my $i = 0;
  foreach my $l (@list) {
	$l =~ s{([a-z_]+)(?:| +asc| +(desc)) *(?:(,) *|$)}{
	  $1 . ($2 ? '!' : '#') . $3 }egi;
	return ($i, undef) if($l eq $order);
	return ($i, 1) if($l eq $revord);
	$i++;
  }
  return undef;
}

=item infilter ( STRREF [,OPTION] )

  $dbi->infilter(\$in);

    ARGS :
      $inref => STRINGREF      # ե륿򤫤ʸؤΥե

    OPTION :
      printerror => BOOLEAN    # 顼̤Ϥ
      file => BOOLEAN          # ե뤫ɤ߹
      code => STRING           # ʸ

    RET : STRING               # Ѵʸ

ϤλʸФѴԤ
̾ϡϤФơޤΥե륿̤롣

ŪˤϡνǽԤ

  1. ʿ֤ȾѶˡԥɤ \x0A ִ롣
     ʤֶڤեοʿ֤
  2. ɤ楳ɤޤޤƤʤХ᥽åɤλ롣
  3. HTTP_USER_AGENT 򸫤 Win/Macε¸ʸŬڤ˽
     ʸɤEUCѴ롣
     DBIPgSystem::Code::toeuc ȡ
  4. 楳ޤޤƤХ顼Ф
  5. ޤޤ٤Ǥʤʸ (JIS X 0208 915,8594)
     ޤޤƤХ顼Ф
  6. ѱѿȾѱѿˡȾѥʤѤˡ
     ѶȾѶ2Ĥִ롣
     ޤ $self->{__infilter}{codelist} Υбִͤ롣
  7. ̾/ȾСǤʸ礹롣
  8. ʥǡեƤС $self->{__infilter}{hook}
     ¹Ԥ롣

$opt{file}  true ΤȤǽʥɤ \x0C ˡ
Ѷػߤ楳ɤ \x0B ִ롣
ʤСɤ $self->{global}{code_invalid} ִ롣
\x0B  \x0C ϻѶػߤΥɤΤᡢʳξˤϽϤʤ

顼/ٹ𤬤硢$opt{printerror}  true ʤС
print_error ᥽åɤƤӽФ
$opt{printerror}  false ʤС顼ɤ֤

ʤִǤ undef ֤

=cut

sub infilter {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $in, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  $self->fatal_error("The parameter 'in' is invalid")
	if(ref($in) ne 'SCALAR');
  $opt{code} ||= $self->{sys}{incode};

  $$in =~ s/\x0D\x0A/\x0A/g;   $$in =~ s/[\x0B\x0D]/\x0A/g;
  $$in =~ s/\x09/ /g if($opt{file} ne 'tab');
  return undef if($$in !~ m/[^\x0A\x1D\x20-\x7E]/);	# ®

  my $ret;

  # EUCѴ
  my $errorcode = $opt{file} ne '' ? "\x0C" : $self->{global}{code_invalid};
  my $os;
  $os = 'win' if($ENV{HTTP_USER_AGENT} =~ m/WIN/i);
  $os = 'mac' if($ENV{HTTP_USER_AGENT} =~ m/(MAC_|MACINTOSH)/i); # not 'Emacs'
  DBIPgSystem::Code::toeuc($in, $opt{code}, $os, errorcode => $errorcode)
		or $ret = 'infilter_invalid';
  $$in = jcode($$in, 'euc')->h2z->euc;			# Ⱦѥʤִ

  # ѱѿ,Ѷִʿ/Ҳ̾(Ⱦ)ν
  # ®ΤἫǽ򤹤
  my ($chr_son, $chr_ps, $c1, $c2);
  $self->{_infilter}{codelist} ||= { };
  my $codelist = $self->{__infilter}{codelist};
  $$in =~ s{(?:([\xA2\xA4-\xA8\xB0-\xF4][\xA1-\xFE])|
             ([\xA1\xA3][\xA1-\xFE])|[\xA1-\xFE][\xA1-\xFE]|
             \x8F[\xA1-\xFE][\xA1-\xFE]|
             [\x00-\x08\x0B-\x1C\x1E\x1F\x7F-\xA0\xFF])}{
	if($1 ne '') {
	  exists($codelist->{$1}) ? $codelist->{$1} : $1;
	} elsif($2 eq '') {		# 楳, ޤޤ٤Ǥʤ -> "\x0B"
	  $ret ||= 'invalid_code';
	  "\x0B";
	} elsif(exists($codelist->{$2})) {
	  $codelist->{$2};
	} else {
	  ($c1, $c2) = unpack('CC', $2);
	  if($c1 eq 0xA1) {
		$codelist->{$2} = $c2 eq 0xA1 ? '  ' :			# Ѷ -> '  '
		  $c2 eq 0xAB ? ($chr_son = 1, "\x91") :		#  -> "\x91"
			$c2 eq 0xAC ? ($chr_ps = 1, "\x92") : $2;	# Ⱦ -> "\x92"
	  } else {
		$codelist->{$2} =								# ѱѿ -> Ⱦ
		  ($c2 >= 0xB0 and $c2 <= 0xB9 or $c2 >= 0xC1 and $c2 <= 0xDA
		   or $c2 >= 0xE1 and $c2 <= 0xFA) ? chr($c2 - 0x80) : $2;
	  }
	  $codelist->{$2};
	}
  }gex;

  #  ''ν
  if($chr_son) {
	$$in =~ s{(..\x91)}{
	  my ($c1, $c2) = split(//, $1);
	  ($c1 =~ m/^[\xA4\xA5]$/ and
	   ($c2 =~ m/^[\xAB\xAD\xAF\xB1\xB3\xB5\xB7\xB9\xBB\xBD\xBF\xC1\xC4]$/ or
		$c2 =~ m/^[\xC6\xC8\xCF\xD2\xD5\xD8\xDB]$/)) ?
		  $c1.chr(ord($c2)+1) : ($c1 eq "\xA5" and $c2 eq "\xA6") ? "" :
			$c1.$c2."";
	}ges;
	$$in =~ s/\x91//g;
  }

  # Ⱦ ''ν
  if($chr_ps) {
	$$in =~ s{(..\x92)}{
	  my ($c1, $c2) = split(//, $1);
	  ($c1 =~ m/^[\xA4\xA5]$/ and $c2 =~ m/^[\xCF\xD2\xD5\xD8\xDB]$/) ?
		$c1.chr(ord($c2)+2) : $c1.$c2."";
	}ges;
	$$in =~ s/\x92//g;
  }

  $$in =~ s/\x0B/$self->{global}{code_invalid}/g if($opt{file} eq '');

  # ǡեˤִ
  $ret = &{ $self->{__infilter}{hook} }($in)
	if($self->{__infilter}{hook} and not $ret);

  $self->print_error
	('infilter-title', ':' . $self->get_errmsg($ret) . ": $$in")
	  if($ret and $opt{printerror});

  return $ret;
}

=item create_table ( [OPTION] )

  $str = $dbi->create_table() or die;
  $str = $dbi->create_table(dbtable => $dbtable) or die;

    OPTION :
      dbtable => STRING        # TABLEλ
      drop => BOOLEAN          # DROP ޥɤ֤

    RET : STRING               # CREATE TABLE ޥ

ǡե˽äƥơ֥ $opt{dbtable} 褦
CREATE TABLE ޥɤ֤
$opt{dbtable} ꤵƤʤ
ǡեƤƤ TABLE оݤˤʤ롣

=cut

sub create_table {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my ($dbtable, $file);
  if(defined $opt{dbtable}) {
	return unless(exists $self->{dbcol}{ $opt{dbtable} });
	$dbtable = [ $opt{dbtable} ];
  } else {
	$dbtable = [ keys %{ $self->{dbcol} } ];
  FILE: foreach my $dbt (@$dbtable) {
	  foreach my $dbcol (@{ $self->{dbcol}{$dbt} }) {
		if($dbcol->{type} eq 'file') { $file = 1; last FILE; }
	  }
	}
  }

  my $ret;
  my $primary = $self->{global}{primary};
  my ($user_list, $search_list, $system_list);
  foreach my $dbt (@$dbtable) {
	($user_list, $search_list, $system_list) = ([ ], [ ], [ ]);
	# 桼, ѥ
	foreach my $dbcol (@{ $self->{dbcol}{$dbt} }) {
	  push(@$user_list,
		   "  \"$dbcol->{name}\" $self->{db}{type_sql}{ $dbcol->{type} }");
	  push(@$search_list, "  \"$dbcol->{name}$self->{sys}{search_ext}\" "
		   . "$self->{db}{type_sql}{ $dbcol->{stype} }") if($dbcol->{search});
	}

	if($dbt eq $primary) {
	  my $uniq;
	  # ƥ
	  foreach my $syscol (@{ $self->{db}{syscol} }) {
		$uniq = $syscol->{name} eq 'system_uniq' ? 'UNIQUE' : '';
		push(@$system_list,
			 "  \"$syscol->{name}\" $syscol->{type_sql} $uniq");
	  }
	  push(@$ret, 'DROP SEQUENCE seq_rid;', 'DROP SEQUENCE seq_did;',
		   'DROP SEQUENCE seq_rid_dft;', 'DROP SEQUENCE seq_dftid;')
		if($opt{drop});
	  push(@$ret, 'CREATE SEQUENCE seq_rid;', 'CREATE SEQUENCE seq_did;',
		   'CREATE SEQUENCE seq_rid_dft;', 'CREATE SEQUENCE seq_dftid;');
	} else {
	  foreach my $subsyscol (@{ $self->{db}{subsyscol} }) {
		push(@$system_list,
			 "  \"$subsyscol->{name}\" $subsyscol->{type_sql}");
	  }
	}

	push(@$ret, "DROP TABLE \"$dbt\";", "DROP TABLE \"${dbt}_dft\";")
	  if($opt{drop});
	push(@$ret, "CREATE TABLE \"$dbt\" (\n"
		 . join(",\n", @$user_list, @$search_list, @$system_list) . ' );');

	# draft ѤΥơ֥
	foreach (@$system_list) { s/ UNIQUE$//; }
	push(@$system_list, "  \"draft_rid\" int4");
	push(@$system_list, "  \"draft_line\" int4") if($dbt eq $primary);
	push(@$ret, "CREATE TABLE \"${dbt}_dft\" (\n"
		 . join(",\n", @$user_list, @$search_list, @$system_list) . ' );');
  }

  # ե
  if($file) {
	push(@$ret, "DROP TABLE \"sys_file\";") if($opt{drop});
	$self->DBIPgSystem::DB::_init_dbfile();
	$system_list = [ ];
	foreach my $syscol (@{ $self->{col_dbfile} }) {
	  push(@$system_list, "  \"$syscol->{name}\" $syscol->{type_sql}");
	}
	push(@$ret, "CREATE TABLE \"sys_file\" (\n"
		 . join(",\n", @$system_list) . ' );');
  }

  return join("\n", @$ret) . "\n";
}

=item create_userinfo_table ( [OPTION] )

  $str = $dbi->create_userinfo_table() or die;

    OPTION :
      drop => BOOLEAN          # DROP ޥɤ֤

    RET : STRING               # CREATE TABLE ޥ

ǡե˽äƥơ֥ system_userinfo 褦
CREATE TABLE ޥɤ֤

=cut

sub create_userinfo_table {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  $self->DBIPgSystem::DB::_init_userinfo();
  my $list = [ ];
  my $uniq;
  foreach my $col (@{ $self->{col_userinfo} }) {
	$uniq = $col->{unique} ? 'UNIQUE' : '';
	push(@$list, "  \"$col->{name}\" $col->{type_sql} $uniq");
  }

  my $ret = [ ];
  push(@$ret, "DROP TABLE \"sys_userinfo\";") if($opt{drop});
  push(@$ret, "CREATE TABLE \"sys_userinfo\" (\n"
	   . join(",\n", @$list) . ' );');
  return join("\n", @$ret) . "\n";
}

=item selectrow_array ( SQL [,OPTION] )

  $list = $dbi->selectrow_array($sql, %opt);

    ARGS :
      $sql => STRING           # SELECTʸ

    OPTION :
      nofatal => BOOLEAN       # fatal_error äƤ⶯λʤ

    RET : STRING               # DBI::selectrow_array 

DBI::selectrow_array ¹Ԥ롣
եå줿֤
ƤӽФΥƥȤ顼ͤƤȤ
κǽǤ֤DBI::selectrow_array Ʊˡ
եå˼ԤȤ undef ֤

=cut

sub selectrow_array {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $sql, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  return undef if($self->{debug}{no_db});

  my @ret;
  eval { @ret = $self->{dbh}->selectrow_array($sql) };
  if($@) {
	$self->fatal_error("$@", sqlcmd => $sql) unless($opt{nofatal});
	@ret = ( );
  }
  return wantarray ? @ret : $ret[0];
}

=item selectall_arrayref ( SQL [,OPTION] )

  $list = $dbi->selectall_arrayref($sql, %opt);

    ARGS :
      $sql => STRING           # SELECTʸ

    OPTION :
      nofatal => BOOLEAN       # fatal_error äƤ⶯λʤ

    RET : STRING               # DBI::selectall_arrayref 

DBI::selectall_arrayref ¹Ԥ롣
եå줿ѿ֤
եå˼ԤȤ undef ֤

=cut

sub selectall_arrayref {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $sql, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  return undef if($self->{debug}{no_db});

  my $ret;
  eval { $ret = $self->{dbh}->selectall_arrayref($sql) };
  if($@) {
	$self->fatal_error("$@", sqlcmd => $sql) unless($opt{nofatal});
	$ret = [ ];
  }
  return $ret;
}

=item do ( SQL )

  $dbi->do($sql);

    ARGS :
      $sql => STRING           # ޥ

    RET : STRING               # DBI::do 

DBI::do ¹Ԥ롣

=cut

sub do {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $sql) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  return undef if($self->{debug}{no_db});

  my $rc;
  eval { $rc = $self->{dbh}->do($sql) };
  $self->fatal_error("$@", sqlcmd => $sql) if($@);
  $self->DBIPgSystem::DB::_commit;
  return $rc;
}

=item get_errmsg ( CODE [,VAR] )

  $str = $dbi->get_errmsg($code, @var)

顼å롣
$code  ':' ǻϤޤϡ$code 2ʸܰʹߡ':'ʹߡˤʸ
顼åȤ롣
ʤС顼åե뤫бå롣
顼åŬڤ˥פƤ顢ͤȤ֤

=cut

sub get_errmsg {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $code, %var) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  $self->fatal_error("The parameter 'code' must be defined")
	if($code eq '');
  my ($code_, $msg_, $msg);
  if($code =~ m/^:(.*)$/s) {
	$msg = $1;
  } else {
	my $file = "$self->{global}{basedir}/$self->{global}{errcode_file}";
	open(IN, $file) or $self->fatal_error("Cannot open '$file'");
	flock(IN, 1);
	while(<IN>) {
	  s/[\x0D\x0A]//g;
	  next if(m/^\s*(#.*)?$/);
	  ($code_, $msg_) = split(/:/, $_, 2);
	  if($code_ eq $code) { $msg = $msg_; last; }
	}
	close(IN);
  }
  # 顼åʤ
  $self->fatal_error("code '$code' is invalid") if($msg eq '');

  $msg =~ s(<%(\w+)%>){ CGI->escapeHTML($var{$1}) }ge;
  return $msg;
}

=item warn_ ( MSG )

  $dbi->warn_(@msg);

@msg ɸϤ˽Ϥ롣ǥХåѤ

=cut

sub warn_ {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, @msg) = @_;
  return undef unless(@msg);

  $self->DBIPgSystem::DB::_print_header();
  foreach (@msg) {
	CGI->escapeHTML($_);
	s/\n/<br>/g;
	s/  /&nbsp; /g;
  }
  print join(', ', @msg), "<br>";
}

=item get_template_detail ( PAGE [,GROUP] )

  $html = $dbi->get_template_detail($page);
  $html = $dbi->get_template_detail($page, $group);

ǡξܺɽǡɽڡ֤̾
бڡʤϡnull ֤

=cut

sub get_template_detail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $page, $group) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  $group = $self->{userinfo}{group} unless(defined $group);
  return undef
	if($page > $self->{template}{numpage_detail}{$group});

  $page = sprintf("%.2d", $page);
  my $html = $self->{template}{detail};
  $html =~ s/\^p/$page/g;
  return $html;
}

=item get_template_insert ( PAGE )

  $html = $dbi->get_template_insert($page);

ǡǡɽڡ֤̾
бڡʤϡnull ֤

=cut

sub get_template_insert {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $page) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  return undef if($page > $self->{template}{numpage_insert});

  $page = sprintf("%.2d", $page);
  my $html = $self->{template}{insert};
  $html =~ s/\^p/$page/g;
  return $html;
}

=item file_collist ( )

  $collist = $dbi->file_collist();

    RET : ARRAYREF             # Υꥹ

CSV/ֶڤեΥݡȻ˼դ륫ν֤
ͤγǤؤΥե󥹤ǡбơ֥̾ $dbt ȡ
$self->{dbcol}{$dbt}[$i] Ǽ롣
бơ֥뤬ơ֥ξϡ$dbt ˶ʸ󤬳Ǽ롣

=cut

sub file_collist {
  my ($self) = @_;

  my ($collist, $dbt_, $dbc);
  my $primary = $self->{global}{primary};
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$dbt_ = $dbt eq $primary ? '' : $dbt;
	$dbc = $self->{dbcol}{$dbt};
	foreach my $i (0 .. $#{ $self->{dbcnum}{$dbt} }) {
	  $collist->[ $self->{dbcnum}{$dbt}[$i] ] = [ $dbt_, $dbc->[$i] ];
	}
  }
  return $collist;
}

=item get_actid ( DID )

  $rid = $dbi->get_actid($did);

    ARGS :
      $did => STRING           # ǡID

    RET : NUM                  # 쥳ID

ꤵ줿DIDǡͭʥǡRID֤
бǡϡǽǤʤФʤʤ

=cut

sub get_actid {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $did) = @_;
  $self->fatal_error("\$did is invalid: $did") if($did !~ m/^\d+$/);

  my $perm_r = $self->check_permission
	('read', state => $self->{db}{sysstate}{active});
  return $self->selectrow_array
	($self->selectcmd('system_rid', where => "system_did = '$did'",
					  where_and => $perm_r));
}

=back

=head2 METHODS

=over 4

=item search ( RID, REVISE [,OPTION] )

  ($total, $list) = $dbi->search($cols, $sql);

    ARGS :
      $cols => STRING          # Υ̾
      $sql => HASHREF          # selectcmd Ϥ SQLʸ

    RET : LIST
      0 => NUM                 # ̤
      1 => ARRAYREF            # selectall_arrayref Ǥθ

Ϳ줿ǸԤ̤פȡ̤֤
˸꤬ undef ֤

=cut

sub search {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $cols, $sql, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);

  my $perm_r = $self->check_permission('read');

  # ̤פĴ٤
  my $total;
  $total = $self->selectrow_array
	($self->selectcmd('COUNT(*)', %$sql, where_and => $perm_r), nofatal => 1);
  return undef unless(defined $total);

  # μ¹
  my $list = $self->selectall_arrayref
	($self->selectcmd($cols, %$sql, where_and => $perm_r));

  return ($total, $list);
}

=item search_detail ( RID, REVISE )

  ($data, $system) = $dbi->search_detail($rid, $revise);

    ARGS :
      $rid => NUM             # RID
      $revise => BOOLEAN      # ǡν

    RET : LIST
      0 => HASHREF            # ǡ
      1 => HASHREF            # ƥξ
      2 => HASHREF            # revise  true ʤС
                              # Υƥξ

system_rid  $rid Υǡǡ١ɤ߹ߡ
ƥξȶ˽Ϥ롣

revise  true ξ硢ƥξͤ 3ܤǤ
Ǽʰ revise  false ξ 2ܤ˳Ǽˡ
ξ硢ͤ 2ܤǤϡ
ǡȤΥƥξȲᤵ롣

revise  true ξͤ 2ܤǤˤϡ
ΥƥξΤ
system_did, system_pre_rid, system_uid ǼƤ롣

revise  true ξ硢
$self->{__search_detail}{hook_revise} ƤС¹Ԥ롣

=cut

sub search_detail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $rid, $revise) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);

  my $primary = $self->{global}{primary};
  my $search_ext = $self->{sys}{search_ext};
  my ($order, $list, $dbcol, $dbnum);
  my ($data, $system) = ({ }, { });
  my $errwarn = { error => [ ], warning => [ ] };
  # rid 
  my $where = "system_rid = '$rid'";
  $where = "( $where ) AND " . $self->check_permission('detail');
  my $rid_ = $rid;
  $rid = $self->selectrow_array
	($self->selectcmd('system_rid', from => $primary, where => $where));
  $self->print_error('permission-title', 'permission', undef, qs_rid => $rid_)
	if($rid eq '');

  # ǡ
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$dbcol = $self->{dbcol}{$dbt};
	$dbnum = $self->{dbnum}{$dbt};
	$order = $dbt ne $primary ? 'system_num' : '';
	$list = $self->selectall_arrayref
	  ($self->selectcmd('*', from => $dbt, where => "system_rid = '$rid'",
						order => $order));
	if($dbt eq $primary) {
	  $self->print_error('nulldata-title', 'nulldata') unless(@$list);
	  foreach my $j (0 .. $#{ $self->{db}{syscol} }) {
		$system->{ $self->{db}{syscol}[$j]{name} } =
		  $list->[0][$dbnum->{user_search} + $j];
	  }
	}
	foreach my $i (0 .. $#$list) {
	  $data->{$dbt}[$i] = { };
	  foreach my $j (0 .. $#$dbcol) {
		$data->{$dbt}[$i]{ $dbcol->[$j]{name} } = $list->[$i][$j];
		$data->{$dbt}[$i]{ $dbcol->[$j]{name}.$search_ext } =
		  $list->[$i][ $dbcol->[$j]{search_num} ] if($dbcol->[$j]{search});
	  }
	}
  }

  $self->check_permission('is_revise', uid => $system->{system_uid})
	if($revise);
  $data->{$primary} = $data->{$primary}[0];

  return ($data, $system) unless($revise);

  # Υǡ˥ƥͤѾ
  my $nextsys = { };
  $nextsys->{system_did} = $system->{system_did};
  $nextsys->{system_pre_rid} = $rid;
  $nextsys->{system_uid} = $system->{system_uid};

  # ǡեˤ
  &{ $self->{__search_detail}{hook_revise} }($data, $nextsys, $system)
	if($self->{__search_detail}{hook_revise});

  return ($data, $nextsys, $system);
}

=item get_errwarn ( DATA, CPAGE )

  $warn = $dbi->get_errwarn($data, $cpage);

    ARGS :
      $data => HASHREF         # ǡ
      $cpage => HASHREF        # ڡֹξ

    RET : HASHREF
      error => HASHREF         # 顼ξ
      warning => HASHREF       # ٹξ

$data 饨顼/ٹξ롣
Υ᥽åɤϡ̾ǡν򳫻Ϥݤ˸ƤӽФ졢
data_check  $errwarn б֤ͤ

=cut

sub get_errwarn {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $data, $cpage) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);

  my $primary = $self->{global}{primary};
  my $re_searchext = qr{$self->{sys}{search_ext}$};
  $data->{$primary} = [ $data->{$primary} ];

  my $errkind = $self->{debug}{no_data_error} ? 'warning' : 'error';
  my ($dbseq, $error, $tmpdata, $ew, $all_ew, $tmp);
  my $errwarn = { error => { }, warning => { } };
  my $search = \$tmp;
  foreach my $dbt (keys %$data) {
	$dbseq = $self->{dbseq}{$dbt};
	foreach my $i (0 .. $#{ $data->{$dbt} }) {
	  $error = 0;
	  $tmpdata = { };
	  foreach my $key (keys %{ $data->{$dbt}[$i] }) {
		$tmpdata->{$key} = $data->{$dbt}[$i]{$key};
		next if($key =~ m/$re_searchext/);
		### ե˷ٹ𤬤ϤȤꤢѤʤȤˤ
		next if($dbseq->{$key}{type} eq 'file');
		# cpage  0 ΥˤĤƤϥ顼/ٹΥå򤷤ʤ
		next if($cpage->{$dbt}{$key} == 0);
		$ew = { error => [ ], warning => [ ] };
		$self->DBIPgSystem::DB::_filter_one_data
		  ($dbt, $dbseq->{$key}{num}, \$tmpdata->{$key}, $ew, $search,
		   check => 1, page => $cpage->{$dbt}{$key}, noencode => 1);
		if( @{ $ew->{error} }) {
		  $error = 1;
		  $errwarn->{error}{$dbt}[$i]{$key} = $ew->{error};
		}
		$errwarn->{warning}{$dbt}[$i]{$key} = $ew->{warning}
		  if( @{ $ew->{warning} });
	  }

	  next unless($self->{db}{filter_all}{$dbt} and not $error);

	  ($all_ew->{error}, $all_ew->{warn}) =
		&{ $self->{db}{filter_all}{$dbt} }($self, $tmpdata);
	  foreach my $ewstr ('error', 'warning') {
		my $ek = $ewstr eq 'error' ? $errkind : 'warning';
		# cpage  0 ΥबäƤ⤳Ǥϥå򤹤
		foreach my $e (@{ $all_ew->{$ewstr} }) {
		  $tmp = { msg => $self->get_errmsg($e->[0]), table => $dbt };
		  $tmp->{cols} =
			[ sort { $a->[0] <=> $b->[0] }
			  map { [ $cpage->{$dbt}{$_}, $self->{dbseq}{$dbt}{$_}{print} ] }
			  @{ $e->[1] } ];
		  # system_all ϥ̾ȽŤʤʤ
		  $errwarn->{$ek}{$dbt}[$i]{system_all} = $tmp;
		}
		last if(@{ $all_ew->{error} } and $ek eq 'error');
	  }
	}
  }
  $data->{$primary} = $data->{$primary}[0];
  return $errwarn;
}

=item db2file ( SQL, FILENAME, TYPE [,OPTION] )

  $list = $dbi->db2file($sql, $filename, $type, %opt);

    ARGS :
      $sql => HASHREF          # selectcmd Ϥ SQLʸ
      $filename => STRING      # ΥǥեȤΥե̾
      $type => STRING          # եη (csv|tab)

    OPTION :
      add_out_head => BOOLEAN  # true ʤХإåϤ
      outfilter => SUBREF      # outfilter

    RET : STRING               # SQLʸ

CSVե/ֶڤեϤƽλ롣
$opt{outfilter} ꤷơϤ˥ե륿̤ȤǤ롣

=cut

sub db2file {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $sql, $filename, $type, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 4);
  return undef if($self->{debug}{no_db});
  $self->fatal_error("The parameter 'type' is invalid",
					 type => $type) if($type !~ m/^(csv|tab)$/);
  $self->print_error('permission-title', 'permission')
	unless($self->{userinfo}{staff});

  my $and = $self->check_permission('tofile');
  my $sqlcmd = $self->selectcmd('*', %$sql, where_and => $and);

  my $primary = $self->{global}{primary};
  my $dbnum = $self->{dbnum};
  my $dbh = $self->{dbh};

  my $sth;
  eval { $sth = $dbh->prepare($sqlcmd);
		 $sth->execute; };
  if($@ or not $sth) {
	my $errstr = "$@ ; " . $dbh->errstr;
	eval { $dbh->rollback };
	$self->fatal_error("$errstr", sqlcmd => $sqlcmd);
  }

  my $relsth;
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	next if($dbt eq $primary);
	$relsth->{$dbt} = $dbh->prepare
	  ("SELECT * FROM \"$dbt\" WHERE system_rid = ? ORDER BY system_num");
  }

  my $csv_xs;
  $csv_xs = Text::CSV_XS->new( { binary => 1 } ) if($type eq 'csv');

  # եΥإå
  my $name = [ ];
  my ($dbcol, $tblname);
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$tblname = $dbt eq $primary ? '' : "$dbt:";
	foreach my $i (0 .. $#{ $self->{dbcol}{$dbt} }) {
	  $name->[ $self->{dbcnum}{$dbt}[$i] ] =
		$tblname . $self->{dbcol}{$dbt}[$i]{name};
	}
  }
  foreach my $col (@{ $self->{db}{syscol} }) { push(@$name, $col->{name}); }
  my $head;
  if($type eq 'csv') {
	$self->fatal_error("header")
	  unless($csv_xs->combine(@$name));
	$head = $csv_xs->string . "\x0A";
  } else {
	foreach (@$name) { $_ =~ s/\x0A/\x0B/g; }
	$head = join("\x09", @$name) . "\x0A";
  }

  &{ $opt{outfilter} }(\$head) if($opt{outfilter});

  $self->{sys}{printheader} = 1;
  print "HTTP/1.1 200 OK\r\n" if($self->{sys}{nph});
  print "Status: 200 OK\r\n";
  print "Content-type: application/x-msexcel\r\n";
  print "Content-Disposition: attachment; filename=\"$filename\"\r\n";
  print "\r\n";
  print $head;

  my $totalcol = 0;
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$totalcol += $dbnum->{$dbt}{user};
  }

  # Τν
  my ($list, $rid, $rellist, $data, $out, $dbc, $dataref, $code);
  my $ridnum = $self->{dbnum}{$primary}{user_search}
	+ $self->{db}{sysseq}{system_rid}{num};
  while($list = $sth->fetchrow_arrayref) {
	$data = [ ];
	$rid = $list->[ $ridnum ];

	# ơ֥ν
	foreach my $i (0 .. $#{ $self->{dbcol}{$primary} }) {
	  $dbc = $self->{dbcol}{$primary}[$i];
	  $dataref = \$list->[$i];
	  # code ν
	  if($dbc->{code}) {
		$code = $self->{code}{ $dbc->{code}[0] };
		if($dbc->{plural}) {
		  $$dataref =~ s/([^\x1D]+)/$code->{$1}/eg;
		} else {
		  $$dataref = $code->{$$dataref};
		}
	  }
	  $data->[0][ $self->{dbcnum}{$primary}[$i] ] = $$dataref;
	}
	foreach my $i (0 .. $#{ $self->{db}{syscol} }) {
	  $data->[0][$totalcol + $i] =
		$list->[ $dbnum->{$primary}{user_search} + $i ];
	}

	# Ϣơ֥ν
	foreach my $dbt (keys %{ $self->{dbcol} }) {
	  next if($dbt eq $primary);
	  $relsth->{$dbt}->execute($rid);
	  $rellist = $relsth->{$dbt}->fetchall_arrayref;
	  foreach my $i (0 .. $#$rellist) {
		foreach my $j (0 .. $#{ $self->{dbcol}{$dbt} }) {
		  $dbc = $self->{dbcol}{$dbt}[$j];
		  $dataref = \$rellist->[$i][$j];
		  # code ν
		  if($dbc->{code}) {
			$code = $self->{code}{ $dbc->{code}[0] };
			if($dbc->{plural}) {
			  # $self->{code} ˤ϶ʸΥʤ
			  $$dataref =~ s/([^\x1D]+)/$code->{$1}/eg;
			} else {
			  $$dataref = $code->{$$dataref};
			}
		  }
		  $data->[$i][ $self->{dbcnum}{$dbt}[$j] ] = $$dataref;
		}
	  }
	}
	if($type eq 'csv') {
	  foreach my $d (@$data) {
		$self->fatal_error("csv_xs") unless($csv_xs->combine(@$d));
		$out = $csv_xs->string . "\x0A";
		&{ $opt{outfilter} }(\$out) if($opt{outfilter});
		print $out;
	  }
	} else {
	  foreach my $d (@$data) {
		($out = join("\x09", @$d)) =~ s/\x0A/\x0B/g;
		$out .= "\x0A";
		&{ $opt{outfilter} }(\$out) if($opt{outfilter});
		print $out;
	  }
	}
  }

  $dbh->disconnect();
  return $sqlcmd;
}

=item remove_data ( SQL, TOTAL [,OPTION] )

  $list = $dbi->remove_data($sql, $total, %opt);

    ARGS :
      $sql => HASHREF          # selectcmd Ϥ SQLʸ
      $total => NUM            # ͽΥǡη
      $qs_prim => HASHREF      # Ϥ줿ơ֥

    OPTION :
      rollback => BOOLEAN      # rollback 

ǡξ֤ invalid ˤ롣

оݤȤʤǡ˾̵֤ΤΤХ顼Ϥ롣
ޤоݤȤʤǡη $total Ӥ򤷡
פʤХ顼Ϥ롣

$opt{rollback}  false ʤ commit 
̵ˤǡбܺɽѤHTML롣
true ʤ rollback 롣

=cut

sub remove_data {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $sql, $total, $qs_prim, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 4);
  $self->print_error('permission-title', 'permission')
	unless($self->{userinfo}{staff});

  return undef if($self->{debug}{no_db});
  my $dbh = $self->{dbh};

  my $sqland = [ ];
  my $where = $sql->{where};
  if(ref($qs_prim) eq 'HASH') {
	&{ $self->{__remove_data}{hook} }($qs_prim)
	  if($self->{__remove_data}{hook});
	my ($k, $v);
	while(($k, $v) = each %$qs_prim) {
	  $self->_pgsqlunpack(\$v);
	  push(@$sqland, "$k = '$v'");
	}
	$where = "( $where ) AND " . join(' AND ', @$sqland) if(@$sqland);
  }

  my $invnum = $self->selectrow_array
	($self->selectcmd
	 ('COUNT(*)', %$sql,
	  where_and => "system_state = '$self->{db}{sysstate}{invalid}'"));
  $self->print_error('remove-title', 'remove') if($invnum > 0);

  my $active_did;
  eval {
	$active_did = $dbh->selectcol_arrayref
	  ($self->selectcmd
	   ('system_did', %$sql,
		where_and => "system_state = '$self->{db}{sysstate}{active}'")) };
  $self->fatal_error("$@", where => $where) if($@);

  my $num = $self->DBIPgSystem::DB::_update_invalid
	($where, undef, join => $sql->{join});
  if($total != $num) {
	eval { $dbh->rollback };
	$self->print_error('remove_total-title', 'remove_total');
  }
  $self->DBIPgSystem::DB::_commit(rollback => $opt{rollback});

  return if($opt{rollback} or not $self->{global}{export});

  # ܺɽѤHTML
  my ($out, $outs, $page, $alpha);
  foreach my $group (keys %{ $self->{global}{export} }) {
	next unless($self->{global}{export}{$group});
	foreach my $did (@$active_did) {
	  $#$outs = -1;
	  foreach my $p (1 .. $self->{template}{numpage_detail}{$group}) {
		$page = sprintf("%.2d", $p);
		$did = sprintf("%.7d", $did);
		$alpha = chr(96 + $p);
		($out = $self->{global}{export_file}{$group}) =~ s/\^d/$did/g;
		$out =~ s/\^p/$page/g;   $out =~ s/\^a/$alpha/g;
		push(@$outs, $out);
	  }
	  unlink(@$outs);
	}
  }
}

=item data_check ( DATA, QSDATA, ERRWARN, SYSTEM, CMD, CPAGE, PAGE, RESTORE [,OPTION] )

  $ret = $dbi->data_check($data, $qsdata, $errwarn, $system, $cmd, $cpage, $page, $restore, %opt);

    ARGS :
      $data => HASHREF         # ʽѤǤ˥ǡ
      $qsdata => HASHREF       # եफƤ̤Υǡ
      $errwarn => HASHREF      # 顼/ٹξ
      $system => HASHREF       # ƥξ
      $cmd => HASHREF          # ǡɲ/̤ǻȤ륳ޥ
      $cpage => HASHREF        # ڡֹξ
      $page => NUM             # ڡֹ
      $restore => HASH         # ե뷿Υν

    OPTION :
      noencoded => BOOLEAN     # true ʤ code Ѥ륫ब
                               # ˥󥳡ɤƤ
      islast => BOOLEAN        # ƤΥڡɤ
      isfilename => BOOLEAN    # true ʤ $qsdata ͤե̾Ȥߤʤ

    RET : STRING               # 顼 'error'ʤ undef

Ϥ줿ǡå̤ $data ʤɤ롣
ǡ˥顼ĤǤޤޤƤʸ 'error' 
ʤ undef ֤

ŪˤϡνǽԤ

  A. qsdata б륭ġ˳ƥơ֥γƥ쥳ɤˤĤơνԤ
    1. filter_all ˴ؤ륨顼õ롣
    2. ƥˤĤơνԤ
      2-1. type  'file' ξ
        2-1-1. select  'unchange' ʤв⤷ʤ
        2-1-2. select  'none' ʤСɬפʤХեõ롣
        2-1-3. select  'restore' ʤСΥǡƱ֤᤹
        2-1-4. select ʳͤʤСեꡢ
               _convfile ƤӽФ顼н򤹤롣
        2-1-5. nextA. μη֤ءˡ
      2-2. ʣΥȥ뤫Ϥäν
      2-3. infilter ƤӽФʸɤʤɤѴԤˡ
           顼н򤹤롣
      2-4. _filter_one_data ƤӽФִ¤ΥåԤˡ
           顼н򤹤롣
    3. Ϣơ֥ξ硢쥳ɤƶ󤫤ɤå롣
    4. ˤ륨顼ν򤹤롣
    5. 顼ʤϢơ֥ޤ $opt{islast}  true ξ
       filter_all ƤӽФʥΤִ¤ΥåԤˡ
  B. Ϣơ֥Υ쥳ɤˤĤơνԤ
    1. inscmd ˽äб쥳ɤ롣
    2. delcmd ˽äб쥳ɤõ롣
    3. ƶΥ쥳ɤõ롣
  C. 顼Х˻Ĥ
  D. 顼ʤС$errwarn  $system->{system_warning} 򹹿롣

եΥåץɤξ硢$opt{isfilename}  true ʤ
$qsdata б륭˥ե̾ǼƤꡢ
$opt{isfilename}  false ʤ CGI.pm ˤäƥåץɤ
 Fh ֥ȡcgi.pm ȡˤǼƤʤФʤʤ

ǡԶ礬äʤޤԶʤʤäˤϡ
$errwarn->{error}, $errwarn->{warning} бͤ롣
Զϡ̤
  $errwarn->{Զμ}{ơ֥̾}[쥳ֹ]{̾}
ؤΥե󥹤ȤƳǼ롣filter_all ˤԶϡ
  $errwarn->{Զμ}{ơ֥̾}[쥳ֹ]{system_all}
ؤΥե󥹤ȤƳǼ롣
γǤϥϥåؤΥե󥹤ǡ
ͤǼ롣

  msg   : ԶΥå
  print : ̾ (system_all )
  value : ԶΤä (ե뷿, system_all )
  table : бơ֥̾
  num   : ơ֥бֹ (system_all )
  page  : б̤Υڡ (system_all )
  cols  : page  print  (system_all Τ)

Ϣơ֥ insert  delete ʤɤǻꤹ쥳ɤν֤ϡ
ԤΥ쥳ɤбƽԤ
ʶ餯ʹͤȻפ
㤨С3ܤΥ쥳ɤ1ܤľ˰ư
1ܤΥ쥳ɤ褦˻ꤵ줿硢
3ܤΥ쥳ɤ1ܤ˰ưƤ顢
1ܤΥ쥳ɡʰư쥳ɡˤΤǤϤʤ
ºݤˤϡ3ܤΥ쥳ɤ1ܤ˰ưƤ顢
2ܤΥ쥳ɡʸ1ܤˤä쥳ɡˤ롣
̯ʹäԤϡ򻲾Ȥ뤳ȡ

=cut

sub data_check {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $data, $qsdata, $errwarn, $system, $cmd, $cpage,
	  $page, $restore, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 10);

  $page = sprintf("%.2d", $page);

  my $primary = $self->{global}{primary};
  my $search_ext = $self->{sys}{search_ext};
  my $filetypedir = $self->{global}{filetype}{dir};
  my $tmpdir = $self->{global}{filetype}{tmpdir};
  my $thiserror = [ ];
  my $error_null = [ ];
  my $errkind = $self->{debug}{no_data_error} ? 'warning' : 'error';
  my $exist = { };		# nullͰʳͤǼƤ true
  my ($e, $ew, $dbcol, $dref, $search, $filename, $suberror, $all_ew,
	  $key_search, $oldfile, $oldfile_tn, $file, $searchref, $dbtdata,
	  $dbtrestore);
  $data->{$primary} = [ $data->{$primary} ];
  $cmd->{select}{$primary} = [ $cmd->{select}{$primary} ];
  foreach my $dbt (keys %$qsdata) {
	$self->fatal_error("qsdata is invalid", dbt => $dbt)
	  unless(exists $self->{dbcol}{$dbt});
	foreach my $i (0 .. $#{ $qsdata->{$dbt} }) {
	  delete $errwarn->{error}{$dbt}[$i]{system_all};
	  delete $errwarn->{warning}{$dbt}[$i]{system_all};
	  $data->{$dbt}[$i] = { } unless(defined $data->{$dbt}[$i]);
	  $dbtdata = $data->{$dbt}[$i];
	  foreach my $key (keys %{ $qsdata->{$dbt}[$i] }) {
		$self->fatal_error
		  ("qsdata is invalid", dbt => $dbt, key => $key)
			unless(exists $self->{dbseq}{$dbt}{$key});

		delete $errwarn->{error}{$dbt}[$i]{$key};
		delete $errwarn->{warning}{$dbt}[$i]{$key};
		$suberror = 0;
		$dbcol = $self->{dbseq}{$dbt}{$key};
		$key_search = $key . $search_ext;

		# եξ
		if($dbcol->{type} eq 'file') {
		  $restore->{$dbt}[$i] = { } unless(defined $restore->{$dbt}[$i]);
		  $dbtrestore = $restore->{$dbt}[$i];
		  next if($cmd->{select}{$dbt}[$i]{$key} eq 'unchange');
		  $oldfile = $dbtdata->{$key};
		  $oldfile_tn = $dbtdata->{$key_search} if($dbcol->{search});

		  # ե򥢥åץɤʤ
		  if($cmd->{select}{$dbt}[$i]{$key} eq 'none') {
			$dbtdata->{$key} = undef;
			# Υǡ˥ե뤬Сͤ򤵤
			if(-f "$filetypedir/$oldfile") {
			  $dbtrestore->{$key} = $oldfile;
			  $dbtrestore->{$key_search} = $oldfile_tn
				if($dbcol->{search});
			} else {
			  unlink("$tmpdir/$oldfile");
			  unlink("$tmpdir/$oldfile_tn") if($dbcol->{search});
			  unlink("$tmpdir/$oldfile") if($oldfile =~ s!\.[^/]*$!!);
			}
			next;
		  }

		  # ᤹
		  if($cmd->{select}{$dbt}[$i]{$key} eq 'restore') {
			next if($oldfile eq '' and $dbtrestore->{$key} eq '');
			$dbtdata->{$key} = $dbtrestore->{$key};
			delete $dbtrestore->{$key};
			if($dbcol->{search}) {
			  $dbtdata->{$key_search} = $dbtrestore->{$key_search};
			  delete $dbtrestore->{$key_search};
			}
			unless(-f "$filetypedir/$oldfile") {
			  unlink("$tmpdir/$oldfile");
			  unlink("$tmpdir/$oldfile_tn") if($dbcol->{search});
			  unlink("$tmpdir/$oldfile") if($oldfile =~ s!\.[^/]*$!!);
			}
			next;
		  }

		  # եϥɥե̾
		  if($opt{isfilename}) {
			$filename = $qsdata->{$dbt}[$i]{$key};
			open(FILE, $filename)
			  or $self->fatal_error("file is invalid", key => $key,
									filename => $filename);
			flock(FILE, 1);
			$file = *FILE;
		  } else {
			$file = $qsdata->{$dbt}[$i]{$key} or next;
			$self->fatal_error("file is invalid", key => $key,
							   ref => ref($file), file => $file)
			  unless(ref($file) =~ m/^FH$/i and fileno($file));
		  }
		  $exist->{$dbt}[$i] = 1;

		  # Ѵƥ顼
		  $searchref = \$dbtdata->{$key_search};
		  $e = $self->DBIPgSystem::DB::_convfile
			($file, \$dbtdata->{$key}, $searchref,
			 filter => $dbcol->{subst}, thumbnail => $dbcol->{search},
			 restore => (defined $dbtrestore->{$key} ? 1 : 0));
		  if($e) {
			my $tmp = { msg => $e->[1], table => $dbt,
						num => $dbcol->{num}, print => $dbcol->{print},
						page => $page };
			$errwarn->{ $e->[0] }{$dbt}[$i]{$key} = [ $tmp ];
			if($e->[0] eq 'error') {
			  push(@$thiserror, $tmp);
			  $suberror = 1;
			}
		  }
		  # Υǡ˥ե뤬Сͤ򤵤
		  if(-f "$filetypedir/$oldfile") {
			$dbtrestore->{$key} = $oldfile;
			$dbtrestore->{$key_search} = $oldfile_tn if($dbcol->{search});
		  }

		  close(FILE) if($opt{isfilename});
		  next;
		}

		# ҤȤĤΥФʣΥȥ뤫Ϥä
		if(ref($qsdata->{$dbt}[$i]{$key}) eq 'HASH') {
		  $self->fatal_error("'$key' is invalid", key => $key)
			unless($self->{dbseq}{$dbt}{$key}{plural});
		  $qsdata->{$dbt}[$i]{$key} = join
			("\x1D", map { $qsdata->{$dbt}[$i]{$key}{$_} }
			 (sort { $a <=> $b } keys %{ $qsdata->{$dbt}[$i]{$key} }));
		  $qsdata->{$dbt}[$i]{$key} = "\x1D$qsdata->{$dbt}[$i]{$key}\x1D";
		}

		$dbtdata->{$key} = $qsdata->{$dbt}[$i]{$key};
		$dref = \$dbtdata->{$key};

		# ʸɤѴ
		$e = $self->infilter($dref);
		if($e) {
		  my $tmp = { msg => $self->get_errmsg($e), table => $dbt,
					  value => $$dref, num => $dbcol->{num},
					  print => $dbcol->{print}, page => $page };
		  $errwarn->{error}{$dbt}[$i]{$key} = [ $tmp ];
		  push(@$thiserror, $tmp);
		  $suberror = 1;
		  next;
		}
		# ͤϤ
		$ew = { error => [ ], warning => [ ] };
		$self->DBIPgSystem::DB::_filter_one_data
		  ($dbt, $dbcol->{num}, $dref, $ew, \$search, page => $page,
		   noencode => not $opt{noencoded});
		$dbtdata->{$key_search} = $search
		  if($dbcol->{search});
		if($dbt ne $primary and not defined($$dref)) {
		  # Ϣơ֥ͤΤȤϡޤ顼ɤϤ狼ʤ
		  push(@$error_null, @{ $ew->{error} });
		} else {
		  push(@$thiserror, @{ $ew->{error} });
		  $suberror = 1 if(@{ $ew->{error} });
		}
		$errwarn->{error}{$dbt}[$i]{$key} = [ @{ $ew->{error} } ]
		  if(@{ $ew->{error} });
		$errwarn->{warning}{$dbt}[$i]{$key} = [ @{ $ew->{warning} } ]
		  if(@{ $ew->{warning} });
	  }

	  $exist->{$dbt}[$i] = 1 if($dbt eq $primary);

	  # 顼ä
	  if($suberror) { $exist->{$dbt}[$i] = 1; next; }

	  # Ϣơ֥ǥ쥳ɤƶ󤫤ɤå
	  unless($exist->{$dbt}[$i]) {
		foreach my $k (keys %$dbtdata) {
		  if($k !~ m/$search_ext$/o and
			 defined $dbtdata->{$k}) { $exist->{$dbt}[$i] = 1; last; }
		}
		unless($exist->{$dbt}[$i]) { @$error_null = ( ); next; }
	  }

	  # ˤ륨顼ä
	  if(@$error_null) {
		push(@$thiserror, @$error_null);
		@$error_null = ( );
		$exist->{$dbt}[$i] = 1;
		next;
	  }

	  next if($dbt eq $primary and not $opt{islast});

	  # filter_all : ΤФִ¤Υå
	  if($self->{db}{filter_all}{$dbt}) {
		($all_ew->{error}, $all_ew->{warning})
		  = &{ $self->{db}{filter_all}{$dbt} }($self, $dbtdata);
		foreach my $ewstr ('error', 'warning') {
		  my $ek = $ewstr eq 'error' ? $errkind : 'warning';
		  foreach my $e (@{ $all_ew->{$ewstr} }) {
			my $tmp = { msg => $self->get_errmsg($e->[0]), table => $dbt };
			$tmp->{cols} =
			  [ sort { $a->[0] <=> $b->[0] }
				map { [ $cpage->{$dbt}{$_}, $self->{dbseq}{$dbt}{$_}{print} ] }
				@{ $e->[1] } ];
			$errwarn->{$ek}{$dbt}[$i]{system_all} = [ $tmp ];
			push(@$thiserror, $tmp) if($ek eq 'error');
		  }
		  last if(@{ $all_ew->{error} } and $ek eq 'error');
		}
	  }
	}
  }
  $data->{$primary} = $data->{$primary}[0];

  # Ϣơ֥Υ쥳ν
  my ($isdef, $j, $inscmd, $delcmd);
  foreach my $dbt (keys %$qsdata) {
	next if($dbt eq $primary);

	# 쥳ɤ
	$inscmd = $cmd->{insert}{$dbt} || [ ];
	$delcmd = $cmd->{delete}{$dbt} || [ ];
	foreach my $i (0 .. $#$inscmd) {
	  $j = $inscmd->[$i];
	  next if($j eq '');
	  foreach my $ref ($data, $errwarn->{error}, $errwarn->{warning}, $exist) {
		splice(@{ $ref->{$dbt} }, $j-1, 0, $ref->{$dbt}[$i-1]);
		splice(@{ $ref->{$dbt} }, $i, 1);
	  }
	  foreach my $k ($i+1 .. $#$inscmd) {
		$inscmd->[$k]++
		  if($inscmd->[$k] ne '' and $inscmd->[$k] >= $j);
	  }
	  foreach my $k (0 .. $#$delcmd) {
		$delcmd->[$k]++ if($delcmd->[$k] >= $j);
	  }
	}
	# 쥳ɤξõ
	foreach my $i (0 .. $#$delcmd) {
	  next if($delcmd->[$i] eq '');
	  foreach my $ref ($data, $errwarn->{error}, $errwarn->{warning}, $exist) {
		splice(@{ $ref->{$dbt} }, $delcmd->[$i] - 1, 1);
	  }
	  foreach my $k ($i+1 .. $#$delcmd) {
		splice(@$delcmd, $k, 1) if($delcmd->[$k] == $i);
		$delcmd->[$k]-- if($delcmd->[$k] > $i);
	  }
	}
	# ƶΥ쥳ɤξõ
	foreach my $i (reverse(0 .. $#{ $data->{$dbt} })) {
	  next if($exist->{$dbt}[$i]);
	  foreach my $ref ($data, $errwarn->{error}, $errwarn->{warning}, $exist) {
		splice(@{ $ref->{$dbt} }, $i, 1);
	  }
	}
  }

  # 顼ϥȤ
  if(@$thiserror) {
	foreach my $e (@$thiserror) {
	  $self->add_log
		('DataError', 'data_insert', table => $e->{table},
		 print => $e->{print}, value => $e->{value}, msg => $e->{msg});
	}
	return 'error';
  }

  # 顼ʤ $errwarn 򹹿
  my $iserr;
 ERR: foreach my $dbt (keys %{ $errwarn->{error} }) {
	foreach my $e (@{ $errwarn->{error}{$dbt} }) {
	  foreach my $key (keys %$e) {
		if($e->{$key} and @{ $e->{$key} }) { $iserr = 1;   last ERR; }
	  }
	}
  }
  $errwarn->{error} = { } unless($iserr);

  return 'error' if($iserr);
  return undef;
}

=item data_verify_check ( DATA, PRESYS, SYSTEM )

  $ret = $dbi->data_verify_check($data, $presys, $system);

    ARGS :
      $data => HASHREF         # ǡ
      $presys => HASHREF       # ΥǡΥƥξ
      $system => HASHREF       # ƥξ

    RET : STRING               # 顼

ǡ draftѥơ֥permission ΥåʤɤԤ
顼Х顼ɤ֤

=cut

sub data_verify_check {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $data, $presys, $system) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 4);

  my $primary = $self->{global}{primary};
  my $dbh = $self->{dbh};
  my $revise = $system->{system_did} ne '' ? 1 : 0;

  # $self->{deny}{data_verify_check} Υå
  if($self->{deny}{data_verify_check}) {
	my $err =
	  &{ $self->{deny}{data_verify_check} }($data, $presys, $system, $revise);
	return $err if($err);
  }

  # Permission (delete) Υå
  if($system->{system_did} ne '') {
	if($system->{system_state} eq $self->{db}{sysstate}{wait}) {
	  $self->DBIPgSystem::DB::_update_invalid
		("system_rid = $presys->{system_rid}", undef, waitonly => 1)
		  or return 'insert_permission';
	} else {
	  $self->DBIPgSystem::DB::_update_invalid
		("system_did = $system->{system_did}", undef)
		  or return 'insert_permission';
	}
	eval { $dbh->rollback; };
  }

  my $primarylist = $self->DBIPgSystem::DB::_hash2array_data
	($data->{$primary}, $primary);

  # INSERT ʸ
  my $issysbind = { };
  my ($sth, $sysbnum) = $self->DBIPgSystem::DB::_prepare_insert_cmd
	(1, $system, $issysbind);
  my $sysmainbnum = $sysbnum->{$primary};
  my $primsth = $sth->{$primary};
  my $bnum = 1;

  my $perm_a = $self->check_permission
	('add', state => $system->{system_state});
  my $err;
  eval {
	my $rand = int(rand(65536));
	foreach (@$primarylist) { $primsth->bind_param($bnum++, $_); }
	$primsth->bind_param($sysmainbnum->{draft_rid}, undef);
	$primsth->bind_param($sysmainbnum->{draft_line}, $rand);
	$primsth->execute or die "Cannot execute";

	# Permission (add) Υå
	$err = 'insert_permission'
	  if($self->selectrow_array
		 ("SELECT COUNT(*) FROM \"${primary}_dft\" "
		  . "WHERE draft_rid IS NULL AND draft_line = '$rand' "
		  . "AND NOT ( $perm_a )") > 0);
  };
  if($@) {
	my $errstr = "$@ ; " . $dbh->errstr;
	eval { $dbh->rollback };
	$self->fatal_error($errstr);
  }

  eval { $dbh->rollback };
  return $err;
}

=item data_insert ( DATA, PRESYS, SYSTEM, ERRWARN )

  $ret = $dbi->data_insert($data, $presys, $system, $errwarn);

    ARGS :
      $data => HASHREF         # ǡ
      $presys => HASHREF       # ΥǡΥƥξ
      $system => HASHREF       # ƥξ
      $errwarn => HASHREF      # 顼/ٹξ

    RET : LIST
      0 => NUM                 # system_rid
      1 => STRING              # 顼

1Υǡܥơ֥롣
ǡνξ硢$system->{system_state} ͭʤС
DID Ʊǡ̵ˤ롣
$system->{system_state} ʤСΥǡ̵ˤ롣

ޤ롼פ staff θ¤ʤ桼Υ᡼륢ɥ쥹ꤵƤꡢ
 $self->{global}{insert_mail} ꤵƤС
λݤ᡼Τ餻롣

˼Ԥϥ顼ɤ֤

=cut

sub data_insert {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $data, $presys, $system, $errwarn, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 5);

  my $primary = $self->{global}{primary};
  my $filetypedir = $self->{global}{filetype}{dir};
  my $tmpdir = $self->{global}{filetype}{tmpdir};
  my $dbh = $self->{dbh};
  my $revise = $system->{system_did} ne '' ? 1 : 0;

  $self->fatal_error("'system_state' is invalid")
	if(not $self->{userinfo}{staff} and
	   $system->{system_state} eq $self->{db}{sysstate}{active});

  # $self->{deny}{data_insert} Υå
  if($self->{deny}{data_insert}) {
	my $err =
	  &{ $self->{deny}{data_insert} }($data, $presys, $system, $revise);
	return (undef, $err) if($err);
  }

  # ǡ¤ؤ
  $data->{$primary} = [ $data->{$primary} ];
  my $datalist;
  foreach my $dbt (keys %$data) {
	my $i = 0;
	foreach my $dbdata (@{ $data->{$dbt} }) {
	  $datalist->{$dbt}[$i++] = $self->DBIPgSystem::DB::_hash2array_data
		($dbdata, $dbt);
	}
  }
  $data->{$primary} = $data->{$primary}[0];

  # ƥ
  $system->{system_date} = 'NOW';
  $system->{system_method} = $ENV{SCRIPT_NAME};
  $system->{system_addr} = $ENV{REMOTE_ADDR};
  $system->{system_agent} = $ENV{HTTP_USER_AGENT};
  $system->{system_uid} = $self->{userinfo}{uid} unless($revise);
  $system->{system_rev_uid} = $self->{userinfo}{uid} if($revise);

  # ϿƤǡȤνʣå
  my $system_uniq = $self->DBIPgSystem::DB::_calc_system_uniq($datalist);
  $system->{system_uniq} =
	$system->{system_state} eq $self->{db}{sysstate}{active} ?
	  $system_uniq : undef;
  my $nouniq;
  eval {
	my $uniqsth = $dbh->prepare
	  ("SELECT count(*) FROM \"$primary\" WHERE system_uniq = ?");
	$uniqsth->execute($system_uniq);
	$nouniq = $uniqsth->fetchrow_array; };
  if($@) {
	my $errstr = "$@ ; " . $dbh->errstr;
	eval { $dbh->rollback };
	$self->fatal_error("$errstr");
  }
  return (undef, 'insert_unique') if($nouniq);

  # system_warning
  foreach my $dbt (keys %{ $errwarn->{warning} }) {
	foreach my $w (@{ $errwarn->{warning}{$dbt} }) {
	  foreach my $key (keys %$w) {
		foreach my $wi (@{ $w->{$key} }) {
		  $system->{system_warning} .=
			"$wi->{table}\x1D$wi->{print}\x1D$wi->{msg}\x0A";
		}
	  }
	}
  }

  # INSERT ʸ
  my $issysbind = { system_did => 1, system_rid => 1 };
  my ($sth, $sysbnum) = $self->DBIPgSystem::DB::_prepare_insert_cmd
	(0, $system, $issysbind);
  my $sysmainbnum = $sysbnum->{$primary};

  # ɬפʤХǡ̵ˤsystem_rid, system_did 
  my $rid = $system->{system_rid} =
	$self->DBIPgSystem::DB::_get_nextval("seq_rid");
  if($revise) {
	if($system->{system_state} eq $self->{db}{sysstate}{wait}) {
	  $self->DBIPgSystem::DB::_update_invalid
		("system_rid = '$presys->{system_rid}'", $rid, waitonly => 1)
		  or return (undef, 'insert_permission');
	} else {
	  $self->DBIPgSystem::DB::_update_invalid
		("system_did = '$system->{system_did}'", $rid)
		  or return (undef, 'insert_permission');
	}
  } else {
	$system->{system_did} = $self->DBIPgSystem::DB::_get_nextval("seq_did");
  }

  # ǡ
  my ($dataref, $searchref, $origfile, $upfile, $upfile_tn, $rubbish, $bnum,
	  $sthdbt);
  my $mode = $self->{global}{filetype}{mode};
  eval {
	foreach my $dbt (keys %$datalist) {
	  $sthdbt = $sth->{$dbt};
	  foreach my $i (0 .. $#{ $datalist->{$dbt} }) {
		my $j = 0;
		foreach my $dbc (@{ $self->{dbcol}{$dbt} }) {
		  $dataref = \$datalist->{$dbt}[$i][$j++];
		  next unless($dbc->{type} eq "file" and -f "$tmpdir/$$dataref");

		  # ----- åץɤ줿եν -----
		  $searchref = $dbc->{search} ?
			\$datalist->{$dbt}[$i][ $dbc->{search_num} ] : undef;

		  if(($origfile = $$dataref) =~ s!(\.[^/]*)$!!) {
			# åץɤ줿ꥸʥΥեס˰ư
			$rubbish = join
			  ('', $self->{global}{filetype}{pooldir}, '/',
			   sprintf("%.7d", $rid), '-', $dbc->{name});
			rename("$tmpdir/$origfile", $rubbish)
			  or die "Cannot rename $tmpdir/$origfile to $rubbish: $!";
		  }

		  # եư
		  $upfile = "$filetypedir/$$dataref";
		  rename("$tmpdir/$$dataref", $upfile)
			or die "Cannot rename $tmpdir/$$dataref: $!";
		  chmod($mode, $upfile) or die "Cannot change mode: $!" if($mode);

		  # ͥΥե̾Ѥƥեư
		  if($dbc->{search}) {
			$upfile_tn = "$filetypedir/$$searchref";
			rename("$tmpdir/$$searchref", $upfile_tn)
			  or die "Cannot rename $tmpdir/$$searchref: $!";
			chmod($mode, $upfile_tn) or die "Cannot change mode: $!" if($mode);
		  }

		  # եξǡ١ߤ
		  $self->DBIPgSystem::DB::_insert_filedb
			($$dataref, $$searchref, $dbt, $i + 1, $dbc->{name},
			 $system, $errwarn);
		}

		# ǡǡ١
		$bnum = 1;
		foreach (@{ $datalist->{$dbt}[$i] }) {
		  $sthdbt->bind_param($bnum++, $_);
		}
		if($dbt eq $primary) {
		  $sthdbt->bind_param
			($sysmainbnum->{system_did}, $system->{system_did});
		  $sthdbt->bind_param
			($sysmainbnum->{system_rid}, $system->{system_rid});
		} else {
		  $sthdbt->bind_param
			($sysbnum->{$dbt}{system_rid}, $system->{system_rid});
		  $sthdbt->bind_param($sysbnum->{$dbt}{system_num}, $i + 1);
		}
		$sthdbt->execute or die "table: $dbt ($i)";
	  }
	}
  };
  if($@) {
	my $errstr = "$@ ; " . $dbh->errstr;
	eval { $dbh->rollback };
	$self->fatal_error("$errstr", inssid => $opt{inssid})
	  if($errstr !~ m/unique index/i);
	return (undef, 'insert_unique');
  }

  $self->DBIPgSystem::DB::_commit;

  $self->DBIPgSystem::DB::_export_html_detail($rid)
	if($system->{system_state} eq $self->{db}{sysstate}{active});

  if($self->{global}{insert_mail} and not $self->{userinfo}{staff} and
	 $self->{userinfo}{email} ne '') {
	# ᡼
	my ($title, $body) = &{ $self->{global}{insert_mail} }($data, $system);
	if(defined $body) {
	  my $ret = $self->send_mail($self->{userinfo}{email}, $title, $body);
	  $self->fatal_error
		("Cannot send e-mail", mailto => $self->{userinfo}{email},
		 title => $title, body => $body) unless($ret);
	}
  }

  return ($rid, undef);
}

=item file_check ( FILEHANDLE, SYSTEM, FTYPE, NEWLINE, REVISE, REMOVE_HEAD, STATE [,OPTION] )

  $list = $dbi->file_check($fh, $system, $ftype, $nl, $revise, $remove_head, $state, %opt);

    ARGS :
      $fh => FILEHANDLE        # եΥեϥɥ
      $system => HASHREF       # ƥξ
      $ftype => STRING         # եη (csv|tab)
      $newline => STRING       # եβʸ (\x0D\x0A|\x0D|\x0A)
      $revise => BOOLEAN       # true ʤХǡν
      $remove_head => BOOLEAN  # true ʤХե1ܤ̵뤹
      $state => NUM            # system_state

    OPTION :
      report => BOOLEAN        # вϤ
      code => STRING           # ʸ

    RET : HASHREF
      draft_rid => NUM         # draft_rid
      error => ARRAYREF        # 顼ξ
      warning => ARRAYREF      # ٹξ
      over => ARRAYREF         # CSVե˽ʣΤäǡΰ
      ignored => ARRAYREF      # ܥơ֥ΥǡȽʣǡΰ
      invalid => ARRAYREF      # 齤Τäǡΰ
      permission => ARRAYREF   # ʤäǡΰ
      num => HASHREF
        error => NUM           # 顼ޤǡη
        over => NUM            # scalar @{ $ret->{over} } Ʊ
        ignored => NUM         # scalar @{ $ret->{ignored} } Ʊ
        success => NUM         # 嵭ʳΡ˥ǡη
        warning => NUM         # ٹ𤬤ǡη
        noactive => NUM        # ǡνκ active ǤϤʤǡη
        invalid => NUM         # scalar @{ $ret->{invalid} } Ʊ
        permission => NUM      # scalar @{ $ret->{permission} } Ʊ
        error_i => NUM         # 顼θĿ
        warning_i => NUM       # ٹθĿ
        total => NUM           # ǡ

CSVե, ֶڤե draftѤΥơ֥롣

ƥ쥳ɤˤĤơ顼ٹΥåԤ
ɤΥˤ⥨顼ʤ
ե¾Υ쥳ɤǡ١ܥơ֥ȽʣƤʤС
draftѤΥơ֥롣

᥽åɤμ¹ draft_rid 1
1ĤΥե뤫ƤΥ쥳ɤƱ draft_rid бդ롣
draft_rid Ѥ¾νˤǡȼ̤Ԥ

ޤơ֥ȴϢơ֥Υ쥳ɤбդ뤿ᡢ
ơ֥γƥ쥳 seq_rid_dft ֹ
ͤơ֥ system_next_rid ȴϢơ֥ system_rid 
Ǽ롣

ǡɲäϡեΥƥ̵뤹롣

ǡϡեΥƥΤ
system_rid, system_did, system_state, system_uniq 򻲾Ȥ롣
system_rid  system_did, system_uniq Ȥǡ١ƤȰפ
ĥեΥǡȥǡ١бǡ system_state 
ͭξΤߡΥǡνߤ롣
ǡԽƤʤsystem_uniq ͤѤʤˤϡ
򤷤ʤ

ǡ˥顼ٹ𤬤äϡ
$ret->{error}, $ret->{warning} ˥ϥåηǾǼ롣
ϥåˤϼƤǼ롣

  msg   : ԶΥå
  table : бơ֥̾
  value : ԶΤä
  num   : ơ֥бֹ
  col   : ԶΤä
  print : ̾
  line  : եб

$ret->{over}, $ret->{ignored} ˤϡ
ʣΤ̵ˤʤäǡ $line_mt ͤηǳǼ롣

=cut

sub file_check {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $fh, $system, $ftype, $newline, $revise, $remove_head, $state,
	  %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 8);
  $self->fatal_error("The parameter 'ftype' is invalid",
					 ftype => $ftype) if($ftype !~ m/^(csv|tab)$/);
  $self->fatal_error("The parameter 'state' is invalid")
	unless($state eq $self->{db}{sysstate}{wait}
		   or $state eq $self->{db}{sysstate}{active});
  $self->print_error('permission-title', 'permission')
	unless($self->{userinfo}{staff} and $self->{global}{enable_file_insert});

  my $nl = $/;
  $| = 1 if($opt{report});

  my $ret = { num => { success => 0, error => 0, warning => 0, over => 0,
					   ignored => 0, noactive => 0, invalid => 0,
					   permission => 0, error_i => 0, warning_i => 0 },
			  error => [ ], warning => [ ], over => [ ], ignored => [ ],
			  invalid => [ ], permission => [ ] };
  my $dbh = $self->{dbh};
  my $primary = $self->{global}{primary};
  my $maxnumerr = $self->{global}{file_maxnumerr};
  my $csv_xs = Text::CSV_XS->new( { binary => 1 } );
  my $sysstate = $self->{db}{sysstate};

  # draft_rid 
  my $draft_rid = $self->DBIPgSystem::DB::_get_nextval("seq_dftid");
  $self->fatal_error("$@ ; " . $dbh->errstr)
	if($@ or $draft_rid eq '');
  $system->{draft_rid} = $draft_rid;
  $ret->{draft_rid} = $draft_rid;

  # ǡ˰¸ʤƥ
  $system->{system_state} = $state;
  $system->{system_pre_state} = $sysstate->{active} if($revise);
  $system->{system_date} = 'NOW';
  $system->{system_method} = $ENV{SCRIPT_NAME};
  $system->{system_addr} = $ENV{REMOTE_ADDR};
  $system->{system_agent} = $ENV{HTTP_USER_AGENT};
  $system->{system_uid} = $self->{userinfo}{uid} unless($revise);
  $system->{system_rev_uid} = $self->{userinfo}{uid} if($revise);
  $ret->{addr} = $ENV{REMOTE_ADDR};

  # seq_rid_dft ϳƥǡ1ĤĳƤ졢system_next_rid ˳Ǽ
  my $rdseqsth;
  eval { $rdseqsth = $dbh->prepare
		   ("SELECT nextval('seq_rid_dft')") };
  $self->fatal_error("$@ ; " . $dbh->errstr) if($@);
  # INSERT ʸ
  my $issysbind =
	{ system_next_rid => 1,  system_uniq => 1, system_warning => 1 };
  $issysbind = { %$issysbind, system_did => 1, system_rid => 1,
				 system_pre_rid => 1 } if($revise);

  my ($sth, $sysbnum) = $self->DBIPgSystem::DB::_prepare_insert_cmd
	(1, $system, $issysbind);
  my $sysmainbnum = $sysbnum->{$primary};

  # 桼ȸѥ׻
  my $totalcol = 0;
  foreach my $dbt (keys %{ $self->{dbnum} }) {
	$totalcol += $self->{dbnum}{$dbt}{user};
  }

  # ΥƥबեβܤΥˤ뤫Ĵ٤Ƥ
  my $syscolnum;
  foreach my $key ('system_state', 'system_rid', 'system_did', 'system_uniq') {
	$syscolnum->{$key} = $totalcol + $self->{db}{sysseq}{$key}{num};
  }

  # ͭʥǡ RID  DID ơ֥ $hashdid 
  my ($hashdid, $hashuniqrev, $dpermsth);
  if($revise) {
	my ($rid, $did, $uniq);

	my $perm_r = $self->check_permission
	  ('detail', state => $sysstate->{active});
	my $perm_d = $self->check_permission('delete');
	eval {
	  # did ǿѤäơ餫Ƥ
	  my $dmax = $dbh->selectrow_array("SELECT COUNT(*) FROM \"$primary\"");
	  $#$hashdid = $dmax;

	  my $sth = $dbh->prepare
		("SELECT system_rid, system_did, system_uniq FROM \"$primary\" "
		 . "WHERE $perm_r ORDER BY system_rid");
	  $sth->execute;
	  ($hashdid->[$rid], $hashuniqrev->[$rid]) = ($did, $uniq)
		while(($rid, $did, $uniq) = $sth->fetchrow_array);

	  $dpermsth = $dbh->prepare
		("SELECT COUNT(*) FROM \"$primary\" "
		 . "WHERE system_did = ? AND system_state != '$sysstate->{invalid}' "
		 . "AND NOT ( $perm_d )");
	};
	$self->fatal_error("$@ ; " . $dbh->errstr) if($@);
  }

  my ($rid, $did, $uniq, $rc, $bnum, $subdbtnum, $sthdbt, $datalist, $abort,
	  $hashuniq, $infilter_err, $tmp);
  my $data = "";
  my $first_line = $remove_head ? 2 : 1;
  my $ff = { };
  my $ff_ew = { error => [ ], warning => [ ]};
  my $record = { };
  my $line = 0;
  my $line_mt = $remove_head ? 2 : 1;
  my $num_warning = { };
  # eval ɾϻ֤뤿롼פγ˽ФƤ
  # while νϤǤڤ٤
  eval {
	while(1) {
	  # եκǸޤǽä顢롼פȴ
	  last unless(defined $data);
	  # 쥳ɤνäƤ顢ѿŬڤ˽
	  if($record->{complete}) {
		%$record = ( );
		$line_mt = $line;
	  }

	  # ľ˼¹Ԥ _file_filter_indata ν
	  foreach my $dbt (keys %$ff) {
		push(@{ $record->{table}{$dbt} }, $ff->{$dbt});
	  }
	  foreach my $key ('error', 'warning') {
		next unless(@{ $ff_ew->{$key} });
		foreach my $e (@{ $ff_ew->{$key} }) {
		  $tmp = { %$e, line => $line_mt };
		  $tmp->{col} = $self->{dbcnum}{ $e->{table} }[ $e->{num} ] + 1
			if(defined $e->{num});
		  push(@{ $record->{$key} }, $tmp);
		}
		last;
	  }
	  if($revise and defined($ff->{$primary})) {
		$system->{system_state} = $datalist->[ $syscolnum->{system_state} ];
		$system->{system_rid} = $datalist->[ $syscolnum->{system_rid} ];
		$system->{system_did} = $datalist->[ $syscolnum->{system_did} ];
		$uniq = $datalist->[ $syscolnum->{system_uniq} ];
	  }

	  # ե뤫1ʬɤ߹ (CSVξϥβԤ)
	  undef $data;
	  $/ = $newline;
	  while(<$fh>) {
		$data .= $_;
		last unless($ftype eq 'csv' and $data =~ tr/"// % 2);
	  }
	  $/ = $nl;

	  next if($line++ == 0 and $remove_head);
	  print "$line " if($opt{report} and $line % 100 == 0);

	  if(defined $data) {
		# ʸɤѴ
		$infilter_err = $self->infilter
		  (\$data, code => $opt{code}, file => $ftype);

		# CSV/ֶڤηؤΥե󥹤Ѵ
		if($ftype eq 'csv') {
		  $abort = 'file_invalid' unless($csv_xs->parse($data));
		  $datalist = [ $csv_xs->fields() ];
		} else {
		  $data =~ s/$newline$//o;
		  $datalist = [ split(/\x09/, $data, -1) ];
		}

		# եΥ­ʤ
		$abort = 'file_col' if(@$datalist < $totalcol and
							   not $self->{global}{file_allow_short_col});

		# 顼ΤǤ
		if($abort) {
		  foreach my $dbt (keys %{ $self->{dbcol} }) {
			$self->do("DELETE FROM \"${dbt}_dft\" "
					  . "WHERE draft_rid = '$draft_rid'");
		  }
		  $self->print_error('file-title', { msg => $abort, line => $line });
		}

		# ƥͤ
		($ff, $ff_ew) = $self->DBIPgSystem::DB::_file_filter_indata
		  ($datalist, $infilter_err ? 1 : 0);
	  }

	  # եƬ primary ͤʤԤǻϤޤäƤϡ
	  # primary ͤԤޤǤ̵뤹
	  %$record = ( ) if(not exists($record->{table}{$primary}) and
						$ff->{$primary});

	  # ơ֥1쥳ʬξɤ߹߽Ƥʤ
	  # ǽ next
	  next unless(defined($record->{table}{$primary}));
	  next if(defined $data and not $ff->{$primary});

	  # ----- ơ֥1쥳ʬξɤ߹߽ν -----
	  $record->{complete} = 1;

	  # 顼
	  if($record->{error}) {
		if(@{ $ret->{error} } < $maxnumerr) {
		  push(@{ $ret->{error} }, @{ $record->{error} });
		  $#{ $ret->{error} } = $maxnumerr - 1
			if(@{ $ret->{error} } > $maxnumerr);
		}
		$ret->{num}{error_i} += @{ $record->{error} };
		$ret->{num}{error}++;
		next;
	  }

	  # ǡνξ
	  if($revise) {
		# active Ǥʤ
		if($system->{system_state} ne $sysstate->{active}) {
		  $ret->{num}{noactive}++;
		  next;
		}
		# ֤Ѥä
		$rid = $system->{system_rid};
		$did = $hashdid->[$rid];
		unless(defined $did) {
		  push(@{ $ret->{invalid} }, $line_mt);
		  next;
		}
		# ե뤫ɤ߹ DID or system_uniq ʤ
		if($system->{system_did} ne $did or $hashuniqrev->[$rid] ne $uniq) {
		  if(@{ $ret->{error} } < $maxnumerr) {
			push(@{ $ret->{error} },
				 { msg => $self->get_errmsg('file_revise'),
				   table => $primary, line => $line_mt });
			$#{ $ret->{error} } = $maxnumerr - 1
			  if(@{ $ret->{error} } > $maxnumerr);
		  }
		  $ret->{num}{error_i}++;
		  $ret->{num}{error}++;
		  next;
		}

		# system_uniq 
		$system->{system_uniq} =
		  $self->DBIPgSystem::DB::_calc_system_uniq($record->{table});
		if($system->{system_uniq} eq $uniq) {
		  push(@{ $ret->{ignored} }, $line_mt);
		  next;
		}

		# Permission (delete) Υå
		if($state eq $sysstate->{active}) {
		  $dpermsth->execute($system->{system_did});
		  if($dpermsth->fetchrow_array > 0) {
			push(@{ $ret->{permission} }, $line_mt);
			next;
		  }
		}

		# ƥ
		$sth->{$primary}->bind_param
		  ($sysmainbnum->{system_rid}, $system->{system_rid});
		$sth->{$primary}->bind_param
		  ($sysmainbnum->{system_did}, $system->{system_did});
		$sth->{$primary}->bind_param
		  ($sysmainbnum->{system_pre_rid}, $system->{system_rid});
	  }
	  # ǡɲäξ
	  else {
		# system_uniq 
		$system->{system_uniq} =
		  $self->DBIPgSystem::DB::_calc_system_uniq($record->{table});
	  }

	  # ʣǡ򥫥Ȥ
	  if($hashuniq->{ $system->{system_uniq} }++ > 0) {
		push(@{ $ret->{over} }, $line_mt);
		next;
	  }

	  # system_warning
	  undef $system->{system_warning};
	  if($record->{warning}) {
		foreach my $w (@{ $record->{warning} }) {
		  $system->{system_warning} .=
			"$w->{table}\x1D$w->{print}\x1D$w->{msg}\x0A";
		}
	  }

	  # seq_rid_dft 
	  $rdseqsth->execute;
	  $system->{system_next_rid} = $rdseqsth->fetchrow_array;

	  # ǡ
	  foreach my $dbt (keys %{ $record->{table} }) {
		$subdbtnum = 1;
		foreach my $d (@{ $record->{table}{$dbt} }) {
		  $sthdbt = $sth->{$dbt};
		  $bnum = 1;
		  foreach (@$d) { $sthdbt->bind_param($bnum++, $_); }
		  if($dbt eq $primary) {
			$sthdbt->bind_param
			  ($sysmainbnum->{system_uniq}, $system->{system_uniq});
			$sthdbt->bind_param
			  ($sysmainbnum->{system_next_rid}, $system->{system_next_rid});
			$sthdbt->bind_param
			  ($sysmainbnum->{system_warning}, $system->{system_warning});
			$sthdbt->bind_param($sysmainbnum->{draft_rid}, $draft_rid);
			$sthdbt->bind_param($sysmainbnum->{draft_line}, $line_mt);
		  } else {
			$sthdbt->bind_param
			  ($sysbnum->{$dbt}{system_rid}, $system->{system_next_rid});
			$sthdbt->bind_param($sysbnum->{$dbt}{system_num}, $subdbtnum++);
			$sthdbt->bind_param($sysbnum->{$dbt}{draft_rid}, $draft_rid);
		  }
		  $rc = $sthdbt->execute;
		  if($rc == 0) {
			eval { $dbh->rollback };
			$self->fatal_error("\$rc = 0");
		  }
		}
	  }

	  # ʥ顼åƽ˷ٹν
	  if($record->{warning}) {
		if(@{ $ret->{warning} } < $maxnumerr) {
		  push(@{ $ret->{warning} }, @{ $record->{warning} });
		  $#{ $ret->{warning} } = $maxnumerr - 1
			if(@{ $ret->{warning} } > $maxnumerr);
		}
		$ret->{num}{warning_i} += @{ $record->{warning} };
		$ret->{num}{warning}++;
		$num_warning->{$line_mt} = @{ $record->{warning} };
	  }

	  $self->DBIPgSystem::DB::_commit;
	  $ret->{num}{success}++;
	}
  };
  if($@) {
	my $errstr = "$@ ; " . $dbh->errstr;
	eval { $dbh->rollback };
	$self->fatal_error($errstr);
  }

  # ʣǡå
  my $nouniq_line;
  eval {
	$nouniq_line = $dbh->selectcol_arrayref
	  ("SELECT draft_line FROM \"${primary}_dft\" "
	   . "WHERE draft_rid = '$draft_rid' AND system_uniq = ANY "
	   . "( SELECT system_uniq FROM \"$primary\" "
	   . "WHERE system_uniq IS NOT NULL)");
  };
  if($@) {
	my $errstr = "$@ ; " . $dbh->errstr;
	$self->fatal_error($errstr);
  }
  if(@$nouniq_line) {
	push(@{ $ret->{ignored} }, @$nouniq_line);
	$ret->{num}{success} -= @$nouniq_line;
	my $sth = $dbh->prepare
	  ("DELETE FROM \"${primary}_dft\" WHERE draft_rid = '$draft_rid'"
	   . " AND draft_line = ?");
	my $is_del_warning;
	foreach my $l (@$nouniq_line) {
	  $sth->execute($l);
	  if($num_warning->{$l} > 0) {		# бǡηٹ
		$ret->{num}{warning_i} -= $num_warning->{$l};
		$ret->{num}{warning}--;
		$is_del_warning = 1;
		@{ $ret->{warning} } = grep { $_->{line} ne $l } @{ $ret->{warning} };
	  }
	}
  }

  # Permission (add) å
  my $perm_a = $self->check_permission('add', state => $state);
  my $perm_a_line;
  eval {
	$perm_a_line = $dbh->selectcol_arrayref
	  ("SELECT draft_line FROM \"${primary}_dft\" "
	   . "WHERE draft_rid = '$draft_rid' AND NOT ( $perm_a )");
  };
  if($@) {
	my $errstr = "$@ ; " . $dbh->errstr;
	$self->fatal_error($errstr);
  }
  if(@$perm_a_line) {
	push(@{ $ret->{permission} }, @$perm_a_line);
	$ret->{num}{success} -= @$perm_a_line;
	my $sth = $dbh->do
	  ("DELETE FROM \"${primary}_dft\" WHERE draft_rid = '$draft_rid'"
	   . " AND NOT ( $perm_a )");
	my $is_del_warning;
	foreach my $l (@$perm_a_line) {
	  if($num_warning->{$l} > 0) {		# бǡηٹ
		$ret->{num}{warning_i} -= $num_warning->{$l};
		$ret->{num}{warning}--;
		$is_del_warning = 1;
		@{ $ret->{warning} } = grep { $_->{line} ne $l } @{ $ret->{warning} };
	  }
	}
  }

  my $rn = $ret->{num};
  $rn->{over} = @{ $ret->{over} };
  $rn->{ignored} = @{ $ret->{ignored} };
  $rn->{invalid} = @{ $ret->{invalid} };
  $rn->{permission} = @{ $ret->{permission} };
  $rn->{total} = $rn->{success} + $rn->{error} + $rn->{over} + $rn->{ignored}
	+ $rn->{noactive} + $rn->{invalid} + $rn->{permission};

  return $ret;
}

=item file_insert ( DRAFT_RID, ADDR, REVISE [,OPTION] )

  $ret = $dbi->file_insert($draft_rid, $addr, $revise, %opt);

    ARGS :
      $draft_rid => NUM        # draft_rid
      $addr => STRING          # ADDR
      $revise => BOOLEAN       # true ʤХǡν

    OPTION :
      report => BOOLEAN        # вϤ

    RET : HASHREF
      ignored => ARRAYREF      # ʣΤ̵ˤʤäǡΰ
      invalid => ARRAYREF      # 齤Τäǡΰ
                               # ($dbi->file_check  $line)
      permission => ARRAYREF   # ʤäǡΰ
      where_all => STRING      # ǡ򸡺뤿WHERE
      num =>
        ignored => NUM         # scalar @{ $ret->{ignored} } Ʊ
        invalid => NUM         # scalar @{ $ret->{invalid} } Ʊ
        permission => NUM      # scalar @{ $ret->{permission} } Ʊ
        success => NUM         # 嵭ʳΥǡǡˤη

file_check ᥽åɤˤä draftѤΥơ֥줿ǡ
ܥơ֥롣
θ塢draftѤбǡõ롣
ޤ줿ǡ򸡺뤿 WHERE롣

ǡνξϡǡƱ DID ǡ
֤ wait  active Υǡ̵ˤ롣

=cut

sub file_insert {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $draft_rid, $addr, $revise, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 4);
  $self->fatal_error("\$draft_rid is invalid: $draft_rid")
	unless($draft_rid =~ m/^\d+$/);
  $self->print_error('permission-title', 'permission')
	unless($self->{userinfo}{staff} and $self->{global}{enable_file_insert});

  my $ret = { num => { success => 0, ignored => 0, invalid => 0,
					   permission => 0 },
			  ignored => [ ], invalid => [ ], permission => [ ],
			  where_all => undef };

  $self->_init_export_html_detail();
  my $is_export = $self->{___export_html_detail}{is_export};

  # եåν
  my $dbh = $self->{dbh};
  my $primary = $self->{global}{primary};
  my $sysstate = $self->{db}{sysstate};
  my $fetchsth = $dbh->prepare
	("SELECT * FROM \"${primary}_dft\" WHERE draft_rid = '$draft_rid' "
	 . "ORDER BY system_rid, draft_line");
  $fetchsth->execute;
  my $ridsth = $dbh->prepare("SELECT nextval('seq_rid')");
  my $didsth = $dbh->prepare("SELECT nextval('seq_did')");
  my $ststh = $dbh->prepare
	("SELECT system_state FROM \"$primary\" WHERE system_rid = ?");

  # INSERT/UPDATEʸν
  my ($inssth, $upsth);
  # ơ֥ܥơ֥ؤ
  $inssth->{$primary} = $dbh->prepare
	("INSERT INTO \"$primary\" VALUES ( "
	 . "?, " x ($self->{dbnum}{$primary}{user_search}
				+ $#{ $self->{db}{syscol} }) . "? )");
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	next if($dbt eq $primary);
	my ($user_list, $search_list, $sys_list) = ([ ], [ ], [ ]);
	foreach my $dbcol (@{ $self->{dbcol}{$dbt} }) {
	  push(@$user_list, "\"$dbcol->{name}\"");
	  push(@$search_list, "\"$dbcol->{name}$self->{sys}{search_ext}\"")
		if($dbcol->{search});
	}
	foreach my $subsyscol (@{ $self->{db}{subsyscol} }) {
	  push(@$sys_list, "\"$subsyscol->{name}\"");
	}
	# Ϣơ֥ draftѥơ֥ι
	$upsth->{$dbt} = $dbh->prepare
	  ("UPDATE \"${dbt}_dft\" SET system_rid = ? "
	   . "WHERE draft_rid = " . $dbh->quote($draft_rid)
	   . " AND system_rid = ?");
	# Ϣơ֥ܥơ֥ؤ
	$inssth->{$dbt} = $dbh->prepare
	  ("INSERT INTO \"$dbt\" SELECT "
	   . join(',', @$user_list, @$search_list, @$sys_list)
	   . " FROM \"${dbt}_dft\" "
	   . "WHERE draft_rid = " . $dbh->quote($draft_rid)
	   . " AND system_rid = ?");
  }

  my $mn = $self->{dbnum}{$primary}{user_search};
  my $didnum = $mn + $self->{db}{sysseq}{system_did}{num};
  my $ridnum = $mn + $self->{db}{sysseq}{system_rid}{num};
  my $statenum = $mn + $self->{db}{sysseq}{system_state}{num};
  my $nextridnum = $mn + $self->{db}{sysseq}{system_next_rid}{num};
  my $datenum = $mn + $self->{db}{sysseq}{system_date}{num};

  $| = 1 if($opt{report});
  my ($data, $rid, $did, $line, $firstrid, $st, $relrid, $state);
  my ($numsuccess, $datanum) = (0, 0);

  my $reldbt = [ grep { $_ ne $primary; } keys %{ $self->{dbcol} } ];

  # ǡ1쥳ɤܥơ֥
 INSERT: {
	eval {
	  while($data = $fetchsth->fetchrow_arrayref) {
		$datanum++;
		print "$datanum " if($opt{report} and $datanum % 100 == 0);
		($line, $state) = ($data->[-1], $data->[$statenum]);

		# ǡν
		if($revise) {
		  $rid = $data->[$ridnum];
		  # ֤ active ɤǧ
		  eval { $ststh->execute($rid);
				 $st = $ststh->fetchrow_array; };
		  $self->fatal_error("$@ ; " . $dbh->errstr) if($@);
		  if($st ne $sysstate->{active}) {
			push(@{ $ret->{invalid} }, $line);
			next;
		  }

		  # DID ΰפǡ̵ˤ
		  if($state eq $sysstate->{active}) {
			unless($self->DBIPgSystem::DB::_update_invalid
				   ("system_did = $data->[$didnum]", $rid)) {
			  push(@{ $ret->{permission} }, $line);
			  next;
			}
		  }
		}
		# ǡɲ
		else {
		  # system_did 
		  $didsth->execute;
		  $data->[$didnum] = $did = $didsth->fetchrow_array;
		}

		# system_rid 
		$ridsth->execute;
		$rid = $ridsth->fetchrow_array;

		# ƥνʤ
		$firstrid = $rid unless(defined $firstrid);
		($relrid, $data->[$ridnum], $data->[$nextridnum], $data->[$datenum]) =
		  ($data->[$nextridnum], $rid, undef, 'NOW');

		# ơ֥ؤΥǡ
		$inssth->{$primary}->execute(@$data[0 .. $#$data - 2])
		  or die "inssth ($primary)";

		# Ϣơ֥ؤΥǡ
		foreach my $dbt (@$reldbt) {
		  $upsth->{$dbt}->execute($rid, $relrid) or die "upsth ($dbt)";
		  $inssth->{$dbt}->execute($rid) or die "inssth ($dbt)";
		}
		$dbh->commit;
		$self->DBIPgSystem::DB::_export_html_detail($rid)
		  if($is_export and $state eq $sysstate->{active});
		$numsuccess++;
	  }
	};
	if($@) {
	  my $errstr = "$@ ; " . $dbh->errstr;
	  eval { $dbh->rollback };
	  # 顼θǡνʣʳʤ fatal error
	  $self->fatal_error($errstr)
		if($errstr !~ m/unique index/i);
	  $ret->{num}{ignored}++;
	  push(@{ $ret->{ignored} }, $line);
	  redo INSERT;
	}
  }

  my $lastrid = $rid;
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$self->do("DELETE FROM \"${dbt}_dft\" WHERE draft_rid = '$draft_rid'");
  }

  $ret->{num}{ignored} = @{ $ret->{ignored} };
  $ret->{num}{invalid} = @{ $ret->{invalid} };
  $ret->{num}{permission} = @{ $ret->{permission} };
  $ret->{num}{success} = $numsuccess;
  $ret->{where_all} = "system_rid >= $firstrid AND system_rid <= $lastrid "
	. "AND system_addr = $addr";
  return $ret;
}

=item setincode ( CODE_DIST )

  $dbi->setincode($code_dist);

ʸɤȽ̤Ԥ
$code_dist ǡե $self->{global}{code} ΥӤ
פ륭ĤСΥбͤ
ϤʸɤȤ$self->{global}{code} ˡ
פ륭ĤʤХ顼Ф
$self->{global}{code}{''} ͤꤹС
$code_dist ͤʤΥǥեͤˤʤ롣
$self->{global}{code} ϥåؤΥե󥹤Ǥʤʸξϡ
ͤϤʸɤȤ롣

=cut

sub setincode {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $code_dist) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  $self->{sys}{incode} = ref($self->{global}{code}) eq 'HASH' ?
	$self->{global}{code}{$code_dist} : $self->{global}{code};
  $self->print_error('incode-title', 'incode')
	if($self->{sys}{incode} eq '');
}

=item insert_userinfo ( UID )

  $dbi->insert_userinfo($uid);

    ARGS :
      $uid => NUM              # UID

桼 sys_userinfo 롣
system_uid ˤϻꤵ줿 UID 
¾Υˤ $self->{global}{userinfo}{init} ͤ롣

=cut

sub insert_userinfo {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $uid) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  my $dbh = $self->{dbh};

  my ($key, $val);
  my ($names, $vals) = ([ 'system_uid' ], [ $uid ]);
  while(($key, $val) = each %{ $self->{global}{userinfo}{init} }) {
	push(@$names, $key);
	push(@$vals, $val);
  }
  eval {
	my $sth = $dbh->prepare
	  (join('', "INSERT INTO \"sys_userinfo\" ( ", join(', ', @$names),
			" ) VALUES ( ", "?, " x $#$vals, "? )"));
	$sth->execute(@$vals);
	$self->DBIPgSystem::DB::_commit;
  };
  $self->fatal_error("$@ ; " . $self->{dbh}->errstr) if($@);
}

=item get_colpage ( )

  $hashref = $dbi->get_colpage();

    RET : HASHREF

ǡβ̤ǡƥबڡܤϤ¥뤫Ĵ١
ϥå˳Ǽ롣

=cut

sub get_colpage {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self) = @_;

  return undef if($self->{template}{numpage_insert} == 1);
  open(NULL, "> /dev/null") or
	$self->fatal_error("Cannot open '/dev/null'");
  my $cpage;
  my ($html, $column, $p);
  my $primary = $self->{global}{primary};
  my $dbmain = $self->{dbseq}{$primary};
  foreach my $page (1 .. $self->{template}{numpage_insert}) {
	$column = [ ];
	$html = $self->get_template_insert($page);
	eval { $self->print_template
			 ($html, { }, fh => \*NULL, noheader => 1, noexit => 1,
			  column => $column) };
	$self->fatal_error("'$html' is invalid: $@") if($@);

	foreach my $name (@$column) {
	  $p = ($name =~ s/^!//) ? 0 : $page;
	  if($name =~ s/^://) {
		$self->fatal_error("':$name' is invalid (page: $page)")
		  unless(exists $dbmain->{$name});
		$cpage->{$primary}{$name} = $p;
	  } else {
		$self->fatal_error("'$name' is invalid (page: $page)")
		  unless(exists $self->{dbseq}{$name});
		foreach my $key (keys %{ $self->{dbseq}{$name} }) {
		  $cpage->{$name}{$key} = $p;
		}
	  }
	}
  }
  close(NULL);
  return $cpage;
}

=item check_permission ( KIND [,OPTION] )

  $where_clause = $dbi->check_permission($type, %opt);

    ARGS :
      $type => STRING          # åμ

    OPTION :
      uid => NUM               # system_uid
      state => NUM             # system_state פΤߤоݤˤ

    RET :
      STRING                   # WHERE
      BOOLEAN                  # true ʤХ

ǡ˥Ǥ뤫ɤĴ٤롣
$type ͤˤäơͤΰ̣ۤʤ뤬
ʤߤΤ WHERE֤ޤϥ̵֤ͭ

=cut

sub check_permission {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $type, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  my $ui = $self->{userinfo};
  my $uid = $ui->{uid};
  my $sysstate = $self->{db}{sysstate};

  unless($self->{subs}{make_clause}) {
	$self->{subs}{make_clause} = sub {
	  my ($qr, $qru, $state, $add) = @_;

	  my $wh_uid = defined($uid) ?
		"system_uid = '$uid' OR system_rev_uid = '$uid'" : undef;
	  my $wh_active = "system_state = '$sysstate->{active}'";
	  my $wh_wait = "system_state = '$sysstate->{wait}'";
	  my $wh_invalid = "system_state = '$sysstate->{invalid}'";

	  my $st = [ ];
	  if($state eq $sysstate->{active} or not defined($state)) {
		if($ui->{state_active} =~ m/$qr/) { push(@$st, $wh_active); }
		elsif(defined($uid) and $ui->{state_active} =~ m/$qru/) {
		  push(@$st, "$wh_active AND $wh_uid"); }
	  }
	  if($state eq $sysstate->{wait} or not defined($state)) {
		if($ui->{state_wait} =~ m/$qr/) { push(@$st, $wh_wait); }
		elsif(defined($uid) and $ui->{state_wait} =~ m/$qru/) {
		  push(@$st, "$wh_wait AND $wh_uid"); }
	  }
	  if($state eq $sysstate->{invalid} or not defined($state)) {
		if($ui->{state_invalid} =~ m/$qr/) { push(@$st, $wh_invalid); }
		elsif(defined($uid) and $ui->{state_invalid} =~ m/$qru/) {
		  push(@$st, "$wh_invalid AND $wh_uid"); }
	  }
	  return @$st ? '( ' . join(' OR ', @$st) . ' )' : "'false'";
	};
  }

  my $and;
  if($type eq 'read') {
	$and = &{ $self->{subs}{make_clause} }(qr{R}, qr{r}, $opt{state});
	$and .= " AND ( $ui->{read} )" if($ui->{read} ne '');
  } elsif($type eq 'detail') {
	$and = &{ $self->{subs}{make_clause} }(qr{R}, qr{r}, $opt{state});
	$and .= " AND ( $ui->{read} )" if($ui->{read} ne '');
	$and .= " AND ( $ui->{detail} )" if($ui->{detail} ne '');
  } elsif($type eq 'tofile') {
	$and = &{ $self->{subs}{make_clause} }(qr{R}, qr{r}, $opt{state});
	$and .= " AND ( $ui->{read} )" if($ui->{read} ne '');
	$and .= " AND ( $ui->{detail} )" if($ui->{detail} ne '');
	$and .= " AND ( $ui->{tofile} )" if($ui->{tofile} ne '');
  } elsif($type eq 'start_insert') {
	return undef if($ui->{state_active} =~ m/a/ or $ui->{state_wait} =~ m/a/);
  } elsif($type eq 'add') {
	$and = &{ $self->{subs}{make_clause} }(qr{A}, qr{a}, $opt{state}, 1);
	$and .= " AND ( $ui->{add} )" if($ui->{add} ne '');
  } elsif($type eq 'delete') {
	$and = &{ $self->{subs}{make_clause} }(qr{D}, qr{d}, $opt{state});
	$and .= " AND ( $ui->{delete} )" if($ui->{delete} ne '');
  } elsif($type eq 'is_revise') {
	return undef if($ui->{state_active} =~ m/A/i
					and $ui->{state_active} =~ m/D/
					and $ui->{state_wait} =~ m/D/);
	return undef if($ui->{state_wait} =~ m/A/i and $ui->{state_wait} =~ m/D/);
	return undef if($opt{uid} eq $uid and $ui->{state_wait} =~ m/a/ and
					$ui->{state_wait} =~ m/d/);
	$self->print_error('permission-title', 'permission');
  } else {
	$self->fatal_error("'type' is invalid: $type") if($@);
  }
  return $and;
}

=item selectcmd ( EXPRESSION [,SQL] )

  $cmd = $dbi->selectcmd($expr, %sql);

    ARGS :
      $expr => STRING          # ơ֥̾
      %sql => HASH
        where => STRING        # WHEREɬܡ
        from => STRING         # FROMʶʸʤмơ֥
        where_and => STRING    # WHEREAND³ʸ
        join => STRING         # JOIN
        order => STRING        # ORDER BY
        limit => STRING        # LIMIT

    RET : STRING               # SELECTʸ

SQLSELECTʸ롣
$expr ˽ؿ order  limit ̵뤹롣
ޤޥɤʸ ';' ǽλƤʤȤǧ롣

=cut

sub selectcmd {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $expr, %sql) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);
  $self->fatal_error("\$sql{where} must not be null string")
	if($sql{where} eq '');

  my $aggregate = ($expr =~ m/COUNT\([^)]*\)/i) ? 1 : 0;
  my $cmd = [ ];
  $sql{from} = $self->{global}{primary} if($sql{from} eq '');
  $sql{where} = "( $sql{where} ) AND ( $sql{where_and} )" if($sql{where_and});

  push(@$cmd, "SELECT $expr", "FROM \"$sql{from}\"");
  push(@$cmd, $sql{join}) if($sql{join} ne '');
  push(@$cmd, "WHERE $sql{where}");
  push(@$cmd, "ORDER BY $sql{order}") if($sql{order} ne '' and not $aggregate);
  push(@$cmd, "LIMIT $sql{limit}") if($sql{limit} ne '' and not $aggregate);
  my $select = join(' ', @$cmd);

  # ޥɤʸ ';' ǽλƤ fatal_error
  $self->fatal_error("select command", selectcmd => $select)
	if($select =~ m/;/ and
	   $select =~ m/^([^"';]|"[^"]*"|'([^\\']|\\.|'')*'[^';])*;/);

  return $select;
}

=back

=head2 TEST METHODS

=over 4

=item test_errcode ( )

  $dbi->test_errcode();

$errcode ˻ꤵ줿顼ɤ
顼åեƤ뤳Ȥǧ롣

=cut

sub test_errcode {
  &dbdebug('sub', @_) if($DEBUG);
  my $self = shift;
  my $errcode =
	[ 'fatal', 'fatal_nomail',							# Fatal error
	  'infilter-title', 'infilter_invalid',				# ǡΥå
	  'invalid_code', 'incode-title', 'incode',
	  'upload',
	  'insert_unique', 'insert_permission',				# ǡ
	  'col_code', 'col_null', 'col_format',				# ƥΥå
	  'file-title', 'file_invalid', 'file_col',			# ե뤫
	  'file_revise', 'file_upload',
	  'remove-title', 'remove',							# ǡκ
	  'remove_total-title', 'remove_total',
	  'nulldata-title', 'nulldata',						# ܺٸ
	  'permission-title', 'permission',
	];
  foreach my $c (@$errcode) { $self->get_errmsg($c); }
}

=item test_conf ( )

  $dbi->test_conf();

ɤ߹ǡե뤬ɤǧ롣

=cut

sub test_conf {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;
  my $groups = [ ];
  my ($tmp, $tmplatedir);

  # userinfo Υ̾
  $self->DBIPgSystem::DB::_init_userinfo();
  my $col_userinfo = { };
  foreach my $col (@{ $self->{col_userinfo} }) {
	$col_userinfo->{ $col->{name} } = 1;
  }

  # ***** $self->{debug} Υå *****
  # check_conf
  &{ $self->{debug}{check_conf} } if($self->{debug}{check_conf});
  # maintenance_except_addr
  eval { "" =~ m/$self->{debug}{maintenance_except_addr}/ };
  die "\$self->{debug}{maintenance_except_addr} is invalid: $@" if($@);

  # ***** $self->{global} Υå *****
  # ----- Ū -----
  # primary
  die "\$self->{global}{primary} must be defined"
	unless(defined $self->{global}{primary});
  die "\$self->{global}{primary} is invalid"
	unless(exists $self->{dbcol}{ $self->{global}{primary} });
  # basedir
  die "\$self->{global}{basedir} must be defined"
	unless(defined $self->{global}{basedir});
  die "\$self->{global}{basedir} must end without a slash"
	if($self->{global}{basedir} =~ m!/$!);
  die "\$self->{global}{basedir} must represent a absolute pathname"
	if($self->{global}{basedir} !~ m!^/!);
  die "Directory $self->{global}{basedir} doesn't exist"
	unless(-d $self->{global}{basedir});
  # tmpdir
  die "\$self->{global}{tmpdir} must be defined"
	unless(defined $self->{global}{tmpdir});
  die "\$self->{global}{tmpdir} must end without a slash"
	if($self->{global}{tmpdir} =~ m!/$!);
  die "\$self->{global}{tmpdir} must represent a relative pathname"
	if($self->{global}{tmpdir} =~ m!^/!);
  $tmp = "$self->{global}{basedir}/$self->{global}{tmpdir}";
  die "Directory $tmp doesn't exist" unless(-d $tmp);
  open(OUT, ">> $tmp/test.tmp") or die "Cannot open '$tmp/test.tmp': $!";
  close(OUT);
  unlink("$tmp/test.tmp") or die "Cannot remove '$tmp/test.tmp': $!";
  # errcode_file
  die "\$self->{global}{errcode_file} must be defined"
	unless(defined $self->{global}{errcode_file});
  $tmp = "$self->{global}{basedir}/$self->{global}{errcode_file}";
  die "File $tmp cannot read" unless(-r $tmp);
  # groups
  die "\$self->{global}{groups} must be defined"
	unless(defined $self->{global}{groups});
  die "\$self->{global}{groups} is invalid"
	if(ref($self->{global}{groups}) ne 'HASH');
  foreach my $key (keys %{ $self->{global}{groups} }) {
	push(@$groups, $key) if($self->{global}{groups}{$key});
  }
  die "No groups found" unless(@$groups);
  # staff
  die "\$self->{global}{staff} must be defined"
	unless(defined $self->{global}{staff});
  die "\$self->{global}{staff} is invalid"
	if(ref($self->{global}{staff}) ne 'HASH');
  # baseuri
  die "\$self->{global}{baseuri} must be defined"
	unless(defined $self->{global}{baseuri});
  die "\$self->{global}{baseuri} is invalid"
	if(ref($self->{global}{baseuri}) ne 'HASH');
  foreach my $group (@$groups) {
	die "\$self->{global}{baseuri}{$group} must be defined"
	  unless(defined $self->{global}{baseuri}{$group});
  }

  # ----- ʸɤ -----
  # html_charset
  die "\$self->{global}{html_charset} must be defined"
	unless(defined $self->{global}{html_charset});
  if(ref($self->{global}{html_charset}) eq 'HASH') {
	foreach my $group (@$groups) {
	  $tmp = $self->{global}{html_charset}{$group};
	  next if(exists($self->{global}{html_charset}{$group}) and
			  not defined($tmp));
	  die "\$self->{global}{html_charset}{$group} is invalid"
		if($tmp !~ m/^(US-ASCII|ISO-8859-1|ISO-2022-JP|Shift_JIS|EUC-JP|
                     x-sjis|x-euc)$/x);
	}
  } else {
	die "\$self->{global}{html_charset} is invalid"
	  if($self->{global}{html_charset} !~
		 m/^(US-ASCII|ISO-8859-1|ISO-2022-JP|Shift_JIS|EUC-JP|x-sjis|x-euc)$/);
  }

  # code_dist
  die "\$self->{global}{code_dist} must be defined"
	unless(defined $self->{global}{code_dist});
  # code
  die "\$self->{global}{code} must be defined"
	unless(defined $self->{global}{code});
  die "\$self->{global}{code} is invalid"
	if(ref($self->{global}{code}) ne '' and
	   ref($self->{global}{code}) ne 'HASH');
  # code_invalid
  $tmp = $self->{global}{code_invalid};
  die "\$self->{global}{code_invalid} must be defined" unless(defined $tmp);
  die "\$self->{global}{code_invalid} is invalid"
	if($tmp =~ m/[\x00-\x09\x0B-\x1F\x7F\x80-\x8D\x90-\xA0\xFF]/ or
	   $tmp =~ m/^((?:[\x00-\x7E]|[\xA1-\xA8\xB0-\xF4][\xA1-\xFE])*)
            (\x8F[\xA1-\xFE][\xA1-\xFE]|[\xA9-\xAF\xF5-\xFE][\xA1-\xFE])/x);

  # ----- ᡼˴ؤ -----
  # sendmail
  die "\$self->{global}{sendmail} must be defined"
	if(not $self->{debug}{no_mail} and not defined($self->{global}{sendmail}));
  die "\$self->{global}{sendmail} must represent a absolute pathname"
	if($self->{global}{sendmail} !~ m!^/!);
  die "$self->{global}{sendmail} doesn't exist"
	unless(-e $self->{global}{sendmail});
  # mailfrom
  $tmp = $self->{global}{mailfrom};
  die "\$self->{global}{mailfrom} must be defined" unless(defined $tmp);
  die "\$self->{global}{mailfrom} is invalid" if(ref($tmp) ne '');
  # mailto
  die "\$self->{global}{mailto} must be defined"
	unless(defined $self->{global}{mailto});
  # mail_charset
  die "\$self->{global}{mail_charset} is invalid"
	if(defined($self->{global}{mail_charset}) and
	   $self->{global}{mail_charset} !~ m/^(US-ASCII|ISO-2022-JP)$/);

  # ----- db: ǡ١ -----
  # data_source
  die "\$self->{global}{db}{data_source} must be defined"
	unless(defined $self->{global}{db}{data_source});
  # username
  die "\$self->{global}{db}{username} must be defined"
	unless(defined $self->{global}{db}{username});
  # passwd
  die "\$self->{global}{db}{passwd} must be defined"
	unless(defined $self->{global}{db}{passwd});

  # ----- userinfo: 桼 -----
  if($self->{global}{userinfo}) {
	#join
	# col_user
	die "\$self->{global}{userinfo}{col_user} must be defined"
	  unless(defined $self->{global}{userinfo}{col_user});
	# col_email
	die "\$self->{global}{userinfo}{col_email} must be defined"
	  unless(defined $self->{global}{userinfo}{col_email});
	# init
	die "\$self->{global}{userinfo}{init} is invalid"
	  if(ref($self->{global}{userinfo}{init}) ne 'HASH');
	foreach my $key (keys %{ $self->{global}{userinfo}{init} }) {
	  die "\$self->{global}{userinfo}{init}{$key} is invalid"
		unless($col_userinfo->{$key});
	}
  }
  # userinfo_default
  die "\$self->{global}{userinfo_default} is invalid"
	if(defined($self->{global}{userinfo_default})
	   and ref($self->{global}{userinfo_default}) ne 'HASH');

  # ----- ܺɽβ̤ν񤭽Ф˴ؤ -----
  # export
  die "\$self->{global}{exporto} must be defined"
	unless(defined $self->{global}{export});
  die "\$self->{global}{export} is invalid"
	if(ref($self->{global}{export}) ne 'HASH');
  foreach my $group (keys %{ $self->{global}{export} }) {
	next unless($self->{global}{export}{$group});
	# export_file
	die "\$self->{global}{export_file}{$group} must be defined"
	  unless(defined $self->{global}{export_file}{$group});
	($tmp = $self->{global}{export_file}{$group}) =~ s!/[^/]+$!!
	  or die "\$self->{global}{export_file}{$group} is invalid";
	die "\$self->{global}{export_file}{$group} must represent "
	  . "a absolute pathname"
		if($self->{global}{export_file}{$group} !~ m!^/!);
	warn "\$self->{global}{export_file}{$group} is invalid" unless(-d $tmp);
	# export_uri
	die "\$self->{global}{export_uri}{$group} must be defined"
	  unless(defined $self->{global}{export_uri}{$group});
  }

  # ----- եफΥǡ˴ؤ -----
  # insert_mail
  die "\$self->{global}{insert_mail} is invalid"
	if(defined $self->{global}{insert_mail} and
	   ref($self->{global}{insert_mail}) ne 'CODE');

  # ----- ե뤫Υǡ˴ؤ -----
  # enable_file_insert
  if($self->{global}{enable_file_insert}) {
	# file_maxnumerr
	die "\$self->{global}{file_maxnumerr} is invalid"
	  if($self->{global}{file_maxnumerr} !~ m/^\d+$/);
  }

  # ----- ¾λ¿ -----
  # searchnum
  die "\$self->{global}{searchnum} is invalid"
	if(defined($self->{global}{searchnum})
	   and $self->{global}{searchnum} !~ m/^\d+$/);
  # session_time_limit

  # filetype ΥåϸǹԤ

  # ***** $self->{template} Υå *****
  # dir
  die "\$self->{template}{dir} must be defined"
	unless(defined $self->{template}{dir});
  die "\$self->{template}{dir} is invalid"
	if(ref($self->{template}{dir}) ne 'HASH');
  foreach my $group (@$groups) {
	die "\$self->{template}{dir}{$group} must be defined"
	  unless(defined $self->{template}{dir}{$group});
	die "\$self->{template}{dir}{$group} must represent a relative pathname"
	  if($self->{template}{dir}{$group} =~ m!^/!);
	die "\$self->{template}{dir}{$group} must end without a slash"
	  if($self->{template}{dir}{$group} =~ m!/$!);
  }
  $tmplatedir = "$self->{global}{basedir}/"
	. "$self->{template}{dir}{ $self->{userinfo}{group} }";
  die "Directory $tmplatedir doesn't exist" unless(-d $tmplatedir);
  my $ext = $self->{template}{decoded} ? '.pl' : '.html';
  # fatalerror
  die "\$self->{template}{fatalerror} must be defined"
	unless(defined $self->{template}{fatalerror});
  die "File $tmplatedir/$self->{template}{fatalerror}$ext doesn't exist"
	unless(-f "$tmplatedir/$self->{template}{fatalerror}$ext");
  # error
  die "\$self->{template}{error} must be defined"
	unless(defined $self->{template}{error});
  die "File $tmplatedir/$self->{template}{error}$ext doesn't exist"
	unless(-f "$tmplatedir/$self->{template}{error}$ext");
  # maintenance
  die "\$self->{template}{maintenance} must be defined"
	unless(defined $self->{template}{maintenance});
  die "File $tmplatedir/$self->{template}{maintenance}$ext doesn't exist"
	unless(-f "$tmplatedir/$self->{template}{maintenance}$ext");
  # search
  die "\$self->{template}{search} must exist"
	unless(exists $self->{template}{search});
  if(defined $self->{template}{search}) {
	die "\$self->{template}{search} is invalid"
	  if(ref($self->{template}{search}) ne 'HASH');
	die "\$self->{template}{search}{default} must be defined"
	  unless(defined $self->{template}{search}{default});
	foreach my $key (keys %{ $self->{template}{search} }) {
	  my $exist = 0;
	  foreach my $group (@$groups) {
		if(-f "$self->{global}{basedir}/$self->{template}{dir}{$group}/"
		   . "$self->{template}{search}{$key}$ext") { $exist = 1; last; }
	  }
	  die "\$self->{template}{search}{$key} is invalid" unless($exist);
	}
  }
  # numpage_detail
  die "\$self->{template}{numpage_detail} must be defined"
	unless(defined $self->{template}{numpage_detail});
  die "\$self->{template}{numpage_detail} is invalid"
	if(ref($self->{template}{numpage_detail}) ne 'HASH');
  # detail
  die "\$self->{template}{detail} must exist"
	unless(exists $self->{template}{detail});
  foreach my $group (@$groups) {
	die "\$self->{template}{numpage_detail}{$group} is invalid"
	  if($self->{template}{numpage_detail}{$group} !~ m/^\d+$/);
	foreach my $page (1 .. $self->{template}{numpage_detail}{$group}) {
	  $tmp = "$self->{global}{basedir}/$self->{template}{dir}{$group}/"
		. $self->get_template_detail($page, $group) . $ext;
	  die "File $tmp doesn't exist" unless(-f $tmp);
	}
  }
  # detail_other
  if(defined $self->{template}{detail_other}) {
	die "\$self->{template}{detail_other} is invalid"
	  if(ref($self->{template}{detail_other}) ne 'HASH');
	foreach my $key (keys %{ $self->{template}{detail_other} }) {
	  my $exist = 0;
	  foreach my $group (@$groups) {
		$tmp = "$self->{global}{basedir}/$self->{template}{dir}{$group}/"
			. "$self->{template}{detail_other}{$key}$ext";
		if(-f $tmp) { $exist = 1; last; }
	  }
	  die "\$self->{template}{detail_other}{$key} is invalid" unless($exist);
	}
  }
  # numpage_insert
  die "\$self->{template}{numpage_insert} must be defined"
	unless(defined $self->{template}{numpage_insert});
  die "\$self->{template}{numpage_insert} is invalid"
	if($self->{template}{numpage_insert} !~ m/^\d+$/);
  if($self->{template}{numpage_insert} > 0) {
	# insert
	die "\$self->{template}{insert} must be defined"
	  unless(defined $self->{template}{insert});
	foreach my $page (1 .. $self->{template}{numpage_insert}) {
	  $tmp = "$tmplatedir/" . $self->get_template_insert($page) . $ext;
	  die "File $tmp doesn't exist" unless(-f $tmp);
	}
	# insert_verify
	die "\$self->{template}{insert_verify} must be defined"
	  unless(defined $self->{template}{insert_verify});
	die "File $tmplatedir/$self->{template}{insert_verify}$ext doesn't exist"
	  unless(-f "$tmplatedir/$self->{template}{insert_verify}$ext");
	# insert_success
	die "\$self->{template}{insert_success} must be defined"
	  unless(defined $self->{template}{insert_success});
	die "File $tmplatedir/$self->{template}{insert_success}$ext doesn't exist"
	  unless(-f "$tmplatedir/$self->{template}{insert_success}$ext");
  }
  # remove
  die "\$self->{template}{detail} must exist"
	unless(exists $self->{template}{remove});
  if($self->{userinfo}{staff}) {
	if(defined $self->{template}{remove}) {
	  die "\$self->{template}{remove} is invalid"
		if(ref($self->{template}{remove}) ne 'HASH');
	  foreach my $key (keys %{ $self->{template}{remove} }) {
		die "File $tmplatedir/$self->{template}{remove}{$key}$ext "
		  . "doesn't exist"
			unless(-f "$tmplatedir/$self->{template}{remove}{$key}$ext");
	  }
	}
  }
  # file_head, file_verify, file_success, file_cancel
  if($self->{userinfo}{staff} and $self->{global}{enable_file_insert}) {
	foreach my $key ('file_head', 'file_verify', 'file_success',
					 'file_cancel') {
	  die "File $tmplatedir/$self->{template}{$key}$ext doesn't exist"
		unless(-f "$tmplatedir/$self->{template}{$key}$ext");
	}
  }

  # ***** $self->{log} Υå *****
  # basefile
  die "\$self->{log}{basefile} must be defined"
	unless(defined $self->{log}{basefile});
  # Fatal
  die "\$self->{log}{Fatal} must be defined"
	unless(defined $self->{log}{Fatal});
  open(OUT, ">> $self->{global}{basedir}/$self->{log}{Fatal}")
	or warn "Cannot open '$self->{global}{basedir}/$self->{log}{Fatal}'";
  close(OUT);

  # ¾
  foreach my $k (keys %{ $self->{log} }) {
	$tmp = $self->{log}{$k};
	die "\$self->{log}{$k} must represent a relative pathname"
	  if($tmp =~ m!^/!);
	$tmp = "$self->{global}{basedir}/$tmp";
	$tmp =~ s!/[^/]+$!! or next;
	warn "\$self->{log}{$k}: directory $tmp doesn't exist"
	  unless(-d $tmp);
  }

  # ***** $self->{debug}{ckeck_conf} *****
  die "\$self->{debug}{check_conf} is invalid"
	if(defined($self->{debug}{check_conf}) and
	   ref($self->{debug}{check_conf}) ne 'CODE');

  # ***** $self->{__infilter}{hook} *****
  die "'\$self->{__infilter}{hook}' is invalid"
	if(defined($self->{__infilter}{hook})
	   and ref($self->{__infilter}{hook}) ne 'CODE');

  # ***** $self->{__search_detail}{hook_revise} *****
  die "'\$self->{__search_detail}{hook_revise}' is invalid"
	if(defined($self->{__search_detail}{hook_revise})
	   and ref($self->{__search_detail}{hook_revise}) ne 'CODE');

  # ***** $self->{deny}{*} *****
  die "'\$self->{deny}{data_verify_check}' is invalid"
	if(defined($self->{deny}{data_verify_check})
	   and ref($self->{deny}{data_verify_check}) ne 'CODE');
  die "'\$self->{deny}{data_insert}' is invalid"
	if(defined($self->{deny}{data_insert})
	   and ref($self->{deny}{data_insert}) ne 'CODE');

  # ***** $self->{db}{sql_*} *****
  die "'\$self->{db}{sql_join}' is invalid"
	if(defined($self->{db}{sql_join})
	   and ref($self->{db}{sql_join}) ne 'HASH');

  # ***** $self->{db}{sql_cols} *****
  die "\$self->{db}{sql_cols} must be defined"
	unless(defined $self->{db}{sql_cols});
  die "'\$self->{db}{sql_cols}' is invalid"
	if(ref($self->{db}{sql_cols}) ne 'HASH');
  die "'\$self->{db}{sql_cols}{default}' must be defined"
	unless(defined $self->{db}{sql_cols}{default});

  # ***** $self->{db}{sql_default_order} *****
  die "\$self->{db}{sql_default_order} must be defined"
	unless(defined $self->{db}{sql_default_order});

  # ***** $self->{db}{alias} *****
  die "'\$self->{db}{alias}' is invalid"
	if(defined($self->{db}{alias}) and ref($self->{db}{alias}) ne 'HASH');
  if(defined $self->{db}{alias}) {
	foreach my $dbt (keys %{ $self->{db}{alias} }) {
	  foreach my $key (keys %{ $self->{db}{alias}{$dbt} }) {
		die "\$self->{dbseq}{$dbt}{$key} doesn't exist"
		  unless(exists $self->{dbseq}{$dbt}{$key});
	  }
	}
  }

  # ***** $self->{code} *****
  die "'\$self->{code}' is invalid"
	if(defined($self->{code}) and ref($self->{code}) ne 'HASH');
  die "'\$self->{code}' is invalid" if(exists $self->{code}{''});
  foreach my $key (keys %{ $self->{code} }) {
	die "'\$self->{code}{$key}' is invalid"
	  if(ref($self->{code}{$key}) ne 'HASH');
  }

  # ***** ƥΥå *****
  # prefilter_each
  die "'\$self->{db}{prefilter_each}' is invalid"
	if(defined($self->{db}{prefilter_each}) and
	   ref($self->{db}{prefilter_each}) ne 'CODE');

  # $self->{dbcol} Υå
  my $exist = { };
  my $filetype = 0;
  die "\$self->{db} must be defined" unless($self->{db});
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	die "dbtable '$dbt' is invalid"
	  unless($dbt =~ m/^[a-z](?:|[a-z_]*[a-z])$/
			 and $dbt !~ m/^(seq_|dbsession|sys_)/
			 and length("${dbt}_dft") < $self->{sys}{sqlnamelen});
	foreach my $i (0 .. $#{ $self->{dbcol}{$dbt} }) {
	  my $dbc = $self->{dbcol}{$dbt}[$i];
	  die "\$self->{dbcol}{$dbt}[$i] is invalid"
		unless(ref($dbc) eq 'HASH');

	  # ʣΥå
	  my $name = $dbc->{name};
	  die "attribute '$dbt.$dbc->{name}' duplicated"
		if(defined $exist->{$dbt}{ $dbc->{name} });
	  $exist->{$dbt}{ $dbc->{name} } = 1;

	  # name Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{name}' is invalid"
		unless($dbc->{name} =~ m/^[a-z](?:|[a-z_]*[a-z])$/
			   and length($dbc->{name} . $self->{sys}{search_ext})
			   < $self->{sys}{sqlnamelen});
	  die "'\$self->{dbseq}{$dbt}{$name}{name}' is invalid"
		if($dbc->{name} =~ m/$self->{sys}{search_ext}$/);
	  die "'\$self->{dbseq}{$dbt}{$name}{name}' is invalid"
		if($dbc->{name} =~ m/^(system_|draft_)/);

	  # print Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{print}' is invalid"
		if($dbc->{print} =~ m/[\x0D\x0A]/);

	  # type Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{type}' is invalid"
		unless(defined $self->{db}{type_sql}{ $dbc->{type} });
	  $filetype = 1 if($dbc->{type} eq 'file');

	  if($dbc->{type} eq 'file') {
		foreach my $key ('null', 'plural', 'format', 'code', 'snull') {
		  die "'\$self->{dbseq}{$dbt}{$name}{$key}' must not be defined"
			if(defined $dbc->{$key});
		}
	  }

	  # null Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{null}' is invalid"
		unless(not defined $dbc->{null}
			   or $dbc->{null} =~ m/^(|:.*|error|warning(:.*)?)$/s);
	  # null ˳ƤƤͤǡ¤˽äƤʤ
	  die "'\$self->{dbseq}{$dbt}{$name}{null}' is invalid"
		if($dbc->{null} =~ m/^(?:warning)?:(.*)$/s
		   and $1 !~ m/$self->{db}{type}{format}->{ $dbc->{type} }/);
	  # ǥեͤб code Υʤ
	  if(($tmp = $dbc->{null}) =~ s/^(warning)?://) {
		my $err = 1;
		foreach my $dc (@{ $dbc->{code} }) {
		  if(exists $self->{code}{$dc}{$tmp}) { undef $err; last; }
		}
		die "'\$self->{dbseq}{$dbt}{$name}{null}' is invalid: $dbc->{null}"
		  if($err);
	  }

	  # plural Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{type}' must be 'text'"
		if($dbc->{plural} and $dbc->{type} ne 'text');

	  # subst Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{subst}' is invalid"
		if(defined($dbc->{subst}) and ref($dbc->{subst}) ne 'CODE');

	  # format Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{format}' is invalid"
		if(defined($dbc->{format}) and ref($dbc->{format}) ne 'CODE');
	  # code Υå
	  if(defined $dbc->{code}) {
		die "'\$self->{dbseq}{$dbt}{$name}{code}' is invalid"
		  if(ref($dbc->{code}) ne 'ARRAY');
		foreach my $i (@{ $dbc->{code} }) {
		  die "'\$self->{code}{$i}' must be defined"
			unless(defined($self->{code}{$i}));
		}
	  }

	  # search Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{search}' is invalid"
		unless(not defined($dbc->{search}) or $dbc->{type} eq 'file'
			   or ref($dbc->{search}) eq 'CODE');
	  # stype Υå
	  die "'\$self->{dbseq}{$dbt}{$name}{stype}' is invalid"
		if($dbc->{search} and not $self->{db}{type_sql}{ $dbc->{stype} });
	  die "'\$self->{dbseq}{$dbt}{$name}{stype}' is invalid"
		if($dbc->{search} and $dbc->{type} eq 'file' and
		   $dbc->{stype} ne 'file');
	  die "'\$self->{dbseq}{$dbt}{$name}{stype}' is invalid"
		if(not defined($dbc->{search}) and defined($dbc->{stype}));
	  # snull Υå
	  my $type_sql = $self->{db}{type_sql}{ $dbc->{stype} };
	  if($dbc->{null} =~ m/^(?:warning)?(:.*)?$/s and $dbc->{search}
		 and $dbc->{type} ne 'file') {
		die "'\$self->{dbseq}{$dbt}{$name}{snull}' is invalid"
		  unless(not defined($dbc->{snull}) or $dbc->{snull} =~ m/^(:.*)?$/s);
		die "'\$self->{dbseq}{$dbt}{$name}{snull}' is invalid"
		  if($dbc->{snull} =~ m/^:(.*)$/s
			 and $1 !~ m/$self->{db}{type}{format}->{$type_sql}/);
	  }
	}
  }

  # $self->{db}{filter_all} Υå
  if($self->{db}{filter_all}) {
	foreach my $dbt (keys %{ $self->{db}{filter_all} }) {
	  die "'\$self->{db}{filter_all}{$dbt}' is invalid"
		if(defined($self->{db}{filter_all}{$dbt})
		   and ref($self->{db}{filter_all}{$dbt}) ne 'CODE');
	}
  }

  # ----- $self->{global}{filetype}: ե뷿 -----
  if($filetype) {
	die "\$self->{global}{filetype} is invalid"
	  if(ref($self->{global}{filetype}) ne 'HASH');
	# dir
	die "\$self->{global}{filetype}{dir} must be defined"
	  unless(defined $self->{global}{filetype}{dir});
	die "\$self->{global}{filetype}{dir} must end without a slash"
	  if($self->{global}{filetype}{dir} =~ m!/$!);
	die "\$self->{global}{filetype}{dir} must represent a absolute pathname"
	  if($self->{global}{filetype}{dir} !~ m!^/!);
	warn "\$self->{global}{filetype}{dir} is invalid"
	  unless(-d $self->{global}{filetype}{dir});
	# pooldir
	die "\$self->{global}{filetype}{pooldir} must be defined"
	  unless(defined $self->{global}{filetype}{pooldir});
	die "\$self->{global}{filetype}{pooldir} must end without a slash"
	  if($self->{global}{filetype}{pooldir} =~ m!/$!);
	die "\$self->{global}{filetype}{pooldir} must represent "
	  . "a absolute pathname"
		if($self->{global}{filetype}{pooldir} !~ m!^/!);
	warn "\$self->{global}{filetype}{pooldir} doesn't exist"
	  unless(-d $self->{global}{filetype}{pooldir});
	# tmpdir
	die "\$self->{global}{filetype}{tmpdir} must be defined"
	  unless(defined $self->{global}{filetype}{tmpdir});
	die "\$self->{global}{filetype}{tmpdir} must end without a slash"
	  if($self->{global}{filetype}{tmpdir} =~ m!/$!);
	die "\$self->{global}{filetype}{tmpdir} must represent a absolute pathname"
	  if($self->{global}{filetype}{tmpdir} !~ m!^/!);
	warn "\$self->{global}{filetype}{tmpdir} doesn't exist"
	  unless(-d $self->{global}{filetype}{tmpdir});
	# mode
	die "\$self->{global}{filetype}{mode} must be defined"
	  unless(defined $self->{global}{filetype}{mode});
	# fileuri
	die "\$self->{global}{filetype}{fileuri} must be defined"
	  unless(defined $self->{global}{filetype}{fileuri});
	# tmpfileuri
	die "\$self->{global}{filetype}{tmpfileuri} must be defined"
	  unless(defined $self->{global}{filetype}{tmpfileuri});
  } else {
	die "\$self->{global}{filetype} must not be defined"
	  if(defined $self->{global}{filetype});
  }

  $self->{dbh}->disconnect()
	if(not $self->{debug}{no_db} and not $opt{noexit});
}

=back

=head2 INTERNAL METHODS

=over 4

=item _init ( )

  $self->_init();

$self->{db} ɬפʾ롣

=cut

sub _init {
  my $self = shift;
  $self->{db}{type_sql} =		# ʥˤSQLΥǡ͡ˤȤδط
	{ int2 => 'int2', int4 => 'int4', int8 => 'int8',
	  text => 'text', file => 'text', real => 'real',
	};
  $self->{db}{type}{format} =		# Ʒޥå٤ѥ
	{ int2 => qr{^-?[12]?\d{1,4}$}, int4 => qr{^-?[1]?\d{1,9}$},
	  int8 => qr{^-?\d{1,17}$}, text => qr{.?}, file => qr{.?},
	  real => qr{^-?(\d+\.?\d*|\.\d+)?(e[+-]?\d+)?$},
	};
  $self->{db}{syscol} =				# ƥ
	[ { name => 'system_did', type_sql => 'int4' },
	  { name => 'system_rid', type_sql => 'int4' },
	  { name => 'system_state', type_sql => 'int2' },
	  { name => 'system_uniq', type_sql => 'text' },
	  { name => 'system_uid', type_sql => 'int4' },
	  { name => 'system_date', type_sql => 'timestamp' },
	  { name => 'system_method', type_sql => 'text' },
	  { name => 'system_addr', type_sql => 'text' },
	  { name => 'system_agent', type_sql => 'text' },
	  { name => 'system_warning', type_sql => 'text' },
	  { name => 'system_rev_uid', type_sql => 'int4' },
	  { name => 'system_inv_date', type_sql => 'timestamp' },
	  { name => 'system_inv_method', type_sql => 'text' },
	  { name => 'system_inv_addr', type_sql => 'text' },
	  { name => 'system_inv_agent', type_sql => 'text' },
	  { name => 'system_inv_uid', type_sql => 'int4' },
	  { name => 'system_pre_state', type_sql => 'int2' },
	  { name => 'system_pre_rid', type_sql => 'int4' },
	  { name => 'system_next_rid', type_sql => 'int4' },
	];
  $self->{db}{subsyscol} =
	[ { name => 'system_rid', type_sql => 'int4' },
	  { name => 'system_num', type_sql => 'int4' },
	];
  $self->{db}{sysstate} =			# ǡξ
	{ invalid => 0, wait => 1, active => 2, unstable => 3 };
}

=item _print_header ( [OPTION] )

  $self->_print_header(%opt);

    OPTION :
      status => STRING           # HTTP ơ
      fh => $fh                # 

HTTP ΥإåʬϤ롣
˥إåϤƤϡϤʤ

=cut

sub _print_header {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $status = $opt{status} || "200 OK";
  my $fh = $opt{fh} || \*STDOUT;
  return if($self->{sys}{printheader});

  my $group = $opt{group} ne '' ? $opt{group} : $self->{userinfo}{group};
  if($self->{sys}{nph}) {
	print $fh "HTTP/1.1 $status\r\n"
	  or $self->fatal_error("Cannot print: $!");
  }
  my $html_charset = ref($self->{global}{html_charset}) eq 'HASH' ?
	$self->{global}{html_charset}{$group} : $self->{global}{html_charset};
  my $charset = $html_charset ne '' ? "; charset=$html_charset" : '';
  print $fh "Status: $status\r\nContent-type: text/html$charset\r\n\r\n"
	or $self->fatal_error("Cannot print: $!");
  $self->{sys}{printheader} = 1;
}

=item _new_tmpfile ( NAME [,OPTION] )

  $fh = $self->_new_tmpfile($name, %opt);
  $fh = $self->_new_tmpfile(undef, %opt);

    ARGS :
      $name => STRING or undef # ƥݥե̾

    OPTION :
      dir => STRING            # ǥ쥯ȥ
      head => STRING           # ե̾Ƭʸ
      undelete => BOOLEAN      # ʤ
      nameref => STRINGREF     # ե̾γǼ

$opt{dir} ˡ$opt{dir}ꤵƤʤ
$dbi->{global}{basedir}/$dbi->{global}{tmpdir} ˡ
ƥݥեꡢեΥեϥɥ֤

$name  undef ξϡtmpnam() Ѥƥե̾롣
$opt{nameref} ꤵ줿Ȥϡ$opt{nameref} ˥ƥݥե
ե̾Ǽ롣

=cut

sub _new_tmpfile {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $name, %opt) = @_;
  $self->fatal_error("The parameter 'nameref' is invalid")
	if(exists($opt{nameref}) and ref($opt{nameref}) ne 'SCALAR');

  # tmpfile 򳫤
  my $fh;
  my $dir = $opt{dir} ? $opt{dir} :
	"$self->{global}{basedir}/$self->{global}{tmpdir}";
  if(defined $name) {
	$self->fatal_error("The parameter 'name' is invalid",
					   name => $name)
	  if($name eq '' or $name =~ m![^\w.#~=:%-]!);
	$name = "$dir/$name";
	$fh = IO::File->new($name, O_RDWR|O_CREAT|O_EXCL) or return undef;
  } else {
	my $n;
	if($opt{head}) { $opt{head} =~ s!^.*/!!;   $opt{head} .= '-'; }
	my $head = "$dir/$opt{head}";
	while(1) {
	  ($name = tmpnam() . $$ . int(rand(10000))) =~ s!^.*/!!;
	  if($fh = IO::File->new("$head$name", O_RDWR|O_CREAT|O_EXCL)) {
		$name = $head . $name;
		last;
	  }
	  return undef if($n++ > 30);
	}
  }
  flock($fh, 2);
  unlink($name) unless($opt{undelete});
  ${ $opt{nameref} } = $name if($opt{nameref});
  return $fh;
}

=item _get_nextval ( SEQUENCE )

  $val = $self->_get_nextval($seqence);

    RET : NUM

SEQUENCE 鼡ͤ롣
˼Ԥ fatal_error Ȥ롣

=cut

sub _get_nextval {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $seq) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  my $ret;
  eval { $ret = $self->{dbh}->selectrow_array
		   ("SELECT nextval('$seq')") };
  $self->fatal_error("$@ ; " . $self->{dbh}->errstr)
	if($@ or $ret eq '');
  return $ret;
}

=item _convfile ( FH, NAMEREF, NAMEREF_TN [,OPTION] )

  $ew = $self->_convfile($fh, $nameref, $nameref_tn, %opt);

    RET : LIST                 # 顼ٹξ
      0 => STRING              # 'error' or 'warning'
      1 => STRING              # 顼å

Ϥ줿եŬڤѴ롣
Ѵ undef ֤ʤХ顼åޤ֤

Ѵ硢$nameref, $nameref_tn ˿ե̾Ǽ졢
 $nameref, $nameref_tn ˳ǼƤ̾ΥեϺ롣

=cut

sub _convfile {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $fh, $nameref, $nameref_tn, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 5);

  my $oldfile = $$nameref;
  my $oldfile_tn = defined($nameref_tn) ? $$nameref_tn : undef;
  my $tmpdir = $self->{global}{filetype}{tmpdir};

  # ե
  my ($fh_new, $key, $exist);
  opendir(DIR, $self->{global}{filetype}{dir})
	or $self->fatal_error("Cannot opendir: $!");
  while($key = readdir(DIR)) { $key =~ s!\.[^/]*$!!; $exist->{$key} = 1; }
  closedir(DIR);
  opendir(DIR, $self->{global}{filetype}{tmpdir})
	or $self->fatal_error("Cannot opendir: $!");
  while($key = readdir(DIR)) { $key =~ s!\.[^/]*$!!; $exist->{$key} = 1; }
  closedir(DIR);
  foreach (1 .. 30) {
	$$nameref = Digest::MD5::md5_hex(Digest::MD5::md5_hex(rand().time()));
	next if($exist->{$$nameref});
	$fh_new = $self->DBIPgSystem::DB::_new_tmpfile
	  ($$nameref, dir => $tmpdir, undelete => 1);
	last if($fh_new);
  }
  $self->fatal_error("Unable to create new temporary file") unless($fh_new);
  $$nameref = "$tmpdir/$$nameref";
  if($opt{thumbnail}) {
	($$nameref_tn = $$nameref) =~ s!/([^/]*)$!/tn_$1!;
  } else {
	$$nameref_tn = undef;
  }
  $self->DBIPgSystem::DB::_cut_macbinary($fh, $fh_new);
  close($fh_new);

  my $ew;
  eval {
	# ɬפʤХե륿̤
	if(defined $opt{filter}) {
	  my $stderrfile = $$nameref . "-stderr";
	  open(STDERR, "> $stderrfile") or die "Cannot open $stderrfile: $!";
	  flock(STDERR, 2) or die "Cannot flock: $!";
	  my $oldfh = select STDERR;   $| = 1;   select $oldfh;
	  my ($newfile, $ext, $ext_tn);
	  ($ext, $ew, $ext_tn) = &{ $opt{filter} }($$nameref, $$nameref_tn);
	  if(defined $ext) {
		$newfile = "$$nameref.$ext";
		if($opt{thumbnail}) {
		  $ext_tn = $ext unless(defined $ext_tn);
		  $$nameref_tn .= ".$ext_tn";
		}
	  }

	  # ĥҤʤ硢ե뤬¸ߤʤ硢 0 ξʤ
	  unless(defined $ext and -f $newfile and (stat($newfile))[7] > 0
			 and (not $opt{thumbnail} or -f $$nameref_tn)) {
		$ew = $self->get_errmsg($ew ne '' ? $ew : 'upload');
		$self->add_log('UploadError', "$ew", file => $$nameref,
					   newfile => $newfile, file_tn => $$nameref_tn,
					   size => (stat($newfile))[7]);
		unlink($$nameref, $newfile);
		unlink($$nameref_tn) if($opt{thumbnail});
		($$nameref, $$nameref_tn) = ($oldfile, $oldfile_tn);
		$ew = [ 'error', $ew ];
	  }
	  # ɸ२顼ϤʸǤ줿
	  elsif(tell(STDERR)) {
		my $errmsg;
		open(IN, $stderrfile) or die;
		$errmsg .= $_ while(<IN>);
		close(IN);
		$self->add_log('UploadError', "STDERR: $errmsg", file => $$nameref);
		unlink($$nameref, $newfile);
		unlink($$nameref_tn) if($opt{thumbnail});
		($$nameref, $$nameref_tn) = ($oldfile, $oldfile_tn);
		$ew = [ 'error', $self->get_errmsg('upload') ];
		$self->send_mail
		  ($self->{global}{mailto},
		   "DBIPgSystem (ver. $VERSION), File Upload Error",
		   "[STDERR]\n$errmsg\n");
	  }
	  # ե륿
	  else {
		if($oldfile and not (-f "$self->{global}{filetype}{dir}/$oldfile")) {
		  unlink("$tmpdir/$oldfile", "$tmpdir/$oldfile_tn");
		  unlink("$tmpdir/$oldfile") if($oldfile =~ s!\.[^/]*$!!);
		}
		$ew = [ 'warning', $self->get_errmsg($ew) ] if($ew ne '');
		if($self->{global}{filetype}{mode}) {
		  chmod($self->{global}{filetype}{mode}, $newfile);
		  chmod($self->{global}{filetype}{mode}, $$nameref_tn)
			if($opt{thumbnail});
		}
		($$nameref = $newfile) =~ s!^.*/!!;
		$$nameref_tn =~ s!^.*/!!;
	  }
	  close(STDERR);
	  unlink($stderrfile);
	}
  };
  $self->fatal_error("$@") if($@);
  return $ew;
}

=item _prepare_insert_cmd ( DRAFT, SYSTEM, ISBIND )

  ($sth, $sysbnum) = $self->_prepare_insert_cmd($draft, $system, $isbind);

    ARGS :
      $draft => BOOLEAN        # true ʤ draftѥơ֥
      $system => HASHREF       # ƥξ
      $isbind => HASHREF       # bind 륷ƥξ

    RET : LIST                 # INSERTʸ
      0 => HASHREF             # INSERTʸΥơȥȥϥɥ륪֥
      1 => HASHREF             # ƥ bind 뤿ֹ

INSERTʸ롣

=cut

sub _prepare_insert_cmd {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $draft, $system, $isbind) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 4);

  my $primary = $self->{global}{primary};
  my $dbh = $self->{dbh};

  # INSERTʸν
  my ($sth, $sysbnum) = ({ }, { });
  my ($bnum, $dbnum, $key);
  my $values = [ ];
  $draft = $draft ? '_dft' : '';
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$dbnum = $self->{dbnum}{$dbt};
	$#$values = -1;

	push(@$values, map { '?' } 1 .. $dbnum->{user} + $dbnum->{search});
	$bnum = @$values + 1;

	if($dbt eq $primary) {
	  # ƥǡ˰¸ʤͤƤ
	  foreach my $syscol (@{ $self->{db}{syscol} }) {
		$key = $syscol->{name};
		if($isbind->{$key}) {
		  push(@$values, '?');
		  $sysbnum->{$dbt}{$key} = $bnum++;
		} else {
		  push(@$values, ($system->{$key} ne '' ? $dbh->quote($system->{$key})
						  : 'NULL' ));
		}
	  }
	  if($draft) {
		push(@$values, '?', '?');
		$sysbnum->{$dbt}{draft_rid} = $bnum++;
		$sysbnum->{$dbt}{draft_line} = $bnum++;
	  }
	} else {
	  foreach my $subsyscol (@{ $self->{db}{subsyscol} }) {
		$sysbnum->{$dbt}{ $subsyscol->{name} } = $bnum++;
	  }
	  push(@$values, map { '?' } @{ $self->{db}{subsyscol} });
	  if($draft) {
		push(@$values, '?');
		$sysbnum->{$dbt}{draft_rid} = $bnum++;
	  }
	}

	$sth->{$dbt} = $dbh->prepare
	  ("INSERT INTO \"$dbt$draft\" VALUES ( " . join(', ', @$values) . " )");
  }

  return ($sth, $sysbnum);
}

=item _filter_one_data ( DBTABLE, NUM, DATAREF, ERRWARN, SEARCHREF [,OPTION] )

  $self->_filter_one_data($dbt, $num, $dataref, $errwarn, $searchref, %opt);

    OPTION :
      page => NUM              # бڡֹ
      noencode => BOOLEAN      # code ȤǡˤĤơ
                               # ˥󥳡ɤƤȤߤʤ
      check => BOOLEAN         # ϿƤǡΥå

    RET : undef

1ĤΥͤΥåִԤ

ŪˤϡνǽԤ

  1. $self->{db}{prefilter_each} ƤСΥե륿̤
  2. subst ƤСΥե륿̤
  3. ͤʸʤС
     3-1. 顼åִԤ
     3-2. ѥνԤ
     3-3. ᥽åɤλ롣
  4. ͤбSQLΥǡΥեޥåȤȤΤ롣
     ʤХ顼򤷤塢᥽åɤλ롣
  5. format_error ƤС¤å롣
     顼ȯХ᥽åɤλ롣
  6. format_warning ƤС¤å롣
  7. ѥνԤ

 $errwarn->{error}  $errwarn->{warning} 
ؤΥե󥹤ǤʤФʤʤ
ǡԶ礬äϡ$errwarn->{error}  $errwarn->{warning}
Ǥɲä롣ǤϥϥåؤΥե󥹤ǡ
Υͤġ

  msg   : ԶΥå
  table : бơ֥̾
  value : ԶΤä
  num   : ơ֥бֹ
  print : ̾
  page  : б̤Υڡ (= $opt{page})

=cut

sub _filter_one_data {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $dbt, $num, $dataref, $ew, $searchref, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 6);
  $self->fatal_error("The parameter 'dataref' is invalid")
	if(ref($dataref) ne 'SCALAR');
  if($opt{check}) { my $tmp = $$dataref; $dataref = \$tmp;}

  my $dbc = $self->{dbcol}{$dbt}[$num];
  my $error = $self->{debug}{no_data_error} ? 'warning' : 'error';
  my $regtype;

  # subst
  &{ $self->{db}{prefilter_each} }($dataref) if($self->{db}{prefilter_each});
  &{ $dbc->{subst} }($dataref) if(defined $dbc->{subst});

  # ʣͤʤ \x1D ޤޤ
  if(not $dbc->{plural} and $$dataref =~ m/\x1D/) {
	$$dataref =~ s/\x1D/$self->{global}{code_invalid}/g;
	push(@{ $ew->{error} },
		 { msg => $self->get_errmsg('invalid_code'), table => $dbt,
		   value => $$dataref, num => $num,
		   print => $self->{dbcol}{$dbt}[$num]{print},
		   page => $opt{page} });
	return;
  }

  # null ν
  if($$dataref =~ m/^\s*$/) {
	undef $$dataref;
	if($dbc->{null} eq 'error') {
	  push(@{ $ew->{$error} },
		   { msg => $self->get_errmsg('col_null'), table => $dbt,
			 value => $$dataref, num => $num,
			 print => $self->{dbcol}{$dbt}[$num]{print},
			 page => $opt{page} });
	  return;
	}
	push(@{ $ew->{warning} },
		 { msg => $self->get_errmsg('col_null'), table => $dbt,
		   value => $$dataref, num => $num,
		   print => $self->{dbcol}{$dbt}[$num]{print},
		   page => $opt{page} }) if($dbc->{null} =~ m/^warning/);
	# code Ѥ硢ǥեͤб륳ɤ뤳Ȥ
	# test_conf ǳǧƤȤǤϥå򤷤ʤ
	if($dbc->{null} !~ m/^(warning)?$/) {
	  ($$dataref = $dbc->{null}) =~ s/^(warning)?://;
	}
	if($dbc->{search}) {
	  if($dbc->{snull} eq '') {
		undef $$searchref;
	  } else {
		($$searchref = $dbc->{snull}) =~ s/^://;
	  }
	}
	return;
  }

  # code Ѥ
  if($dbc->{code}) {
	my $code = $$dataref;
	my $err;
	if($dbc->{plural}) {
	  $code =~ s/^\x1D//;   $code =~ s/\x1D$//;
	  $code = [ split(/\x1D/, $code) ];
	} else { $code = [ $code ]; }
	if($opt{noencode}) {
	  # ɤ¸ߤ뤳ȤΤ
	  foreach my $c (@$code) {
		$err = $c;
		foreach my $dc (@{ $dbc->{code} }) {
		  if(exists $self->{code}{$dc}{$c}) { undef $err; last; }
		}
		last unless(defined $err);
	  }
	} else {
	  # հѤΥϥåʤޤѰդƤʤСѰդ
	  unless(exists $self->{coderev}{$dbt}{$num}) {
		my ($k, $v);
		foreach my $c (@{ $dbc->{code} }) {
		  $self->{coderev}{$dbt}{$num}{$v} = $k
			while(($k, $v) = each %{ $self->{code}{$c} });
		}
	  }
	  # б륳ɤ֤
	  foreach my $c (@$code) {
		if(exists $self->{coderev}{$dbt}{$num}{$c}) {
		  $c = $self->{coderev}{$dbt}{$num}{$c};
		} else { $err = $c; last; }
	  }
	}
	if($dbc->{plural}) {
	  $$dataref = "\x1D" . join("\x1D", sort @$code) . "\x1D";
	} else { $$dataref = $code->[0]; }
	push(@{ $ew->{error} },
		 { msg => $self->get_errmsg('col_code'), table => $dbt,
		   value => $err, num => $num,
		   print => $self->{dbcol}{$dbt}[$num]{print},
		   page => $opt{page} }) if(defined $err);
	return;
  }
  # code Ѥʤ
  else {
	# ǡˤ¤Υå
	$regtype = $self->{db}{type}{format}
	  { $self->{db}{type_sql}{ $dbc->{type} } };
	if($$dataref !~ m/$regtype/) {
	  push(@{ $ew->{error} },
		   { msg => $self->get_errmsg('col_format'), table => $dbt,
			 value => $$dataref, num => $num,
			 print => $self->{dbcol}{$dbt}[$num]{print},
			 page => $opt{page} });
	  return;
	}

	# ¤Υå (format)
	if(defined $dbc->{format}) {
	  my $err = &{ $dbc->{format} }($$dataref);
	  if(defined $err) {
		$err =~ s/^(error|warn)\|//
		  or $self->fatal_error("format", err => $err);
		my $errkind = $1 eq 'error' ? $error : 'warning';
		push(@{ $ew->{$errkind} },
			 { msg => $self->get_errmsg($err), table => $dbt,
			   value => $$dataref, num => $num,
			   print => $self->{dbcol}{$dbt}[$num]{print},
			   page => $opt{page} });
		return if($errkind eq 'error');
	  }
	}
  }

  # ѥ
  return unless(defined $dbc->{search});
  $$searchref = &{ $dbc->{search} }($$dataref);
  # ǡˤ¤Υå
  $regtype = $self->{db}{type}{format}
	{ $self->{db}{type_sql}{ $dbc->{stype} } };
  $self->fatal_error
	("stype is invalid, \$data = " . $$dataref,
	 dbt => $dbt, col => $self->{dbcol}{$dbt}[$num]{name},
	 searchdata => $$searchref)
	  if(defined($$searchref) and $$searchref !~ m/$regtype/);
  return;
}

=item _file_filter_indata ( DATA, INFILTER_ERROR )

  $err = $self->_file_filter_indata($data, $infilter_error);

    ARGS :
      data => ARRAYREF          # ǡξʥեΥ
      infilter_error => BOOLEAN # true ʤ infilter ᥽åɤǥ顼ä

    RET : ARRAY
      0 => HASHREF             # ǡξ
      1 => HASHREF
       error => HASHREF        # 顼ξ
       warning => HASHREF      # ٹξ

ե뤫Ϥ줿ǡγƥ䥫ΤΥåִԤ

=cut

sub _file_filter_indata {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $data, $infilter_error) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);
  my $ff = { };
  my $ff_ew = { error => [ ], warning => [ ] };
  my $error = $self->{debug}{no_data_error} ? 'warning' : 'error';
  my $filetypedir = $self->{global}{filetype}{dir};

  my ($dref, $snum, $dbhash, $dbdata, $exist, $search, $dbc, $ew, $colerror,
	  $error_null, $warning_null);
  my ($err, $warn);
  my $search_ext = $self->{sys}{search_ext};
  foreach my $dbt (keys %{ $self->{dbcol} }) {
	$snum = @{ $self->{dbcnum}{$dbt} };
	$dbhash->{$dbt} = { };
	$error_null = [ ];
	$warning_null = [ ];
	$colerror = 0;
	foreach my $j (0 .. $snum - 1) {
	  $dbc = $self->{dbcol}{$dbt}[$j];
	  $dbhash->{$dbt}{ $dbc->{name} } = $data->[ $self->{dbcnum}{$dbt}[$j] ];
	  $dref = \$dbhash->{$dbt}{ $dbc->{name} };
	  $search = \$dbhash->{$dbt}{ $dbc->{name} . $search_ext }
		if($dbc->{search});

	  # ե뷿
	  if($dbc->{type} eq 'file') {
		if($$dref =~ m/^\s*$/) {
		  undef $$dref;
		  undef $$search if($dbc->{search});
		  next;
		}
		if($$dref =~ m!^[\w.-]+$! and -f "$filetypedir/$$dref"
		   and (not $dbc->{search} or -f "$filetypedir/tn_$$dref")) {
		  $$search = 'tn_' . $$dref if($dbc->{search});
		} else {
		  push(@{ $ff_ew->{error} },
			   { msg => $self->get_errmsg('file_upload'), table => $dbt,
				 value => $$dref, num => $j,
				 print => $self->{dbcol}{$dbt}[$j]{print} });
		  $colerror = 1;
		}
		next;
	  }
	  # ǽʸޤޤ
	  if($infilter_error) {
		push(@{ $ff_ew->{error} },
			 { msg => $self->get_errmsg('infilter_invalid'), table => $dbt,
			   value => $$dref, num => $j,
			   print => $self->{dbcol}{$dbt}[$j]{print} })
		  if($$dref =~ s/\x0C/$self->{global}{code_invalid}/g);
		push(@{ $ff_ew->{error} },
			 { msg => $self->get_errmsg('invalid_code'), table => $dbt,
			   value => $$dref, num => $j,
			   print => $self->{dbcol}{$dbt}[$j]{print} })
		  if($$dref =~ s/\x0B/$self->{global}{code_invalid}/g);
		$colerror = 1;
		next;
	  }

	  $ew = { error => [ ], warning => [ ] };
	  $self->DBIPgSystem::DB::_filter_one_data($dbt, $j, $dref, $ew, $search);
	  if(defined($$dref)) {
		push(@{ $ff_ew->{error} }, @{ $ew->{error} });
		push(@{ $ff_ew->{warning} }, @{ $ew->{warning} });
		$colerror = 1 if(@{ $ew->{error} });
	  } else {
		# ͤΤȤϡޤ顼ɤϤ狼ʤ
		push(@$error_null, @{ $ew->{error} });
		push(@$warning_null, @{ $ew->{warning} });
	  }
	}
	if($colerror) {
	  $dbdata = $ff->{$dbt} = [ ];
	  next;
	}

	# ƤΥͤǤʤå
	if($self->{db}{dbtnum} > 1) {
	  $exist = 0;
	  foreach my $k (keys %{ $dbhash->{$dbt} }) {
		if(defined($dbhash->{$dbt}{$k}) and $k !~ m/$search_ext$/o) {
		  $exist = 1; last; }
	  }
	  next unless($exist);
	}
	if(@$error_null) { push(@{ $ff_ew->{error} }, @$error_null); next; }
	push(@{ $ff_ew->{warning} }, @$warning_null);

	# ΤФִ¤Υå
	if($self->{db}{filter_all}{$dbt}) {
	  ($err, $warn) = &{ $self->{db}{filter_all}{$dbt} }
		($self, $dbhash->{$dbt});
	  foreach my $i (@$err) {
		push(@{ $ff_ew->{$error} },
			 { msg => $self->get_errmsg($i->[0]), table => $dbt });
	  }
	  next if(@{ $ff_ew->{error} });
	  foreach my $i (@$warn) {
		push(@{ $ff_ew->{warning} },
			 { msg => $self->get_errmsg($i->[0]), table => $dbt });
	  }
	}

	$ff->{$dbt} = $self->DBIPgSystem::DB::_hash2array_data
	  ($dbhash->{$dbt}, $dbt);
  }
  return ($ff, $ff_ew);
}

=item _insert_filedb ( FILENAME, DBTABLE, NUM, COLNAME, SYSTEM, ERRWARN )

  $self->_insert_filedb($file, $dbtable, $num, $col, $system, $errwarn);

եξǡ١롣
ϡե̾ͥΥե̾
ѸΥơ֥̾system_num ͡ѸΥ̾
ե뤬줿Ȥ system_rid ͡줿

=cut

sub _insert_filedb {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $file, $thumbnail, $dbtable, $num, $col, $system, $errwarn) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 7);

  # 쥳ɤͤꤹ
  my $data =
	{ file => $file, thumbnail => $thumbnail, table => $dbtable, num => $num,
	  column => $col, system_rid => $system->{system_rid},
	  system_date => 'NOW', system_method => $system->{system_method},
	  system_addr => $system->{system_addr},
	  system_agent => $system->{system_agent}, system_warning => undef,
	};
  my $warning = \$data->{system_warning};
  foreach my $w (@{ $errwarn->{warning}{$dbtable}[$num-1]{$col} }) {
	$$warning .= "$w->{msg}\x0A";
  }

  # 
  my ($k, $v, $key, $val);
  while(($k, $v) = each %$data) {
	push(@$key, "\"$k\"");
	push(@$val, $v);
  }

  my $sth = $self->{dbh}->prepare
	(join('', "INSERT INTO \"sys_file\" ( ", join(', ', @$key),
		  " ) VALUES ( ", "?, " x $#$val, "? )"));
  $sth->execute(@$val) or die "$file";
}

=item _init_export_html_detail ( RID )

  $self->{__export_html_detail} = $self->_init_export_html_detail($rid);

_export_html_detail ᥽åɤ¹Ԥɬפѿ롣

=cut

sub _init_export_html_detail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self) = @_;

  # $self->{___export_html_detail} 
  my $export_sys = { };
  $export_sys->{export_group} = [ ];
  foreach my $group (keys %{ $self->{global}{export} }) {
	push(@{ $export_sys->{export_group} }, $group)
	  if($self->{global}{export}{$group});
  }
  $export_sys->{is_export} = @{ $export_sys->{export_group} } ? 1 : 0;
  $self->{___export_html_detail} = $export_sys;

  return $export_sys;
}

=item _export_html_detail ( RID )

  $self->_export_html_detail($rid);

    ARGS :
      $rid => NUM              # 쥳ID

ܺɽHTML Ϥ롣
ƥץ졼ȥե¦Ǥϡ$var{export} ͤĴ٤С
ݡȤƤ뤫ɤȽ̤Ǥ롣

$rid  undef ΤȤϡ$self->{__export_html_detail} ΤߤԤ

=cut

sub _export_html_detail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $rid) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  my $export_sys = $self->{___export_html_detail}
	|| $self->_init_export_html_detail();
  my ($data, $system) = $self->DBIPgSystem::DB::search_detail($rid, 0);
  my $did = sprintf("%.7d", $system->{system_did});

  my ($html, $out, $page, $dir);
  $self->{sys}{export_mode} = 1;
  my $maintenance = $self->{debug}{maintenance};
  $self->{debug}{maintenance} = 0;
  eval {
	foreach my $group (@{ $export_sys->{export_group} }) {
	  foreach my $p (1 .. $self->{template}{numpage_detail}{$group}) {
		$page = sprintf("%.2d", $p);
		$out = $self->{global}{export_file}{$group};
		$out =~ s{\^([dpa])}{
		  $1 eq 'd' ? $did : $1 eq 'p' ? $page : chr(96 + $p);
		}eg;
		if(-e $out) {
		  open(OUT, "+< $out") or die "Cannot open '$out': $!";
		} else {
		  open(OUT, "> $out") or die "Cannot open '$out': $!";
		}
		flock(OUT, 2) or die "Cannot lock: $!";
		seek(OUT, 0, 0) or die "Cannot seek: $!";
		$html = $self->get_template_detail($p, $group);
		$self->print_template
		  ($html,
		   { data => $data, system => $system, revise => 0, page => $page,
			 export => 1 },
		   fh => \*OUT, noexit => 1, noheader => 1, group => $group);
		truncate(OUT, tell(OUT)) or die "Cannot truncate: $!";
		close(OUT);
	  }
	}
  };
  $self->fatal_error("Export: $@") if($@);
  $self->{debug}{maintenance} = $maintenance;
  $self->{sys}{export_mode} = 0;
}

=item _update_invalid ( WHERE [,OPTION] )

  $num = $self->_update_invalid($where, $next_rid, %opt);

    ARGS :
      $where => STRING         # WHERE
      $next_rid => NUM         # system_next_rid

    OPTION :
      system => HASHREF        # ƥξ
      join => STRING           # JOIN

    RET : NUM                  # UPDATE줿ǡη

$where ǻꤵ줿ǡΤ̵Ǥʤǡ̵ˤ롣
ǡνξ̾$next_rid ͤǼɬפ롣

ɬפ˱ơsystem_inv_method, system_inv_addr, system_inv_agent
ͤǼǤ롣ʤСǥեͤȤ롣

ŪˤϡǡΥƥ򼡤Τ褦ѹ롣

  * system_state  invalid ˤ롣
  * system_uniq  nullͤˤ롣
  * system_inv_date ˸Ǽ롣
  * system_pre_state ˹ system_state ͤǼ롣
  * system_next_rid  $next_rid Ǽ롣
  * system_inv_method, system_inv_addr, system_inv_agent, system_inv_uid 
     ꤵ줿ͤޤϥǥեͤǼ롣

UPDATEޥɤμ¹Ԥ˼ԤȤ rollback ¹Ԥ뤬
Ƥ commit ¹Ԥʤ

UPDATE ǡηʷ 0 ξ '0E0'ˤ֤
Permission ˰ääϡUPDATEޥɤ¹Ԥ undef ֤

=cut

sub _update_invalid {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $where, $next_rid, %opt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);

  return if($self->{debug}{no_db});
  my $primary = $self->{global}{primary};
  my $dbh = $self->{dbh};
  my $sysstate = $self->{db}{sysstate};

  # Ϣ륷ƥν
  my $system =
	{ system_state => $sysstate->{invalid},
	  system_uniq => undef,
	  system_inv_date => 'NOW',
	  system_inv_method => $ENV{SCRIPT_NAME},
	  system_inv_addr => $ENV{REMOTE_ADDR},
	  system_inv_agent => $ENV{HTTP_USER_AGENT},
	  system_inv_uid => $self->{userinfo}{uid},
	  system_next_rid => $next_rid,
	};
  if(ref($opt{system}) eq 'HASH') {
	foreach my $k ('system_inv_method', 'system_inv_addr',
				   'system_inv_agent') {
	  $system->{$k} = $opt{system}{$k} if(exists $opt{system}{$k});
	  $system->{$k} = undef if($system->{$k} eq '');
	}
  }

  # 륫ν
  my $set = [ ];
  foreach my $k (keys %$system) {
	my $val;
	if(defined $system->{$k}) {
	  $val = $dbh->quote($system->{$k})
		or $self->fatal_error
		  ("DBI::quote() failed", type => $self->{db}{sysseq}{$k}{type_sql},
		   key => $k, value => $system->{$k});
	} else { $val = 'null'; }
	push(@$set, "\"$k\" = $val");
  }

  # Permission Υå
  my $perm = $self->check_permission('delete');
  my $where_npm = "( $where ) AND NOT ( $perm ) AND "
	. "( system_state = '$sysstate->{wait}'" .
	  ($opt{waitonly} ? '' : " OR system_state = '$sysstate->{active}'")
		. " )";
  return undef
	if($self->selectrow_array
	   ("SELECT COUNT(*) FROM \"$primary\" "
		. ($opt{join} ? "WHERE system_rid = ANY ( SELECT system_rid FROM "
		   . "\"$primary\" $opt{join} WHERE $where_npm" :
		   "WHERE $where_npm")) > 0);

  # ͭΥǡˤĤơ򤹤
  my $state = $opt{waitonly} ? [ 'wait' ] : [ 'wait', 'active' ];
  my ($num_success, $rc, $st, $sqlcmd);
  foreach my $k (@$state) {
	$st = $sysstate->{$k};
	$sqlcmd = "UPDATE \"$primary\" SET " . join(', ', @$set)
	  . ", system_pre_state = $st ";
	$sqlcmd .= $opt{join} ?
	  "WHERE system_rid = ANY ( SELECT system_rid FROM \"$primary\" "
		. "$opt{join} WHERE ( $where ) AND ( $perm ) AND "
		  . "system_state = '$st' )" :
			"WHERE ( $where ) AND ( $perm ) AND system_state = '$st'";
	eval { $rc = $dbh->do($sqlcmd) };
	if($@ or not $rc) {
	  my $errstr = "$@ ; " . $dbh->errstr;
	  eval { $dbh->rollback };
	  $self->fatal_error("$errstr", sqlcmd => $sqlcmd);
	}
	$num_success += $rc;
  }

  return ($num_success == 0 ? "0E0" : $num_success);
}

=item _calc_system_uniq ( DATA )

  $uniq = $self->_calc_system_uniq($data);

    ARGS :
      $data => HASHREF         # ǡ

    RET : STRING               # system_uniq

ơ֥1쥳ʬΥǡƤ顢system_uniq ׻롣

=cut

sub _calc_system_uniq {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $data) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  my $md5 = Digest::MD5->new;
  foreach my $dbt (sort keys %$data) {
	foreach my $d (@{ $data->{$dbt} }) {
	  foreach (@$d) { $md5->add($_); }
	}
  }
  return $md5->b64digest;
}

=item _hash2array_data ( HASH, DBTABLE )

  $array = $self->_hash2array_data($hash, $dbt);

    ARGS :
      $hash => HASHREF         # ơ֥ $dbt Υǡ
      $dbt => STRING           # ơ֥̾

    RET : ARRAYREF             # $hash Ѥǡ

ơ֥ $dbt  1쥳ʬΥǡ
ϥåؤΥե󥹤ؤΥե󥹤Ѵ롣

=cut

sub _hash2array_data {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $hash, $dbt) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 3);

  my $dbseq = $self->{dbseq}{$dbt};
  my $search_ext = $self->{sys}{search_ext};
  my ($ret, $k, $v);
  while(($k, $v) = each %$hash) {
	next if($k =~ m/$search_ext$/o);
	$ret->[ $dbseq->{$k}{num} ] = $v;
	$ret->[ $dbseq->{$k}{search_num} ] = $hash->{$k.$search_ext}
	  if($dbseq->{$k}{search});
  }

  return $ret;
}

=item _commit ( [OPTION] )

  $uniq = $self->_commit(%opt);

    OPTION :
      rollback => BOOLEAN      # true ʤ rollback 

commitʸ¹Ԥ롣

=cut

sub _commit {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;
  return undef if($self->{debug}{no_db});

  eval {
	if($self->{debug}{no_db_commit} or $opt{rollback}) {
	  $self->{dbh}->rollback();
	} else { $self->{dbh}->commit(); }
  };
  $self->fatal_error("$@ ; " . $self->{dbh}->errstr) if($@);
}

=item _init_dbfile ( )

  $self->_init_dbfile();

$self->{col_dbfile} ͤꤹ롣

=cut

sub _init_dbfile {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self) = @_;

  return if($self->{col_dbfile});
  $self->{col_dbfile} =
	[ { name => 'file', type_sql => 'text' },
	  { name => 'thumbnail', type_sql => 'text' },
	  { name => 'table', type_sql => 'text' },
	  { name => 'num', type_sql => 'int2' },
	  { name => 'column', type_sql => 'text' },
	  { name => 'system_rid', type_sql => 'int4' },
	  { name => 'system_date', type_sql => 'timestamp' },
	  { name => 'system_method', type_sql => 'text' },
	  { name => 'system_addr', type_sql => 'text' },
	  { name => 'system_agent', type_sql => 'text' },
	  { name => 'system_warning', type_sql => 'text' },
	];
}

=item _init_userinfo ( )

  $self->_init_userinfo();

$self->{col_userinfo} ͤꤹ롣

=cut

sub _init_userinfo {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self) = @_;

  return if($self->{col_userinfo});
  $self->{col_userinfo} =
	[ { name => 'system_uid', type_sql => 'int4', unique => 1 },
	  { name => 'system_read', type_sql => 'text' },
	  { name => 'system_add', type_sql => 'text' },
	  { name => 'system_delete', type_sql => 'text' },
	  { name => 'system_detail', type_sql => 'text' },
	  { name => 'system_tofile', type_sql => 'text' },
	  { name => 'system_state_active', type_sql => 'text' },
	  { name => 'system_state_wait', type_sql => 'text' },
	  { name => 'system_state_invalid', type_sql => 'text' },
	];
}

=item _pgsqlunpack ( REF )

  $self->_pgsqlunpack($ref);

PostgreSQL ʸüʸեå('\')Ȥäɽ

Ūˤ \x0A, \x1D 򡢤줾 '\n', '\035' Ѵ롣
ޤ'\', "'"  '\' դ롣

=cut

sub _pgsqlunpack {
  my ($self, $ref) = @_;
  $$ref =~ s/([\\'])/\\$1/g;
  $$ref =~ s/\x0A/\\n/g;   $$ref =~ s/\x1D/\\035/g;
}

=item _cut_macbinary ( FH_IN, FH_OUT )

  $fh = $self->_cut_macbinary($fh_in, $fh_out);

    RET : FH                   # $fh_out

$fh_in Ǽե뤬 MacBinary ɤȽ̤
⤷ MacBinary ʤСǡեΤߤФ롣
$fh_in, $fh_out Υեݥ󥿤ƬؤƤʤФʤʤ

$fh_out ꤵƤСMacBinary Ǥ뤫ɤ˴ؤ餺
ǡʬ $fh_out ˽Ϥ$fh_out ֤
$fh_out ꤵƤʤСMacBinary äΤ
äƥݥե˥ǡʬϤ
Υեϥɥ֤
$fh_out ꤵ줺MacBinary Ǥʤ undef ֤

=cut

sub _cut_macbinary {
  my ($self, $fh, $fh_out) = @_;
  my $read_unit = 16384;

  my ($macver, $buf, $tmp);
 MACBIN: {
	# Windows  Linux ʤ MacBinary ǤϤʤ
	last MACBIN if($ENV{HTTP_USER_AGENT} =~ m/WIN/i or
				   $ENV{HTTP_USER_AGENT} =~ m/LINUX/i);
	read($fh, $buf, 128) or last MACBIN;
	last MACBIN unless
	  (substr($buf, 0, 1) eq "\x00" and substr($buf, 74, 1) eq "\x00");
	$tmp = ord(substr($buf, 1, 1));
	last MACBIN if($tmp < 1 or $tmp > 63);
	if(substr($buf, 102, 4) eq 'mBIN') { $macver = 3;   last MACBIN; }
	$tmp = ord(substr($buf, 123, 1));
	if($tmp == 129) { $macver = 2;   last MACBIN; }
	$macver = 1 if($tmp == 0 and substr($buf, 82, 1) eq "\x00");
  }

  if($macver) {
	# MacBinary ʤХǡեΤߤФ
	$fh_out = $self->DBIPgSystem::DB::_new_tmpfile(undef)
	  unless(defined $fh_out);
	$self->fatal_error("_new_tmpfile: $!") unless(defined $fh_out);
	my $datalen = unpack("N", substr($buf, 83, 4));
	my $len = $datalen;
	while(read($fh, $buf, $len < $read_unit ? $len : $read_unit)) {
	  print $fh_out $buf or $self->fatal_error("Cannot print: $!");
	  $len -= $read_unit;
	  last if($len <= 0);
	}
	seek($fh_out, 0, 0) or $self->fatal_error("Cannot seek: $!");
	$self->add_log('MacBinary', "Successful", ver => $macver,
				   user_agent => $ENV{HTTP_USER_AGENT},
				   datalen => $datalen);
  } elsif(defined $fh_out) {
	# $fh_out ꤵƤХեƤ򥳥ԡ
	while(read($fh, $buf, $read_unit)) {
	  print $fh_out $buf or $self->fatal_error("Cannot print: $!");
	}
	seek($fh_out, 0, 0) or $self->fatal_error("Cannot seek: $!");
  }
  seek($fh, 0, 0) or $self->fatal_error("Cannot seek: $!");
  return $fh_out;
}

=back

=head2 SUBROUTINES

=over 4

=item dbdebug ( TYPE [,LIST] )

  &dbdebug('sub', @_);

ǥХåϤ롣

=cut

sub dbdebug {
  my $type = shift;
  return if($type ne 'sub');

  my $from = (caller(1))[1] . ': line ' . (caller(1))[2];
  my ($c, $caller) = ([ ], [ ]);
  my $i = 0;
  push(@$caller, $c) while(@$c = caller($i++));
  print "  " x (@$caller - 3), '** sub ',
	(caller(1))[3], " ( ", join(', ', @_), " )   [ <- $from ]\n";
}

# 1;
# __END__

=back

=head1 SEE ALSO

F<IO::File>, F<CGI>, F<Text::CSV_XS>, F<DBI>, F<Jcode>, F<Digest::MD5>,
F<DBIPgSystem::Code>

=head1 COPYRIGHT

Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the following URL for more details:
  http://www.gnu.org/licenses/gpl.txt

Written by Kenji Nakahira <nakahira@coop.nagoya-u.ac.jp>

=for html
</div>

=cut
