#!/usr/bin/perl
# DBIPgSystem.pm   ǡ١ƥ
#    $Id: DBIPgSystem.pm,v 1.3 2002/12/30 13:29:09 nakahira Exp $
#    Last updated: 12/30/2002
#
# Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association
#   Written by K.Nakahira
#
#  This program is licensed under the GNU GPL.
#  See the following URL for more details:
#    http://www.gnu.org/licenses/gpl.txt
#

package DBIPgSystem;
require 5.005;

use strict;
use AutoLoader;
use Jcode;
$CGI::POST_MAX = 30_000_000;				# 30MB

use DBSession;
use DBIPgSystem::DB;
use DBIPgSystem::Passwd;

use vars qw(@ISA @EXPORT $VERSION $DEBUG $ERROR);
$VERSION = '2.001';

require Exporter;
@ISA = qw(DBIPgSystem::DB Exporter AutoLoader);
@EXPORT = qw();

=for html
<div class="header">
<div class="bar">
<a href="../index.html">Top</a>
<a href="index.html">ޥ˥奢</a>
</div>
<h1>DBIPgSystem.pm</h1></div>

=for html
<div class="pod">

=head1 NAME

DBIPgSystem - Postgre SQL Ȥäǡ١ƥ

=head1 DESCRIPTION

Postgre SQL + CGI Ȥäƥǡ١ñ˹ԤΥƥࡣ
ǡɲáCSVե/ֶڤեɤ߽񤭡
ǡθʤɤԤ

=head2 METHODS --- API

=over 4

=cut

my %SQLMETA =
  ( b => "\x08", f => "\x0C", n => "\x0A", r => "\x0D", t => "\x09" );

=item new ( CONFIG_FILE, GROUP, USER [,OPTION] )

  $dbs = DBIPgSystem->new($config_file, $group, $user, %opt);

    ARGS :
      config_file => STRING    # ǡե
      group => STRING          # 롼̾
      user => STRING           # 桼̾

    OPTION :
      debug => BOOLEAN         # true ʤХǥХå⡼
      test => BOOLEAN          # true ʤưƥȥ⡼
      nph => BOOLEAN           # true ʤ NPH

󥹥ȥ饯

=cut

sub new {
  my ($class, $conffile, $group, $user, %opt) = @_;

  $DEBUG = $opt{debug};
  my $dbi = DBIPgSystem::DB->new($conffile, $group, $user, %opt);
  my $self = $dbi;

  bless $self, $class;
  return $self;
}

1;

__END__

=item search ( [OPTION] )

  $dbs->search(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      cols => STRING           # ̾ (޶ڤ)
      srcsid => STRING         # åIDʸѡ
      where => STRING          # Ϥ WHERE
      and => STRING            # ʤ߸Ԥ
      v_where => STRING        # ѿ WHERE
      :* => STRING             # v_where ѿ
      page => NUM              # ɽڡ
      searchnum => NUM         # 1ڡɽǤ
      html => STRING           # ɽ HTML
      strict => BOOLEAN        # ̩ʸ
      usemeta => BOOLEAN       # оݤȤʤʸ᥿ʸȤư
      code_dist => STRING      # ʸɤμ̤Τ˻Ȥʸ
      order => STRING          # ORDER

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       list => ARRAYREF        # 
       page => NUM             # ڡֹ
       total => NUM            # 줿ǡ
       numpage => NUM          # ڡ
       searchnum => NUM        # = $qs->{searchnum}
       where => STRING         # Ϥ줿WHERE
       strict => BOOLEAN       # $qs->{strict} б
       join => STRING          # $qs->{join} б
       sql_from => STRING      # SELECTʸFROMJOIN
       sql_where => STRING     # SELECTʸWHERE
       v_qs => HASHREF         # $qs->{":*"} б
       html => STRING          # $qs->{html} б
       usemeta => BOOLEAN      # $qs->{usemeta} б
       srcsid => STRING        # åID
       cols => STRING          # $qs->{cols} б
       uri_qs => STRING        # URI꡼
       order => STRING         # $qs->{order} б

ǡθԤ

Υ֥롼̤ƸԤŪˡϡ5̤Ǥ롣

  1. ʥեफŪ˸ＰͿˡ
     $qs->{v_where} ͤϤηȤߤʤ
     ޤɬפ˱ $qs->{:*} ͤʤФʤʤ
     '*' Ŭڤʸˡ
  2. եफ鸡ＰľͿˡ
     1. ʳξǡ$qs->{direct} ͤ
     ηȤߤʤ
     ξ硢$qs->{where} ͤʤФʤʤ
  3. URI꡼鸡ＰľͿˡ
     1,2. ʳξǡ$session ͤʤϤηȤߤʤ
     ξ硢$qs->{where} ͤʤФʤʤ
  4. ʤ߸Τ˸ＰľͿˡ
     1,2,3. ʳξǡ$qs->{and} ͤϡηȤߤʤ
     ξ硢$qs->{srcsid}, $qs->{where} ͤʤФʤʤ
  5. ʸ̤ΥڡѤȤʤɡˡƱͿˡ
     1,2,3,4. ʳξϡηȤߤʤ
     $qs->{srcsid} ͤʤФʤʤ

1 ξΤ usemeta ͤ˻Ȥ롣

̤եͤǼ뤿ˡåѤ롣
郎Ѥ1,2,3 ξˤǤϡ
ＰβϤ鿷å롣
4, 5 ξǤϰ˺줿å󤫤鸡Ｐɤ߹ࡣ
5 ξΤߡＰϤʤ

$qs->{cols} ˤϡ$self->{db}{sql_cols} Υꤹ뤳ȡ
ꤷʤ 'default' 롣
$qs->{join} ˤϡ$self->{db}{sql_join} Υꤹ뤳ȡ
ꤷʤ JOINϤʤȤߤʤ

Ϥǡ $list ϡؤΥե󥹤ǡ
Ǥ $qs->{cols} б륫बǼ줿Ȥʤ롣

åˤϼѿݻ :
$v_qs, $cols, $qs->{where}, $sql_where, $qs->{html},
$qs->{strict}, $qs->{usemeta}, $total

Ｐ̵ط $qs->{page}  $qs->{searchnum} ϥå
ݻʤΤǡŬͤꤹɬפ롣
$qs->{searchnum} ξ¤ $opt{searchnum_max} Ƿ
ʥǥեͤ 1000ˡ

=cut

sub search {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  $opt{searchnum_max} ||= 1000;
  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  my $primary = $self->{global}{primary};

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam
	($query, $opt{param}, 'srcsid=s', 'cols=s', 'where=s', 'direct!', 'and!',
	 'v_where=s', 'join=s', 'page=i', 'searchnum=i', 'order=s', 'html=s',
	 'strict!', 'usemeta!');
  $qs->{page} ||= 1;
  $qs->{searchnum} ||= $self->{global}{searchnum};
  $qs->{searchnum} = $opt{searchnum_max}
	if($qs->{searchnum} > $opt{searchnum_max});

  # åǡɤ߹
  my $srcsid = $qs->{srcsid};
  $self->fatal_error("The parameter is invalid")
	unless($qs->{v_where} or $qs->{where} or $srcsid);
  $self->fatal_error("'srcsid' must be defined")
	if($qs->{and} and $srcsid eq '');
  my $session;
  if($srcsid) {
	$session = $self->_session_connect('search', $srcsid);
	$qs->{html} = $session->read('html') if($qs->{html} eq '');
  }
  $qs->{html} = 'default' if($qs->{html} eq '');
  my $html = $self->{template}{search}{ $qs->{html} };
  $self->print_error('query-title', 'query', 'html', html => $qs->{html})
	unless(defined $html);

  # SELECT ޥɤν
  my ($v_qs, $where_in, $noparse);
  my $usealias = 1;

  undef $qs->{and} if($qs->{where} =~ m/^\s*$/);

  # ̤ΥեफθƤӽФξ
  if($qs->{v_where}) {
	undef $session;
	undef $qs->{direct};
	undef $qs->{and};
	undef $qs->{where};
	$usealias = 0;

	# v_where (ѿ WHERE) ѡ
	my ($v_qs_en, $isescape);
	my $qs_name = [ $query->param ];
	foreach my $key (@$qs_name) {
	  next unless($key =~ s/^://);
	  $v_qs->{$key} = $query->param(":$key");
	  $self->infilter(\$v_qs->{$key}, printerror => 1);
	  $v_qs->{$key} =~ s/^\s*//;
	  $v_qs->{$key} =~ s/\s*$//;
	  $v_qs_en->{$key} = $v_qs->{$key};
	  # פ
	  $self->_pgsqlunpack(\$v_qs_en->{$key});
	}
	($where_in = $qs->{v_where}) =~ s/#\{([^}]+)\}/$v_qs_en->{$1}/ge;
	$where_in =~ s/#!\{([^}]+)\}/$v_qs->{$1}/ge;
  }
  # ＰեURI꡼ľܻꤵ줿
  elsif($qs->{direct} or not $session) {
	undef $session;
	undef $qs->{and};
	$where_in = $qs->{where};
	unless($qs->{direct}) {
	  $qs->{strict} = 1;
	  $usealias = 0;
	}
  }
  # ʤ߸ξ
  elsif($qs->{and}) {
	$where_in = $qs->{where};
  }
  # ƱǸԤ
  else {
	$noparse = 1;
  }

  # $cols μ
  $qs->{cols} = $session ? $session->read('qs_cols') : 'default'
	unless(defined $qs->{cols});
  my $cols = $self->{db}{sql_cols}{ $qs->{cols} };
  $self->print_error('query-title', 'query', 'cols', qs_cols => $qs->{cols})
	unless(defined $cols);

  my $usemeta = $qs->{v_where} ? $qs->{usemeta} : 1;
  my $strict = $qs->{strict};
  my $sql;
  ($sql, $v_qs, $qs->{strict}, $qs->{usemeta}, $qs->{join}, $qs->{where}) =
	$session->read('sql', 'v_qs', 'strict', 'usemeta', 'qs_join',
				   'qs_where') if($session);

  # $sql->{order} μ
  if($qs->{order}) {
	$sql->{order} = $self->_get_order($qs->{order})
	  or $self->print_error
		('query-title', 'query', 'order', qs_order => $qs->{order});
  } else {
	$sql->{order} = $self->{db}{sql_default_order};
  }

  # WHEREѡ
  my ($parsed_where, $parse_error);
  unless($noparse) {
	($parsed_where, $parse_error) = $self->_make_cond_sentence
	  ($where_in, strict => $strict,
	   allow_null => ($qs->{v_where} ? 1 : 0), and => $qs->{and},
	   usemeta => $usemeta, direct => ($qs->{v_where} ? 0 : 1),
	   usealias => $usealias);
	if($parse_error) {
	  $parse_error = $self->get_errmsg
		($parse_error,
		 cond => (defined($parsed_where) ? $parsed_where : $where_in));
	}
  }

  # $sql 
  unless($session) {
	$sql->{where} = $parse_error ? '' : $parsed_where;
	$sql->{join} = $qs->{join} ? $self->{db}{sql_join}{ $qs->{join} } : '';
	$self->print_error('query-title', 'query', 'join', qs_join => $qs->{join})
	  unless(defined $sql->{join});
  }
  $sql->{where} = $parse_error ? $sql->{where} :
	"( $sql->{where} ) AND ( $parsed_where )" if($qs->{and});

  my $sql_from = "\"$primary\" $sql->{join}";
  $sql->{limit} = "$qs->{searchnum} OFFSET "
	. (($qs->{page} - 1) * $qs->{searchnum});
  my ($total, $list) =
	$self->SUPER::search($cols, $sql) unless($parse_error);

  # 郎Ŭڤä
  if($parse_error or not defined($total)) {
	my $errmsg = $parse_error ? $parse_error :
	  $self->get_errmsg('cond', cond => $qs->{where} || $sql->{where});
	$self->add_log
	  ('SelectError', $errmsg, where_in => $where_in,
	   sql_where => $sql->{where}, strict => $strict, and => $qs->{and});
	return ($html,
			{ list => [ ], page => 1, total => 0, numpage => 1,
			  searchnum => $qs->{searchnum}, sql_from => $sql_from,
			  where => $qs->{where}, strict => $qs->{strict},
			  join => $qs->{join}, sql_where => $sql->{where},
			  errmsg => $errmsg, v_qs => $v_qs,
			  html => $qs->{html}, usemeta => $qs->{usemeta},
			  srcsid => $srcsid, cols => $qs->{cols},
			  order => $sql->{order} });
  }

  # å
  delete $sql->{limit};
  if($qs->{order} or not $noparse) {
	$session = $self->_session_connect('search');
	$srcsid = $session->id;
	$session->data
	  (v_qs => $v_qs, sql => $sql, sql_cols => $cols, qs_cols => $qs->{cols},
	   qs_join => $qs->{join}, qs_where => $qs->{where}, html => $qs->{html},
	   strict => $qs->{strict}, usemeta => $qs->{usemeta}, total => $total);
  }
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  # URI Υ꡼
  my $uri_code = $self->{global}{code_dist}{ $self->{userinfo}{group} };
  $uri_code =~ s/([^\w ])/'%'.unpack('H2',$1)/ge;   $uri_code =~ s/ /+/g;
  my $uri_w = $sql->{where};
  $uri_w =~ s/([^\w ])/'%'.unpack('H2',$1)/ge;   $uri_w =~ s/ /+/g;
  my $uri_qs = "where=$uri_w&code_dist=$uri_code";
  if($qs->{join}) {
	my $uri_j = $qs->{join};
	$uri_j =~ s/([^\w ])/'%'.unpack('H2',$1)/ge;   $uri_j =~ s/ /+/g;
	$uri_qs .= "&join=$uri_j";
  }

  # ̤ν
  $self->add_log('Select', "Successful", uri_qs => $uri_qs) unless($noparse);
  my $numpage = int(($total + $qs->{searchnum} - 1) / $qs->{searchnum});
  return ($html,
		  { list => $list, page => $qs->{page}, total => $total,
			numpage => $numpage, searchnum => $qs->{searchnum},
			where => $qs->{where}, strict => $qs->{strict},
			join => $qs->{join}, sql_from => $sql_from,
			sql_where => $sql->{where}, v_qs => $v_qs,
			html => $qs->{html}, usemeta => $qs->{usemeta},
			srcsid => $srcsid, cols => $qs->{cols}, uri_qs => $uri_qs,
			order => $sql->{order} });
}

=item search_detail ( [OPTION] )

  $dbs->search_detail(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      page => NUM              # ڡֹ
      revise => BOOLEAN        # ǡν
      srcsid => STRING         # åIDʸѡ
      did => NUM               # system_did
      rid => NUM               # system_rid
      actid => NUM             # actid

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       list => ARRAYREF        # 

ǡξܺɽΤνԤ
ޤϡǡνԤνԤ
$qs->{did} ޤ $qs->{rid} ͤǼƤɬפ롣
ξͤϡ$qs->{rid} ͥ褹롣
$qs->{did} ꤵƤȡ
б DID ΥǡΤ֤ active ΤΤϤ롣
$qs->{rid} ꤵƤȡб RID ΥǡϤ롣

$qs->{revise}  true ΤȤϡǡνȤߤʤ
åʤɤν򤹤롣

$qs->{actid} ϡͭʥǡѲäɤĴ٤뤿˻Ȥ롣
$qs->{actid} ꤵƤ硢ǡξ塢
ΥǡƱ DID Ǿ֤ͭʥǡ RID
(Ǥ ACTID ȸƤ) 򸡺롣
бͭʥǡʤ ACTID ʸ 'null' Ȥ롣
ACTID  $qs->{actid} Ȱۤʤˤϥ顼Ф
ACTID ѤСܺٲ̤ɽΥǡν򳫻ϤޤǤδ֤
ǡѲäȤΤ뤳ȤǤ롣

=cut

sub search_detail {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # FORM ǡ
  my $qs = $self->_getparam
	($query, $opt{param}, 'page=i', 'revise!', 'srcsid=s', 'did=i', 'rid=i',
	 'actid=s', 'html=s');
  $self->fatal_error("The query is invalid: either did or rid must be defined")
	if($qs->{did} eq '' and $qs->{rid} eq '');
  undef $qs->{did} if(defined $qs->{rid});
  $qs->{page} ||= 1;
  my $html = $qs->{revise} ? $self->get_template_insert(1) :
	$self->get_template_detail($qs->{page});
  if(defined $qs->{html}) {
	$html = $self->{template}{detail_other}{ $qs->{html} };
	$self->print_error('query-title', 'query', 'html', html => $qs->{html})
	  unless(defined $html);
  }
  $self->fatal_error("'page' is invalid", page => $qs->{page})
	unless(defined $html);

  $self->fatal_error
	("'actid' is invalid", rid => $qs->{rid}, actid => $qs->{actid})
	  if($qs->{rid} ne '' and $qs->{actid} !~ m/^(|\d+|null)$/);
  $qs->{actid} = undef if($qs->{actid} =~ m/^(|null)$/);

  my $rid;
  if(defined $qs->{did}) {
	$rid = $self->selectrow_array
	  ($self->selectcmd
	   ('system_rid', where => "system_did = $qs->{did} AND "
		. "system_state = $self->{db}{sysstate}{active}"));
	$self->print_error('nulldata-title', 'nulldata') if($rid eq '');
  } else {
	$rid = $qs->{rid};
  }

  # ¹
  my ($data, $system, $presys) =
	$self->SUPER::search_detail($rid, $qs->{revise});

  # actidʸǡƱ DID ͭʥǡ RIDˤ
  my $actid;
  if($qs->{did} ne '') {
	$actid = $rid;
  } else {
	$actid = $self->selectrow_array
	  ($self->selectcmd
	   ('system_rid', where => "system_did = $system->{system_did} "
		. "AND system_state = $self->{db}{sysstate}{active}"));
	$actid = 'null' unless(defined $actid);
  }
  $self->print_error('insert-title', 'insert')
	if(defined($qs->{actid}) and $qs->{actid} ne $actid);

  my $inssid;
  my $vpage = [ ];
  my ($error, $warning) = ([ ], [ ]);

  if($qs->{revise}) {
	# actid Υåsystem_did μ
	push(@$vpage, map { 1 } (1 .. $self->{template}{numpage_insert}));
	my $cpage = $self->get_colpage();
	my $errwarn = $self->get_errwarn($data, $cpage);

	# å
	my $session = $self->_session_connect('insert');
	$inssid = $session->id;
	$session->data
	  (data => $data, presys => $presys, system => $system, vpage => $vpage,
	   actid => $actid, cpage => $cpage, errwarn => $errwarn);
	eval { undef $session };
	$self->fatal_error("Session error") if($@);

	foreach my $dbt (keys %{ $errwarn->{error} }) {
	  foreach my $e (@{ $errwarn->{error}{$dbt} }) {
		foreach my $key (keys %$e) { push(@$error, @{ $e->{$key} }); }
	  }
	}
	foreach my $dbt (keys %{ $errwarn->{warning} }) {
	  foreach my $w (@{ $errwarn->{warning}{$dbt} }) {
		foreach my $key (keys %$w) { push(@$warning, @{ $w->{$key} }); }
	  }
	}
  }

  return ($html,
		  { data => $data, system => $system, revise => $qs->{revise},
			srcsid => $qs->{srcsid}, actid => $actid, inssid => $inssid,
			vpage => $vpage, islast => 1, page => $qs->{page}, error => $error,
			warning => $warning, presys => $presys });
}

=item db2file ( [OPTION] )

  $dbs->db2file(%opt);

    OPTION :
      filename => STRING       # Ϥե̾
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      srcsid => STRING         # åIDʸѡ
      type => STRING           # Ϥեη
      newline => STRING        # եβԥ
      code => STRING           # եʸ (sjis|jis|euc)

ǡե˽񤭽Ф
$qs->{srcsid} ͤǼƤʤФʤʤ

եʸɤ $qs->{code} ˤäƷޤ롣
ޤԥɤ $qs->{newline}  "CR" ʤ \x0D,
"CRLF" ʤ \x0D\x0A, ʳʤ \x0A ˤʤ롣

=cut

sub db2file {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam
	($query, $opt{param}, 'srcsid=s', 'type=s', 'newline=s', 'code=s');
  $qs->{type} ||= 'csv';
  $qs->{code} = 'sjis' unless(defined $qs->{code});

  my $newline = $qs->{newline} =~ m/^CRLF$/i ? "\x0D\x0A"
	: $qs->{newline} =~ m/^CR$/i ? "\x0D" : "\x0A";
  my $outfilter;
  if($qs->{code} =~ m/^SJIS$/i) {
	$outfilter = sub {
	  ${ $_[0] } =~ s/(\x0D\x0A|\x0D|\x0A)/$newline/g;
	  ${ $_[0] } = jcode(${ $_[0] }, 'euc')->sjis; };
  } elsif($qs->{code} =~ m/^JIS$/i) {
	$outfilter = sub {
	  ${ $_[0] } =~ s/(\x0D\x0A|\x0D|\x0A)/$newline/g;
	  ${ $_[0] } = jcode(${ $_[0] }, 'euc')->jis; };
  } elsif($qs->{code} =~ m/^EUC$/i) {
	$outfilter = sub {
	  ${ $_[0] } =~ s/(\x0D\x0A|\x0D|\x0A)/$newline/g; };
  } else {
	$self->fatal_error("The query 'code' is invalid",
					  code => $qs->{code});
  }

  # åǡɤ߹
  my $session = $self->_session_connect('search', $qs->{srcsid});
  my $sql = $session->read('sql') or $self->fatal_error('session');

  # ե
  $opt{filename} =~ s/##/$qs->{type}/g;
  my $sqlcmd =
	$self->SUPER::db2file($sql, $opt{filename}, $qs->{type},
						  add_out_head => 1, outfilter => $outfilter);

  $self->add_log('DB2File', "Successful", sqlcmd => $sqlcmd);
}

=item remove_data ( [OPTION] )

  $dbs->remove_data(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      noverify => BOOLEAN      # invalid ˤʳǧ򤷤ʤ
      rid => NUM               # invalid ˤǡ system_rid
      srcsid => STRING         # åIDʸѡ
      :* => STRING             # ơ֥Υ

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       total => NUM            # оݤȤʤǡ
       join => STRING          # JOIN
       where => STRING         # WHERE
       rid => NUM              # $qs->{rid} Ʊ
       srcsid => STRING        # $qs->{srcsid} Ʊ

ǡξ̵֤ˤ롣
$qs->{noverify}  false ΤȤϡcommit ޥɤ¹Ԥ
åΤߤԤ

$qs->{rid} ꤵƤȤϡб system_rid Υǡ̵ˤ롣
ʤХåǡSQLʸȤ롣

$qs->{:*} ꤵƤȤϡ˻Ȥ WHERE "̾ = ''"
 AND Ƿ礷äƺǡ˾դ롣
ʣ $qs->{:*} ꤹ뤳ȤǤ롣

=cut

sub remove_data {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # FORM ǡ
  my $qs = $self->_getparam
	($query, $opt{param}, 'noverify!', 'rid=i', 'srcsid=s');
  my $html = $self->{template}{remove}{
	$qs->{noverify} ? 'noverify' : 'verify' };

  my $total = 1;
  my $sql;
  if(defined $qs->{rid}) {
	$sql->{where} = "system_rid = $qs->{rid}";
  } else {
	# åǡɤ߹
	my $session = $self->_session_connect('search', $qs->{srcsid});
	($sql, $total) = $session->read('sql', 'total');
  }

  my @qname = $query->param;
  my ($value, $qs_prim);
  foreach my $name (@qname) {
	next unless($name =~ s/^://);
	$self->fatal_error("name ( = '$name' ) is invalid")
	  unless(exists $self->{dbseq}{ $self->{global}{primary} }{$name});
	$value = $query->param(":$name");
	$self->infilter(\$value, printerror => 1);
	$qs_prim->{$name} = $value;
  }

  $self->SUPER::remove_data
	($sql, $total, $qs_prim, rollback => (not $qs->{noverify}));

  $self->add_log('RemoveData', "Successful", total => $total,
				sql => $self->selectcmd('*', %$sql, order => ''))
	if($qs->{noverify});
  return ($html,
		  { total => $total, join => $sql->{join}, where => $sql->{where},
			rid => $qs->{rid}, srcsid => $qs->{srcsid} });
}

=item start_insert ( [OPTION] )

  $dbs->start_insert(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      srcsid => STRING         # åIDʸѡ

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       data => HASHREF         # ǡξ ( = { } )
       system => HASHREF       # ƥξ ( = { } )
       revise => BOOLEAN       # true ʤХǡν ( = 0 )
       inssid => STRING        # åIDѡ
       error => ARRAYREF       # 顼ξ ( = [ ] )
       warning => ARRAYREF     # ٹξ ( = [ ] )
       page => NUM             # ڡֹ ( = 1 )
       islast => BOOLEAN       # ɽڡνä
                               # ڡν 1
       srcsid => STRING        # $qs->{srcsid} Ʊ
       vpage => ARRAYREF       # ƥڡѤߤɤ򼨤 ( = [ ] )

åꡢɲѤΥڡ1ڡܤ֤
ʥ֥饦ΡפΤ褦ʥܥ򲡤줿Ȥưͤȡ
ʣڡˤ錄äƥǡɲäԤϡ
Υ᥽åɤƤӽФ٤Ǥ롣

=cut

sub start_insert {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};

  # FORM ǡ
  my $qs = $self->_getparam($query, $opt{param}, 'srcsid=s');

  $self->check_permission('start_insert');

  # å
  my $session = $self->_session_connect('insert');
  my $inssid = $session->id;
  my $cpage = $self->get_colpage();
  $session->data(vpage => [ ], data => { }, presys => { }, system => { },
				 cpage => $cpage);
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  my $html = $self->get_template_insert(1);
  my $islast = 1 if($self->{template}{numpage_insert} == 1);

  return ($html,
		  { data => { }, system => { }, revise => 0, inssid => $inssid,
			error => [ ], warning => [ ], page => 1, islast => $islast,
			srcsid => $qs->{srcsid}, vpage => [ ] });
}

=item data_check ( [OPTION] )

  $dbs->data_check(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      code_dist => STRING      # ʸɤμ̤Τ˻Ȥʸ
      verify => BOOLEAN        # true ʤγǧ
      inssid => STRING         # åIDѡ
      page => NUM              # ƤӽФΥڡΥڡֹ
      system_state => STRING   # system_state
      noencoded => BOOLEAN     # false ʤ code Υǡϥ󥳡ɺѤ
      nextpage:*               # ɽڡ'*' ϥڡֹ
      :* => STRING             # ơ֥Υ
      :*:*:* => STRING         # Ϣơ֥Υ
      :*:select => STRING      # եΥåץѡʼơ֥
                               # unchange or restore or file or none
      :*:*:*:select => STRING  # եΥåץѡʴϢơ֥
      :*:insert:* => NUM       # Ϣơ֥Υ쥳ɤ̤ΰ֤
      :*:delete:* => BOOLEAN   # Ϣơ֥Υ쥳ɤ

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       data => HASHREF         # ǡξ
       presys => HASHREF       # ΥǡΥƥξ
       system => HASHREF       # ƥξ
       revise => BOOLEAN       # ǡνʤ 1
       inssid => STRING        # åIDѡ
       error => ARRAYREF       # 顼ξ
       warning => ARRAYREF     # ٹξ
       page => NUM             # ڡֹ
       islast => BOOLEAN       # ɽڡνä
                               # ڡν 1
       srcsid => STRING        # $qs->{srcsid} Ʊ
       vpage => ARRAYREF       # ƥڡѤߤɤ򼨤 ( = [ ] )
       errwarn => HASHREF      # 顼ȷٹξ
       restore => HASHREF      # åץɤ줿ե

ǡ/ɲä뤿νԤdraftѤΥơ֥˥ǡ롣

$system->{system_did} ǤʤХǡνȤߤʤ
ξ硢̾糧å actid ͡search_detail ȡ
ǼƤϤǤ롣
actid ͤСǥǡѹʤȤݾڤ뤿ˡ
ͤåưפȤΤ߽³롣

staff θ¤ʤ $qs->{system_state}  active ǤäƤϤʤʤ

=cut

sub data_check {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam
	($query, $opt{param}, 'verify!', 'inssid=s', 'page=i', 'system_state=i',
     'srcsid=s', 'noencoded!');
  $qs->{page} = 1 unless($qs->{page});

  my $inssid = $qs->{inssid};

  # åǡɤ߹
  my $session = $self->_session_connect('insert', $inssid);
  my ($data, $errwarn, $restore, $presys, $system, $vpage, $actid, $cpage) =
	$session->read('data', 'errwarn', 'restore', 'presys', 'system', 'vpage',
				   'actid', 'cpage');
  $restore ||= { };
  $errwarn = { error => { }, warning => { } } unless($errwarn);

  # 桼, ڡ
  my $qsdata;
  my $cmd = { };
  my $primary = $self->{global}{primary};
  my $re_sel = qr{^(unchange|restore|file|none)$};
  my @qname = $query->param;
  foreach my $name (@qname) {
	if($name =~ m/^nextpage:(\d+)$/) {
	  $qs->{nextpage} = $1 < $self->{template}{numpage_insert} ?
		$1 : $self->{template}{numpage_insert};
	  next;
	}
	next if($name !~ m/^:/);
	# $qsdata  $self->data_check ᥽åɤ infilter ˤ뤿ᡢ
	# Ǥ̤
	if($name =~ m/^:([^:?]+)(?:\?(.+))?$/) {
	  if($2 eq '') {
		$qsdata->{$primary}[0]{$1} = $query->param($name);
	  } elsif(not defined($qsdata->{$primary}[0]{$1}) or
			  ref($qsdata->{$primary}[0]{$1}) eq 'HASH') {
		$qsdata->{$primary}[0]{$1}{$2} = $query->param($name);
	  }
	} elsif($name =~ m/^:([^:?]+):select$/) {
	  # $cmd->{select} ɤ߹ߡå
	  my $val = $cmd->{select}{$primary}{$1} = $query->param($name);
	  $self->fatal_error("select cmd is invalid", val => $val)
		if($val !~ m/$re_sel/);
	} elsif($name =~ m/^:([^:?]+):(\d+):([^:?]+)(?:\?(.+))?$/) {
	  if($4 eq '') {
		$qsdata->{$1}[$2-1]{$3} = $query->param($name);
	  } elsif(not defined($qsdata->{$1}[$2-1]{$3}) or
			  ref($qsdata->{$1}[$2-1]{$3}) eq 'HASH') {
		$qsdata->{$1}[$2-1]{$3}{$4} = $query->param($name);
	  }
	} elsif($name =~ m/^:([^:?]+):(\d+):([^:?]+):select$/) {
	  # $cmd->{select} ɤ߹ߡå
	  my $val = $cmd->{select}{$1}[$2-1]{$3} = $query->param($name);
	  $self->fatal_error("select cmd is invalid", val => $val)
		if($val !~ m/$re_sel/);
	} elsif($name =~ m/^:([^:?]+):insert:(\d+)$/) {
	  my ($k, $i) = ($1, $2);
	  # $cmd->{insert} ɤ߹ߡå
	  $cmd->{insert}{$k}[$i] = $query->param($name);
	  $self->fatal_error("insert cmd is invalid",
						name => $name, value => $cmd->{insert}{$k}[$i])
		if($cmd->{insert}{$k}[$i] =~ m/^\d+$/ and
		   ($cmd->{insert}{$k}[$i] < 1 or $cmd->{insert}{$k}[$i] >= $i));
	} elsif($name =~ m/^:([^:?]+):delete:(\d+)$/) {
	  my ($k, $i) = ($1, $2);
	  $cmd->{delete}{$k} = [ ] unless(defined $cmd->{delete}{$k});
	  push(@{ $cmd->{delete}{$k} }, $i) if(scalar $query->param($name));
	}
  }

  # ƥ
  $system->{system_state} = $self->{db}{sysstate}{wait}
	unless(defined $system->{system_state});
  if(defined $qs->{system_state}) {
	$system->{system_state} = $qs->{system_state};
	$self->print_error('query-title', 'query', "system_state",
					  system_state => $qs->{system_state})
	  if($qs->{system_state} ne $self->{db}{sysstate}{active} and
		 $qs->{system_state} ne $self->{db}{sysstate}{wait});
	$self->fatal_error("'system_state' is invalid")
	  if(not $self->{userinfo}{staff} and
		 $qs->{system_state} eq $self->{db}{sysstate}{active});
  }

  # actid Υå
  if(defined $actid and $actid ne 'null') {
	$self->fatal_error("'system_did' is invalid")
	  if($system->{system_did} eq '');
	my $actid_ = $self->selectrow_array
	  ($self->selectcmd
	   ('system_rid', where => "system_did = $system->{system_did} "
		. "AND system_state = $self->{db}{sysstate}{active}"));
	$self->print_error('insert-title', 'insert', "actid",
					  actid_ => $actid_, actid => $actid)
	  if($actid_ ne $actid);
  }

  $vpage->[ $qs->{page}-1 ] = 1 if($qsdata);
  my $islast = 1;
  foreach my $i (1 .. $self->{template}{numpage_insert}) {
	unless($vpage->[$i-1]) { $islast = 0; last; }
  }

  # ǡΥå
  $self->SUPER::data_check
	($data, $qsdata, $errwarn, $system, $cmd, $cpage, $qs->{page},
	 $restore, islast => $islast, noencoded => $qs->{noencoded})
	  if($qsdata);

  my $page = $qs->{nextpage} || $qs->{page};
  my $html_verify = $self->{template}{insert_verify};
  my $html = $self->get_template_insert($page) || $html_verify;
  unless($islast) {
	$islast = 1;
	foreach my $i (1 .. $self->{template}{numpage_insert}) {
	  unless($vpage->[$i-1] or $i == $page) { $islast = 0; last; }
	}
  }

  # 顼ȷٹν
  my $error = [ ];
  foreach my $dbt (keys %{ $errwarn->{error} }) {
	foreach my $e (@{ $errwarn->{error}{$dbt} }) {
	  foreach my $key (keys %$e) { push(@$error, @{ $e->{$key} }); }
	}
  }
  my $warning = [ ];
  foreach my $dbt (keys %{ $errwarn->{warning} }) {
	foreach my $w (@{ $errwarn->{warning}{$dbt} }) {
	  foreach my $key (keys %$w) { push(@$warning, @{ $w->{$key} }); }
	}
  }

  my $verify;
  if($qs->{verify}) {
	# å
	my $err = $self->data_verify_check($data, $presys, $system);
	push(@$error, { cols => [ ], msg => $self->get_errmsg($err) }) if($err);

	unless(@$error) {
	  $self->fatal_error("The parameter 'verify' is invalid",
						page => $qs->{page}, vpage => join(',', @$vpage))
		unless($islast);
	  $html = $html_verify;
	  $page = $self->{template}{numpage_insert} + 1;
	  $verify = 1
	}
  }

  # åν
  $session->data
	(vpage => $vpage, data => $data, system => $system, errwarn => $errwarn,
	 restore => $restore, verify => $verify) if($qsdata);
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  return ($html,
		  { data => $data, revise => ($system->{system_did} ne '' ? 1 : 0),
			inssid => $inssid, presys => $presys, system => $system,
			error => $error, warning => $warning, page => $page,
			islast => $islast, srcsid => $qs->{srcsid}, vpage => $vpage,
			errwarn => $errwarn, restore => $restore });
}

=item data_insert ( [OPTION] )

  $dbs->data_insert(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      inssid => STRING         # åIDѡ
      system_state => STRING   # system_state
      srcsid => STRING         # åIDʸѡ

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       # 顼ä data_check ᥽åɤ RET Ʊ͡
       # ʲǤϡ顼ʤäͤ򼨤
       rid => NUM              # ǡ RID
       revise => BOOLEAN       # ǡνʤ 1
       srcsid => STRING        # $qs->{srcsid} Ʊ

ǡܥơ֥˽/ɲä롣ޤϥ󥻥뤹롣

$qs->{inssid} ͤǼƤɬפ롣
åǡ did ͤХǡνȤߤʤ

ǡνξϡdata_check᥽åɤƱͤ actid ΥåԤ

=cut

sub data_insert {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # FORM ǡ
  my $qs = $self->_getparam
	($query, $opt{param}, 'inssid=s', 'system_state=i', 'srcsid=s');

  # åǡɤ߹
  $self->print_error('query-title', 'query', "'inssid' must be defined")
	unless($qs->{inssid});
  my $session = $self->_session_connect('insert', $qs->{inssid});
  my ($data, $presys, $system, $actid, $errwarn, $verify) =
	$session->read('data', 'presys', 'system', 'actid', 'errwarn', 'verify');
  $self->fatal_error("\$verify is invalid") unless($verify);
  my $revise = $system->{system_did} ne '' ? 1 : 0;

  # ƥ
  if(defined $qs->{system_state}) {
	$system->{system_state} = $qs->{system_state};
	$self->print_error('query-title', 'query', "system_state",
					  system_state => $qs->{system_state})
	  if($qs->{system_state} ne $self->{db}{sysstate}{active} and
		 $qs->{system_state} ne $self->{db}{sysstate}{wait});
	$self->fatal_error("'system_state' is invalid")
	  if(not $self->{userinfo}{staff} and
		 $qs->{system_state} eq $self->{db}{sysstate}{active});
  }

  # actid Υå
  if(defined $actid and $actid ne 'null') {
	$self->fatal_error("'system_did' is invalid")
	  if($system->{system_did} eq '');
	my $actid_ = $self->selectrow_array
	  ($self->selectcmd('system_rid',
					   where => "system_did = $system->{system_did} AND "
					   . "system_state = $self->{db}{sysstate}{active}"));
	$self->print_error('insert-title', 'insert', "actid",
					  actid_ => $actid_, actid => $actid)
	  if($actid_ ne $actid);
  }

  # ǡܥơ֥
  my ($rid, $err) = $self->SUPER::data_insert
	($data, $presys, $system, $errwarn, inssid => $qs->{inssid});

  my ($restore, $vpage);
  if($err) {
	# ǡɲ/̤
	my $error = [ ];
	push(@$error, { cols => [ ], msg => $self->get_errmsg($err) });
	foreach my $dbt (keys %{ $errwarn->{error} }) {
	  foreach my $e (@{ $errwarn->{error}{$dbt} }) {
		foreach my $key (keys %$e) { push(@$error, @{ $e->{$key} }); }
	  }
	}
	my $warning = [ ];
	foreach my $dbt (keys %{ $errwarn->{warning} }) {
	  foreach my $w (@{ $errwarn->{warning}{$dbt} }) {
		foreach my $key (keys %$w) { push(@$warning, @{ $w->{$key} }); }
	  }
	}
	($restore, $vpage) = $session->read('restore', 'vpage');

	return ($self->{template}{insert_verify},
			{ data => $data, revise => $revise, inssid => $qs->{inssid},
			  presys => $presys, system => $system, error => $error,
			  warning => $warning, page => 1, misc => $qs->{misc}, islast => 1,
			  srcsid => $qs->{srcsid}, vpage => $vpage, errwarn => $errwarn,
			  restore => $restore });
  }

  # å
  eval { $session->remove };
  $self->fatal_error("Session error") if($@);

  return ($self->{template}{insert_success},
		  { rid => $rid, revise => $revise, srcsid => $qs->{srcsid} });
}

=item file_check ( [OPTION] )

  $dbs->file_check(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )
      read_unit => NUM         # ԥɤĴ٤ȤΥѥ᡼
      num_large => NUM         # вɽ뤿ɬפʥǡ

    QUERY :
      remove_head => BOOLEAN   # 1ܤإåȤߤʤ̵뤹
      revise => BOOLEAN        # 1(0)ʤХǡν(ɲ)
      system_state => NUM      # system_state
      type => STRING           # եη'csv' or 'tab', ɬܡ
      file => FILE             # եɬܡ
      code_dist => STRING      # ʸɤμ̤Τ˻Ȥʸ

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       error => ARRAYREF       # 顼ξ
       warning => ARRAYREF     # ٹξ
       over => ARRAYREF        # ե˽ʣΤäǡΰ
       ignored => ARRAYREF     # ܥơ֥ΥǡȽʣǡΰ
       invalid => ARRAYREF     # 齤Τäǡΰ
       permission => ARRAYREF  # ʤäǡΰ
       num => HASHREF
         error => NUM          # 顼ޤǡη
         over => NUM           # @{ $ret->{over} } Ʊ
         ignored => NUM        # @{ $ret->{ignored} } Ʊ
         success => NUM        # 嵭ʳΡ˥ǡη
         warning => NUM        # ٹ𤬤ǡη
         noactive => NUM       # ǡνκ active ǤϤʤǡη
         invalid => NUM        # @{ $ret->{invalid} } Ʊ
         permission => NUM     # scalar @{ $ret->{permission} } Ʊ
         error_i => NUM        # 顼θĿ
         warning_i => NUM      # ٹθĿ
         total => NUM          # ǡ
       inssid => STRING        # åIDѡ
       revise => BOOLEAN       # ǡνʤ 1
       total_large => BOOLEAN  # вɽʤ 1

եɲä뤿νԤdraftѤΥơ֥˥ǡ롣

Υ᥽åɤǤϡꤵ줿եβԥɤʸɤĴ٤롣
θ塢եιԿ롣
Կ $opt{num_large} ۤϡ
$self->{template}{file_head} ɽ塢вɽ롣

 SUPER::file_check ɤ߽Фơ
1Ԥĥ顼åʤɤԤʤ draftѤΥơ֥롣
ǸˡåꡢdraftѤ RID ʤɤǼ롣

$qs->{code_dist} ϡե˵줿ʸʸɤ
뤿˻Ȥեʸɤμ̤ˤϻȤʤ

=cut

sub file_check {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  $opt{read_unit} ||= 2048;
  $opt{num_large} ||= 500;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam
	($query, $opt{param}, 'remove_head!', 'revise!', 'system_state=i',
	 'type=s');
  $self->fatal_error("The parameter 'type' is invalid",
					type => $qs->{type}) if($qs->{type} !~ m/^(csv|tab)$/);

  # ƥ
  my $system = { };

  # åץɤ줿ե򳫤
  my $file_ = $query->upload('file');
  $self->print_error('fileopen-title', 'file-nofile') unless($file_);
  my $file = $self->_cut_macbinary($file_, undef);
  $file = $file_ unless(defined $file);

  # եβԥ,ʸɤĴ٤
  my ($newline, $str, $str2, $buffer, $code);
  foreach (1 .. 10) {
	read($file, $buffer, $opt{read_unit}) or $buffer = "\x00";
	$str2 .= $buffer;
	$str .= $buffer;
	$str =~ s/"[^"]*"//g;
	if($str =~ m/^[^"]*(\x0D\x0A|\x0D[^\x0A]|\x0A)/) {
	  ($newline = $1) =~ s/[^\x0D\x0A]//g;
	  $code = &getcode($str2);
	  last;
	}
	last if($buffer eq "\x00");
  }
  $self->print_error('fileopen-title', 'fileopen', "newline")
	unless(defined $newline);
  seek($file, 0, 0);

  # եιԿĴ٤
  my ($total, $total_large);
  my $nl = $/;
  $/ = $newline;
  while(<$file>) {
	$_ .= <$file> while($qs->{type} eq 'csv' and tr/"// % 2);
	$total++;
  }
  $/ = $nl;
  $total-- if($qs->{remove_head});
  seek($file, 0, 0);

  $self->print_error('fileopen-title', 'fileopen')
	if(!$file and $query->cgi_error);

  if(not $opt{nohtml} and $total > $opt{num_large}) {
	$total_large = 1;
	$self->print_template
	  ($self->{template}{file_head},
	   { total => $total }, noexit => 1, status => '200 OK');
  }

  # å
  my $ret = $self->SUPER::file_check
	($file, $system, $qs->{type}, $newline, $qs->{revise}, $qs->{remove_head},
	 $qs->{system_state}, report => $total_large, code => $code);

  # å
  my $session = $self->_session_connect('import');
  my $inssid = $session->id;
  $session->data
	(draft_rid => $ret->{draft_rid}, num => $ret->{num},
	 addr => $ret->{addr}, revise => $qs->{revise},
	 total_large => $total_large);
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  return ($self->{template}{file_verify},
		  { num => $ret->{num}, error => $ret->{error},
			warning => $ret->{warning}, over => $ret->{over},
			ignored => $ret->{ignored}, invalid => $ret->{invalid},
			permission => $ret->{permission},
			inssid => $inssid, revise => $qs->{revise},
			total_large => $total_large });
}

=item file_insert ( [OPTION] )

  $dbs->file_insert(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      cancel => BOOLEAN        # 󥻥
      inssid => STRING         # åIDѡ

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       ins_ignored => ARRAYREF     # ܥơ֥ΥǡȽʣǡΰ
       ins_invalid => ARRAYREF     # 齤Τäǡΰ
       ins_permission => ARRAYREF  # ʤäǡΰ
       num => HASHREF
        ins_ignored => NUM     # @{ $ret->{ins_ignored} } Ʊ
        ins_invalid => NUM     # @{ $ret->{ins_invalid} } Ʊ
        ins_permission => NUM  # @{ $ret->{ins_permission} } Ʊ
       where_all => STRING     # 줿ǡ򸡺뤿WHERE
       revise => BOOLEAN       # ǡνʤ 1
       total_large => BOOLEAN  # вɽʤ 1

ǡܥơ֥ɲ/롣ޤϥ󥻥뤹롣

$qs->{inssid} ͤǼƤɬפ롣
å󤫤 draftѤΥơ֥˽񤭹ǡξɤ߹ߡ
draftѥơ֥бǡܥơ֥롣

cancel  true ξϡΥ󥻥Ȥߤʤ
file_check ᥽åɤ draftѤΥơ֥˽񤭹ǡ롣

=cut

sub file_insert {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));
  $self->print_error('permission-title', 'permission')
	unless($self->{userinfo}{staff} and $self->{global}{enable_file_insert});

  # FORM ǡ
  my $qs = $self->_getparam($query, $opt{param}, 'cancel!', 'inssid=s');

  # åǡɤ߹ߡå
  $self->print_error
	('query-title', 'query', "'inssid' must be defined")
	  unless($qs->{inssid});
  my $session = $self->_session_connect('import', $qs->{inssid});
  my ($draft_rid, $num, $addr, $revise, $total_large) =
	$session->read('draft_rid', 'num', 'addr', 'revise', 'total_large');
  eval { $session->remove };
  $self->fatal_error("Session error") if($@);

  # 󥻥ξ
  my $primary = $self->{global}{primary};
  if($qs->{cancel}) {
	foreach my $dbt (keys %{ $self->{dbcol} }) {
	  $self->do("DELETE FROM ${dbt}_dft WHERE draft_rid = $draft_rid");
	}
	return ($self->{template}{file_cancel}, { });
  }

  if($total_large and $num->{success}) {
	$self->print_template
	  ($self->{template}{file_head},
	   { total => $num->{success} }, noexit => 1, status => '200 OK');
  }

  # draftѤΥơ֥Υǡܥơ֥
  my $ret = $self->SUPER::file_insert
	($draft_rid, $addr, $revise, report => $total_large);

  $num->{success} = $ret->{num}{success};
  $num->{ins_ignored} = $ret->{num}{ignored};
  $num->{ins_invalid} = $ret->{num}{invalid};
  $num->{ins_permission} = $ret->{num}{permission};
  undef $num->{warning};
  undef $num->{warning_i};

  $self->add_log('FileInsert', "Successful", num_success => $num->{success});

  return ($self->{template}{file_success},
		  { num => $num, ins_ignored => $ret->{ignored},
			ins_invalid => $ret->{invalid},
			ins_permission => $ret->{permission},
			where_all => $ret->{where_all}, revise => $revise,
			total_large => $total_large });
}

=item start_update_passwd ( AUTHCONF )

  $dbs->start_update_passwd($authconf);

    ARGS :
      authconf => STRING       # 桼ե

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       col => HASHREF          # 桼
       passsid => STRING       # åIDʥ桼Ͽѡ
       update => BOOLEAN       # 桼ιʤ 1 ( = 1 )

桼ι򤹤Ԥ

=cut

sub start_update_passwd {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $authconf) = @_;

  # DBIPgSystem::Passwd
  my $dbpass = DBIPgSystem::Passwd->new($self, $authconf, debug => $DEBUG);

  $self->fatal_error("'\$self->{userinfo}{uid}' must be defined")
	unless(defined $self->{userinfo}{uid});
  my $col = $dbpass->readcol('uid', $self->{userinfo}{uid})
	or $self->fatal_error
	  ("'\$self->{userinfo}{uid}' is invalid: $self->{userinfo}{uid}");

  # å
  my $session = $self->_session_connect('dbpass');
  my $passsid = $session->id;
  $session->data(col => $col, update => 1);
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  my $html = $dbpass->{template}{registry_error};
  return ($html, { col => $col, passsid => $passsid, update => 1 });
}

=item registry_passwd_verify ( AUTHCONF [,OPTION] )

  $dbs->registry_passwd_verify($authconf, %opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    ARGS :
      authconf => STRING       # 桼ե

    QUERY :
      passsid => STRING        # åIDʥ桼Ͽѡ
      update => BOOLEAN        # 򤹤
      :*                       # 桼

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       col => HASHREF          # 桼
       passsid => STRING       # $qs->{passsid} Ʊ
       update => BOOLEAN       # $qs->{update} Ʊ
       error => ARRAYREF       # 顼ξ

桼Ͽ/桼ιγǧԤ
桼ι ( $qs->{update}  true ) ΤȤϡ
$self->{userinfo}{uid} ͤʤФʤʤ

=cut

sub registry_passwd_verify {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $authconf, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # DBIPgSystem::Passwd
  my $dbpass = DBIPgSystem::Passwd->new($self, $authconf, debug => $DEBUG);

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam($query, $opt{param}, 'passsid=s', 'update!');

  my $session;
  my $passsid = $qs->{passsid};
  my ($col, $update);
  if($passsid) {
	$session = $self->_session_connect('dbpass', $passsid);
	($col, $update) = $session->read('col', 'update');
  }

  my @qname = $query->param;
  foreach my $name (@qname) {
	next unless($name =~ m/^:(.*)$/);
	$col->{$1} = $query->param($name);
	$self->infilter(\$col->{$1}, printerror => 1);
  }
  my $error = $dbpass->column_check($col);

  $self->fatal_error("'update' is invalid")
	if($qs->{update} and not defined($self->{userinfo}{uid}) or
	   defined($update) and $update ne $qs->{update});
  $update = $qs->{update};

  # ǡ١ϤHTML 
  my $html;
  if($error and @$error) {
	$html = $dbpass->{template}{registry_error};
  } else {
	$html = $dbpass->{template}{registry_verify};

	my $uid = $self->{userinfo}{uid};
	my $e = $dbpass->register($col, \$uid, rollback => 1, update => $update);
	if($e) {
	  # ϿƤǡȽʣƤ
	  $error = [ $e ];
	  $html = $dbpass->{template}{registry_error};
	}
  }

  # å
  unless($session) {
	$session = $self->_session_connect('dbpass');
	$passsid = $session->id;
  }
  $session->data(col => $col, update => $update);
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  return ($html, { col => $col, passsid => $passsid, update => $update,
				   error => $error });
}

=item registry_passwd ( AUTHCONF [,OPTION] )

  $dbs->registry($authconf, %opt);

    ARGS :
      authconf => STRING       # 桼ե

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      passsid => STRING        # åIDʥ桼Ͽѡ
      cancel => BOOLEAN        # 󥻥

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       col => HASHREF          # 桼
       passsid => STRING       # $qs->{passsid} Ʊ
       update => BOOLEAN       # 桼ιʤ 1
       error => ARRAYREF       # 顼ξ

桼Ͽ/桼ιԤ

=cut

sub registry_passwd {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $authconf, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # DBIPgSystem::Passwd
  my $dbpass = DBIPgSystem::Passwd->new($self, $authconf, debug => $DEBUG);

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam($query, $opt{param}, 'passsid=s', 'cancel!');

  $self->print_error('query-title', 'query', "'passsid' must be defined")
	unless($qs->{passsid});
  my $session = $self->_session_connect('dbpass', $qs->{passsid});
  my ($col, $update) = $session->read('col', 'update');

  $self->fatal_error("'update' is invalid")
	if($update and not defined($self->{userinfo}{uid}));

  # ǡ١ϤHTML 
  my ($html, $error);
  if($qs->{cancel}) {
	$html = $dbpass->{template}{registry_error};
  } else {
	$html = $dbpass->{template}{registry_success};

	my $uid = $self->{userinfo}{uid};
	my $e = $dbpass->register($col, \$uid, update => $update);
	if($e) {
	  # ϿƤǡȽʣƤ
	  $error = [ $e ];
	  $html = $dbpass->{template}{registry_error};
	} else {
	  # Ͽλν
	  my $user = $col->{ $self->{global}{userinfo}{col_user} };
	  $dbpass->send_mail(($update ? 'update' : 'registry'), $col);
	  $self->insert_userinfo($uid) unless($update);
	  $self->add_log
		('RegistryPasswd', ($update ? 'Update' : 'Insert'), __UID__ => $uid,
		 values => join(' ; ', map { "$_: $col->{$_}" } keys %$col));

	  # å
	  eval { $session->remove };
	  $self->fatal_error("Session error") if($@);
	}
  }

  return ($html, { col => $col, passsid => $qs->{passsid}, update => $update,
				   error => $error });
}

=item send_passwd ( AUTHCONF [,OPTION] )

  $dbs->send_passwd($authconf, %opt);

    ARGS :
      authconf => STRING       # 桼ե

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      email => STRING          # E-mail

    RET : ARRAY
      0 => STRING              # ƥץ졼ȥե
      1 => HASHREF
       email => STRING         # $qs->{email} Ʊ

ꤵ줿᡼륢ɥ쥹顢б桼᡼롣
ѥɤ˺줿ȤѤ롣

=cut

sub send_passwd {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $authconf, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  # DBIPgSystem::Passwd
  my $dbpass = DBIPgSystem::Passwd->new($self, $authconf, debug => $DEBUG);

  # FORM ǡ
  $self->setincode(scalar $query->param('code_dist'));
  my $qs = $self->_getparam($query, $opt{param}, 'email=s');

  # 桼᡼
  my $col = $dbpass->readcol('email', $qs->{email})
	or $self->print_error('email-title', 'email');
  $dbpass->send_mail('forget', $col);

  my $html = $dbpass->{template}{send_passwd_success};
  return ($html, { email => $qs->{email} });
}

=item create_detail_session ( [OPTION] )

  ($dtlsid, $dtltotal, $dtlnum, $did) = $dbs->create_detail_session(%opt);

    OPTION :
      param => HASHREF         # ѥ᡼ ($qs )

    QUERY :
      $srcsid => STRING        # åIDʸѡ
      $rid => NUM              # 쥳ID

    RET : @array
      0 => STRING              # åIDʾܺɽѡ
      1 => NUM                 # 줿ǡ
      2 => NUM                 # 쥳ID бǡֹ
      3 => NUM                 # ǡID

ܺɽѤΥå롣$rid ϤʤƤ褤

=cut

sub create_detail_session {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, %opt) = @_;

  my $query = $self->{query};
  $self->print_error('query-title', 'query')
	unless($query->param or exists($opt{param}));

  my $qs = $self->_getparam($query, $opt{param}, 'srcsid=s', 'rid=i');
  my $rid = $qs->{rid};

  # åǡɤ߹
  my $active = $self->{db}{sysstate}{active};
  my $session = $self->_session_connect('search', $qs->{srcsid});
  my $sql = $session->read('sql');
  my $and = $self->check_permission('detail');
  my $list = $self->selectall_arrayref
	($self->selectcmd
	 ('system_rid, system_did, system_state', %$sql, where_and => $and));

  my ($didlist, $ridlist) = ([ ], [ ]);
  my ($i, $dtlnum) = (0, 0);
  foreach my $l (@$list) {
	push(@$ridlist, $l->[0]);
	push(@$didlist, $l->[2] eq $active ? $l->[1] : undef);
	$dtlnum = $i if($l->[0] eq $rid);
	$i++;
  }
  my $dtltotal = @$ridlist;
  $rid = $ridlist->[$dtlnum] if($rid eq '');
  my $did = $didlist->[$dtlnum];

  # å
  $session = $self->_session_connect('detail');
  my $dtlsid = $session->id;
  $session->data(didlist => $didlist, ridlist => $ridlist, total => $dtltotal);
  eval { undef $session };
  $self->fatal_error("Session error") if($@);

  return ($dtlsid, $dtltotal, $dtlnum, $did, $rid);
}

=item get_dtl_session ( DTLSID, NUM )

  ($rid, $did) = $dbs->get_dtl_session($dtlsid, $num);

    ARGS :
      $dtlsid => STRING        # åIDʾܺɽѡ
      $num => NUM              # ǡֹ

    RET : LIST
      0 => NUM                 # 쥳ID
      1 => NUM                 # ǡID

ܺɽѤΥå󤫤顢бֹΥǡID֤

=cut

sub get_dtl_session {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $dtlsid, $num) = @_;
  $self->fatal_error("Too few arguments",
					'@_' => join(' :: ', @_)) if(@_ < 2);

  # åǡɤ߹
  my $session = $self->_session_connect('detail', $dtlsid);
  my ($ridlist, $didlist) = $session->read('ridlist', 'didlist');
  return ($ridlist->[$num], $didlist->[$num]);
}

=back

=head2 TEST METHODS

=over 4

=item test_errcode ( )

  $self->test_errcode();

$errcode ˻ꤵ줿顼ɤ
顼åեƤ뤳Ȥǧ롣

=cut

sub test_errcode {
  &dbdebug('sub', @_) if($DEBUG);
  my $self = shift;

  $self->SUPER::test_errcode();

  my $errcode =
	[ 'query-title', 'query',							# ϥǡ
	  'fileopen-title', 'fileopen',	'file-nofile',		# ե뤫
	  'insert-title', 'insert',							# ǡ
	  'permission-title', 'permission',					# ܺɽ
	  'timeout-title', 'timeout',						# ॢ
	  'cond', 'cond_null', 'cond_quot', 'cond_quot_pos',# 
	  'cond_op', 'cond_left',
	  'rpn_blacket_mis_l', 'rpn_blacket_mis_r',
	  'rpn_blacket_l',
	  'email-title', 'email',							# ᡼
	  'session-title', 'session',						# å
	];

  foreach my $c (@$errcode) { $self->get_errmsg($c); }
}

=back

=head2 INTERNAL METHODS

=over 4

=item _make_cond_sentence ( WHERE [,OPTION] )

  ($where, $err) = $self->_make_cond_sentence($where_in, %opt);

    ARGS :
      where_in => STRING       #  WHERE

    OPTION :
      strict => BOOLEAN        # subst 両ѥΤδؿ̤ʤ
      usemata => BOOLEAN       # ᥿ʸѤ
      allow_null => BOOLEAN    # ͤ '' ñ̵뤹
      and => BOOLEAN           # ʤ߸
      direct => BOOLEAN        # v_where Ȥʤľܻꤹ˸
      usealias => BOOLEAN      # ͤǧ alias ʤɤѤ

    RET : @array
      0 => STRING              # ϸ WHERE
      1 => STRING              # 顼

$where_in ϤSQL  WHEREȤŬڤʸ֤

ޤǽԤ˾Ｐñʬ򤹤롣
줫ñˤĤƲϤԤǸ WHERE롣
Ϥǥ顼ĤС$err ˥顼ɤϤ롣

ñβϤϡץͤʤɤ˱׵Ѥ˹Ԥ롣

ñˤĤơͤˤϥ桼ࡢѥࡢ
ƥबǤ롣
nosearch ꤵƤ桼䡢
ѤػߤƤ륷ƥꤹ뤳ȤϤǤʤ

strict ץϡsubst 両ѥΤδؿ̤ɤ
뤿˻Ȥ롣
strict ץ false ξ硢ͤ桼ǡ
ˤĤξñˤĤơ
ͤ subst Υե륿̤
ޤб븡ѥबСͤ򸡺ѥ֤
ͤ search Υե륿̤
˸ѥ֤줿ʤñˤϡ
ͤʸ '#s' դФ褤

=cut

sub _make_cond_sentence {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $where_in, %opt) = @_;
  $self->fatal_error("Too few arguments",
					'@_' => join(' :: ', @_)) if(@_ < 2);

  my $op_precedence = { 'AND' => 1, 'OR' => 2 };
  my $re_op = qr{(?:AND|OR)}i;
  # Perl ɽ PostgreSQL ɽ (LIKE, ~) Υ᥿ʸʡܦ
  my $re_meta = qr{[][\\|(){}^*+?.\$_%]};
  my $sql_active = "system_state = $self->{db}{sysstate}{active}";
  my $primary = $self->{global}{primary};
  my $search_ext = $self->{sys}{search_ext};
  my $autoactive = $opt{and} ? 0 : 1;

  return ($sql_active, undef) if($where_in =~ m/^\s*ALL\s*$/is);
  return ($where_in, 'cond_null') if($where_in =~ m/^\s*$/is);

  my ($n, $quot) = (-1, [ ]);
  # _conv_rpn ǲϤȤ˼ˤʤ뤫⤷ʤʸ "...", ',,,' 
  # $quot ˰򤵤"0", '1', ... Τ褦Ѵ
  my $where_esc = $where_in;
  $where_esc =~ s{("([^"])*"|'([^\\']|\\.)*')}{
	(push(@$quot, $1), $n++, $2 ? "\"$n\"" : "'$n'") }ges;
								# 'That''s right' Τ褦ʾǤ

  # ¦ʤäꡢ';' ǰϤäƤʤϥ顼
  return ($where_in, 'cond_quot') if($where_esc !~ m/^([^'";]|'\d+'|"\d+")*$/);

  # AND, OR 黻ҤβϤ򤹤
  my $list = $self->_conv_rpn($where_esc, $op_precedence, $re_op);
  return ($where_in, $list) if(ref($list) eq '');

  # ＰγñˤĤƲϤ򤹤
  my ($left, $op, $right, $dbt, $dbc, $leftopt);
  foreach my $l (@$list) {
	next if($l =~ m/^$re_op$/);

	if($l =~ m/^'(\d+)'$/) {
	  if($quot->[$1] =~ m/^'(?:1|true)'$/) {
		$l = "'true'";   next;
	  }
	  if($quot->[$1] =~ m/^'(?:0|false)'$/) {
		$l = "'false'";   next;
	  }
	}

	# , 黻, ͤʬ䤹
	($left, $op, $right) =
	  $l =~ m/^(.*?)(!~\*?\^?\$?|~\*?\^?\$?|[<>!]=|[=<>]|
                \s(?:NOT\s+)?LIKE\s|\sIS\s+(?:NOT\s)?)(.*)/ixs
		or return ($l, 'cond_op');
	$left =~ s/\s+$//;   $right =~ s/^\s+//;

	# ----- ͤν -----
	# å򤷤ơ$quot 򤵤ʸ򸵤᤹
	unless($right =~ m/^((?:'\d+')+|[^"']*)$/) {
	  $right =~ s/"(\d+)"/$quot->[$1]/g;
	  $right =~ s/'(\d+)'/$quot->[$1]/g;
	  # 黻Ҥ IS (NOT) NULL ξ硢θ³ʸ󤬤äƤ̵뤹
	  return ($right, 'cond_quot_pos') unless($op =~ m/ IS (?:NOT )?/i);
	  $right =~ s/^\s*NULL.*$/NULL/is or return ($1, 'cond_op');
	}
	$right =~ s/'(\d+)'/$quot->[$1]/g;
	$right =~ s/^'//;   $right =~ s/'$//;	# ͤξü "'" õ
	if($right eq '' and $opt{allow_null}) { undef $l; next; }

	# 黻Ҥ IS (NOT) NULL ξ硢θ³ʸ󤬤äƤ̵뤹
	if($op =~ m/ IS (?:NOT )?/i) {
	  $right =~ s/^\s*NULL.*$/NULL/is or return ($1, 'cond_op');
	}

	# ʸľܻꤷƤʤ SQLʸΥ󥨥פ򤹤
	$self->_pgsqlpack(\$right) or return ($ERROR, 'cond') unless($opt{direct});

	# usemetaץ true ʤ SQLʸΥ󥨥פ򤹤
	$self->_pgsqlpack(\$right) or return ($ERROR, 'cond') if($opt{usemeta});

	# ----- ͤν -----
	# å򤷤ơ$quot 򤵤ʸ򸵤᤹
	unless($left =~ m/^([^'".]+|"\d+")$/ or
		   $left =~ m/^([^'".]+|"\d+")\.([^'".]+|"\d+")$/) {
	  $left =~ s/'(\d+)'/$quot->[$1]/g;
	  $left =~ s/"(\d+)"/$quot->[$1]/g;
	  return ($left, 'cond_quot_pos');
	}
	$left =~ s/"(\d+)"/$quot->[$1]/g;
	# ơ֥̾ȥ̾ʬΥ
	if($left =~ s/^([^".]+|"[^"]*")\.//s) {
	  $dbt = $1;
	  $dbt =~ s/^"//;   $dbt =~ s/"$//;		# ơ֥̾ξü '"' õ
	  return ("$dbt.$left", 'cond_left') unless(exists $self->{dbcol}{$dbt});
	} else {
	  $dbt = $primary;
	}
	$left =~ s/^"//;   $left =~ s/"$//;		# ̾ξü '"' õ
	$left = lc($left);

	# ----- Ｐβ -----
	# ץȴФ
	$leftopt = $1 if($left =~ s/#(.*)$//);

	# ͤΥ̾桼फɤå
	if(exists $self->{dbseq}{$dbt}{$left}) {
	  $dbc = $self->{dbseq}{$dbt}{$left};
	}
	# ͤΥ̾ѥफɤå
	elsif($left =~ s/$search_ext$//o) {
	  return ($left . $search_ext, 'cond_left')
		unless(exists $self->{dbseq}{$dbt}{$left});
	  $dbc = $self->{dbseq}{$dbt}{$left};
	  $left .= $search_ext;
	}
	# ͤΥ̾ƥफɤå
	elsif(exists($self->{db}{sysseq}{$left}) and $dbt eq $primary) {
	  if($self->{userinfo}{staff}) {
		$autoactive = 0;
	  } else {
		if($left eq 'system_uid' and $op eq '=' and
		   $right eq $self->{userinfo}{uid}) {
		  $autoactive = 0;
		} elsif($left ne 'system_did') {
		  return ($left, 'cond_left');
		}
	  }
	} elsif($opt{usealias}) {
	  # ͤܤĴ٤
	  my $alias = $self->{db}{alias}{$dbt} || { };
	  my $match;
	  foreach my $dbcol (@{ $self->{dbcol}{$dbt} }) {
		if($dbcol->{print} =~ m/^\Q$left\E$/i or
		   $alias->{ $dbcol->{name} } =~ m/^\Q$left\E$/im) {
		  ($match, $left, $dbc) = (1, $dbcol->{name}, $dbcol);
		  last;
		}
	  }
	  # ͤβϤ˼
	  return ($left, 'cond_left') unless($match);
	}
	# ͤβϤ˼
	else { return ($left, 'cond_left'); }

	# ----- ͤŬڤѴ -----
	if(not $opt{strict} and not ($opt{usemeta} and $right =~ m/$re_meta/)
	   and exists($self->{dbseq}{$dbt}{$left}) and $dbc->{type} ne 'file') {
	  # ͤ subst ̤
	  &{ $dbc->{subst} }(\$right) if($dbc->{subst});
	  # ͤѥफɤå
	  if($dbc->{search} and not $leftopt =~ m/s/) {
		my $type = $self->{db}{type_sql}{ $dbc->{stype} };
		my $rights = &{ $dbc->{search} }($right);
		($left, $right) = ($left . $search_ext, $rights)
		  if($rights =~ m/$self->{db}{type}{format}{$type}/);
	  }
	}

	# ͤѥǤʤnosearch  true ʤм
	return ($left, 'cond_left')
	  if($left !~ m/$search_ext$/ and $dbc->{nosearch});

	# PostgreSQLɽǤʸȤư褦եåղ
	$right =~ s/($re_meta)/\\$1/g
	  if(not $opt{usemeta} and $op =~ m/~|LIKE/i);

	# SQLʸΥפ򤹤
	$self->_pgsqlunpack(\$right);

	# 黻 /!?~\*?\^?\$?/ ǰϤ
	if($op =~ s/\$$//) {
	  $right .= (($dbc and $dbc->{plural}) ? '\\035' : '$');
	}
	if($op =~ s/\^$//) {
	  $right = (($dbc and $dbc->{plural}) ? '\\035' : '^') . $right;
	}
	$right = "'$right'" if($op !~ m/ IS (?:NOT )?/i);

	$left = "\"$left\"";
	if($dbt eq $primary) {
	  $l = "$left $op $right";
	} else {
	  $l = "EXISTS (SELECT system_rid FROM \"$dbt\" WHERE "
		. "system_rid = \"$primary\".system_rid AND $left $op $right)";
	}
  }

  # $autoactive  true ʤС֤ active ΥǡΤߤ򸡺
  push(@$list, $sql_active, 'AND') if($autoactive);

  # ֵˡξ֤ WHERE
  # stack_pr, pr_[abc] ̤ͥǼ졢Ŭڤ˳̤դ
  my ($stack, $stack_pr, $cond_a, $cond_b, $cond_c, $pr_a, $pr_b, $pr_c);
  foreach my $l (@$list) {
	if($l !~ m/^$re_op$/) {
	  push(@$stack, $l);
	  push(@$stack_pr, 0);
	  next;
	}
	$cond_b = pop(@$stack);
	$pr_b = pop(@$stack_pr);
	$cond_a = pop(@$stack);
	$pr_a = pop(@$stack_pr);
	if(defined($cond_a) and defined($cond_b)) {
	  $cond_a = "( $cond_a )" if($op_precedence->{$l} < $pr_a);
	  $cond_b = "( $cond_b )" if($op_precedence->{$l} < $pr_b);
	  $cond_c = "$cond_a $l $cond_b";
	  $pr_c = $op_precedence->{$l};
	} elsif(defined($cond_a)) {
	  $cond_c = $cond_a;
	  $pr_c = $pr_a;
	} elsif(defined($cond_b)) {
	  $cond_c = $cond_b;
	  $pr_c = $pr_b;
	} else {
	  undef $cond_c;
	  $pr_c = 0;
	}
	push(@$stack, $cond_c);
	push(@$stack_pr, $pr_c);
  }

  return ($where_in, 'cond_null')
	if($stack->[0] eq '' or ($autoactive and $stack->[0] eq $sql_active));
  return (($#$stack == 0 ? $stack->[0] : undef), undef);
}

=item _conv_rpn ( STR, PRECEDENCE, REGEX )

  $list = $self->_conv_rpn($in, $op_precedence, $regex_op);

    ARGS :
      in => STRING             # ʸ
      op_precedence => HASHREF # 黻Ҥ̤ͥǼ줿ϥå
      regex_op => REGEX        # 黻Ҥɽ

ʸ '(', ')'黻 $regex_op
̻ҡʤʳʸˤʬ򤷡
ǲϤ䤹褦ֵˡѴ롣
黻Ҥ϶ǤʤФʤʤ
Ǥʤм̻ҤȤߤʤ롣
黻Ҥʸʸζ̤Ϥʤ
$op_precedence ̤ͤۤͥ⤤
̤ˤä̤ͥѤ뤳ȤǤ̤ΥͥȤˤбƤ롣
Υ᥽åɤǤϡ̻Ҥ /( $regex_op |[()])/
ޤޤƤʤȤư򤹤
ʤ餬ޤޤʤ褦ŬڤƤΤȤˡ

ʸˡ˸꤬ʤСؤΥե󥹤֤
ʤС顼ɤ֤

=cut

sub _conv_rpn {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $in, $op_precedence, $regex_op) = @_;
  $self->fatal_error("Too few arguments",
					'@_' => join(' :: ', @_)) if(@_ < 4);

  my ($s, $k, $list, $inner, $p, $r);
  my ($pre, $rest, $op);
  # Ƭ˥ѡ[ Ｐ, 黻, Ｐ, ... ] η֤
  while($in =~ m/^(.*?)( $regex_op |[()])(.*)$/s) {
	return 'rpn_blacket_mis_r' if($2 eq ')');
	if($2 eq '(') {
	  ($pre, $rest) = ($1, $3);
	  return 'rpn_blacket_l' if($pre !~ m/^\s*$/);

	  # бĤ̤򸫤Ĥ
	  ($inner, $p) = ('', '');
	  while($rest =~ m/([^)]*)\)(?=(.*))/gs) {
		($p, $r) = ($p . $1, $2);
		if($p =~ tr/\(// == $p =~ tr/\)//) {
		  ($inner, $rest) = ($p, $r);
		  last;
		}
		$p .= ')';
	  }
	  # бĤ̤ʤ
	  return 'rpn_blacket_mis_l' if($inner eq '');

	  if($rest =~ m/^\s*$/) { $in = $inner;   last; }
	  if($rest =~ m/^\s*( $regex_op )(.*)$/s) {
		push(@$k, $inner, uc($1));
		$in = $2;
	  } else { return 'cond'; }
	} else {					# $regex_op ξ
	  ($pre, $op, $in) = ($1, $2, $3);
	  return 'cond' if($pre =~ m/^\s*$/);
	  push(@$k, $pre, uc($op));
	}
  }
  push(@$k, $in);
  foreach (@$k) {
	s/^\s+//;   s/\s+$//;
	s/^(?:\(\s*)+([^)]*[^) ])(?:\s*\))+$/$1/;
  }
  my $l;
  foreach my $k_ (@$k) {
	if($k_ =~ m/^$regex_op$/) { push(@$list, $k_); next; }
	if($k_ =~ m/ $regex_op /) {
	  $l = $self->_conv_rpn($k_, $op_precedence, $regex_op);
	  return $l if(ref($l) ne 'ARRAY');
	  push(@$list, $l);
	}
	else { push(@$list, $k_); }
  }

  # ֵˡ¤ؤ
  my $a;
  foreach my $i (0 .. $#$list) {
	if($list->[$i] =~ m/^$regex_op$/) {
	  foreach my $j ($i+1 .. $#$list+1) {
		if($j > $#$list or $list->[$j] =~ m/^$regex_op$/
		   and $op_precedence->{$list->[$i]}
		   <= $op_precedence->{$list->[$j]}) {
		  $a = splice(@$list, $i, 1);
		  splice(@$list, $j-1, 0, $a);
		  last;
		}
	  }
	}
  }
  # ʿ
  ($s, $list) = ($list, [ ]);
  while(@$s) {
	if(ref($s->[0]) eq 'ARRAY') { splice(@$s, 0, 1, @{ $s->[0] }); }
	else { push(@$list, shift(@$s)); }
  }
  return $list;
}

=item _get_order ( STRING )

  $order = $self->_get_order($in);

    ARGS :
      in => STRING             # ORDER ɽʸ

    RET : STRING               # ORDER

Ϥ ORDER롣ORDERƾʸǽϤ롣
Ϥ˼ԤȤ undef ֤
nosearch  true Υ ORDER˴ޤʤ

=cut

sub _get_order {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $in) = @_;
  $self->fatal_error("Too few arguments",
					 '@_' => join(' :: ', @_)) if(@_ < 2);

  $in = lc($in);
  return undef
	unless ($in =~ m/^[a-z_]+(?:\s+(?:a|de)sc)?
                     (?:\s*,\s*[a-z_]+(?:\s+(?:a|de)sc)?)*$/x);
  my $orderlist = [ split(/\s*,\s*/, $in) ];
  my ($ord_, $err);
  my $ext = { };
  my $re_search = qr{$self->{sys}{search_ext}};
  my $dbpr = $self->{dbseq}{ $self->{global}{primary} };
  foreach my $ord (@$orderlist) {
	($ord_ = $ord) =~ s/(\s+(a|de)sc)?$//;
	return undef if($ext->{$ord_});
	if($ord_ =~ s/$re_search$//) {
	  return undef unless(exists $dbpr->{$ord_} and $dbpr->{$ord_}{search});
	} else {
	  return undef unless
		($ord_ =~ m/^system_(rid|did|date|state)$/ or
		 $self->{userinfo}{staff} and exists($self->{db}{sysseq}{$ord_}) or
		 exists($dbpr->{$ord_}) and not $dbpr->{$ord_}{nosearch});
	}
	$ext->{$ord_} = 1;
  }
  return join(',', @$orderlist);
}

=item _session_connect ( KIND [,SID] )

  $session = $self->_session_connect($kind);
  $session = $self->_session_connect($kind, $sid);

    ARGS :
      kind => STRING           # åμ
      sid => STRING            # åID

$sid ꤵ줿硢å򸵤᤹
ʤСå롣

å򸵤᤹ȤϡADDR롼סUID$kind 
å󤬺줿ȤͤƱǤʤФʤʤ

=cut

sub _session_connect {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $kind, $sid) = @_;
  my $session;

  eval {
	$session = DBSession->new
	  ("dbi:Pg:$self->{global}{db}{data_source}",
	   $self->{global}{db}{username}, $self->{global}{db}{passwd}, $sid,
	   interval => $self->{global}{session_time_limit}) };
  $self->print_error('session-title', 'session', "session", sid => $sid)
	if($@ or not $session);
  if($sid) {
	my ($s_addr, $s_kind, $s_uid, $s_group) =
	  $session->read('__REMOTE_ADDR__', '__KIND__', '__UID__', '__GROUP__');
	$self->print_error
	  ('session-title', 'session', "wrong", IP => $ENV{REMOTE_ADDR},
	   __REMOTE_ADDR__ => $s_addr, s_uid => $s_uid,
	   uid => $self->{userinfo}{uid}, kind => $kind, __KIND__ => $s_kind)
		if($ENV{REMOTE_ADDR} ne $s_addr or $self->{userinfo}{uid} ne $s_uid
		   or $self->{userinfo}{group} ne $s_group or $kind ne $s_kind);
	$session->touch;
  } else {
	$session->data
	  (__KIND__ => $kind, __REMOTE_ADDR__ => $ENV{REMOTE_ADDR},
	   __UID__ => $self->{userinfo}{uid}, __GROUP__ => $self->{userinfo}{group});
  }

  return $session;
}

=item _getparam ( QUERY, PARAM, LISTS.. )

  $self->_getparam($query, $param, @lists);

    ARGS :
      query => CGI             # CGI⥸塼Υ֥
      param => HASHREF         # ѥ᡼
      lists => ARRAY           # ɤ߹ߤѥ᡼

@lists бCGI ѥ᡼ɤ߹ߡ$qs ˥ϥåηǳǼ롣
@lists γǤϡΤ줫ηǵҤGetopt::Long ˻Ƥˡ
'name' ϡѥ᡼֤̾뤳ȡ

  'name!'                      # 0 or 1 Τ줫Ȥɾ
  'name=i'                     # 0ʾͤȤɾ
  'name=s'                     # ʸȤɾ

=cut

sub _getparam {
  &dbdebug('sub', @_) if($DEBUG);
  my ($self, $query, $param, @lists) = @_;
  my $ret = { };

  $param ||= { };
  foreach my $list (@lists) {
	if($list =~ s/!$//) {
	  my $value = exists($param->{$list}) ?
		$param->{$list} : $query->param($list);
	  $ret->{$list} = $value ? 1 : 0;
	  next;
	}
	if($list =~ s/=i$//) {					# 0ʾ
	  my $value = exists($param->{$list}) ?
		$param->{$list} : $query->param($list);
	  $self->infilter(\$value, printerror => 1);
	  if($value =~ m/^\d+$/) { $ret->{$list} = $value; }
	  elsif($value eq '') { $ret->{$list} = undef; }
	  else {
		$self->print_error('query-title', 'query', "Invalid query",
						   list => $list, value => $value);
	  }
	} elsif($list =~ s/=s$//) {
	  my $value = exists($param->{$list}) ?
		$param->{$list} : $query->param($list);
	  $self->infilter(\$value, printerror => 1);
	  $ret->{$list} = $value;
	} else {
	  $self->fatal_error("'lists' is invalid", list => $list);
	}
  }
  return $ret;
}

=item _pgsqlpack ( REF )

  $self->_pgsqlpack($ref) or die $ERROR;

PostgreSQL ʸεեå('\')᤹롣

Ūˤ '\n', '\035', "''" 򡢤줾 \x0A, \x1D, "'" Ѵ롣
ޤ嵭ʳüʰ̣ʸ'\b', '\f', '\r', '\t', '\xxx'
СѴ˼Ԥ롣
ñȤεեå夬䡢"'" ľ "'" ³ʤˤ⡢
Ѵ˼Ԥ롣
'\n', '\035' ʳεեå³ʸС
Ϥεեå夬롣

Ѵ 1 ֤ʤмԤθȤʤʸ
$ERROR 0 ֤

=cut

sub _pgsqlpack {
  my ($self, $ref) = @_;
  $ERROR = '';
  $$ref =~ s{(?:\\([0-7]{3}|.)|'(.)|(\\|')$)}{
	$1 ? ($1 eq '035' ? "\x1D" :
		  length($1) > 1 ? ($ERROR |= "\\$1", $1) :
		  $1 =~ m/^([bfrt])$/ ? ($ERROR |= "\\$1", $1) :
		  $1 eq 'n' ? "\x0A" : $1)
	  : $2 ? ($2 eq "'" ? $2 : ($ERROR |= "'$2", $2))
		: ($ERROR |= $3, $3);
  }ge;
  return $ERROR ? 0 : 1;
}

# 1;
# __END__

=back

=head1 SEE ALSO

F<Jcode>, F<DBIPgSystem::DB>, F<DBSession>, F<DBIPgSystem::Passwd>

=head1 COPYRIGHT

Copyright (C) 2002 The Nagoya University Consumers' Co-operative Association

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the following URL for more details:
  http://www.gnu.org/licenses/gpl.txt

Written by Kenji Nakahira <nakahira@coop.nagoya-u.ac.jp>

=for html
</div>

=cut
