#include "mpi.h"
#include <stdio.h>
#include <math.h>

static int ut = 0;

void
ut_begin(int argc, char** argv);

void
ut_end();

int
assert_equal_int(int a, int b, char* message);

int
assert_equal_double(double a, double b, char* message);

int
main(int argc, char *argv[])
{
  int myrank;
  double d;
  MPI_Status status;
  MPI_Request req;

  ut_begin(argc, argv);
  
  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
  
  if(myrank == 0) {
    d = 0.1;
    MPI_Send(&d, 1, MPI_DOUBLE, 1, 0, MPI_COMM_WORLD);
    d = 0.2;
    MPI_Bcast(&d, 1, MPI_DOUBLE, 0, MPI_COMM_WORLD);
  }
  else if(myrank == 1) {
    d = 0.0;
    MPI_Recv(&d, 1, MPI_DOUBLE, 0, 0, MPI_COMM_WORLD, &status);
    assert_equal_double(0.1, d, "rank1: recv");
    MPI_Bcast(&d, 1, MPI_DOUBLE, 0, MPI_COMM_WORLD);
    assert_equal_double(0.2, d, "rank1: bcast");
  }

  ut_end();
  
  MPI_Finalize();
  return 0;
}

int
assert_equal_int(int a, int b, char* message)
{
  if(ut) {
    if(a == b) {
      printf(".");
      return 1;
    }
    else {
      puts(message);
      printf("require <%d> but was <%d>\n", a, b);
    }
  }

  return 0;
}

int
assert_equal_double(double a, double b, char* message)
{
  if(ut) {
    if(a == b) {
      printf(".");
      return 1;
    }
    else {
      puts(message);
      printf("require <%lf> but was <%lf>\n", a, b);
    }
  }

  return 0;
}

void
ut_begin(int argc, char** argv)
{
  if(argc == 2) {
    ut = 1;
  }
}

void
ut_end()
{
  if(ut) {
    puts("");
  }
}
