#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"
  
static FILE* logfile;

#define log(buf, byte, count) \
  fwrite(buf, byte, count, logfile)

int
MPI_Init(int* argc, char*** argv)
{
  int ret, rank;
  char filename[32];

  ret = PMPI_Init(argc, argv);

  PMPI_Comm_rank(MPI_COMM_WORLD, &rank);
  sprintf(filename, "rank%d.log", rank);
  
  if(NULL == (logfile = fopen(filename, "wb"))) {
    printf("Logging Error: Can't open %s\n", filename);
    exit(-1);
  }

  log(&ret, sizeof(int), 1);
  
  return ret;
}

int
MPI_Comm_size(MPI_Comm comm, int* numprocs)
{
  int ret;

  ret = PMPI_Comm_size(comm, numprocs);
  
  log(&ret, sizeof(int), 1);
  log(numprocs, sizeof(int), 1);

  return ret;
}

int
MPI_Comm_rank(MPI_Comm comm, int* rank)
{

  int ret;

  ret = PMPI_Comm_rank(comm, rank);

  log(&ret, sizeof(int), 1);
  log(rank, sizeof(int), 1);
  
  return ret;
}

int
MPI_Send(void* buf, int count, MPI_Datatype datatype,
         int dest, int tag, MPI_Comm comm)
{
  int ret;

  ret = PMPI_Send(buf, count, datatype, dest, tag, comm);
  
  log(&ret, sizeof(int), 1);
  
  return ret;
}

int
MPI_Recv(void* buf, int count, MPI_Datatype datatype,
         int src, int tag, MPI_Comm comm, MPI_Status *status)
{
  int ret, size;
  
  ret = PMPI_Recv(buf, count, datatype, src, tag, comm, status);
  
  log(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  log(buf, size, count);
  log(status, sizeof(MPI_Status), 1);

  return ret;
}

int
MPI_Bcast(void* buf, int count, MPI_Datatype datatype,
          int root, MPI_Comm comm)
{
  int ret, size;

  ret = PMPI_Bcast(buf, count, datatype, root, comm);
  
  log(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  log(buf, size, count);

  return ret;
}

int
MPI_Scatter(void* sendbuf, int sendcnt, MPI_Datatype sendtype,
            void* recvbuf, int recvcnt, MPI_Datatype recvtype,
            int root, MPI_Comm comm)
{
  int ret, size;

  ret = PMPI_Scatter(sendbuf, sendcnt, sendtype,
                     recvbuf, recvcnt, recvtype,
                     root, comm);
  
  log(&ret, sizeof(int), 1);
  MPI_Type_size(recvtype, &size);
  log(recvbuf, size, recvcnt);

  return ret;
}

int
MPI_Gather(void* sendbuf, int sendcnt, MPI_Datatype sendtype,
           void* recvbuf, int recvcnt, MPI_Datatype recvtype,
           int root, MPI_Comm comm)
{
  int ret, size;

  ret = PMPI_Gather(sendbuf, sendcnt, sendtype,
                    recvbuf, recvcnt, recvtype,
                    root, comm);
  
  log(&ret, sizeof(int), 1);
  MPI_Type_size(recvtype, &size);
  log(recvbuf, size, recvcnt);

  return ret;
}

int
MPI_Barrier(MPI_Comm comm)
{
  int ret;

  ret = PMPI_Barrier(comm);

  log(&ret, sizeof(int), 1);

  return ret;
}

int
MPI_Allreduce(void* operand, void* result, int count,
              MPI_Datatype datatype, MPI_Op operator, MPI_Comm comm)
{
  int ret, size;

  ret = PMPI_Allreduce(operand, result, count, datatype, operator, comm);

  log(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  log(result, size, count);

  return ret;
}

int
MPI_Cart_create(MPI_Comm oldcomm, int ndims, int dimsizes[],
                int wraparound[], int reorder, MPI_Comm* cart)
{
  int ret;

  ret = PMPI_Cart_create(oldcomm, ndims, dimsizes, wraparound,
                         reorder, cart);

  log(&ret, sizeof(int), 1);
  log(cart, sizeof(MPI_Comm), 1);

  return ret;
}

int
MPI_Cart_get(MPI_Comm comm, int maxdims, int dims[], int periods[],
             int coords[])
{
  int ret;

  ret = PMPI_Cart_get(comm, maxdims, dims, periods, coords);

  log(&ret, sizeof(int), 1);
  log(dims, sizeof(int), maxdims);
  log(periods, sizeof(int), maxdims);
  log(coords, sizeof(int), maxdims);

  return ret;
}

int
MPI_Cart_shift(MPI_Comm comm, int direction, int displacement,
               int* ranksrc, int* rankdest)
{
  int ret;

  ret = PMPI_Cart_shift(comm, direction, displacement, ranksrc, rankdest);

  log(&ret, sizeof(int), 1);
  log(ranksrc, sizeof(int), 1);
  log(rankdest, sizeof(int), 1);

  return ret;
}

int
MPI_Isend(void* buf, int count, MPI_Datatype datatype, int dest,
          int tag, MPI_Comm comm, MPI_Request* req)
{
  int ret;

  ret = PMPI_Isend(buf, count, datatype, dest, tag, comm, req);

  log(&ret, sizeof(int), 1);
  log(req, sizeof(MPI_Request), 1);

  return ret;
}

int
MPI_Irecv(void* buf, int count, MPI_Datatype datatype, int src,
          int tag, MPI_Comm comm, MPI_Request* req)
{
  int ret, size;

  ret = PMPI_Irecv(buf, count, datatype, src, tag, comm, req);

  log(&ret, sizeof(int), 1);
  MPI_Type_size(datatype, &size);
  log(buf, size, count);
  log(req, sizeof(MPI_Request), 1);

  return ret;
}

int
MPI_Wait(MPI_Request* req, MPI_Status* st)
{
  int ret;

  ret = PMPI_Wait(req, st);

  log(&ret, sizeof(int), 1);
  log(req, sizeof(MPI_Request), 1);
  log(st, sizeof(MPI_Status), 1);

  return ret;
}

int
MPI_Waitall(int arysize, MPI_Request req[], MPI_Status st[])
{
  int ret;

  ret = PMPI_Waitall(arysize, req, st);

  log(&ret, sizeof(int), 1);
  log(req, sizeof(MPI_Request), arysize);
  log(st, sizeof(MPI_Status), arysize);

  return ret;
}
