package daruma.sql;

import daruma.sql.SQLDataType;

/* !!! [[09/08/26 22:01 I.Noda]] !!! */
// to link column definition to XMLSchema
import daruma.storage_manager.type_definition.XMLSchemaElementDefinition;

public class TableColumnDefinition
{
	private	SQLDataType	sqlType;
	private	String		columnName;
	private	boolean		isExternalTable;
	/* !!! [[09/08/26 22:01 I.Noda]] !!! */
	private XMLSchemaElementDefinition elementDefinition ;

    	/* <<< [[09/08/26 22:01 I.Noda]] <<< */
	public	TableColumnDefinition( String  columnName ,
				       SQLDataType  sqlType ,
				       XMLSchemaElementDefinition elementDef )
	{
		this.sqlType         = sqlType;
		this.columnName      = columnName;
		this.isExternalTable = false;
		this.elementDefinition = elementDef ;
	}
    	/* >>> [[09/08/26 22:01 I.Noda]] >>> */

	public	TableColumnDefinition( String  columnName ,
				       SQLDataType  sqlType )
	{
		this.sqlType         = sqlType;
		this.columnName      = columnName;
		this.isExternalTable = false;
		this.elementDefinition = null ;
	}

	public	String	getColumnName()
	{
		return( this.columnName );
	}

	public	SQLDataType	getSQLDataType()
	{
		return( this.sqlType );
	}

	public	void	setIsExternalTable( boolean  isExternalTable )
	{
		this.isExternalTable = isExternalTable;
	}

	public	boolean	isExternalTable()
	{
		return( this.isExternalTable );
	}

	/* <<< [[09/08/26 22:01 I.Noda]] <<< */
	public XMLSchemaElementDefinition getElementDefinition()
	{
		return( this.elementDefinition ) ;
	}

	public void setElementDefinition(XMLSchemaElementDefinition elementDef)
	{
		this.elementDefinition = elementDef ;
	}

    	public boolean isIndexed()
    	{
	    if(this.elementDefinition == null) {
		return false ;
	    } else {
		return (this.elementDefinition.getIndexed() ) ;
	    }
    	}
    	/* >>> [[09/08/26 22:01 I.Noda]] >>> */
}
