package daruma.sql;

import daruma.sql.DatabaseConnection;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.DatabaseConnectionException
				.ClassLoadFailedDatabaseConnectionException;

public abstract class DatabaseConnectionFactory
{
	abstract public DatabaseConnection	create();
	abstract public	String			getDriverClass();

	public	void	loadClass() throws DatabaseConnectionException
	{
		try
		{
			//
			// load driver class
			//
			Class.forName( this.getDriverClass() );
		}
		catch( java.lang.ClassNotFoundException  e )
		{
			throw new DatabaseConnectionException.
				   ClassLoadFailedDatabaseConnectionException
				   ( "can't load class ["
				     + this.getDriverClass() + "]" ,
				     this.getDriverClass() , e );
		}
	}
}
