package daruma.auth;

import daruma.auth.PermissionDirective;

import daruma.xml.UniversalName;

import daruma.util.LogWriter;

import java.util.List;
import java.util.ArrayList;

public class PermissionManager
{
    private PermissionType defaultPermission;
    private List<PermissionDirective> directives;

    public PermissionManager( PermissionType defaultPermission )
    {
	this.defaultPermission = defaultPermission;
	this.directives = new ArrayList<PermissionDirective>();
    }

    public void addPermissionRule( PermissionDirective directive )
    {
	this.directives.add( directive );
    }

    public boolean canRead( Account account, UniversalName feature )
    {
	if ( account == null )
	{
	    return false;
	}

	for ( PermissionDirective d : this.directives )
	{
	    if ( d.getAccount().equals( account ) )
	    {
		if ( d.getAllowDeny() == PermissionType.Allow )
		{
		    return true;
		}
		else
		{
		    return false;
		}
	    }
	}

	return (this.defaultPermission == PermissionType.Allow);
    }

    public boolean canWrite( Account account, UniversalName feature )
    {
	// not implemented yet
	return false;
    }

    public void debugPrint()
    {
	LogWriter.qwrite( "DEBUG", "PermissionManager: " + directives.size() + " rule"+ (directives.size() == 1? "": "s") );

	for ( PermissionDirective d : this.directives )
	{
	    d.debugPrint();
	}
    }
}
