package daruma.auth;

import daruma.auth.PermissionManager;
import daruma.auth.PermissionType;
import daruma.xml.UniversalName;
import daruma.util.LogWriter;

public class PermissionDirective
{
    private PermissionType allowDeny;
    private Account account;
    private UniversalName featureName;

    public PermissionDirective( PermissionType allowDeny,
				Account account,
				UniversalName featureName )
    {
	this.allowDeny = allowDeny;
	this.account = account;
	this.featureName = featureName;
    }

    public PermissionType getAllowDeny()
    {
	return this.allowDeny;
    }

    public Account getAccount()
    {
	return this.account;
    }

    public UniversalName getFeatureName()
    {
	return this.featureName;
    }

    public void debugPrint()
    {
	LogWriter.qwrite( "DEBUG",
			  this.allowDeny + ": [" + this.account.getName() + "], [" + featureName + "]" );
    }
}
