package daruma.auth;

import daruma.util.LogWriter;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;

public class AccountManager
{
    private Map<Account, Set<Account>> accountMap;
    private Map<Account, Set<Account>> reverseMap;

    public AccountManager()
    {
	this.accountMap = new HashMap<Account, Set<Account>>();
	this.reverseMap = new HashMap<Account, Set<Account>>();
    }

    public void addAccount( Account account )
    {
	Set<Account> s = this.accountMap.get( account );

	if ( s == null )
	{
	    Set<Account> newSet = new HashSet<Account>();
	    newSet.add( account );

	    this.accountMap.put( account, newSet );

	    Set<Account> newReverseSet = new HashSet<Account>();
	    newReverseSet.add( account );

	    this.reverseMap.put( account, newReverseSet );
	}
    }

    public void addAccount( Account account, Account member )
    {
	Set<Account> s = this.accountMap.get( account );

	Set<Account> newSet;

	if ( s == null )
	{
	    newSet = new HashSet<Account>();
	    newSet.add( account );
	}
	else
	{
	    newSet = s;
	}

	newSet.add( member );

	this.accountMap.put( account, newSet );


	//
	// reverse map
	//
	{
	    Set<Account> newReverseSet = new HashSet<Account>();

	    Set<Account> rs = this.accountMap.get( member );
	    if ( rs == null )
	    {
		newReverseSet = new HashSet<Account>();
		newReverseSet.add( member );
	    }
	    newReverseSet.add( account );
	    this.reverseMap.put( member, newReverseSet );
	}
    }

    public Set<Account> getAllowedAccountList( Account account )
    {
	Set<Account> s = this.reverseMap.get( account );

	if ( s == null )
	{
	    return new HashSet<Account>();
	}

	return s;
    }


    public void debugPrint()
    {
	LogWriter.qwrite( "DEBUG", "AccountManager: "
			  + this.accountMap.size() + " accounts"
			  + (this.accountMap.size() == 1? "": "s") );

	for ( Map.Entry<Account, Set<Account>> e : this.accountMap.entrySet() )
	{
	    LogWriter.qwrite( "DEBUG",
			      "account: [", e.getKey().getName(), "]" );

	    for ( Account a : e.getValue() )
	    {
		LogWriter.qwrite( "DEBUG",
				  "  member account: [", a.getName(), "]" );
	    }
	}
    }
}
